/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.SpectralSpecCollection;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.MultipageViewException;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.TargetEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.TargetModel;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class NoSpectralSpecPanel
extends EditorWithGridBagLayout {
    public static final FieldID SS_DROPDOWN_FID = new FieldID("NoSpectralSpecPanel.DropDownFID");
    public static final FieldID FID_SS_OK = new FieldID("NoSpectralSpecPanel.OKButtonFID");
    private JTable summaryTable;
    protected final String labelNewBL = "Create new BL Correlator setup";
    protected final String labelNewACA = "Create new ACA Correlator setup";
    protected final String labelNewTP = "Create new Square law setup";
    protected final String[] newLabelArray = new String[]{"Create new BL Correlator setup", "Create new ACA Correlator setup", "Create new Square law setup"};
    private static final int TABLE_WIDTH = 400;
    private static final int TABLE_HEIGHT = 200;

    public NoSpectralSpecPanel(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public TargetModel getModel() {
        return (TargetModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        this.initEvents(jButton, FID_SS_OK);
        jPanel.add(jButton);
        this.addLabel(this, this.layout, this.constraints, "<html><br><br><p>Please select a Spectral Spec for this target</p><br><br><br></html>");
        this.addComboBox((JComponent)this, this.layout, this.constraints, SS_DROPDOWN_FID, "Spectral Spec to use", "<html>Select the field source to use for this target,<br>or choose to create a new one</html>", this.getSpectralSpecNameList());
        this.setupSummaryTable();
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.summaryTable);
        this.addComponent(this, this.layout, this.constraints, scrollWhenFocusedPane);
        this.addComponent(this, this.layout, this.constraints, jPanel);
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    private String[] getSpectralSpecNameList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.newLabelArray) {
            arrayList.add(string);
        }
        arrayList.addAll(this.getSpectralSpecNames());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private ArrayList<String> getSpectralSpecNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SpectralSpecCollection spectralSpecCollection = this.getSpectralSpecCollection();
        if (spectralSpecCollection != null) {
            for (BusinessObject businessObject : spectralSpecCollection.getCollection()) {
                SpectralSpec spectralSpec = (SpectralSpec)businessObject;
                arrayList.add(spectralSpec.getNameOrDefault());
            }
        }
        return arrayList;
    }

    private SpectralSpecCollection getSpectralSpecCollection() {
        SchedBlock schedBlock;
        SpectralSpecCollection spectralSpecCollection = null;
        Target target = this.getModel().getTarget();
        if (target != null && (schedBlock = target.getSchedBlock()) != null) {
            spectralSpecCollection = new SpectralSpecCollection(schedBlock);
        }
        return spectralSpecCollection;
    }

    @Override
    protected void build() {
        super.build("No Spectral Spec");
    }

    public SpectralSpec getSelectedSpectralSpec() {
        JComboBox jComboBox = (JComboBox)this.getComponent(SS_DROPDOWN_FID);
        int n = jComboBox.getSelectedIndex();
        Target target = this.getModel().getTarget();
        SchedBlock schedBlock = target.getSchedBlock();
        SpectralSpec spectralSpec = null;
        switch (n) {
            case 0: {
                spectralSpec = schedBlock.addNewBLSpectralSpec();
                break;
            }
            case 1: {
                spectralSpec = schedBlock.addNewACASpectralSpec();
                break;
            }
            case 2: {
                spectralSpec = schedBlock.addNewSLDSpectralSpec();
                break;
            }
            default: {
                int n2 = n - this.newLabelArray.length;
                if (n2 < 0 || n2 >= schedBlock.getSpectralSpecCount()) break;
                spectralSpec = schedBlock.getSpectralSpec(n2);
            }
        }
        return spectralSpec;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_SS_OK)) {
            ObservingToolGui observingToolGui;
            Target target = this.getModel().getTarget();
            SpectralSpec spectralSpec = this.getSelectedSpectralSpec();
            if (spectralSpec != null) {
                target.setSpectralSpec(spectralSpec);
                this.getModel().getSpectralSpecModel().setDocument(spectralSpec);
                this.getModel().publish(TargetEditor.DOCUMENT_FID, target);
            }
            this.update(SS_DROPDOWN_FID, "Create new BL Correlator setup");
            ObservingToolController observingToolController = ObservingToolController.getMyInstance();
            if (observingToolController != null && (observingToolGui = observingToolController.getGui()) != null) {
                observingToolGui.refreshCrossHighlight();
                try {
                    observingToolGui.updateEditor();
                    observingToolGui.jumpToBO((BusinessObject)this.getModel().getTarget());
                }
                catch (MultipageViewException multipageViewException) {
                    Log.logger((Object)this).warning("Cannot display component part " + target.getNameOrDefault() + " - " + multipageViewException.getLocalizedMessage());
                }
            }
            return;
        }
        if (fieldID == SS_DROPDOWN_FID) {
            JComboBox jComboBox = (JComboBox)this.getComponent(fieldID);
            this.updateSpectralSpecDropDown(jComboBox);
            int n = this.newLabelArray.length;
            int n2 = jComboBox.getSelectedIndex();
            if (n2 < n) {
                this.summaryTable.clearSelection();
            } else if (n2 - n < this.summaryTable.getRowCount()) {
                this.summaryTable.setRowSelectionInterval(n2 - n, n2 - n);
            }
            return;
        }
        super.update(fieldID, object);
    }

    private void updateSpectralSpecDropDown(JComboBox jComboBox) {
        int n = jComboBox.getSelectedIndex();
        this.updateSpectralSpecDropDown(jComboBox, n);
    }

    private void updateSpectralSpecDropDown(JComboBox jComboBox, int n) {
        String[] stringArray = this.getSpectralSpecNameList();
        this.suspendEvents(jComboBox);
        jComboBox.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        jComboBox.setSelectedIndex(n == -1 ? 0 : n);
        this.resumeEvents(jComboBox);
    }

    private void setupSummaryTable() {
        this.summaryTable = new Table();
        this.summaryTable.setModel(this.getModel().getSpectralSpecSummaryTableModel());
        this.summaryTable.getTableHeader().setReorderingAllowed(false);
        this.summaryTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        ListSelectionModel listSelectionModel = this.summaryTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        TableModel tableModel = this.summaryTable.getModel();
        tableModel.addTableModelListener(tableModelEvent -> {
            if (tableModelEvent.getType() == -1 || tableModelEvent.getType() == 0) {
                JComboBox jComboBox = (JComboBox)this.getComponent(SS_DROPDOWN_FID);
                this.updateSpectralSpecDropDown(jComboBox, -1);
            }
        });
        ListSelectionListener listSelectionListener = listSelectionEvent -> {
            int n = this.newLabelArray.length;
            JComboBox jComboBox = (JComboBox)this.getComponent(SS_DROPDOWN_FID);
            int n2 = this.summaryTable.getSelectedRow();
            if (n2 != -1) {
                n2 += n;
            }
            this.updateSpectralSpecDropDown(jComboBox, n2);
        };
        listSelectionModel.addListSelectionListener(listSelectionListener);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("NoSpectralSpecPanel");
        jFrame.setDefaultCloseOperation(3);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = schedBlock.createTarget();
        SpectralSpec spectralSpec = schedBlock.createSpectralSpec();
        spectralSpec.setName("ss1");
        SpectralSpec spectralSpec2 = schedBlock.createSpectralSpec();
        spectralSpec2.setName("ss2");
        ObservingToolController observingToolController = new ObservingToolController();
        TargetModel targetModel = new TargetModel(null, observingToolController);
        NoSpectralSpecPanel noSpectralSpecPanel = new NoSpectralSpecPanel(targetModel);
        targetModel.setDocument(target);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().add(noSpectralSpecPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

