/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.ot.boEditors.MultiPageEditor;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersEditor;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ObservatoryGoalEditor
extends MultiPageEditor {
    public ObservatoryGoalEditor(ObservatoryGoalModel observatoryGoalModel) {
        super(observatoryGoalModel);
        this.setName("ObservatoryGoalEditor");
        ObservatoryGoalTargetsEditor observatoryGoalTargetsEditor = new ObservatoryGoalTargetsEditor(observatoryGoalModel);
        SfiSpectralSetupEditor sfiSpectralSetupEditor = new SfiSpectralSetupEditor(observatoryGoalModel.getSpectralSetupModel());
        CalibrationSetupParametersEditor calibrationSetupParametersEditor = new CalibrationSetupParametersEditor(observatoryGoalModel);
        this.registerSubView(observatoryGoalTargetsEditor);
        this.registerSubView(sfiSpectralSetupEditor);
        this.registerSubView(calibrationSetupParametersEditor);
        this.addPage(observatoryGoalTargetsEditor, new MultiPageEditor.PageDescriptor(this, "Target List"), new String[]{""});
        this.addPage(calibrationSetupParametersEditor, new MultiPageEditor.PageDescriptor(this, "Survey Calibrators"), new String[]{""});
        this.addPage(sfiSpectralSetupEditor, new MultiPageEditor.PageDescriptor(this, "Spectral Setup"), new String[]{"You can setup spectral windows to be observed.", "Up to 4 can be observed at the highest frequency resolution depending on the bandwidths you specify.", "If you want to setup more than 4, you need to arrange them into 4 or fewer sets of spectral windows.", "Those sets are called \"Basebands\", and the width of a baseband is 2GHz."});
        Dimension dimension = new Dimension(750, 600);
        observatoryGoalTargetsEditor.setPreferredSize(dimension);
        calibrationSetupParametersEditor.setPreferredSize(dimension);
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        ObservatoryGoal observatoryGoal = ObservatoryGoal.createCalibratorSurveyGoal();
        ObservatoryGoalModel observatoryGoalModel = new ObservatoryGoalModel(observatoryGoal);
        ObservatoryGoalEditor observatoryGoalEditor = new ObservatoryGoalEditor(observatoryGoalModel);
        JFrame jFrame = new JFrame("ObservatoryGoalEditor");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(observatoryGoalEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

