/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.P2GAlerter;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.EphemerisCleaner;
import alma.obsprep.ot.actions.ProjectRepositoryPerformer;
import alma.obsprep.ot.actions.StoreInteractor;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.ValidatorSet;
import alma.obsprep.ot.valdef.ValidatorSetFactory;
import alma.obsprep.ot.valdef.obsproject.ObsUnitSetValidator;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.services.summaryfeedback.TASummaryGenerator;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.data.StatusData;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import lombok.NonNull;

public class StorePerformer
extends ProjectRepositoryPerformer {
    static final String BUSY_START = "preparing";
    static final String BUSY_OTHER = " ";
    static final String BUSY_VALIDATING = "validating";
    static final String BUSY_SUMMARIES = "summarising";
    static final String BUSY_CONDITIONING = "sanitising";
    static final String BUSY_STORING_DATA = "storing";
    static final String BUSY_POSTPROCESS = "post-processing";
    static final String BUSY_END = "finished";
    private final RoleDirectoryService roleDirectory;
    private final UserAuthenticator userAuthenticator;
    private final Collection<String> csvStates = ObsProject.getCsvStates();
    private final Collection<String> operationalStates = ObsProject.getOperationalStates();

    public StorePerformer(StoreInteractor storeInteractor, ProjectRepository projectRepository, UserAuthenticator userAuthenticator, RoleDirectoryService roleDirectoryService) {
        super(storeInteractor, projectRepository);
        this.userAuthenticator = userAuthenticator;
        this.roleDirectory = roleDirectoryService;
        this.operationalStates.remove(ObsProjectData.STATUS_NEWPHASE1);
        this.operationalStates.remove(ObsProjectData.STATUS_NEWPHASE2);
    }

    private void checkDataOK(ObsProject obsProject, StoreInteractor storeInteractor) throws PersistenceException {
        StringBuilder stringBuilder = new StringBuilder();
        if (obsProject.getPI().equals("")) {
            stringBuilder.append("- No PI specified\n");
        }
        if (obsProject.getProjectName().equals("")) {
            stringBuilder.append("- No project name specified\n");
        }
        if (obsProject.getVersion().equals("")) {
            stringBuilder.append("- No project version specified\n");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.insert(0, "Your project is missing required data\n");
            throw new PersistenceException("Project is incomplete", null, "Project is incomplete", "Enter the required data, then retry", stringBuilder.toString(), null);
        }
        String string = obsProject.getStatus();
        boolean bl = obsProject.getIsCommissioning();
        boolean bl2 = storeInteractor.isProjectToBeStoredAsNew();
        if (string.equals(ObsProjectData.STATUS_REJECTED)) {
            throw new PersistenceException("Is rejected project: " + obsProject.getEntityID(), null, "This is a rejected project", "Sorry, you cannot submit a rejected project");
        }
        if (!bl2 && this.csvStates.contains(string) && !bl) {
            throw new PersistenceException("Is not a commissioning project: " + obsProject.getEntityID(), null, "Cannot migrate a commisioning project to the operational lifecycle.", "You must use 'Submit as New', or re-enable the 'is Commissioning' flag");
        }
        if (!bl2 && this.operationalStates.contains(string) && bl) {
            throw new PersistenceException("Is a commissioning project: " + obsProject.getEntityID(), null, "Cannot migrate a normal project to the CSV lifecycle.", "You must use 'Submit as New', or disable the 'is Commissioning' flag");
        }
    }

    private void checkObjectionsAgainstUserSubmitting(@NonNull ObsProject obsProject) throws PersistenceException, ConfirmationNotGivenException {
        Set<ScienceGoal> set;
        if (obsProject == null) {
            throw new NullPointerException("boProj is marked non-null but is null");
        }
        if (this.userAuthenticator == null) {
            return;
        }
        try {
            this.roleDirectory.ensureLoggedIn("Submitting a project to ALMA");
        }
        catch (IOException iOException) {
            String string = "Failure at login of user '" + this.userAuthenticator.getUsername() + "': " + iOException.getMessage();
            throw new PersistenceException(string, iOException);
        }
        if (!RoleDirectoryServiceHelper.isUserP2G() && !(set = this.isSBsNeedingToBeRefreshed(obsProject)).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("<html> The following science goals need their SBs regenerating: <P><ul>");
            set.stream().forEach(scienceGoal -> stringBuilder.append("<li>" + scienceGoal.getName() + "</li>"));
            stringBuilder.append("</ul></html>");
            throw new ConfirmationNotGivenException(stringBuilder.toString());
        }
        boolean bl = obsProject.getPI().equals(this.userAuthenticator.getUsername());
        try {
            if (!bl && !this.roleDirectory.canExecute(OTOperation.STORE_AS_NON_PI)) {
                if (obsProject.isProjectWithStatus(ObsProjectData.STATUS_PHASE2SUBMITTED, ObsProjectData.STATUS_APPROVED) && RoleDirectoryServiceHelper.isPhase2ProposalDelegate(obsProject)) {
                    return;
                }
                boolean bl2 = RoleDirectoryServiceHelper.isContactScientist(obsProject);
                Object object = bl2 ? "Your user id. is that of a contact scientist for this proposal and you cannot resubmit it." : "User is not PI, User cannot " + OTOperation.STORE_AS_NON_PI.getDescription();
                throw new PersistenceException((String)object, null, "Your username and the project PI do not match", "Ensure you are the project PI or a phase 2 proposal delegate and your username is given in the Connection preferences.", "Only privileged users or Phase 2 proposal delegates can submit projects for other users.", null);
            }
        }
        catch (IOException iOException) {
            String string = "Error while determining privileges of user '" + this.userAuthenticator.getUsername() + "'";
            throw new PersistenceException(string, iOException);
        }
    }

    private Set<ScienceGoal> isSBsNeedingToBeRefreshed(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        HashSet<ScienceGoal> hashSet = new HashSet<ScienceGoal>();
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProgram == null) {
            return hashSet;
        }
        StaleSBDetector staleSBDetector = StaleSBDetector.getInstance();
        for (ScienceGoal scienceGoal : obsProgram.getAbstractScienceGoalScienceGoal()) {
            for (SchedBlock schedBlock : SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal))) {
                if (!staleSBDetector.isSBNeedingRegenerating(schedBlock, scienceGoal) || hashSet.contains(scienceGoal)) continue;
                hashSet.add(scienceGoal);
            }
        }
        return hashSet;
    }

    private void generatePdfs(ObsProposal obsProposal) {
        obsProposal.getProposalFeedback().getTimeAllocationBreakdown();
        TASummaryGenerator.attachTASummary(obsProposal);
        Log.Logger logger = Log.logger((Object)this);
        TimeAllocationBreakdown timeAllocationBreakdown = obsProposal.getProposalFeedback().getTimeAllocationBreakdown();
        logger.info("TimeAllocationBreakdown " + String.valueOf((Object)timeAllocationBreakdown));
        if (!timeAllocationBreakdown.testExecutives()) {
            logger.warning("Invalid TimeAllocationBreakdown structure found.");
        }
        if (!timeAllocationBreakdown.testTotal()) {
            logger.warning("Invalid TimeAllocationBreakdown data found.");
        }
    }

    private void updateP2GFlags(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("problemModel is marked non-null but is null");
        }
        if (!(businessObject instanceof ObsProject)) {
            throw new RuntimeException("BO should be of type ObsProject");
        }
        Log.logger(ValidatorSet.class).info("P2G flags are being updated");
        P2GAlerter p2GAlerter = new P2GAlerter((ObsProject)businessObject);
        p2GAlerter.determineIfP2GAttentionNeeded(problemListModel);
        P2GAlerter.getIsP2GFlagsToBeEstablished().getAndSet(false);
    }

    private boolean isP2GFlagsRecalculationRequired(@NonNull HashMap<String, Set<AbstractValidator>> hashMap) {
        if (hashMap == null) {
            throw new NullPointerException("validatorExecutionMap is marked non-null but is null");
        }
        if (P2GAlerter.getIsP2GFlagsToBeEstablished().get()) {
            return true;
        }
        boolean bl = hashMap.entrySet().stream().anyMatch(entry -> ((Set)entry.getValue()).stream().anyMatch(abstractValidator -> {
            if (abstractValidator.getClass().isAssignableFrom(ObsUnitSetValidator.class)) {
                return false;
            }
            return abstractValidator.getIsValidatorRan().get();
        }));
        P2GAlerter.getIsP2GFlagsToBeEstablished().getAndSet(bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        StoreInteractor storeInteractor = (StoreInteractor)this.getGui();
        Log.Logger logger = Log.logger((Object)this);
        boolean bl = false;
        try {
            IBusinessObject iBusinessObject;
            Object object;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            String string;
            boolean bl5;
            Object object2;
            Object object3;
            storeInteractor.busy(false, BUSY_START);
            logger.finer("Storing project to repository");
            ObsProject obsProject = storeInteractor.getObsProject();
            boolean bl6 = storeInteractor.isProjectToBeStoredAsNew();
            if (bl6 && !storeInteractor.confirmAsNew()) {
                throw new ConfirmationNotGivenException();
            }
            storeInteractor.busy(false, BUSY_OTHER);
            this.checkDataOK(obsProject, storeInteractor);
            this.checkObjectionsAgainstUserSubmitting(obsProject);
            String string2 = obsProject.getStatus();
            boolean bl7 = obsProject.getIsDDT();
            if (bl7 && string2.equals(StatusData.STATE_PHASE1SUBMITTED)) {
                storeInteractor.info("This DDT proposal has already been submitted.\nSorry, you cannot re-submit a DDT proposal nor use it as a basis for a new project");
                return;
            }
            boolean bl8 = ObsProject.getPIP1SGEditableStates().contains(string2);
            boolean bl9 = obsProject.getPI().equals(this.userAuthenticator.getUsername());
            if (bl9 && bl8 && this.projectRecycler.updateExecutivesOfInvestigators(obsProject)) {
                GUIUtilities.warning(null, "One or more investigators have changed to a Taiwanese institute since their details were first entered. Please check that their Executives are set correctly and resubmit.");
                return;
            }
            boolean bl10 = storeInteractor.isValidationSkippable();
            if (bl10) {
                logger.info("Be aware that client-side validation on submission was skipped");
            } else {
                storeInteractor.busy(true, BUSY_VALIDATING);
                object3 = new DefaultProblemListModel();
                object2 = ValidatorSetFactory.createStandardValidatorSet();
                ((ValidatorSet)object2).validate((BusinessObject)obsProject, (ProblemListModel)object3);
                if (((DefaultProblemListModel)object3).hasErrorOrWorse()) {
                    throw new PersistenceException("project has validation errors", null, null, "Re-run validation and correct all errors, first. Then retry to submit.", "This project cannot be submitted because it is invalid.", null);
                }
                if (this.isP2GFlagsRecalculationRequired(((ValidatorSet)object2).getValidatorMap())) {
                    this.updateP2GFlags((BusinessObject)obsProject, (ProblemListModel)object3);
                }
            }
            EphemerisCleaner.removeRedundantEphemeris(obsProject);
            storeInteractor.busy(false, BUSY_OTHER);
            object3 = obsProject.getObsProposal().getCycle();
            if (!bl8 && bl7 && !bl6 && !storeInteractor.confirmSubmitToNewerCycle((String)object3, bl5 = string2.equals(StatusData.STATE_PHASE1SUBMITTED))) {
                throw new ConfirmationNotGivenException("Submission of old project to new cycle cancelled");
            }
            object2 = AlmaPolicies.getInstance();
            String string3 = ((AlmaPolicies)object2).getDDTCycleNumber();
            String string4 = string = AlmaPolicies.getInstance().isSupplementalCallEnabled() ? ((AlmaPolicies)object2).getSupplementalCallCycleNumber() : ((AlmaPolicies)object2).getCycleNumber();
            if (bl6) {
                MendMyStruct.moveToCurrentCycle(obsProject, bl7 ? string3 : string);
            }
            if (bl8) {
                if (!bl6) {
                    if (bl7) {
                        if (!((String)object3).equals(string3)) {
                            bl = true;
                            MendMyStruct.moveToCurrentCycle(obsProject, string3);
                        }
                    } else if (!((String)object3).equals(string)) {
                        bl4 = string2.equals(StatusData.STATE_PHASE1SUBMITTED);
                        if (!storeInteractor.confirmSubmitToNewerCycle((String)object3, bl4)) {
                            throw new ConfirmationNotGivenException("Submission of old project to new cycle cancelled");
                        }
                        bl = true;
                        MendMyStruct.moveToCurrentCycle(obsProject, string);
                        bl6 = true;
                    }
                }
                storeInteractor.busy(true, BUSY_SUMMARIES);
                this.generatePdfs(obsProject.getObsProposal());
            }
            storeInteractor.busy(true, BUSY_CONDITIONING);
            if (bl6) {
                try {
                    MendMyStruct.renewIds(obsProject, true);
                }
                catch (EntityException | UnknownEntityException throwable) {
                    logger.fine("Failure while renewing Entity-Ids of the project: " + String.valueOf(throwable));
                }
                if (!ObsProjectData.STATUS_NEWPHASE1.equals(string2)) {
                    if (ObsProjectData.STATUS_PHASE1SUBMITTED.equals(string2)) {
                        MendMyStruct.resetStatusFromPhase1SubmittedToNewPhase1(obsProject);
                    } else {
                        MendMyStruct.resetStatusToNewPhase2(obsProject);
                    }
                }
                obsProject.clearSubmissionRecord();
            }
            boolean bl11 = !(bl4 = ObsProject.getSubmittableStates().contains(string2));
            boolean bl12 = bl3 = storeInteractor.getVariant() == ProjectRepository.StoreVariant.storeback;
            if (bl11) {
                // empty if block
            }
            if (!bl6 && bl11 && !storeInteractor.confirmResubmit()) {
                throw new ConfirmationNotGivenException();
            }
            if (bl || !bl3 && bl4 && !bl6) {
                boolean bl13 = bl2 = ObsProjectData.STATUS_NEWPHASE1.equals(string2) || bl;
                if (!storeInteractor.confirmSubmit(bl2, bl7)) {
                    throw new ConfirmationNotGivenException();
                }
            }
            boolean bl14 = bl2 = this.userAuthenticator != null && !obsProject.getPI().equals(this.userAuthenticator.getUsername());
            if (bl2 && !storeInteractor.confirmSubmitAsNonPI(bl7)) {
                throw new ConfirmationNotGivenException();
            }
            if (!obsProject.isRevisionNumberOfProjectCurrent()) {
                boolean bl15 = ObsProject.isPhase2Project(string2);
                if (bl15 && !GUIUtilities.confirm(null, "You are attempting to submit a project using a version of the OT from a more recent cycle than that used to create the original proposal. Do you wish to proceed?", GUIUtilities.DefaultResponse.NO)) {
                    storeInteractor.busy(false, BUSY_END);
                    return;
                }
                object = Apdm_to_BO.decomposeIncludingFiles(obsProject);
                ImpexFactory.updateRevisionNumbersOfDocuments((Apdm_to_BO.BoBundle)object);
            }
            if (!bl6) {
                String string5 = string2;
                if (string5.equals(StatusData.STATE_BROKEN)) {
                    try {
                        MendMyStruct.pushStatusFromBrokenToRepaired(obsProject);
                    }
                    catch (UnknownEntityException unknownEntityException) {
                        storeInteractor.error((Exception)((Object)unknownEntityException));
                    }
                } else if (string5.equals(StatusData.STATE_APPROVED)) {
                    obsProject.setStatus(StatusData.STATE_PHASE2SUBMITTED);
                }
            }
            try {
                MendMyStruct.renewIds(obsProject, false);
            }
            catch (EntityException | UnknownEntityException throwable) {
                logger.fine("Failure while randomising fake entity IDs: " + String.valueOf(throwable));
            }
            try {
                iBusinessObject = obsProject.getObsProgram().getObsPlan();
                object = iBusinessObject.findSchedBlocks();
                String string6 = obsProject.getPI();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SchedBlock schedBlock = (SchedBlock)iterator.next();
                    schedBlock.setPIName(string6);
                }
                MendMyStruct.sanitizeEntityRefs(obsProject);
            }
            catch (EntityException | UnknownEntityException throwable) {
                storeInteractor.error((Exception)throwable);
            }
            iBusinessObject = null;
            try {
                storeInteractor.busy(true, BUSY_STORING_DATA);
                iBusinessObject = this.projectRepository().store(obsProject, storeInteractor.getVariant(), storeInteractor.getProgressListener());
            }
            catch (PersistenceException persistenceException) {
                if (persistenceException.getErrorCode() != 409) {
                    storeInteractor.busy(false, BUSY_END);
                    throw persistenceException;
                }
                if (!storeInteractor.confirmSubmitForceUpdate()) {
                    storeInteractor.busy(false, BUSY_END);
                    throw new ConfirmationNotGivenException("Submission over conflicting version cancelled");
                }
                iBusinessObject = this.projectRepository().store(obsProject, ProjectRepository.StoreVariant.forceupdate, storeInteractor.getProgressListener());
                MiscUtils.resetJCSCache();
            }
            ActionLog.performed("Submit", obsProject, "to archive");
            storeInteractor.busy(false, BUSY_POSTPROCESS);
            UserEditRestrictionController.getInstance().projectDocumentReset((ObsProject)iBusinessObject, new ImpexFactory.WorkingPersistenceData());
            StaleSBDetector.getInstance().resetSBFreshnessMap((ObsProject)iBusinessObject);
            storeInteractor.busy(false, BUSY_END);
            storeInteractor.info((ObsProject)iBusinessObject);
            storeInteractor.displayAfterStore((ObsProject)iBusinessObject);
            storeInteractor.saveProjectAfterStore();
        }
        catch (ConfirmationNotGivenException confirmationNotGivenException) {
            storeInteractor.busy(false, BUSY_END);
            logger.info(confirmationNotGivenException.getMessage());
            storeInteractor.info(confirmationNotGivenException.getMessage());
        }
        catch (Exception exception) {
            storeInteractor.busy(false, BUSY_END);
            logger.log(Level.SEVERE, "Encountered failure while storing the project: " + String.valueOf(exception), (Throwable)exception);
            storeInteractor.error(exception);
        }
        finally {
            storeInteractor.busy(false, BUSY_END);
        }
    }

    private class ConfirmationNotGivenException
    extends Exception {
        ConfirmationNotGivenException() {
            super("Submission cancelled by user");
        }

        ConfirmationNotGivenException(String string) {
            super(string);
        }
    }
}

