/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.verifiers;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.valuetypes.Frequency;
import javax.swing.JTextField;

public class LO1Verifier
extends Verifier {
    private ValueUnitPairEditor vupe;

    public LO1Verifier(Editor editor, ValueUnitPairEditor valueUnitPairEditor) {
        super(editor, valueUnitPairEditor.getInput());
        this.vupe = valueUnitPairEditor;
    }

    private Frequency getFrequencyFromEditor() {
        Frequency frequency = Frequency.createFrequency();
        double d = Double.parseDouble(this.vupe.getInput().getText());
        String string = (String)this.vupe.getUnits().getSelectedItem();
        frequency.setContent(d);
        frequency.setUnit(string);
        return frequency;
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException, InvalidCoordException {
        Frequency frequency = this.getFrequencyFromEditor();
        double d = frequency.getContentInGHz();
        SpectralSpec spectralSpec = (SpectralSpec)this.getEditor().getModel().getDocument();
        String string = spectralSpec.getFrequencySetup().getReceiverBand();
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(string);
        if (receiverBand == null) {
            throw new OutOfRangeException(String.format("Unknown receiver band \"%s\"", string));
        }
        if (d < receiverBand.getLOMin()) {
            throw new OutOfRangeException(String.format("<html>%s %s %s %s%n%s %4.2f to %4.2f GHz.</html>", new Object[]{"LO<sub>1</sub> frequency of", frequency, "is too low for receiver band", string, "<br>which requires LO<sub>1</sub> to be in the range", receiverBand.getLOMin(), receiverBand.getLOMax()}));
        }
        if (d > receiverBand.getLOMax()) {
            throw new OutOfRangeException(String.format("<html>%s %s %s %s%n%s %4.2f to %4.2f GHz.</html>", new Object[]{"LO<sub>1</sub> frequency of", frequency, "is too high for receiver band", string, "<br>which requires LO<sub>1</sub> to be in the range", receiverBand.getLOMin(), receiverBand.getLOMax()}));
        }
        return frequency.getContent();
    }
}

