/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.ACASpectralWindowT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.ACASpectralWindowI;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.UnknownScalingFactorException;
import alma.obsprep.bo.schedblock.data.ACASpectralWindowData;
import alma.valuetypes.Frequency;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ACASpectralWindow
extends ACASpectralWindowData
implements ACASpectralWindowI {
    public static final double CHANNEL_WIDTH_KHZ = 3.814697265625;

    public ACASpectralWindow(ACASpectralWindowT aCASpectralWindowT) {
        super(aCASpectralWindowT);
    }

    public void initAsNew() {
        super.initAsNew();
        ChannelAverageRegion channelAverageRegion = ChannelAverageRegion.createChannelAverageRegion(0, this.getEffectiveNumberOfChannels());
        this.addChannelAverageRegion(channelAverageRegion);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(",ACA[");
        stringBuilder.append("rprd=" + this.getFrqChProfReproduction());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public CorrelatorType getCorrelatorType() {
        return CorrelatorType.ACA;
    }

    @Override
    public void updateCorrConfigMode() {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(this.getNominalBandwidth());
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode(this.getNominalNumberOfChannels(), set);
        if (set2.size() == 0) {
            this.setCorrConfigMode(-1);
            Log.logger((Object)this).finest("ACASpectralWindow : InvalidCorrConfigMode : nom = (" + String.valueOf((Object)this.getNominalBandwidth()) + ", " + this.getNominalNumberOfChannels() + "), eff = (" + String.valueOf((Object)this.getEffectiveBandwidth()) + ", " + this.getEffectiveNumberOfChannels() + ")");
        } else {
            Iterator<CorrConfigMode> iterator = set2.iterator();
            this.setCorrConfigMode(iterator.next());
        }
    }

    public void updateApplicableModeSet() {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        this.applicableModeSet = oTConfigModeDecoder.findMode(CorrPolarization.getCorrPolarization(this.getPolnProducts()));
    }

    @Override
    public void setPolnProducts(String string) {
        super.setPolnProducts(string);
        this.updateApplicableModeSet();
    }

    @Override
    public void adjustCenterFrequency() {
        double d;
        double d2;
        if (this.getBandwidth().isEqual((AbstractDoubleWithUnit)BaseBandSpecification.basebandWidth)) {
            this.getCenterFrequency().setContentAndUnit(3.0, Frequency.UNIT_GHZ);
        }
        if (this.getCorrConfigMode() == null || this.getCorrConfigMode().getFilter() == null) {
            Log.logger(ACASpectralWindow.class).warning("Unable to determine correlator configuration mode: unable to execute spectral window centre frequency adjustment");
            return;
        }
        CorrFilter corrFilter = this.getCorrConfigMode().getFilter();
        Frequency frequency = this.getCenterFrequency();
        assert (corrFilter != null);
        if (corrFilter.equals((Object)CorrFilter.TFB)) {
            d2 = frequency.getContentInUnits(Frequency.UNIT_KHZ);
            long l = Math.round(d2 / 3.814697265625);
            if ((d2 = (double)l * 3.814697265625) - (d = this.getBandwidth().getContentInUnits(Frequency.UNIT_KHZ) / 2.0) < 2000000.0) {
                d2 = 2000000.0 + d;
            } else if (d2 + d > 4000000.0) {
                d2 = 4000000.0 - d;
            }
            Frequency frequency2 = Frequency.createFrequency((double)d2, (String)Frequency.UNIT_KHZ);
            frequency.setContent(frequency2.getContentInUnits(frequency.getUnit()));
        }
        d2 = (frequency.getContentInMHz() - 2000.0) * 1000.0;
        double d3 = Math.ceil(d2 / 3.814697265625 - 0.5);
        if (this.getEffectiveNumberOfChannels() % 2 == 1 && Math.abs(this.getResolution().getContentInMHz() * 1000.0 - 3.814697265625) < 1.0) {
            d3 = (int)(d2 / 3.814697265625);
        }
        d2 = d3 * 3.814697265625;
        d = d2 / 1000.0 + 2000.0;
        double d4 = this.getACASpectralWindowStepFrequencyMHz();
        double d5 = (double)Math.round(d / d4) * d4;
        Frequency frequency3 = Frequency.createFrequencyMHZ(d5);
        Frequency frequency4 = (Frequency)Frequency.createFrequencyMHZ(2000.0).plus((AbstractDoubleWithUnit)((Frequency)this.getNominalBandwidth().divide(2.0)));
        Frequency frequency5 = (Frequency)Frequency.createFrequencyMHZ(4000.0).minus((AbstractDoubleWithUnit)((Frequency)this.getNominalBandwidth().divide(2.0)));
        if (frequency3.isLessThan((AbstractDoubleWithUnit)frequency4)) {
            d5 = Math.ceil(d / d4) * d4;
            frequency3 = Frequency.createFrequencyMHZ(d5);
        }
        if (frequency3.isGreaterThan((AbstractDoubleWithUnit)frequency5)) {
            d5 = Math.floor(d / d4) * d4;
            frequency3 = Frequency.createFrequencyMHZ(d5);
        }
        Log.logger((Object)this).fine("central freq.: " + String.valueOf((Object)frequency) + " centerFrequencyMhzWithBBOffset: " + d + " adjustedCentralFrequency (MHz): " + String.valueOf((Object)frequency3) + " step MHz: " + d4);
        frequency.setContent(frequency3.getContentInUnits(frequency.getUnit()));
    }

    private double getACASpectralWindowStepFrequencyMHz() {
        double d;
        double d2 = this.getEffectiveBandwidth().getContentInMHz();
        double d3 = d2 / 3.90625;
        double d4 = d3 > (d = (double)this.getEffectiveNumberOfChannels()) ? d3 : d;
        double d5 = d2 / d4;
        double d6 = d5 * 8.0;
        return d6;
    }

    @Override
    public Frequency getEffectiveResolution() throws UnknownScalingFactorException {
        return this.getEffectiveResolution(this.getWindowFunction());
    }

    public Frequency getEffectiveResolution(String string) throws UnknownScalingFactorException {
        int n;
        Frequency frequency = this.getResolution().deepCopy();
        int n2 = n = this.getSpectralAveragingFactor();
        while (n2 % 2 == 0) {
            n2 /= 2;
        }
        if (n2 != 1) {
            throw new UnknownScalingFactorException("Averaging factor not a power of two");
        }
        SpectralAverage spectralAverage = SpectralAverage.getValue(n);
        Double d = 1.0;
        if (null == spectralAverage) {
            d = n;
        } else {
            try {
                d = spectralAverage.getResolutionScalingFactor(string);
            }
            catch (SpectralAverage.UnknownWindowingFunctionException unknownWindowingFunctionException) {
                throw new UnknownScalingFactorException("This windowing function is currently unsupported");
            }
        }
        return (Frequency)frequency.multiply(d);
    }

    @Override
    public String getSynthProf() {
        String string = super.getSynthProf();
        if (string == null) {
            string = ACASpectralWindowData.SYNTHPROF_ACA_CDP;
            this.setSynthProf(string);
            this.setFrqChProfReproduction(false);
        }
        return string;
    }

    @Override
    public void clearSpectralLines(SpectralSpec.SideBand sideBand) {
        super.clearSpectralLine();
    }

    @Override
    public void addSpectralLine(SpectralSpec.SideBand sideBand, SpectralLine spectralLine) {
        super.addSpectralLine(spectralLine);
    }

    @Override
    public List<SpectralLine> getSpectralLines() {
        return Arrays.asList(super.getSpectralLine());
    }
}

