/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.ACABaseBandConfigT;
import alma.entity.xmlbinding.schedblock.SchedBlockRefT;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTPolnProductsType;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.ACASpectralWindow;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.data.ACABaseBandConfigData;
import java.util.HashSet;
import java.util.Iterator;

public class ACABaseBandConfig
extends ACABaseBandConfigData {
    protected String polnProducts = AbstractSpectralWindow.defaultPolnProducts;

    public ACABaseBandConfig(ACABaseBandConfigT aCABaseBandConfigT) {
        super(aCABaseBandConfigT);
    }

    public BaseBandSpecification getBaseBandSpecification() {
        BaseBandSpecification baseBandSpecification = super.getBaseBandSpecification();
        SchedBlockRefT schedBlockRefT = this.getCastorObject().getBaseBandSpecificationRef();
        if (schedBlockRefT != null) {
            schedBlockRefT.setDocumentVersion("1");
        }
        return baseBandSpecification;
    }

    public void initAsNew() {
        super.initAsNew();
        this.getCenterFreqOfResidualDelay().setContentInMHz(0.0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(",ACA[");
        stringBuilder.append("delay=" + String.valueOf((Object)this.getCenterFreqOfResidualDelay()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public CorrelatorType getCorrelatorType() {
        return CorrelatorType.ACA;
    }

    public AbstractSpectralWindow getSingleSpectralWindow(int n) {
        return this.getACASpectralWindow(n);
    }

    public AbstractSpectralWindow[] getSingleSpectralWindow() {
        return this.getACASpectralWindow();
    }

    public int getSingleSpectralWindowCount() {
        return this.getACASpectralWindowCount();
    }

    public void addSingleSpectralWindow(int n, AbstractSpectralWindow abstractSpectralWindow) {
        try {
            ACASpectralWindow aCASpectralWindow = (ACASpectralWindow)((Object)abstractSpectralWindow);
            aCASpectralWindow.setPolnProducts(this.getPolnProducts());
            this.addACASpectralWindow(n, aCASpectralWindow);
            this.adjustSpectralWindowName();
            this.adjustAssociatedSpectralWindowNumber();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void addACASpectralWindow(int n, ACASpectralWindow aCASpectralWindow) {
        super.addACASpectralWindow(n, aCASpectralWindow);
        this.dataRateChanged();
    }

    public ACASpectralWindow createNewSingleSpectralWindow() {
        return ACASpectralWindow.createACASpectralWindow();
    }

    public void clearSpectralWindow() {
        this.clearACASpectralWindow();
        this.forgetPairs();
    }

    public void clearACASpectralWindow() {
        super.clearACASpectralWindow();
        this.dataRateChanged();
    }

    public boolean removeSingleSpectralWindow(AbstractSpectralWindow abstractSpectralWindow) {
        try {
            ACASpectralWindow aCASpectralWindow = (ACASpectralWindow)((Object)abstractSpectralWindow);
            boolean bl = this.removeACASpectralWindow(aCASpectralWindow);
            this.adjustSpectralWindowName();
            this.adjustAssociatedSpectralWindowNumber();
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean removeACASpectralWindow(ACASpectralWindow aCASpectralWindow) {
        boolean bl = super.removeACASpectralWindow(aCASpectralWindow);
        this.dataRateChanged();
        return bl;
    }

    public String[] getKnownPolnProductsList() {
        return AbstractSpectralWindow.getKnownPolnProductsList();
    }

    public String getPolnProducts() {
        return this.polnProducts;
    }

    public void setPolnProducts(String string) {
        AbstractSpectralWindowTPolnProductsType.valueOf((String)string);
        this.polnProducts = string;
        for (AbstractSpectralWindow abstractSpectralWindow : this.getSingleSpectralWindow()) {
            ((ACASpectralWindow)((Object)abstractSpectralWindow)).setPolnProducts(string);
        }
    }

    public void syncPolnProducts() {
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractSpectralWindow abstractSpectralWindow : this.getSingleSpectralWindow()) {
            hashSet.add(abstractSpectralWindow.getPolnProducts());
        }
        if (hashSet.size() == 1 && !hashSet.contains(this.polnProducts)) {
            Iterator iterator = hashSet.iterator();
            this.setPolnProducts((String)iterator.next());
        }
    }
}

