/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes.data;

import alma.entity.xmlbinding.valuetypes.LatitudeT;
import alma.entity.xmlbinding.valuetypes.LongitudeT;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.types.SkyCoordinatesTSystemType;
import alma.entity.xmlbinding.valuetypes.types.SkyCoordinatesTTypeType;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.util.List;

public class SkyCoordinatesData
extends BusinessObject {
    public static final String SYSTEM_J2000 = SkyCoordinatesTSystemType.J2000.toString();
    public static final String SYSTEM_GALACTIC = SkyCoordinatesTSystemType.GALACTIC.toString();
    public static final String SYSTEM_ECLIPTIC = SkyCoordinatesTSystemType.ECLIPTIC.toString();
    public static final String SYSTEM_AZEL = SkyCoordinatesTSystemType.AZEL.toString();
    public static final String SYSTEM_ICRS = SkyCoordinatesTSystemType.ICRS.toString();
    public static final String SYSTEM_HORIZON = SkyCoordinatesTSystemType.HORIZON.toString();
    public static final String TYPE_ABSOLUTE = SkyCoordinatesTTypeType.ABSOLUTE.toString();
    public static final String TYPE_RELATIVE = SkyCoordinatesTTypeType.RELATIVE.toString();
    protected static String[] knownSystemList = new String[]{SYSTEM_J2000, SYSTEM_GALACTIC, SYSTEM_ECLIPTIC, SYSTEM_AZEL, SYSTEM_ICRS, SYSTEM_HORIZON};
    protected static String[] knownTypeList = new String[]{TYPE_ABSOLUTE, TYPE_RELATIVE};
    private Longitude boLongitude = null;
    private Latitude boLatitude = null;

    protected SkyCoordinatesData(SkyCoordinatesT castorObject) {
        super(castorObject);
    }

    public static SkyCoordinatesT testsupport_createSkyCoordinatesT() {
        return SkyCoordinates.createSkyCoordinatesT();
    }

    protected static final SkyCoordinatesT createSkyCoordinatesT() {
        SkyCoordinatesT ret = new SkyCoordinatesT();
        SkyCoordinates.patchSkyCoordinatesT((SkyCoordinatesT)ret);
        return ret;
    }

    private static final SkyCoordinates createUnitializedSkyCoordinates() {
        SkyCoordinatesT so = SkyCoordinates.createSkyCoordinatesT();
        SkyCoordinates ret = new SkyCoordinates(so);
        return ret;
    }

    public static SkyCoordinates createSkyCoordinates() {
        SkyCoordinatesT so = SkyCoordinates.createSkyCoordinatesT();
        SkyCoordinates ret = new SkyCoordinates(so);
        ret.initAsNew();
        return ret;
    }

    protected static final void patchSkyCoordinatesT(SkyCoordinatesT castorObject) {
    }

    @Override
    public SkyCoordinatesT getCastorObject() {
        return (SkyCoordinatesT)this.storageObject;
    }

    public SkyCoordinates deepCopy() throws CopyException {
        return (SkyCoordinates)super.deepCopy();
    }

    protected SkyCoordinates invokeCreateUnitialized() throws CopyException {
        return SkyCoordinatesData.createUnitializedSkyCoordinates();
    }

    @Override
    protected void initAttribsAndPartsFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(original, copier);
        SkyCoordinatesData orig = (SkyCoordinatesData)original;
        if (orig.gettrueLongitude() != null) {
            this.setLongitude((Longitude)copier.cpAttr((BusinessObject)orig.gettrueLongitude()));
        }
        if (orig.gettrueLatitude() != null) {
            this.setLatitude((Latitude)copier.cpAttr((BusinessObject)orig.gettrueLatitude()));
        }
        if (orig.getSystem() != null) {
            this.setSystem(orig.getSystem());
        }
        if (orig.gettrueFieldName() != null) {
            this.setFieldName(orig.gettrueFieldName());
        }
        if (orig.getType() != null) {
            this.setType(orig.getType());
        }
    }

    @Override
    protected void initEntityReferencesFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(original, copier);
        SkyCoordinatesData orig = (SkyCoordinatesData)original;
    }

    public void wrapObjects(ReferenceablesMap referencedObjects, List referrers) {
        super.wrapObjects(referencedObjects, referrers);
        this.wrapLongitude();
        this.wrapLatitude();
    }

    @Override
    public List<IBusinessObject> referencedBOs(Referring.By ... bys) {
        List<IBusinessObject> r = super.referencedBOs(bys);
        block5: for (Referring.By by : bys) {
            switch (by) {
                case UmlComposition: {
                    continue block5;
                }
                case UmlUnidir: {
                    continue block5;
                }
                case UmlAttribution: {
                    this.addToCollection(r, this.gettrueLongitude());
                    this.addToCollection(r, this.gettrueLatitude());
                }
            }
        }
        return r;
    }

    private void wrapLongitude() {
        LongitudeT subSo = this.getCastorObject().getLongitude();
        if (subSo != null) {
            Longitude subBo;
            this.boLongitude = subBo = new Longitude(subSo);
        }
    }

    public void setLongitude(Longitude newValue) {
        SkyCoordinatesT castorObject = this.getCastorObject();
        LongitudeT subCastorObject = newValue.getCastorObject();
        castorObject.setLongitude(subCastorObject);
        this.boLongitude = newValue;
        String propName = "alma.valuetypes.SkyCoordinates.longitude";
        Longitude propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.SkyCoordinates.longitude", propValue);
    }

    public Longitude gettrueLongitude() {
        Longitude ret = this.boLongitude;
        return ret;
    }

    public Longitude getLongitude() {
        Longitude ret = this.gettrueLongitude();
        if (ret == null) {
            ret = Longitude.createLongitude();
            this.setLongitude(ret);
        }
        return ret;
    }

    private void wrapLatitude() {
        LatitudeT subSo = this.getCastorObject().getLatitude();
        if (subSo != null) {
            Latitude subBo;
            this.boLatitude = subBo = new Latitude(subSo);
        }
    }

    public void setLatitude(Latitude newValue) {
        SkyCoordinatesT castorObject = this.getCastorObject();
        LatitudeT subCastorObject = newValue.getCastorObject();
        castorObject.setLatitude(subCastorObject);
        this.boLatitude = newValue;
        String propName = "alma.valuetypes.SkyCoordinates.latitude";
        Latitude propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.SkyCoordinates.latitude", propValue);
    }

    public Latitude gettrueLatitude() {
        Latitude ret = this.boLatitude;
        return ret;
    }

    public Latitude getLatitude() {
        Latitude ret = this.gettrueLatitude();
        if (ret == null) {
            ret = Latitude.createLatitude();
            this.setLatitude(ret);
        }
        return ret;
    }

    public void setSystem(String newValue) throws IllegalArgumentException {
        SkyCoordinatesT castorObject = this.getCastorObject();
        SkyCoordinatesTSystemType castorEnumElement = SkyCoordinatesTSystemType.valueOf(newValue);
        castorObject.setSystem(castorEnumElement);
        String propName = "alma.valuetypes.SkyCoordinates.system";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.SkyCoordinates.system", propValue);
    }

    public String getSystem() {
        SkyCoordinatesT castorObject = this.getCastorObject();
        SkyCoordinatesTSystemType value = castorObject.getSystem();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownSystemList() {
        return knownSystemList;
    }

    public void setFieldName(String newValue) {
        SkyCoordinatesT castorObject = this.getCastorObject();
        castorObject.setFieldName(newValue);
        String propName = "alma.valuetypes.SkyCoordinates.fieldName";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.SkyCoordinates.fieldName", propValue);
    }

    public String gettrueFieldName() {
        SkyCoordinatesT castorObject = this.getCastorObject();
        String ret = castorObject.getFieldName();
        return ret;
    }

    public String getFieldName() {
        String ret = this.gettrueFieldName();
        if (ret == null) {
            ret = "";
            this.setFieldName(ret);
        }
        return ret;
    }

    public void setType(String newValue) throws IllegalArgumentException {
        SkyCoordinatesT castorObject = this.getCastorObject();
        SkyCoordinatesTTypeType castorEnumElement = SkyCoordinatesTTypeType.valueOf(newValue);
        castorObject.setType(castorEnumElement);
        String propName = "alma.valuetypes.SkyCoordinates.type";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.SkyCoordinates.type", propValue);
    }

    public String getType() {
        SkyCoordinatesT castorObject = this.getCastorObject();
        SkyCoordinatesTTypeType value = castorObject.getType();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownTypeList() {
        return knownTypeList;
    }
}

