/*
 * Decompiled with CFR 0.152.
 */
package alma.hibernate.util;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;

public class StringEnumUserType
implements EnhancedUserType<Enum>,
ParameterizedType {
    private Class<Enum> enumClass;

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClassName");
        try {
            this.enumClass = ReflectHelper.classForName((String)enumClassName);
            try {
                this.enumClass.getMethod("valueOfForEnum", String.class);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("Class '" + this.enumClass.getCanonicalName() + "' does not implement the valueOfForEnum(String), cannot proceed");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Enum class not found", (Throwable)cnfe);
        }
    }

    public Class<Enum> returnedClass() {
        return this.enumClass;
    }

    public int getSqlType() {
        return StandardBasicTypes.STRING.getSqlTypeCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Enum deepCopy(Enum value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Enum value) throws HibernateException {
        return value;
    }

    public Enum assemble(Serializable cached, Object owner) throws HibernateException {
        return (Enum)((Object)cached);
    }

    public Enum replace(Enum original, Enum target, Object owner) throws HibernateException {
        return original;
    }

    public boolean equals(Enum x, Enum y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Enum x) throws HibernateException {
        return x.hashCode();
    }

    public Enum fromStringValue(CharSequence xmlValue) {
        try {
            return (Enum)this.enumClass.getMethod("valueOfForEnum", String.class).invoke(this.enumClass, xmlValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HibernateException("Cannot invoke valueOfForEnum(String) in class '" + this.enumClass.getCanonicalName() + "'");
        }
    }

    public String toSqlLiteral(Enum value) {
        return "'" + value.toString() + "'";
    }

    public String toString(Enum value) {
        return value.toString();
    }

    public Enum nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor si, Object owner) throws HibernateException, SQLException {
        String name = rs.getString(position);
        try {
            return rs.wasNull() ? null : (Enum)this.enumClass.getMethod("valueOfForEnum", String.class).invoke(this.enumClass, name);
        }
        catch (Exception e) {
            throw new HibernateException("Cannot invoke valueOfForEnum(String) in class '" + this.enumClass.getCanonicalName() + "'");
        }
    }

    public void nullSafeSet(PreparedStatement st, Enum value, int index, SharedSessionContractImplementor si) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, StandardBasicTypes.STRING.getSqlTypeCode());
        } else {
            st.setString(index, value.toString());
        }
    }
}

