/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StopWatch {
    private static boolean s_shutup = false;
    private final NumberFormat millisecFormatter = new DecimalFormat("#.#");
    private Logger m_logger;
    private String subtaskName;
    private List<StopWatch> subtaskStopWatches;
    private long startTimeNanos;
    private long startClockTime;
    private long stopTimeNanos = -1L;

    public StopWatch() {
        this(null);
    }

    public StopWatch(Logger logger) {
        this(logger, null);
    }

    private StopWatch(Logger logger, String subtaskName) {
        this.m_logger = logger;
        this.subtaskName = subtaskName;
        this.reset();
    }

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public void reset() {
        this.startTimeNanos = System.nanoTime();
        this.startClockTime = System.currentTimeMillis();
        this.stopTimeNanos = -1L;
        if (this.subtaskStopWatches != null) {
            this.subtaskStopWatches.clear();
        }
    }

    public StopWatch createStopWatchForSubtask(String newSubtaskName) {
        StopWatch sw = new StopWatch(this.m_logger, newSubtaskName);
        if (this.subtaskStopWatches == null) {
            this.subtaskStopWatches = new ArrayList<StopWatch>();
        }
        this.subtaskStopWatches.add(sw);
        return sw;
    }

    public Date getStartTime() {
        return new Date(this.startClockTime);
    }

    public void stop() {
        if (this.stopTimeNanos < 0L) {
            this.stopTimeNanos = System.nanoTime();
            if (this.subtaskStopWatches != null) {
                for (StopWatch sw : this.subtaskStopWatches) {
                    sw.stop();
                }
            }
        }
    }

    public long getLapTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.getLapTimeNanos());
    }

    public String formattedMillis() {
        return this.millisecFormatter.format((double)this.getLapTimeNanos() * 1.0E-6);
    }

    public long getLapTimeNanos() {
        long endTime = this.stopTimeNanos > 0L ? this.stopTimeNanos : System.nanoTime();
        return endTime - this.startTimeNanos;
    }

    public void logLapTime(String taskDesc) {
        this.logLapTime(taskDesc, Level.FINE);
    }

    public void logLapTime(String taskDesc, Level logLevel) {
        this.logLapTime(taskDesc, logLevel, false);
    }

    public void logLapTimeWithSubtaskDetails(String taskDesc, Level logLevel) {
        this.logLapTime(taskDesc, logLevel, true);
    }

    private void logLapTime(String taskDesc, Level logLevel, boolean withSubtaskDetails) {
        if (!s_shutup) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("elapsed time in ms to ").append(taskDesc).append(": ");
                if (withSubtaskDetails && this.subtaskStopWatches != null) {
                    this.recursivePrintLapTimes(sb, 0);
                } else {
                    sb.append(this.formattedMillis());
                }
                if (this.m_logger != null) {
                    this.m_logger.log(logLevel, sb.toString());
                } else {
                    System.out.println(sb.toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getSubtaskDetails() {
        String ret = null;
        if (this.subtaskStopWatches != null) {
            StringBuilder sb = new StringBuilder();
            this.recursivePrintLapTimes(sb, 0);
            ret = sb.toString();
        }
        return ret;
    }

    private void recursivePrintLapTimes(StringBuilder sb, int depth) {
        if (this.subtaskName != null) {
            sb.append(this.subtaskName).append("=");
        }
        sb.append(this.formattedMillis());
        if (this.subtaskStopWatches != null) {
            sb.append(" { ");
            for (int i = 0; i < this.subtaskStopWatches.size(); ++i) {
                StopWatch sw = this.subtaskStopWatches.get(i);
                sw.recursivePrintLapTimes(sb, depth + 1);
                if (i < this.subtaskStopWatches.size() - 1) {
                    sb.append(',');
                }
                sb.append(' ');
            }
            sb.append('}');
        }
    }
}

