/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plottask.NamedObjectParameter;

public class DashParameter
extends NamedObjectParameter {
    public DashParameter(String name) {
        super(name);
        this.addOption("dot", new float[]{1.0f, 2.0f});
        this.addOption("dash", new float[]{4.0f, 2.0f});
        this.addOption("longdash", new float[]{8.0f, 4.0f});
        this.addOption("dotdash", new float[]{12.0f, 3.0f, 3.0f, 3.0f});
        this.setNullPermitted(true);
        this.setUsage("dot|dash|...|<a,b,...>");
    }

    public String getFormatDescription() {
        return "To generate a dashed line the value may be\n" + "one of the named dash types:\n" + this.getOptionList() + "\n" + "or may be a comma-separated string of on/off length " + "values such as\n" + "\"<code>4,2,8,2</code>\".\n" + "A <code>null</code> value indicates a solid line.";
    }

    public float[] dashValue(Environment env) throws TaskException {
        return (float[])this.objectValue(env);
    }

    public String toString(Object obj) {
        float[] dash = (float[])obj;
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < dash.length; ++i) {
            float f;
            if (i > 0) {
                sbuf.append(',');
            }
            sbuf.append((f = dash[i]) == (float)((int)f) ? Integer.toString((int)f) : Float.toString(f));
        }
        return sbuf.toString();
    }

    public Object fromString(String name) {
        String[] parts = name.split(",");
        int np = parts.length;
        float[] fs = new float[np];
        for (int i = 0; i < np; ++i) {
            fs[i] = Float.parseFloat(parts[i]);
        }
        return fs;
    }
}

