/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import uk.ac.starlink.ttools.plot.Rounder;

public class AxisLabels {
    private final int nTick_;
    private double[] ticks_;
    private String[] labels_;

    public AxisLabels(double[] ticks, String[] labels) {
        this.ticks_ = (double[])ticks.clone();
        this.labels_ = (String[])labels.clone();
        this.nTick_ = this.ticks_.length;
        if (this.nTick_ != this.labels_.length) {
            throw new IllegalArgumentException();
        }
    }

    public int getCount() {
        return this.nTick_;
    }

    public double getTick(int itick) {
        return this.ticks_[itick];
    }

    public String getLabel(int itick) {
        return this.labels_[itick];
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.nTick_; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.ticks_[i]).append('=').append(this.labels_[i]);
        }
        return sbuf.toString();
    }

    public static AxisLabels labelLinearAxis(double lo, double hi, int approxTicks) {
        Rounder rounder = Rounder.LINEAR;
        double gap = rounder.round((hi - lo) / (double)approxTicks);
        double preGap = lo % gap;
        if (preGap < 0.0) {
            preGap += gap;
        }
        double loTick = preGap == 0.0 ? lo : lo - preGap + gap;
        int nTick = (int)((hi - loTick) / gap) + 1;
        double[] ticks = new double[nTick];
        String[] labels = new String[nTick];
        for (int i = 0; i < nTick; ++i) {
            double value;
            ticks[i] = value = loTick + (double)i * gap;
            labels[i] = AxisLabels.getLabel(value);
        }
        return new AxisLabels(ticks, labels);
    }

    public static AxisLabels labelLogAxis(double lo, double hi, int approxTicks) {
        if (hi <= lo || lo <= 0.0 || hi <= 0.0) {
            throw new IllegalArgumentException("Bad range: " + lo + " .. " + hi);
        }
        if (hi / lo < 4.0) {
            return AxisLabels.labelLinearAxis(lo, hi, approxTicks);
        }
        double gapFactor = Double.NaN;
        for (int i = 0; i < 100 && Double.isNaN(gapFactor); ++i) {
            double factor;
            double d = factor = i == 0 ? 2.0 : Math.pow(10.0, i);
            if (!(Math.pow(factor, approxTicks) > hi / lo)) continue;
            gapFactor = factor;
        }
        if (Double.isNaN(gapFactor)) {
            return AxisLabels.labelLinearAxis(lo, hi, approxTicks);
        }
        double logPregap = Math.log(lo) % Math.log(gapFactor);
        if (logPregap < 0.0) {
            logPregap += Math.log(gapFactor);
        }
        double loTick = logPregap == 0.0 ? lo : lo / Math.exp(logPregap) * gapFactor;
        int nTick = (int)(Math.log(hi / loTick) / Math.log(gapFactor)) + 1;
        double[] ticks = new double[nTick];
        String[] labels = new String[nTick];
        for (int i = 0; i < nTick; ++i) {
            double value;
            ticks[i] = value = loTick * Math.pow(gapFactor, i);
            String label = AxisLabels.getLabel(value);
            if (label.equals("1000")) {
                label = "1E3";
            } else if (label.equals("10000")) {
                label = "1E4";
            } else if (label.equals("100000")) {
                label = "1E5";
            } else if (label.equals("1000000")) {
                label = "1E6";
            }
            labels[i] = label;
        }
        return new AxisLabels(ticks, labels);
    }

    private static String getLabel(double value) {
        float fval = (float)value;
        String label = Float.isInfinite(fval) || fval == 0.0f ? Double.toString(value) : Float.toString(fval);
        label = label.replaceFirst("\\.0$", "");
        label = label.replaceFirst("\\.0E", "E");
        return label;
    }

    public static void main(String[] args) {
        double lo = Double.parseDouble(args[0]);
        double hi = Double.parseDouble(args[1]);
        int ntick = Integer.parseInt(args[2]);
        System.out.println(AxisLabels.labelLinearAxis(lo, hi, ntick));
        if (lo > 0.0 && hi > 0.0) {
            System.out.println(AxisLabels.labelLogAxis(lo, hi, ntick));
        }
    }
}

