/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.nc.sm.generic;

import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.ACSErrTypeCommon.wrappers.AcsJStateMachineActionEx;
import alma.acs.nc.sm.generic.AcsScxmlActionDispatcher;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCXMLExecutor;
import org.apache.commons.scxml.SCXMLListener;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.env.SimpleDispatcher;
import org.apache.commons.scxml.env.Tracer;
import org.apache.commons.scxml.env.jexl.JexlContext;
import org.apache.commons.scxml.env.jexl.JexlEvaluator;
import org.apache.commons.scxml.io.SCXMLParser;
import org.apache.commons.scxml.model.CustomAction;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class AcsScxmlEngine<S extends Enum<S>, A extends Enum<A>> {
    private final Logger logger;
    private final AcsScxmlActionDispatcher<A> actionDispatcher;
    private final Class<S> signalType;
    private final Tracer errorTracer;
    private final Evaluator exprEvaluator;
    private final EventDispatcher eventDispatcher;
    private final Context exprContext;
    private volatile SCXMLExecutor exec;
    private SCXML scxml;

    public AcsScxmlEngine(String scxmlFileName, Logger logger, AcsScxmlActionDispatcher<A> actionDispatcher, Class<S> signalType) {
        this.logger = logger;
        this.actionDispatcher = actionDispatcher;
        this.signalType = signalType;
        if (!actionDispatcher.isActionMappingComplete()) {
            throw new IllegalArgumentException("actionDispatcher is not complete.");
        }
        this.errorTracer = new Tracer();
        this.exprEvaluator = new JexlEvaluator();
        this.eventDispatcher = new SimpleDispatcher();
        this.exprContext = new JexlContext();
        this.exprContext.set(AcsScxmlActionDispatcher.class.getName(), actionDispatcher);
        try {
            this.loadModel(scxmlFileName);
            this.startExecution();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to load or start the state machine.", ex);
        }
    }

    public void loadModel(String scxmlFileName) {
        try {
            URL scxmlUrl = this.getClass().getResource(scxmlFileName);
            if (scxmlUrl == null) {
                this.logger.severe("Failed to load the scxml definition file '" + scxmlFileName + "' from the classpath.");
            }
            List<CustomAction> scxmlActions = this.actionDispatcher.getScxmlActionMap();
            this.scxml = SCXMLParser.parse((URL)scxmlUrl, (ErrorHandler)this.errorTracer, scxmlActions);
            this.logger.fine("Loaded SCXML file " + scxmlUrl.toString() + "...");
        }
        catch (ModelException e) {
            this.logger.severe("Could not load model: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.severe("Could not load model: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.severe("Could not load model: " + e.getMessage());
        }
    }

    public void startExecution() {
        try {
            this.exec = new SCXMLExecutor(this.exprEvaluator, this.eventDispatcher, (ErrorReporter)this.errorTracer);
            this.exec.addListener(this.scxml, (SCXMLListener)this.errorTracer);
            this.exec.setRootContext(this.exprContext);
            this.exec.setStateMachine(this.scxml);
            this.exec.go();
        }
        catch (ModelException e) {
            this.logger.severe("Could not start SM execution: " + e.getMessage());
        }
        this.logger.fine("Started SM execution ...");
    }

    public String getCurrentState() {
        Set activeStates = this.exec.getCurrentStatus().getStates();
        StringBuilder sb = new StringBuilder();
        Iterator iter = activeStates.iterator();
        while (iter.hasNext()) {
            sb.append(((TransitionTarget)iter.next()).getId());
            if (!iter.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public synchronized boolean isStateActive(String stateName) {
        Set activeStates = this.exec.getCurrentStatus().getStates();
        for (TransitionTarget tt : activeStates) {
            if (tt.getId().indexOf(stateName) < 0) continue;
            return true;
        }
        return false;
    }

    public SCXMLExecutor getEngine() {
        return this.exec;
    }

    public synchronized boolean fireSignal(S signal) {
        TriggerEvent evnt = new TriggerEvent(((Enum)signal).name(), 3, null);
        try {
            this.exec.triggerEvent(evnt);
        }
        catch (ModelException e) {
            this.logger.info(e.getMessage());
        }
        return this.exec.getCurrentStatus().isFinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean fireSignalWithErrorFeedback(S signal) throws AcsJIllegalStateEventEx, AcsJStateMachineActionEx, ModelException {
        Set<S> applicableSignals = this.getApplicableSignals();
        if (!applicableSignals.contains(signal)) {
            AcsJIllegalStateEventEx ex = new AcsJIllegalStateEventEx();
            ex.setEvent(((Enum)signal).name());
            ex.setState(this.getCurrentState());
            throw ex;
        }
        MyActionExceptionHandler handler = new MyActionExceptionHandler();
        this.actionDispatcher.setActionExceptionHandler(handler);
        try {
            TriggerEvent evnt = new TriggerEvent(((Enum)signal).name(), 3, null);
            this.exec.triggerEvent(evnt);
            if (handler.theEx != null) {
                throw handler.theEx;
            }
            boolean bl = this.exec.getCurrentStatus().isFinal();
            return bl;
        }
        finally {
            this.actionDispatcher.setActionExceptionHandler(null);
        }
    }

    public synchronized Set<S> getApplicableSignals() {
        HashSet<String> events = new HashSet<String>();
        HashSet<TransitionTarget> stateSet = new HashSet<TransitionTarget>(this.exec.getCurrentStatus().getStates());
        LinkedList<TransitionTarget> todoList = new LinkedList<TransitionTarget>(stateSet);
        while (!todoList.isEmpty()) {
            TransitionTarget tt = (TransitionTarget)todoList.removeFirst();
            List transitions = tt.getTransitionsList();
            for (Transition t : transitions) {
                String event = t.getEvent();
                events.add(event);
            }
            TransitionTarget parentTT = tt.getParent();
            if (parentTT == null || stateSet.contains(parentTT)) continue;
            stateSet.add(parentTT);
            todoList.addLast(parentTT);
        }
        HashSet<S> ret = new HashSet<S>();
        for (String signalName : events) {
            S signal = Enum.valueOf(this.signalType, signalName);
            ret.add(signal);
        }
        return ret;
    }

    private static class MyActionExceptionHandler
    implements AcsScxmlActionDispatcher.ActionExceptionHandler {
        volatile AcsJStateMachineActionEx theEx;

        private MyActionExceptionHandler() {
        }

        @Override
        public void setActionException(AcsJStateMachineActionEx ex) {
            if (this.theEx == null) {
                this.theEx = ex;
            }
        }
    }
}

