/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class DalQuery {
    private final CgiQuery cgi_;
    private String name_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public DalQuery(RegResource resource, RegCapabilityInterface capability, double raPos, double decPos, double size) {
        this(capability.getAccessUrl(), raPos, decPos, size);
        String id = null;
        if (id == null) {
            id = resource.getShortName();
        }
        if (id == null) {
            id = resource.getTitle();
        }
        if (id != null) {
            this.name_ = id;
        }
    }

    public DalQuery(String baseURL, double raPos, double decPos, double size) {
        this.cgi_ = new CgiQuery(baseURL);
        this.name_ = baseURL;
        this.addArgument("POS", this.doubleToString(raPos) + "," + this.doubleToString(decPos));
        this.addArgument("SIZE", this.doubleToString(size));
    }

    public void addArgument(String name, String value) {
        this.cgi_.addArgument(name, value);
    }

    public StarTable execute(StarTableFactory tfact) throws IOException {
        VOElement topEl;
        URL qurl = this.cgi_.toURL();
        logger_.info("Submitting query: " + qurl);
        StoragePolicy storage = tfact.getStoragePolicy();
        try {
            topEl = new VOElementFactory(storage).makeVOElement(qurl.openStream(), qurl.toString());
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        NodeList resources = topEl.getElementsByTagName("RESOURCE");
        Node results = null;
        for (int i = 0; i < resources.getLength(); ++i) {
            Element resource = (Element)resources.item(i);
            if (!resource.hasAttribute("type")) {
                results = resource;
                continue;
            }
            if (!"results".equals(resource.getAttribute("type"))) continue;
            results = resource;
            break;
        }
        if (results == null) {
            throw new IOException("No suitable RESOURCE found in returned VOTable");
        }
        String status = null;
        String message = null;
        for (Node node = results.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element el;
            if (!(node instanceof Element) || !"INFO".equals((el = (Element)node).getTagName()) || !"QUERY_STATUS".equals(el.getAttribute("name"))) continue;
            status = el.getAttribute("value");
            message = DOMUtils.getTextContent((Element)el);
            break;
        }
        if ("ERROR".equals(status)) {
            throw new IOException("SIAP query error: " + message);
        }
        VOStarTable st = null;
        for (Node node = results.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof TableElement)) continue;
            st = new VOStarTable((TableElement)node);
            break;
        }
        if (st == null) {
            throw new IOException("No TABLE element found in SIAP returned VOTable");
        }
        return st;
    }

    public String toString() {
        return this.name_;
    }

    public String doubleToString(double value) {
        return CgiQuery.formatDouble((double)value);
    }
}

