<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:opl="Alma/ObsPrep/ObsProposal"
                xmlns:op="Alma/ObsPrep/ObsProject">

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>


<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<!-- For ObsProposal at  present simply correct the entity ref and modify the entity - other items are in flux -->

<xsl:template match="opl:ObsProposal">
<ObsProposal xmlns="Alma/ObsPrep/ObsProposal">
  <xsl:attribute name="schemaVersion">8</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="@revision"/></xsl:attribute>
  <xsl:attribute name="xsi:type">ObsProposal</xsl:attribute>
  <xsl:apply-templates select="node()"/>
  
  <xsl:comment>Converted to V8 by ObsProposal7-8.xslt</xsl:comment>

</ObsProposal>
</xsl:template>

<xsl:template match="opl:ObsProposalEntity">
<ObsProposalEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">8</xsl:attribute>
</ObsProposalEntity>
</xsl:template>

<!-- Correct the ObsProjectRef -->
  <xsl:template match="opl:ObsProjectRef">
    <ObsProjectRef>
      <xsl:choose>
        <xsl:when test="entity-id">
          <xsl:attribute name="entityId"><xsl:value-of select="entity-id"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="entity-type-name">
          <xsl:attribute name="entityTypeName"><xsl:value-of select="entity-type-name"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:attribute name="documentVersion">1</xsl:attribute>
      <!-- Just in case this Ref was correctly formed to start with -->
      <xsl:apply-templates select="./@entityId"></xsl:apply-templates>
      <xsl:apply-templates select="./@entityTypeName"></xsl:apply-templates>
    </ObsProjectRef>
  </xsl:template>
 

</xsl:stylesheet>
