/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.mock;

import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.wrappers.Permissions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockSchemaManager
implements SchemaManager {
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Map<String, List<String>> schemaNamesToUids = new HashMap<String, List<String>>();

    @Override
    public void close() throws DatabaseException {
    }

    @Override
    public URI getSchemaURI(String schemaName) throws ArchiveException {
        try {
            List<String> uris = this.schemaNamesToUids.get(schemaName);
            if (uris == null || uris.isEmpty()) {
                return new URI("uid://fake_schema_uid/is_not_important/for_tests");
            }
            return new URI(uris.get(uris.size() - 1));
        }
        catch (URISyntaxException e) {
            throw new ArchiveException("failed to create a schema URI", e);
        }
    }

    @Override
    public void refresh() throws ArchiveException {
    }

    @Override
    public URI getSchemaURI(String schemaName, int version) throws ArchiveException {
        try {
            return new URI(this.schemaNamesToUids.get(schemaName).get(version - 1));
        }
        catch (URISyntaxException e) {
            throw new ArchiveException("failed i ncreating a schema URI", e);
        }
    }

    @Override
    public String getSchemaName(URI schemaUri) throws ArchiveException {
        return this.schemaNamesToUids.entrySet().stream().filter(e -> ((List)e.getValue()).contains(schemaUri.toString())).map(Map.Entry::getKey).findFirst().orElse("uid://fake_schema_uid/is_not_important/for_tests");
    }

    @Override
    public int getSchemaVersion(URI schemaUri) throws ArchiveException {
        String schema = this.getSchemaName(schemaUri);
        if (schema == null) {
            return 0;
        }
        List<String> schemaVersions = this.schemaNamesToUids.get(schema);
        if (schemaVersions == null) {
            return 0;
        }
        return schemaVersions.size();
    }

    @Override
    public Map<String, String> getSchemaNamespaces(URI schemaUri) throws ArchiveException {
        return this.namespaces;
    }

    @Override
    public void registerNamespace(String prefix, URI namespace) throws ArchiveException {
        if (this.namespaces.containsKey(prefix)) {
            throw new NamespaceDefinedException(prefix);
        }
        this.namespaces.put(prefix, namespace.toString());
    }

    @Override
    public void removeNamespace(String prefix) throws ArchiveException {
        this.namespaces.remove(prefix);
    }

    @Override
    public void removeAll() throws ArchiveException {
    }

    @Override
    public boolean namespaceExists(URI namespace) throws ArchiveException {
        return this.namespaces.containsValue(namespace.toString());
    }

    @Override
    public void assignNamespace(String namespaceName, URI schemaUri) throws ArchiveException {
    }

    @Override
    public void withdrawNamespace(String name, URI schemaUri) throws ArchiveException {
    }

    @Override
    public Map<String, String> namespaces() throws ArchiveException {
        return this.namespaces;
    }

    @Override
    public List<String> listSchema() throws ArchiveException {
        return Collections.emptyList();
    }

    @Override
    public void addSchema(String schemaName, String xml, String indexConfig, URI schemaURInew, String owner, Permissions permissions) throws ArchiveException {
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(schemaURInew.toString());
        this.schemaNamesToUids.put(schemaName, uris);
    }

    @Override
    public void updateSchema(String schemaName, String xml, String indexConfig, URI schemaURIold, URI schemaURInew, String owner, Permissions permissions) throws ArchiveException {
        this.schemaNamesToUids.get(schemaName).add(schemaURInew.toString());
    }

    @Override
    public void removeSchema(String schemaName) throws ArchiveException {
    }
}

