/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.jhelpgen;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class Util {
    private static Comparator<File> alphabeticSort = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static List<File> findFiles(List<File> ret, File dir, String ... extensions) {
        LinkedList<File> subdirs = new LinkedList<File>();
        File[] ff = dir.listFiles();
        Arrays.sort(ff, alphabeticSort);
        for (File f : ff) {
            if (f.isDirectory()) {
                subdirs.add(f);
                continue;
            }
            for (String ext : extensions) {
                if (!f.getName().endsWith(ext)) continue;
                ret.add(f);
            }
        }
        for (File f : subdirs) {
            Util.findFiles(ret, f, extensions);
        }
        return ret;
    }

    static String readFile(File f) {
        BufferedInputStream bis = null;
        try {
            int c;
            bis = new BufferedInputStream(new FileInputStream(f));
            StringBuilder buf = new StringBuilder((int)f.length());
            while ((c = bis.read()) != -1) {
                if (c == 13 || c == 10) continue;
                buf.append((char)c);
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("workdir is " + System.getProperty("user.dir") + ", couldn't read file contents: " + e);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeFile(String contents, File f) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(f);
            fw.write(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("workdir is " + System.getProperty("user.dir") + ", couldn't write contents to file: " + e);
        }
        finally {
            try {
                fw.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String readResource(String name) {
        InputStream is = Util.class.getResourceAsStream(name);
        if (is == null) {
            throw new RuntimeException("resource not found: " + name);
        }
        BufferedInputStream bis = null;
        try {
            int c;
            bis = new BufferedInputStream(is);
            StringBuilder buf = new StringBuilder(4096);
            while ((c = bis.read()) != -1) {
                buf.append((char)c);
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't read from resource: " + e);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }
}

