/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.app.CommandCenterLogic;
import alma.acs.commandcenter.engine.ExecuteTools;
import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.gui.AddToDeployTree;
import alma.acs.commandcenter.gui.BasicDialog;
import alma.acs.commandcenter.gui.DeploymentTree;
import alma.acs.commandcenter.gui.EditCommandsPanel;
import alma.acs.commandcenter.gui.EditContainerSettingsDialog;
import alma.acs.commandcenter.gui.EditPexpectsPanel;
import alma.acs.commandcenter.gui.EditVariablesPanel;
import alma.acs.commandcenter.gui.ErrorBox;
import alma.acs.commandcenter.gui.FeedbackArea;
import alma.acs.commandcenter.gui.FeedbackTabs;
import alma.acs.commandcenter.gui.LogoPanel;
import alma.acs.commandcenter.gui.ManagerLocationPanel;
import alma.acs.commandcenter.gui.TabPanel;
import alma.acs.commandcenter.gui.ToolInputPanel;
import alma.acs.commandcenter.gui.thirdparty.SpringUtilities;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.commandcenter.util.VariableString;
import alma.acs.util.AcsLocations;
import alma.entity.xmlbinding.acscommandcenterproject.ContainerT;
import alma.entity.xmlbinding.acscommandcenterproject.types.ModeType;
import alma.entity.xmlbinding.acscommandcentertools.Tool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class CommandCenterGui {
    protected static Color COLOR_ActiveButton = Color.gray;
    protected static Color COLOR_PassiveButton = new JButton().getBackground();
    protected static Color COLOR_LogoBackground_A = Color.black;
    protected static Color COLOR_LogoBackground_B = new Color(0, 110, 160);
    protected static Color COLOR_LogoForeground = new Color(255, 255, 255);
    public CommandCenterLogic controller;
    protected Logger log;
    public JFrame frame;
    public JDesktopPane desktop;
    protected TabPanel frontPanel;
    protected FeedbackTabs feedbackTabs;
    public DeploymentTree deployTree;
    protected JPanel deploymentInfoPanel;
    protected NativeCommand.Listener taskListenerObjectExplorer;
    protected NativeCommand.Listener taskListenerAdminClient;
    protected NativeCommand.Listener taskListenerJlogClient;
    protected NativeCommand.Listener taskListenerCdbBrowser;
    protected NativeCommand.Listener taskListenerDynClient;
    protected NativeCommand.Listener taskListenerInterfaceRepBrowser;
    protected NativeCommand.Listener taskListenerNameServiceBrowser;
    protected JMenuBar menuBar;
    protected JMenu toolsMenu;
    protected File currentProjectFile;
    protected BasicDialog managerLocationDialog1;
    protected ManagerLocationPanel.ForTools pnlManagerLocationForTools;
    protected BasicDialog managerLocationDialog2;
    protected ManagerLocationPanel.ForContainers pnlManagerLocationForContainers;
    protected JSplitPane splitLeftRight;
    protected JSplitPane splitTopBottom;
    protected BasicDialog dlgEditVariables;
    protected EditVariablesPanel pnlEditVariables;
    protected EditContainerSettingsDialog dlgContainerSettings;
    JDialog dialog = null;
    JEditorPane editor = null;
    protected DefaultHelpBroker helpBroker;
    protected JDialog editCommandsDialog;
    protected EditCommandsPanel editCommandsPanel;
    protected JDialog editPexpectsDialog;
    protected EditPexpectsPanel editPexpectsPanel;
    protected Vector<JMenuItem> addedToolMenuItems = new Vector();
    protected static final Pattern p = Pattern.compile(".*the ACS_INSTANCE, (.+), is currently in use.*");
    protected Icons icons = new Icons();

    public CommandCenterGui(CommandCenterLogic controller) {
        this.controller = controller;
        this.log = MiscUtils.getPackageLogger(this);
    }

    public void prepare() {
        boolean setLookAndFeel = false;
        if (setLookAndFeel) {
            String lafName = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(lafName);
            }
            catch (Exception exc) {
                this.log.fine("Couldn't set look and feel " + lafName + " due to " + exc);
            }
        }
        this.frame = new JFrame("");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CommandCenterGui.this.controller.stop();
            }
        });
        this.dlgContainerSettings = new EditContainerSettingsDialog(this);
        this.frontPanel = new TabPanel(this);
        this.writeModelToFrontPanel();
        this.splitLeftRight = new JSplitPane(1);
        this.splitLeftRight.setOneTouchExpandable(true);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(new EmptyBorder(10, 10, 10, 10));
        p2.add((Component)this.frontPanel, "North");
        this.splitLeftRight.setLeftComponent(p2);
        this.deploymentInfoPanel = new JPanel(new BorderLayout());
        this.deploymentInfoPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 7, 5, 7), new TitledBorder(LineBorder.createBlackLineBorder(), " Deployment Info ")));
        this.deployTree = new DeploymentTree(this.controller.deploymentTreeControllerImpl);
        AddToDeployTree addToDeployTree = new AddToDeployTree(this, this.deployTree);
        this.deploymentInfoPanel.add((Component)addToDeployTree, "North");
        this.deploymentInfoPanel.add((Component)new JScrollPane(this.deployTree), "Center");
        this.splitLeftRight.setRightComponent(this.deploymentInfoPanel);
        this.feedbackTabs = new FeedbackTabs(this, 3);
        LogoPanel logoPanel = new LogoPanel(COLOR_LogoBackground_A, COLOR_LogoBackground_B);
        logoPanel.setLayout(new BorderLayout());
        JLabel alma = new JLabel(new ImageIcon(this.controller.findResource("alma.jpg")));
        logoPanel.add((Component)alma, "West");
        JLabel text = new JLabel("Acs Command Center");
        text.setForeground(COLOR_LogoForeground);
        text.setHorizontalTextPosition(0);
        text.setFont(text.getFont().deriveFont((float)((double)text.getFont().getSize() * 2.5)));
        text.setBorder(new EmptyBorder(5, 30, 5, 30));
        logoPanel.add((Component)text, "Center");
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("Project");
        fileMenu.setMnemonic(80);
        JMenu newMenu = new JMenu("New");
        newMenu.add(new ActionNewProject("Project"));
        fileMenu.add(newMenu);
        fileMenu.add(new ActionOpenProject("Open..."));
        fileMenu.add(new ActionSaveProject("Save"));
        fileMenu.add(new ActionSaveAsProject("Save As..."));
        fileMenu.addSeparator();
        fileMenu.add(new ActionExit("Exit"));
        this.menuBar.add(fileMenu);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        this.toolsMenu.add(new ActionConfigureTools("Configure Tools..."));
        this.toolsMenu.addSeparator();
        this.menuBar.add(this.toolsMenu);
        JMenu extrasMenu = new JMenu("Expert");
        extrasMenu.setMnemonic(69);
        JMenu extraTools = new JMenu("Tools Menu");
        extraTools.add(new ActionShowExtraTools("View..."));
        extraTools.add(new ActionInstallExtraTools("Replace..."));
        extrasMenu.add(extraTools);
        JMenu builtinTools = new JMenu("Acs Scripts");
        builtinTools.add(new ActionShowBuiltinTools("View..."));
        builtinTools.add(new ActionLoadBuiltinTools("Replace..."));
        extrasMenu.add(builtinTools);
        extrasMenu.add(new JSeparator());
        extrasMenu.add(new ActionShowVariables("Variables..."));
        this.menuBar.add(extrasMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem item = helpMenu.add(new ActionShowHelp("Online Help"));
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        item = helpMenu.add(new ActionShowAbout("About"));
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(helpMenu);
        JPanel h = new JPanel(new SpringLayout());
        h.add(logoPanel);
        h.add(this.menuBar);
        SpringUtilities.makeCompactGrid(h, 0, 1);
        this.frame.getContentPane().add((Component)h, "North");
        this.pnlManagerLocationForTools = new ManagerLocationPanel.ForTools();
        this.managerLocationDialog1 = new BasicDialog(this, "Specify Manager and Services for Tools", "Set", this.pnlManagerLocationForTools);
        this.pnlManagerLocationForContainers = new ManagerLocationPanel.ForContainers();
        this.managerLocationDialog2 = new BasicDialog(this, "Specify Manager and Services for Containers", "Set", this.pnlManagerLocationForContainers);
        this.splitTopBottom = new JSplitPane(0, this.splitLeftRight, this.feedbackTabs);
        this.splitTopBottom.setOneTouchExpandable(true);
        AccInternalFrame bigInternalFrame = new AccInternalFrame();
        bigInternalFrame.add(this.splitTopBottom);
        this.desktop = new JDesktopPane();
        bigInternalFrame.setVisible(true);
        this.desktop.add(bigInternalFrame);
        this.frame.getContentPane().add((Component)this.desktop, "Center");
        try {
            bigInternalFrame.setSelected(true);
            bigInternalFrame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.desktop.setPreferredSize(bigInternalFrame.getPreferredSize());
        this.doFrameTitle();
    }

    public void go(boolean admincMode) {
        if (admincMode) {
            this.menuBar.setVisible(false);
            this.splitLeftRight.getLeftComponent().setVisible(false);
            this.splitTopBottom.getBottomComponent().setVisible(false);
        } else {
            this.splitTopBottom.validate();
            this.splitLeftRight.setDividerLocation((int)((double)this.frame.getWidth() - (double)this.deploymentInfoPanel.getPreferredSize().width * 1.1));
        }
        this.frame.pack();
        if (this.controller.startupOptions.geometry != null) {
            this.frame.setBounds(this.controller.startupOptions.geometry);
        }
        this.frame.setVisible(true);
    }

    public void stop() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    protected void managerStarted() {
        if (this.deployTree == null) {
            return;
        }
        String host = this.controller.model.deriveMgrHostfromCommonSettings();
        String port = this.controller.model.deriveMgrPortfromCommonSettings();
        try {
            this.deployTree.shieldedAddManager(AcsLocations.convertToManagerLocation((String)host, (String)port));
        }
        catch (Exception exc) {
            this.log.log(Level.FINER, "Couldn't add manager (" + host + "," + port + ") to deployment view", exc);
        }
    }

    protected void managerStopped() {
        if (this.deployTree == null) {
            return;
        }
        String host = this.controller.model.deriveMgrHostfromCommonSettings();
        String port = this.controller.model.deriveMgrPortfromCommonSettings();
        try {
            String managerLoc = AcsLocations.convertToManagerLocation((String)host, (String)port);
            boolean ok = this.deployTree.removeManager(managerLoc, true);
            if (!ok) {
                this.log.finer("Couldn't remove manager from deployment view: no such manager known: " + host + "," + port);
            }
        }
        catch (Exception exc) {
            this.log.log(Level.FINER, "Tried to remove (" + host + "," + port + ") manager from deployment view, failed", exc);
        }
    }

    public void setCurrentProjectFile(File f) {
        this.currentProjectFile = f;
    }

    public void currentProjectChanged() {
        this.doFrameTitle();
        this.writeModelToFrontPanel();
    }

    protected void doFrameTitle() {
        String app = "Acs Command Center";
        String proj = this.currentProjectFile == null ? "(project)" : this.currentProjectFile.getName();
        this.frame.setTitle(proj + " - " + app);
    }

    protected File showOpenDialog() {
        File ret = null;
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this.frame);
        if (returnVal == 0) {
            ret = chooser.getSelectedFile();
        }
        return ret;
    }

    protected File showSaveDialog() {
        File ret = null;
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showSaveDialog(this.frame);
        if (returnVal == 0) {
            ret = chooser.getSelectedFile();
        }
        return ret;
    }

    public void showUnresolvableVariableErrorDialog(String var) {
        ErrorBox.showErrorDialog((Component)this.frame, "Variable has been used but is undefined: " + var, "Go to the Variables Editor now and define variable '" + var + "'.\n\nTip: Define a Java system property '" + var + "' before running\nAcs Command Center. E.g., on the command line you'd do\nexport JAVA_OPTIONS=\"$JAVA_OPTIONS -D" + var + "=YourValue\"");
    }

    protected void showVariablesEditor() {
        if (this.dlgEditVariables == null) {
            this.pnlEditVariables = new EditVariablesPanel(this);
            this.dlgEditVariables = new BasicDialog(this, "Project Variables", "Set", this.pnlEditVariables);
        }
        Map<String, Object>[] m = this.controller.giveVariableMapsForGui();
        this.pnlEditVariables.preShow(m[0], m[1], m[2]);
        this.dlgEditVariables.bringUp();
        if (this.dlgEditVariables.okChosen) {
            this.pnlEditVariables.afterOk();
        }
    }

    protected void writeModelToManagerLocationForTools() {
        this.pnlManagerLocationForTools.defaultHostF.setText(this.controller.model.deriveMgrHostfromCommonSettings());
        this.pnlManagerLocationForTools.defaultPortF.setText(this.controller.model.deriveMgrPortfromCommonSettings());
        this.pnlManagerLocationForTools.defaultIntRepF.setText(this.controller.model.deriveIRfromCommonSettings());
        this.pnlManagerLocationForTools.defaultNameServiceF.setText(this.controller.model.deriveNSfromCommonSettings());
        this.pnlManagerLocationForTools.customHostF.setText(String.valueOf(this.controller.project.getToolAgainstManagerHost()));
        this.pnlManagerLocationForTools.customPortF.setText(String.valueOf(this.controller.project.getToolAgainstManagerPort()));
        this.pnlManagerLocationForTools.customIntRepF.setText(String.valueOf(this.controller.project.getToolAgainstInterfaceRepository()));
        this.pnlManagerLocationForTools.customNameServiceF.setText(String.valueOf(this.controller.project.getToolAgainstNameService()));
        this.pnlManagerLocationForTools.btnCustom.setSelected(this.controller.project.getToolRunAgainstDedicatedSettings());
        this.pnlManagerLocationForTools.btnLatest.setSelected(!this.controller.project.getToolRunAgainstDedicatedSettings());
    }

    protected void writeManagerLocationForToolsToModel() {
        this.controller.project.setToolAgainstManagerHost(this.pnlManagerLocationForTools.customHostF.getText().trim());
        this.controller.project.setToolAgainstManagerPort(this.pnlManagerLocationForTools.customPortF.getText().trim());
        this.controller.project.setToolAgainstInterfaceRepository(this.pnlManagerLocationForTools.customIntRepF.getText().trim());
        this.controller.project.setToolAgainstNameService(this.pnlManagerLocationForTools.customNameServiceF.getText().trim());
        this.controller.project.setToolRunAgainstDedicatedSettings(this.pnlManagerLocationForTools.btnCustom.isSelected());
    }

    protected void showManagerLocationForContainersDialog() {
        this.writeModelToManagerLocationForContainers();
        this.managerLocationDialog2.bringUp();
        boolean ok = this.managerLocationDialog2.okChosen;
        if (ok) {
            this.writeManagerLocationForContainersToModel();
        }
    }

    protected void writeModelToManagerLocationForContainers() {
        this.pnlManagerLocationForContainers.defaultHostF.setText(this.controller.model.deriveMgrHostfromCommonSettings());
        this.pnlManagerLocationForContainers.defaultPortF.setText(this.controller.model.deriveMgrPortfromCommonSettings());
        this.pnlManagerLocationForContainers.defaultCdbF.setText(this.controller.model.deriveCDBfromCommonSettings());
        this.pnlManagerLocationForContainers.defaultIntRepF.setText(this.controller.model.deriveIRfromCommonSettings());
        this.pnlManagerLocationForContainers.customHostF.setText(String.valueOf(this.controller.project.getContainers().getAgainstManagerHost()));
        this.pnlManagerLocationForContainers.customPortF.setText(String.valueOf(this.controller.project.getContainers().getAgainstManagerPort()));
        this.pnlManagerLocationForContainers.customCdbF.setText(String.valueOf(this.controller.project.getContainers().getAgainstCDB()));
        this.pnlManagerLocationForContainers.customIntRepF.setText(String.valueOf(this.controller.project.getContainers().getAgainstInterfaceRepository()));
        this.pnlManagerLocationForContainers.btnCustom.setSelected(this.controller.project.getContainers().getRunAgainstDedicatedSettings());
        this.pnlManagerLocationForContainers.btnLatest.setSelected(!this.controller.project.getContainers().getRunAgainstDedicatedSettings());
    }

    protected void writeManagerLocationForContainersToModel() {
        this.controller.project.getContainers().setAgainstManagerHost(this.pnlManagerLocationForContainers.customHostF.getText().trim());
        this.controller.project.getContainers().setAgainstManagerPort(this.pnlManagerLocationForContainers.customPortF.getText().trim());
        this.controller.project.getContainers().setAgainstCDB(this.pnlManagerLocationForContainers.customCdbF.getText().trim());
        this.controller.project.getContainers().setAgainstInterfaceRepository(this.pnlManagerLocationForContainers.customIntRepF.getText().trim());
        this.controller.project.getContainers().setRunAgainstDedicatedSettings(this.pnlManagerLocationForContainers.btnCustom.isSelected());
    }

    protected void showContainerSettingsDialog() {
        int contIndex = (int)this.controller.project.getContainers().getSelect();
        ContainerT cont = this.controller.project.getContainers().getContainer(contIndex);
        this.writeModelToContainerSettingsDialog(cont);
        this.dlgContainerSettings.bringUp();
        if (!this.dlgContainerSettings.okChosen) {
            return;
        }
        this.writeContainerSettingsDialogToModel(cont);
        TabPanel.ContainerLine contline = this.frontPanel.containerLines.get(contIndex);
        String host = cont.getUseDedicatedSettings() ? cont.getRemoteHost() : null;
        contline.populate(cont.getName(), cont.getType(), host, true);
    }

    protected void writeModelToContainerSettingsDialog(ContainerT cont) {
        String modif = MiscUtils.join(cont.getTypeModifier());
        this.dlgContainerSettings.modifF.setText(modif);
        this.dlgContainerSettings.heapF.setText(cont.getHeapSizeMB());
        this.dlgContainerSettings.defaultHostF.setText(this.controller.project.getRemoteHost());
        this.dlgContainerSettings.defaultAccountF.setText(this.controller.project.getRemoteAccount());
        this.dlgContainerSettings.defaultPasswordF.setText(this.controller.project.getRemotePassword());
        this.dlgContainerSettings.hostF.setText(cont.getRemoteHost());
        this.dlgContainerSettings.accountF.setText(cont.getRemoteAccount());
        this.dlgContainerSettings.passwordF.setText(cont.getRemotePassword());
        this.dlgContainerSettings.btnCustom.setSelected(cont.getUseDedicatedSettings());
        this.dlgContainerSettings.btnGlobal.setSelected(!cont.getUseDedicatedSettings());
    }

    protected void writeContainerSettingsDialogToModel(ContainerT cont) {
        cont.setTypeModifier(MiscUtils.split(this.dlgContainerSettings.modifF.getText().trim()));
        cont.setHeapSizeMB(this.dlgContainerSettings.heapF.getText().trim());
        cont.setScriptBase(this.controller.project.getScriptBase());
        cont.setRemoteHost(this.dlgContainerSettings.hostF.getText().trim());
        cont.setRemoteAccount(this.dlgContainerSettings.accountF.getText().trim());
        cont.setRemotePassword(this.dlgContainerSettings.passwordF.getText().trim());
        cont.setUseDedicatedSettings(!this.dlgContainerSettings.btnGlobal.isSelected());
    }

    protected void writeFrontPanelToModel() {
        this.controller.project.setScriptBase(this.frontPanel.acsinstanceF.getText().trim());
        this.controller.project.setServicesLocalJavaRoot(this.frontPanel.cdbrootF.getText().trim());
        this.controller.project.setRemoteHost(this.frontPanel.hostF.getText().trim());
        this.controller.project.setRemoteAccount(this.frontPanel.accountF.getText().trim());
        this.controller.project.setRemotePassword(this.frontPanel.passwordF.getText().trim());
        if (this.frontPanel.chkLocalScript.isSelected()) {
            this.controller.project.setMode(ModeType.LOCAL);
        } else if (this.frontPanel.chkRemoteScript.isSelected()) {
            if (this.frontPanel.chkRemoteDaemons.isSelected()) {
                this.controller.project.setMode(ModeType.REMOTE_DAEMON);
            } else if (this.frontPanel.chkRemoteNative.isSelected()) {
                this.controller.project.setMode(ModeType.REMOTE_NATIVE);
            } else {
                this.controller.project.setMode(ModeType.REMOTE);
            }
        }
        for (int i = 0; i < this.frontPanel.containerLines.size(); ++i) {
            TabPanel.ContainerLine c = this.frontPanel.containerLines.elementAt(i);
            ContainerT cont = this.controller.project.getContainers().getContainer(i);
            if (cont == null) {
                this.log.fine("PROBLEM: number of containers in model and gui is out-of-sync");
                break;
            }
            if (c.selectB.isSelected()) {
                this.controller.project.getContainers().setSelect((long)i);
            }
            cont.setName(c.nameF.getText().trim());
            cont.setType(String.valueOf(c.typeF.getSelectedItem()).trim());
        }
    }

    protected void writeModelToFrontPanel() {
        this.frontPanel.acsinstanceF.setText(this.controller.project.getScriptBase());
        this.frontPanel.cdbrootF.setText(this.controller.project.getServicesLocalJavaRoot());
        this.frontPanel.hostF.setText(this.controller.project.getRemoteHost());
        this.frontPanel.accountF.setText(this.controller.project.getRemoteAccount());
        ModeType mode = this.controller.project.getMode();
        if (mode.equals(ModeType.LOCAL)) {
            this.frontPanel.chkLocalScript.setSelected(true);
        } else if (mode.equals(ModeType.REMOTE)) {
            this.frontPanel.chkRemoteScript.setSelected(true);
            this.frontPanel.chkRemoteBuiltin.setSelected(true);
            this.frontPanel.chkRemoteDaemons.setSelected(false);
            this.frontPanel.chkRemoteNative.setSelected(false);
        } else if (mode.equals(ModeType.REMOTE_DAEMON)) {
            this.frontPanel.chkRemoteScript.setSelected(true);
            this.frontPanel.chkRemoteBuiltin.setSelected(false);
            this.frontPanel.chkRemoteDaemons.setSelected(true);
            this.frontPanel.chkRemoteNative.setSelected(false);
        } else if (mode.equals(ModeType.REMOTE_NATIVE)) {
            this.frontPanel.chkRemoteScript.setSelected(true);
            this.frontPanel.chkRemoteBuiltin.setSelected(false);
            this.frontPanel.chkRemoteDaemons.setSelected(false);
            this.frontPanel.chkRemoteNative.setSelected(true);
        } else if (mode.equals(ModeType.JAVA)) {
            this.frontPanel.chkLocalScript.setSelected(true);
        }
        while (this.frontPanel.containerLines.size() > 0) {
            this.frontPanel.lessContainerLines();
        }
        for (int i = 0; i < this.controller.project.getContainers().getContainerCount(); ++i) {
            ContainerT cont = this.controller.project.getContainers().getContainer(i);
            TabPanel.ContainerLine contline = this.frontPanel.addEmptyContainerLine();
            String host = cont.getUseDedicatedSettings() ? cont.getRemoteHost() : null;
            contline.populate(cont.getName(), cont.getType(), host, (long)i == this.controller.project.getContainers().getSelect());
        }
        this.frontPanel.disenabler.actionPerformed(null);
    }

    public void correctDialogLocation(JDialog d) {
        Point p = d.getLocation();
        if (p.x == 0 && p.y == 0) {
            d.setLocationRelativeTo(d.getParent());
        }
    }

    protected Border createTitledBorder(String title) {
        CompoundBorder ret = new CompoundBorder(new EmptyBorder(5, 7, 5, 7), new TitledBorder(LineBorder.createBlackLineBorder(), title));
        return ret;
    }

    public void showUrlContent(URL url, String title) {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.frame);
            this.dialog.setSize(600, 400);
            this.editor = new JEditorPane();
            this.editor.setEditable(false);
            JScrollPane scroll = new JScrollPane(this.editor);
            this.dialog.getContentPane().add(scroll);
            this.dialog.setLocationRelativeTo(this.frame);
        }
        try {
            this.editor.setPage(url);
            this.dialog.setTitle(title + "  -  " + url);
            this.dialog.setVisible(true);
        }
        catch (Exception exc) {
            ErrorBox.showMessageDialog(this.frame, "Cannot show the resource: " + exc, true);
        }
    }

    protected void showHelpBrowser() {
        if (this.helpBroker == null) {
            HelpSet helpSet = this.controller.getHelpSet();
            if (helpSet == null) {
                ErrorBox.showMessageDialog(this.frame, "Online Help could not be loaded", true);
                return;
            }
            this.helpBroker = (DefaultHelpBroker)helpSet.createHelpBroker();
        }
        this.helpBroker.setCurrentID("intro");
        this.helpBroker.setDisplayed(true);
    }

    public void addExtraTool(Tool tool, final HashMap<String, Object> result, final ExecuteTools.ToolStarter ts) {
        final ToolInputPanel tp = new ToolInputPanel(this, tool);
        final String cap = tool.getCaption();
        Object menuCaption = tp.counter == 0 ? cap : cap + "...";
        final String tabCaption = cap.length() < 15 ? cap : cap.substring(0, 8) + "..." + cap.substring(cap.length() - 4);
        AbstractAction a = new AbstractAction((String)menuCaption){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (tp.counter > 0) {
                    boolean ok = tp.showPanel();
                    if (!ok) {
                        return;
                    }
                    HashMap<String, String> map = tp.evaluate();
                    result.putAll(map);
                }
                NativeCommand.Listener listener = CommandCenterGui.this.giveOutputListener(tabCaption);
                try {
                    ts.start(listener);
                }
                catch (VariableString.UnresolvableException exc) {
                    String var = exc.getVariableName();
                    CommandCenterGui.this.controller.handleUnresolvableVariable(var);
                    CommandCenterGui.this.log.log(Level.INFO, "Couldn't start tool '" + cap + "': Variable '" + var + "' is undefined");
                }
                catch (Throwable t) {
                    CommandCenterGui.this.log.info("Couldn't start tool '" + cap + "', check definition file; reason was: " + t);
                }
            }
        };
        JMenuItem mi = this.toolsMenu.add(a);
        this.addedToolMenuItems.add(mi);
    }

    public void removeAllExtraTools() {
        for (int i = 0; i < this.addedToolMenuItems.size(); ++i) {
            this.toolsMenu.remove(this.addedToolMenuItems.get(i));
        }
        this.addedToolMenuItems.clear();
    }

    protected NativeCommand.Listener giveOutputListener(String taskName) {
        NativeCommand.Listener ret = this.feedbackTabs.viewTab(taskName);
        return ret;
    }

    protected NativeCommand.Listener giveOutputListener2(String taskName) {
        NativeCommand.Listener first = this.giveOutputListener(taskName);
        CheckAcsInstanceTaskListener second = new CheckAcsInstanceTaskListener();
        return new CompoundTaskListener(this, first, second);
    }

    protected class Icons {
        protected Icon startIcon = null;
        protected Icon stopIcon = null;
        protected Icon stopIconRed = null;
        protected Icon plusIcon = null;
        protected Icon minusIcon = null;
        protected Icon okIcon = null;
        protected Icon errIcon = null;
        protected Icon configIcon = null;
        protected Icon upIcon = null;
        protected Icon downIcon = null;

        protected Icons() {
        }

        protected Icon getStartIcon() {
            if (this.startIcon == null) {
                this.startIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("start.gif"));
            }
            return this.startIcon;
        }

        protected Icon getStopIcon() {
            if (this.stopIcon == null) {
                this.stopIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("stop.gif"));
            }
            return this.stopIcon;
        }

        protected Icon getStopIconRed() {
            if (this.stopIconRed == null) {
                this.stopIconRed = new ImageIcon(CommandCenterGui.this.controller.findResource("stop_red.gif"));
            }
            return this.stopIconRed;
        }

        protected Icon getPlusIcon() {
            if (this.plusIcon == null) {
                this.plusIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("plus.gif"));
            }
            return this.plusIcon;
        }

        protected Icon getMinusIcon() {
            if (this.minusIcon == null) {
                this.minusIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("minus.gif"));
            }
            return this.minusIcon;
        }

        protected Icon getOkIcon() {
            if (this.okIcon == null) {
                this.okIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("ok-8x8.gif"));
            }
            return this.okIcon;
        }

        protected Icon getErrIcon() {
            if (this.errIcon == null) {
                this.errIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("err-8x8.gif"));
            }
            return this.errIcon;
        }

        protected Icon getConfigIcon() {
            if (this.configIcon == null) {
                this.configIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("config.gif"));
            }
            return this.configIcon;
        }

        protected Icon getUpIcon() {
            if (this.upIcon == null) {
                this.upIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("up.gif"));
            }
            return this.upIcon;
        }

        protected Icon getDownIcon() {
            if (this.downIcon == null) {
                this.downIcon = new ImageIcon(CommandCenterGui.this.controller.findResource("down.gif"));
            }
            return this.downIcon;
        }
    }

    protected class ActionNewProject
    extends SwingAction {
        public ActionNewProject(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            CommandCenterGui.this.controller.project = CommandCenterGui.this.controller.createProject();
            CommandCenterGui.this.currentProjectFile = null;
            CommandCenterGui.this.currentProjectChanged();
        }
    }

    protected class ActionOpenProject
    extends BackgroundAction {
        public ActionOpenProject(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() throws Exception {
            File f = CommandCenterGui.this.showOpenDialog();
            if (f == null) {
                return;
            }
            CommandCenterGui.this.controller.loadProject(f);
        }
    }

    protected class ActionSaveProject
    extends BackgroundAction {
        public ActionSaveProject(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() throws Exception {
            if (CommandCenterGui.this.currentProjectFile != null) {
                CommandCenterGui.this.controller.writeProject(CommandCenterGui.this.controller.project, CommandCenterGui.this.currentProjectFile);
            } else {
                File f = CommandCenterGui.this.showSaveDialog();
                if (f == null) {
                    return;
                }
                CommandCenterGui.this.controller.writeProject(CommandCenterGui.this.controller.project, f);
                CommandCenterGui.this.currentProjectFile = f;
                CommandCenterGui.this.currentProjectChanged();
            }
        }
    }

    protected class ActionSaveAsProject
    extends BackgroundAction {
        public ActionSaveAsProject(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() throws Exception {
            File f = CommandCenterGui.this.showSaveDialog();
            if (f == null) {
                return;
            }
            CommandCenterGui.this.controller.writeProject(CommandCenterGui.this.controller.project, f);
        }
    }

    protected class ActionExit
    extends BackgroundAction {
        public ActionExit(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            CommandCenterGui.this.controller.stop();
        }
    }

    protected class ActionConfigureTools
    extends SwingAction {
        public ActionConfigureTools(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            CommandCenterGui.this.writeModelToManagerLocationForTools();
            CommandCenterGui.this.managerLocationDialog1.bringUp();
            boolean ok = CommandCenterGui.this.managerLocationDialog1.okChosen;
            if (ok) {
                CommandCenterGui.this.writeManagerLocationForToolsToModel();
            }
        }
    }

    protected class ActionShowExtraTools
    extends BackgroundAction {
        public ActionShowExtraTools(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            CommandCenterGui.this.showUrlContent(CommandCenterGui.this.controller.currentExtraToolsUrl, "Tools");
        }
    }

    protected class ActionInstallExtraTools
    extends BackgroundAction {
        public ActionInstallExtraTools(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            File f = null;
            JFileChooser c = new JFileChooser();
            c.setFileFilter(new FileFilter(this){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".xml") || f.getName().endsWith(".XML");
                }

                @Override
                public String getDescription() {
                    return "CommandCenter Tools (*.xml)";
                }
            });
            int returnVal = c.showOpenDialog(CommandCenterGui.this.frame);
            if (returnVal == 0) {
                f = c.getSelectedFile();
            }
            if (f == null) {
                return;
            }
            try {
                CommandCenterGui.this.controller.removeExtraTools();
                CommandCenterGui.this.controller.installExtraTools(f.toURI().toURL());
            }
            catch (Exception exc) {
                ErrorBox.showMessageDialog(CommandCenterGui.this.frame, "The tools could not be installed. Check console for error output. ", true);
                CommandCenterGui.this.log.fine("could not install tools: " + exc);
                return;
            }
            ErrorBox.showMessageDialog(CommandCenterGui.this.frame, "The tools have been installed successfully. ", false);
        }
    }

    protected class ActionShowBuiltinTools
    extends BackgroundAction {
        public ActionShowBuiltinTools(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            CommandCenterGui.this.showUrlContent(CommandCenterGui.this.controller.latestBuiltinToolsUrl, "Built-in Tools");
        }
    }

    protected class ActionLoadBuiltinTools
    extends BackgroundAction {
        public ActionLoadBuiltinTools(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            File f = null;
            JFileChooser c = new JFileChooser();
            c.setFileFilter(new FileFilter(this){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".xml") || f.getName().endsWith(".XML");
                }

                @Override
                public String getDescription() {
                    return "CommandCenter Built-in Tools (*.xml)";
                }
            });
            int returnVal = c.showOpenDialog(CommandCenterGui.this.frame);
            if (returnVal == 0) {
                f = c.getSelectedFile();
            }
            if (f == null) {
                return;
            }
            try {
                URL url = f.toURI().toURL();
                CommandCenterGui.this.controller.loadBuiltinTools(url);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(CommandCenterGui.this.frame, "The built-in tools could not be loaded. Check console for error output. ");
                CommandCenterGui.this.log.fine("could not load built-in tools: " + exc);
                return;
            }
            JOptionPane.showMessageDialog(CommandCenterGui.this.frame, "The built-in tools have been loaded. ");
        }
    }

    protected class ActionShowVariables
    extends BackgroundAction {
        public ActionShowVariables(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            CommandCenterGui.this.showVariablesEditor();
        }
    }

    protected class ActionShowHelp
    extends SwingAction {
        public ActionShowHelp(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            CommandCenterGui.this.showHelpBrowser();
        }
    }

    protected class ActionShowAbout
    extends SwingAction {
        protected ActionShowAbout(String name) {
            super(name);
        }

        @Override
        protected void actionPerformed() throws Exception {
            String title = "About: Acs Command Center";
            String msg = "This Acs Command Center creates projects of version: " + CommandCenterGui.this.controller.projectCreatorId();
            JOptionPane.showInternalMessageDialog(CommandCenterGui.this.desktop, msg, title, -1);
        }
    }

    protected static class AccInternalFrame
    extends JInternalFrame {
        AccInternalFrame() {
            super(null);
            this.setUI(new AccInternalFrameUI(this));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
    }

    protected class CheckAcsInstanceTaskListener
    implements NativeCommand.Listener {
        protected CheckAcsInstanceTaskListener() {
        }

        @Override
        public void statusChanged(NativeCommand task, String oldStatus) {
        }

        @Override
        public void stderrWritten(NativeCommand task, String additionalOutput) {
        }

        @Override
        public void stdoutWritten(NativeCommand task, String additionalOutput) {
            Matcher m = p.matcher(additionalOutput = additionalOutput.replace('\r', ' ').replace('\n', ' '));
            if (m.matches()) {
                final String desiredAcsInstance = CommandCenterGui.this.frontPanel.acsinstanceF.getText().trim();
                CommandCenterGui.this.controller.runBackground(new Runnable(){

                    @Override
                    public void run() {
                        String message = "The Acs Instance you requested ( " + desiredAcsInstance + " ) is already in use (by you or somebody else).\nChoose a different Acs Instance in the Common Settings.";
                        JOptionPane.showMessageDialog(CommandCenterGui.this.frame, message, "Acs Instance in use", 1);
                    }
                });
            }
        }
    }

    protected class CompoundTaskListener
    implements NativeCommand.Listener {
        NativeCommand.Listener a;
        NativeCommand.Listener b;

        protected CompoundTaskListener(CommandCenterGui this$0, NativeCommand.Listener a, NativeCommand.Listener b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void statusChanged(NativeCommand task, String oldStatus) {
            this.a.statusChanged(task, oldStatus);
            this.b.statusChanged(task, oldStatus);
        }

        @Override
        public void stdoutWritten(NativeCommand task, String additionalOutput) {
            this.a.stdoutWritten(task, additionalOutput);
            this.b.stdoutWritten(task, additionalOutput);
        }

        @Override
        public void stderrWritten(NativeCommand task, String additionalOutput) {
            this.a.stderrWritten(task, additionalOutput);
            this.b.stderrWritten(task, additionalOutput);
        }
    }

    protected static class AccInternalFrameUI
    extends BasicInternalFrameUI {
        AccInternalFrameUI(JInternalFrame frame) {
            super(frame);
        }

        @Override
        protected JComponent createNorthPane(JInternalFrame frame) {
            return null;
        }
    }

    public class WriteToFeedbackAreaTaskListener
    implements NativeCommand.Listener {
        FeedbackArea feedbackArea;

        public WriteToFeedbackAreaTaskListener(CommandCenterGui this$0, FeedbackArea f) {
            this.feedbackArea = f;
        }

        @Override
        public void statusChanged(NativeCommand task, String oldStatus) {
        }

        @Override
        public void stdoutWritten(NativeCommand task, String additionalOutput) {
            if (this.feedbackArea == null) {
                return;
            }
            this.feedbackArea.append(additionalOutput);
        }

        @Override
        public void stderrWritten(NativeCommand task, String additionalOutput) {
            if (this.feedbackArea == null) {
                return;
            }
            this.feedbackArea.append(additionalOutput);
        }
    }

    protected class ActionEditPexpects
    extends BackgroundAction {
        public ActionEditPexpects(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            if (CommandCenterGui.this.editPexpectsDialog == null) {
                CommandCenterGui.this.editPexpectsPanel = new EditPexpectsPanel(CommandCenterGui.this.controller);
                CommandCenterGui.this.editPexpectsDialog = new JDialog(CommandCenterGui.this.frame, "Edit Java Expr", false);
                CommandCenterGui.this.editPexpectsDialog.getContentPane().add(CommandCenterGui.this.editPexpectsPanel);
                CommandCenterGui.this.editPexpectsDialog.pack();
            }
            CommandCenterGui.this.correctDialogLocation(CommandCenterGui.this.editPexpectsDialog);
            CommandCenterGui.this.editPexpectsDialog.setVisible(true);
        }
    }

    protected class ActionEditCommands
    extends BackgroundAction {
        public ActionEditCommands(String name) {
            super(name);
        }

        @Override
        public void actionPerformed() {
            if (CommandCenterGui.this.editCommandsDialog == null) {
                CommandCenterGui.this.editCommandsPanel = new EditCommandsPanel(CommandCenterGui.this.controller);
                CommandCenterGui.this.editCommandsDialog = new JDialog(CommandCenterGui.this.frame, "Edit Java Args", false);
                CommandCenterGui.this.editCommandsDialog.getContentPane().add(CommandCenterGui.this.editCommandsPanel);
                CommandCenterGui.this.editCommandsDialog.pack();
            }
            CommandCenterGui.this.correctDialogLocation(CommandCenterGui.this.editCommandsDialog);
            CommandCenterGui.this.editCommandsDialog.setVisible(true);
        }
    }

    protected abstract class BackgroundAction
    extends AbstractAction {
        protected BackgroundAction(String name) {
            super(name);
        }

        protected BackgroundAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CommandCenterGui.this.controller.runBackground(new Runnable(){

                @Override
                public void run() {
                    try {
                        BackgroundAction.this.actionPerformed();
                    }
                    catch (VariableString.UnresolvableException exc) {
                        String name = "'" + BackgroundAction.this.getValue("Name") + "'";
                        String var = exc.getVariableName();
                        CommandCenterGui.this.controller.handleUnresolvableVariable(var);
                        CommandCenterGui.this.log.log(Level.INFO, "Error while performing " + name + ": Variable '" + var + "' is undefined");
                    }
                    catch (Throwable t) {
                        String name = "'" + BackgroundAction.this.getValue("Name") + "'";
                        ErrorBox.showErrorDialog((Component)CommandCenterGui.this.frame, "Encountered an error while performing " + name, t);
                        CommandCenterGui.this.log.log(Level.INFO, "Error while performing " + name, t);
                    }
                }
            });
        }

        protected abstract void actionPerformed() throws Throwable;
    }

    protected abstract class SwingAction
    extends AbstractAction {
        protected SwingAction(String name) {
            super(name);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            try {
                this.actionPerformed();
            }
            catch (Exception exc) {
                String name = "'" + this.getValue("Name") + "'";
                ErrorBox.showErrorDialog((Component)CommandCenterGui.this.frame, "Encountered an error while performing " + name, exc);
                CommandCenterGui.this.log.log(Level.INFO, "Error while performing " + name, exc);
            }
        }

        protected abstract void actionPerformed() throws Exception;
    }
}

