/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.Optional;
import lombok.NonNull;

class ScienceGoalInfo {
    final ScienceGoal sg;
    String sgname;
    SkyCoordinates sourceCoordinates;
    ReceiverBand receiverBand;
    Angle largestAngularScale;
    boolean isACAUsed;
    boolean isStandAloneACA;
    private Optional<Time> tmTime = Optional.empty();
    private Optional<Time> aca7mTime = Optional.empty();
    private Optional<Time> tpTime = Optional.empty();
    private int noOfSources = 1;

    ScienceGoalInfo(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        Time time;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        this.sg = scienceGoal;
        this.sgname = scienceGoal.getNameOrDefault();
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (targetParameters != null) {
            this.sourceCoordinates = targetParameters.getSourceCoordinates();
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        this.receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
        this.largestAngularScale = performanceParameters.getDesiredLargestScale();
        this.isACAUsed = performanceParameters.getUseACA();
        this.isStandAloneACA = scienceGoal.isStandAloneACA();
        this.noOfSources = scienceGoal.getTargetParametersCount();
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal);
        boolean bl = scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation();
        boolean bl2 = false;
        try {
            bl2 = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        if (!this.isStandAloneACA) {
            time = observingTimeCalculator.getTotalRequestedTime(Array.ARRAY_12M, false, false, true);
            Time time2 = bl2 ? Time.createTime() : observingTimeCalculator.getTotalRequestedTime(Array.ARRAY_12M, false, true, true);
            this.tmTime = Optional.of((Time)time.plus((AbstractDoubleWithUnit)time2));
        }
        if (this.isACAUsed || this.isStandAloneACA) {
            this.aca7mTime = Optional.of(observingTimeCalculator.getTotalRequestedTime(bl ? Array.ARRAY_12M : Array.ARRAY_7M, false, false, true));
        }
        if (performanceParameters.getUseTP()) {
            this.tpTime = Optional.of(observingTimeCalculator.getTotalRequestedTime(bl ? Array.ARRAY_12M : Array.ARRAY_TP, false, false, true));
        }
        if ((time = Log.logger(this.getClass())).fine()) {
            try {
                time.fine("Science goal timing for " + this.sgname + " cluster " + this.sg.getClusterIndex());
            }
            catch (ScienceGoal.NotClusteredScienceGoalException notClusteredScienceGoalException) {
                // empty catch block
            }
            this.tmTime.ifPresent(arg_0 -> ScienceGoalInfo.lambda$new$0((Log.Logger)time, arg_0));
            this.aca7mTime.ifPresent(arg_0 -> ScienceGoalInfo.lambda$new$1((Log.Logger)time, arg_0));
            this.tpTime.ifPresent(arg_0 -> ScienceGoalInfo.lambda$new$2((Log.Logger)time, arg_0));
        }
    }

    public ScienceGoal getSg() {
        return this.sg;
    }

    public String getSgname() {
        return this.sgname;
    }

    public SkyCoordinates getSourceCoordinates() {
        return this.sourceCoordinates;
    }

    public ReceiverBand getReceiverBand() {
        return this.receiverBand;
    }

    public Angle getLargestAngularScale() {
        return this.largestAngularScale;
    }

    public boolean isACAUsed() {
        return this.isACAUsed;
    }

    public boolean isStandAloneACA() {
        return this.isStandAloneACA;
    }

    public Optional<Time> getTmTime() {
        return this.tmTime;
    }

    public Optional<Time> getAca7mTime() {
        return this.aca7mTime;
    }

    public Optional<Time> getTpTime() {
        return this.tpTime;
    }

    public int getNoOfSources() {
        return this.noOfSources;
    }

    private static /* synthetic */ void lambda$new$2(Log.Logger logger, Time time) {
        logger.fine("TP time " + String.valueOf(time));
    }

    private static /* synthetic */ void lambda$new$1(Log.Logger logger, Time time) {
        logger.fine("ACA 7-m time " + String.valueOf(time));
    }

    private static /* synthetic */ void lambda$new$0(Log.Logger logger, Time time) {
        logger.fine("TM time " + String.valueOf(time));
    }
}

