/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Logger;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.catalog.vo.VoTable;
import jsky.coords.CoordinateRadius;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.StringUtil;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLDataSource;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;

public class AlmaSlapCatalog
implements Catalog {
    private static final Logger LOG = Logger.getLogger(AlmaSlapCatalog.class.getName());
    private final URL _url;
    private String name;
    private CatalogDirectory parent;
    private FieldDescAdapter[] fieldDescriptor;
    private transient ProgressPanel progressPanel;

    public static Catalog getCatalog(AstroCatalog astroCatalog) {
        URL uRL;
        try {
            uRL = astroCatalog.getBaseURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        String string = astroCatalog.getName();
        if (string == null) {
            string = "unknown";
        }
        return new AlmaSlapCatalog(string, uRL);
    }

    public AlmaSlapCatalog(String string, URL uRL) {
        this.name = string;
        this._url = uRL;
        this.initialise();
    }

    private void initialise() {
        this.fieldDescriptor = this._loadPersistent();
        if (this.fieldDescriptor == null) {
            try {
                URL uRL = this._makeURL(this._url, "REQUEST=getCapabilities");
                LOG.info("Reading SLAP server configuration from " + String.valueOf(this._url));
                VOElement vOElement = new VOElementFactory(StoragePolicy.getDefaultPolicy()).makeVOElement((DataSource)new URLDataSource(uRL));
                this._checkStatus(vOElement);
                NodeList nodeList = vOElement.getElementsByTagName("PARAM");
                this.fieldDescriptor = new FieldDescAdapter[nodeList.getLength()];
                for (int i = 0; i < this.fieldDescriptor.length; ++i) {
                    Element element = (Element)nodeList.item(i);
                    this.fieldDescriptor[i] = new FieldDescAdapter(this._getName(element));
                    this.fieldDescriptor[i].setDisplayName(this._getDisplayName(element));
                    this.fieldDescriptor[i].setUCD(element.getAttribute("ucd"));
                    this.fieldDescriptor[i].setType(element.getAttribute("utype"));
                    NodeList nodeList2 = element.getElementsByTagName("DESCRIPTION");
                    if (nodeList2 == null || nodeList2.getLength() != 1) continue;
                    this.fieldDescriptor[i].setDescription(nodeList2.item(0).getTextContent());
                }
                this._savePersistent();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private String _getName(Element element) {
        String string = element.getAttribute("name");
        if (string == null) {
            string = "unknown";
        }
        if (string.toLowerCase().startsWith("input:")) {
            string = string.substring(6).trim();
        }
        return string;
    }

    private String _getDisplayName(Element element) {
        String string = element.getAttribute("name").toLowerCase();
        if (string.startsWith("input:")) {
            string = string.substring(6).trim().replace('_', ' ');
        }
        return StringUtil.capitalize((String)string);
    }

    private URL _makeURL(URL uRL, String string) throws MalformedURLException {
        Object object = uRL.toString();
        object = ((String)object).contains("?") ? (String)object + "&" + string : (String)object + "?" + string;
        return new URL(null, (String)object, new URLStreamHandler(this){

            @Override
            protected URLConnection openConnection(URL uRL) throws IOException {
                URL uRL2 = new URL(uRL.toString());
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
                httpURLConnection.setConnectTimeout(0);
                httpURLConnection.setReadTimeout(0);
                return httpURLConnection;
            }
        });
    }

    public Catalog reload() {
        this._removePersistent();
        this.initialise();
        return this;
    }

    private void _checkStatus(VOElement vOElement) throws IOException {
        Object object;
        NodeList nodeList = vOElement.getElementsByTagName("RESOURCE");
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = (Element)nodeList.item(i);
            if (!object.hasAttribute("type")) {
                node = object;
                continue;
            }
            if (!"results".equals(object.getAttribute("type")) && !"result".equals(object.getAttribute("type"))) continue;
            node = object;
            break;
        }
        if (node == null) {
            throw new IOException("No suitable RESOURCE found in returned VOTable");
        }
        String string = null;
        object = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Element element;
            if (!(node2 instanceof Element) || !"INFO".equals((element = (Element)node2).getTagName()) || !"QUERY_STATUS".equals(element.getAttribute("name"))) continue;
            string = element.getAttribute("value");
            object = DOMUtils.getTextContent((Element)element);
            break;
        }
        if ("ERROR".equals(string)) {
            throw new IOException("SLAP query error: " + (String)object);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getId() {
        return this.name;
    }

    public String getTitle() {
        return this.name;
    }

    public String getDescription() {
        return "<html><i>Syntax for range values: min1/max1,min2/max2,...</i></html>";
    }

    public String toString() {
        return this.name;
    }

    public URL getDocURL() {
        return null;
    }

    public int getNumParams() {
        return this.fieldDescriptor.length;
    }

    public FieldDesc getParamDesc(int n) {
        return this.fieldDescriptor[n];
    }

    public FieldDesc getParamDesc(String string) {
        for (FieldDescAdapter fieldDescAdapter : this.fieldDescriptor) {
            if (!fieldDescAdapter.getName().equals(string)) continue;
            return fieldDescAdapter;
        }
        return null;
    }

    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius coordinateRadius) {
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isImageServer() {
        return false;
    }

    public String getType() {
        return "catalog";
    }

    public Catalog[] getPath() {
        CatalogDirectory catalogDirectory = this.getParent();
        if (catalogDirectory == null) {
            return null;
        }
        return catalogDirectory.getPath((Catalog)this);
    }

    protected ProgressPanel _getProgressPanel(String string) {
        if (this.progressPanel == null) {
            this.progressPanel = ProgressPanel.makeProgressPanel((String)string);
        } else {
            this.progressPanel.setTitle(string);
        }
        return this.progressPanel;
    }

    private URL _getQueryUrl(QueryArgs queryArgs) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        boolean bl = true;
        for (FieldDescAdapter fieldDescAdapter : this.fieldDescriptor) {
            String string;
            if ((string = (String)queryArgs.getParamValue(n++)) == null || string.length() == 0) continue;
            if (!bl) {
                stringBuilder.append("&");
            } else {
                stringBuilder.append("REQUEST=queryData&");
            }
            bl = false;
            stringBuilder.append(fieldDescAdapter.getName().toUpperCase());
            stringBuilder.append("=");
            stringBuilder.append(string);
        }
        return this._makeURL(this._url, stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult query(QueryArgs queryArgs) throws IOException {
        URL uRL = this._getQueryUrl(queryArgs);
        this.progressPanel = this._getProgressPanel("Downloading query results");
        this.progressPanel.start();
        this.progressPanel.setText("Performing SLAP query: " + String.valueOf(uRL));
        try {
            VoTable voTable = VoTable.createVoTable((URL)uRL, (String)this.getId(), (String)this.getName(), (Catalog)this);
            if (this.progressPanel.isInterrupted()) {
                throw new ProgressException("Interrupted");
            }
            VoTable voTable2 = voTable;
            return voTable2;
        }
        finally {
            this.progressPanel.stop();
        }
    }

    private void _savePersistent() {
        try {
            String string = AlmaSlapCatalog._getPersistentName(this._url);
            Preferences.getPreferences().serialize(string, (Object)this.fieldDescriptor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private FieldDescAdapter[] _loadPersistent() {
        String string = AlmaSlapCatalog._getPersistentName(this._url);
        FieldDescAdapter[] fieldDescAdapterArray = null;
        try {
            fieldDescAdapterArray = (FieldDescAdapter[])Preferences.getPreferences().deserialize(string);
        }
        catch (Exception exception) {
            try {
                String string2 = string + ".ser";
                InputStream inputStream = Resources.getResourceAsStream((String)string2);
                if (inputStream != null) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(Resources.getResourceAsStream((String)string2));
                    fieldDescAdapterArray = (FieldDescAdapter[])objectInputStream.readObject();
                    objectInputStream.close();
                }
                return fieldDescAdapterArray;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        return fieldDescAdapterArray;
    }

    private void _removePersistent() {
        try {
            String string = AlmaSlapCatalog._getPersistentName(this._url);
            Preferences.getPreferences().removeSerializedFile(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String _getPersistentName(URL uRL) {
        String string = uRL.getHost() + uRL.getPath() + uRL.getQuery();
        return string.replaceAll("[^A-Za-z0-9_]", "-");
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(CatalogDirectory catalogDirectory) {
        this.parent = catalogDirectory;
    }

    public CatalogDirectory getParent() {
        return this.parent;
    }
}

