/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.services.calibration.CalType;
import java.util.EnumSet;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public enum ObsType {
    AMPLITUDE(CalType.Amplitude, QuerySource.INTENDEDUSE_AMPLITUDE, AmplitudeCalParameters.class),
    ATMOSPHERIC(CalType.Atmospheric, QuerySource.INTENDEDUSE_ATMOSPHERIC, AtmosphericCalParameters.class),
    BANDPASS(CalType.Bandpass, QuerySource.INTENDEDUSE_BANDPASS, BandpassCalParameters.class),
    DELAY(CalType.Delay, QuerySource.INTENDEDUSE_DELAY, DelayCalParameters.class),
    CHECKSOURCE(CalType.CheckSource, QuerySource.INTENDEDUSE_CHECKSOURCE, CheckSourceCalParameters.class),
    FOCUS(CalType.Focus, QuerySource.INTENDEDUSE_FOCUS, FocusCalParameters.class),
    PHASE(CalType.Phase, QuerySource.INTENDEDUSE_PHASE, PhaseCalParameters.class),
    POINTING(CalType.Pointing, QuerySource.INTENDEDUSE_POINTING, PointingCalParameters.class),
    POLARIZATION(CalType.Polarization, QuerySource.INTENDEDUSE_POLARIZATION, PolarizationCalParameters.class),
    SIDEBANDRATIO(CalType.SidebandRatio, QuerySource.INTENDEDUSE_SIDEBANDRATIO, SidebandRatioCalParameters.class),
    DGCREFERENCE(CalType.DGCReference, QuerySource.INTENDEDUSE_DGCREFERENCE, DGCReferenceCalParameters.class),
    DGCSCIENCE(CalType.DGCScience, QuerySource.INTENDEDUSE_DGCSCIENCE, DGCScienceCalParameters.class),
    SCIENCE(null, null, ScienceParameters.class);

    public static final Set<ObsType> ALL_TYPES;
    private final CalType calType;
    private final String calIntent;
    private final Class<? extends ObservingParameters> obsParamsClass;

    public static ObsType getObsType(@NonNull ObservingParameters observingParameters) {
        if (observingParameters == null) {
            throw new NullPointerException("obsParams is marked non-null but is null");
        }
        Class<?> clazz = observingParameters.getClass();
        for (ObsType obsType : ALL_TYPES) {
            if (obsType.obsParamsClass != clazz) continue;
            return obsType;
        }
        throw new IllegalArgumentException(String.valueOf(clazz) + " is not a handled caltype");
    }

    public static ObsType getObsType(@NonNull CalibrationTargetParameters calibrationTargetParameters) {
        if (calibrationTargetParameters == null) {
            throw new NullPointerException("ctp is marked non-null but is null");
        }
        return ObsType.getObsType(calibrationTargetParameters.getIntendedUse());
    }

    public static ObsType getObsType(@NonNull QuerySource querySource) {
        if (querySource == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return ObsType.getObsType(querySource.getIntendedUse());
    }

    public static ObsType getObsType(@NonNull CalType calType) {
        if (calType == null) {
            throw new NullPointerException("calType is marked non-null but is null");
        }
        for (ObsType obsType : ALL_TYPES) {
            if (obsType.calType != calType) continue;
            return obsType;
        }
        throw new IllegalArgumentException(String.valueOf((Object)calType) + " is not a handled caltype");
    }

    private static ObsType getObsType(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        for (ObsType obsType : ALL_TYPES) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)obsType.calIntent, (CharSequence)string)) continue;
            return obsType;
        }
        throw new IllegalArgumentException(string + " is not a handled caltype");
    }

    private ObsType(CalType calType, String string2, Class<? extends ObservingParameters> clazz) {
        this.calType = calType;
        this.calIntent = string2;
        this.obsParamsClass = clazz;
    }

    public CalType getCalType() {
        return this.calType;
    }

    public String getCalIntent() {
        return this.calIntent;
    }

    public Class<? extends ObservingParameters> getObsParamsClass() {
        return this.obsParamsClass;
    }

    static {
        ALL_TYPES = EnumSet.allOf(ObsType.class);
    }
}

