/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableColumnResizer {
    private static final int margin = 2;

    public static void resize(final JTable jTable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)jTable.getColumnModel();
                int[] nArray = new int[jTable.getColumnCount()];
                for (int i = 0; i < jTable.getColumnCount(); ++i) {
                    TableColumn tableColumn = defaultTableColumnModel.getColumn(i);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer == null) {
                        tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
                    }
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, i);
                    nArray[i] = component.getPreferredSize().width + 4;
                    for (int j = 0; j < jTable.getRowCount(); ++j) {
                        tableCellRenderer = jTable.getCellRenderer(j, i);
                        component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(j, i), false, false, j, i);
                        int n = component.getPreferredSize().width + 4;
                        if (n <= nArray[i]) continue;
                        nArray[i] = n;
                    }
                    tableColumn.setPreferredWidth(nArray[i]);
                }
            }
        });
    }
}

