/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.util.Convert;
import alma.obsprep.util.Convert4dp;
import alma.valuetypes.Time;

public class CalibratorExpertModel
extends Model {
    private final ValueUnitPairModel minFreqModel = new ValueUnitPairModel(null, QuerySourceEditor.freqminFID_value, QuerySourceEditor.freqminFID_unit);
    private final ValueUnitPairModel maxFreqModel = new ValueUnitPairModel(null, QuerySourceEditor.freqmaxFID_value, QuerySourceEditor.freqmaxFID_unit);
    private final ValueUnitPairModel minFluxModel = new ValueUnitPairModel(null, QuerySourceEditor.fluxminFID_value, QuerySourceEditor.fluxminFID_unit);
    private final ValueUnitPairModel maxFluxModel = new ValueUnitPairModel(null, QuerySourceEditor.fluxmaxFID_value, QuerySourceEditor.fluxmaxFID_unit);
    private final ValueUnitPairModel minLastObservedModel = new ValueUnitPairModel(null, QuerySourceEditor.timeminFID_value, QuerySourceEditor.timeminFID_unit);
    private final ValueUnitPairModel maxLastObservedModel = new ValueUnitPairModel(null, QuerySourceEditor.timemaxFID_value, QuerySourceEditor.timemaxFID_unit);

    public CalibratorExpertModel(ICalibratorExpertDocument iCalibratorExpertDocument) {
        super(iCalibratorExpertDocument);
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> this.getController().modelChanged(fieldID, object);
        this.minFreqModel.subscribe(modelChangeSubscriber);
        this.maxFreqModel.subscribe(modelChangeSubscriber);
        this.minFluxModel.subscribe(modelChangeSubscriber);
        this.maxFluxModel.subscribe(modelChangeSubscriber);
        this.minLastObservedModel.subscribe(modelChangeSubscriber);
        this.maxLastObservedModel.subscribe(modelChangeSubscriber);
        this.registerSubModel(this.minFreqModel, this.maxFreqModel, this.minFluxModel, this.maxFluxModel, this.minLastObservedModel, this.maxLastObservedModel);
        this.setDocument(iCalibratorExpertDocument);
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        if (object instanceof ICalibratorExpertDocument) {
            ICalibratorExpertDocument iCalibratorExpertDocument = this.getCalibratorExpertDocument();
            this.minFreqModel.setDocument((Object)iCalibratorExpertDocument.getMinFrequency());
            this.maxFreqModel.setDocument((Object)iCalibratorExpertDocument.getMaxFrequency());
            this.minFluxModel.setDocument((Object)iCalibratorExpertDocument.getMinFlux());
            this.maxFluxModel.setDocument((Object)iCalibratorExpertDocument.getMaxFlux());
            if (object instanceof QuerySourceAdapter) {
                QuerySourceAdapter querySourceAdapter = (QuerySourceAdapter)object;
                IQuerySource iQuerySource = querySourceAdapter.getQuerySourceAdaptee();
                Time time = iQuerySource.getMinTimeSinceObserved();
                time.convertToUnit(Time.UNIT_D);
                this.minLastObservedModel.setDocument(time);
                Time time2 = iQuerySource.getMaxTimeSinceObserved();
                time2.convertToUnit(Time.UNIT_D);
                this.maxLastObservedModel.setDocument(time2);
            }
        }
        this.publish();
    }

    private ICalibratorExpertDocument getCalibratorExpertDocument() {
        return (ICalibratorExpertDocument)this.getDocument();
    }

    @Override
    public void publish() {
        Object object;
        ICalibratorExpertDocument iCalibratorExpertDocument = this.getCalibratorExpertDocument();
        if (iCalibratorExpertDocument == null) {
            return;
        }
        this.publish(QuerySourceEditor.catlocFID, iCalibratorExpertDocument.getCatalogueLocation());
        try {
            this.publish(QuerySourceEditor.raFID, Convert4dp.milliarcsecToHHMMSS(iCalibratorExpertDocument.getRa()));
            this.publish(QuerySourceEditor.decFID, Convert.milliarcsecToDDMMSS(iCalibratorExpertDocument.getDec()));
        }
        catch (OutOfRangeException outOfRangeException) {
            Log.logger((Object)this).warning("Coordinates are out of range");
        }
        catch (InvalidCoordException invalidCoordException) {
            Log.logger((Object)this).warning("Coordinates are invalid");
        }
        double d = iCalibratorExpertDocument.getRadius();
        if (d != -999.0) {
            this.publish(QuerySourceEditor.radiusFID, d);
        }
        if ((object = this.getDocument()) instanceof QuerySourceAdapter) {
            QuerySourceAdapter querySourceAdapter = (QuerySourceAdapter)object;
            object = querySourceAdapter.getQuerySourceAdaptee();
            this.publish(QuerySourceEditor.maxSourcesFID, object.getMaxSources());
        }
        this.publish(QuerySourceEditor.sourceNameFID, iCalibratorExpertDocument.getSourceName());
        this.publishSubmodels();
        this.publish(QuerySourceEditor.caltypeFID, iCalibratorExpertDocument.getCalType());
        this.publish(CalibratorExpertEditor.tableFID, iCalibratorExpertDocument.getCalibList());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        ICalibratorExpertDocument iCalibratorExpertDocument = this.getCalibratorExpertDocument();
        for (Model object2 : this.getSubModels()) {
            object2.update(editor, fieldID, object);
        }
        try {
            Object object2;
            if (fieldID.equals(QuerySourceEditor.catlocFID)) {
                String string = (String)object;
                ICalibratorExpertDocument iCalibratorExpertDocument2 = this.getCalibratorExpertDocument();
                if (iCalibratorExpertDocument2 != null) {
                    iCalibratorExpertDocument2.setCatalogueLocation(string);
                }
            } else if (fieldID.equals(QuerySourceEditor.radiusFID)) {
                if (object instanceof String) {
                    String string = (String)object;
                    if (iCalibratorExpertDocument != null) {
                        iCalibratorExpertDocument.setRadius(Double.parseDouble(string));
                    }
                } else if (object instanceof Double) {
                    Double d = (Double)object;
                    if (iCalibratorExpertDocument != null) {
                        iCalibratorExpertDocument.setRadius(d);
                    }
                }
            } else if (fieldID.equals(QuerySourceEditor.raFID)) {
                if (iCalibratorExpertDocument != null) {
                    iCalibratorExpertDocument.setRa(Convert4dp.HHMMSSToMilliarcsec((String)object));
                }
            } else if (fieldID.equals(QuerySourceEditor.decFID)) {
                if (iCalibratorExpertDocument != null) {
                    iCalibratorExpertDocument.setDec(Convert.DDMMSSToMilliarcsec((String)object));
                }
            } else if (fieldID.equals(QuerySourceEditor.caltypeFID)) {
                if (iCalibratorExpertDocument != null) {
                    iCalibratorExpertDocument.setCalType(CalibrationUseType.valueOf((String)((String)object)));
                }
            } else if (fieldID.equals(QuerySourceEditor.sourceNameFID)) {
                if (iCalibratorExpertDocument != null) {
                    iCalibratorExpertDocument.setSourceName((String)object);
                }
            } else if (fieldID.equals(QuerySourceEditor.maxSourcesFID) && (object2 = this.getDocument()) instanceof QuerySourceAdapter) {
                QuerySourceAdapter querySourceAdapter = (QuerySourceAdapter)object2;
                querySourceAdapter.setMaxSources(Integer.parseInt((String)object));
            }
        }
        catch (InvalidCoordException invalidCoordException) {
            Log.logger((Object)this).warning("Coordinates are out of range");
        }
        catch (NumberFormatException numberFormatException) {
            Log.logger((Object)this).warning("Could not convert to internal coordinate format");
        }
        return object;
    }

    public ValueUnitPairModel getMinFreqModel() {
        return this.minFreqModel;
    }

    public ValueUnitPairModel getMaxFreqModel() {
        return this.maxFreqModel;
    }

    public ValueUnitPairModel getMinFluxModel() {
        return this.minFluxModel;
    }

    public ValueUnitPairModel getMaxFluxModel() {
        return this.maxFluxModel;
    }

    public ValueUnitPairModel getMinLastObservedModel() {
        return this.minLastObservedModel;
    }

    public ValueUnitPairModel getMaxLastObservedModel() {
        return this.maxLastObservedModel;
    }
}

