/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.scripting.bindings.Angle;
import alma.obsprep.ot.scripting.bindings.AngleType;
import alma.obsprep.ot.scripting.bindings.CoordinateSystemType;
import alma.obsprep.ot.scripting.bindings.CoordinateType;
import alma.obsprep.ot.scripting.bindings.DopplerType;
import alma.obsprep.ot.scripting.bindings.Frequency;
import alma.obsprep.ot.scripting.bindings.FrequencyUnit;
import alma.obsprep.ot.scripting.bindings.IntentType;
import alma.obsprep.ot.scripting.bindings.Length;
import alma.obsprep.ot.scripting.bindings.LengthType;
import alma.obsprep.ot.scripting.bindings.ReceiverbandType;
import alma.obsprep.ot.scripting.bindings.Speed;
import alma.obsprep.ot.scripting.bindings.SpeedType;
import alma.obsprep.ot.scripting.bindings.Time;
import alma.obsprep.ot.scripting.bindings.TimeType;
import alma.obsprep.ot.scripting.bindings.VelocityReferenceType;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import alma.valuetypes.Velocity;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.NonNull;

public final class BatchOTXMLUnitMapper {
    private static final String CANNOT_FIND_MAPPING_FOR = "Cannot find mapping for: ";

    public static AngleUnits mapAngleType(@NonNull AngleType angleType) throws UnitMappingErrorException {
        if (angleType == null) {
            throw new NullPointerException("angleType is marked non-null but is null");
        }
        return switch (angleType) {
            case AngleType.ARCMIN -> new AngleUnits(Latitude.UNIT_ARCMIN, Longitude.UNIT_ARCMIN);
            case AngleType.ARCSEC -> new AngleUnits(Latitude.UNIT_ARCSEC, Longitude.UNIT_ARCSEC);
            case AngleType.DEG -> new AngleUnits(Latitude.UNIT_DEG, Longitude.UNIT_DEG);
            case AngleType.MAS -> new AngleUnits(Latitude.UNIT_MAS, Longitude.UNIT_MAS);
            case AngleType.RAD -> new AngleUnits(Latitude.UNIT_RAD, Longitude.UNIT_RAD);
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf((Object)angleType));
        };
    }

    public static UserAngle mapUserAngle(@NonNull Angle angle) throws UnitMappingErrorException {
        if (angle == null) {
            throw new NullPointerException("angle is marked non-null but is null");
        }
        String string = switch (angle.getUnit()) {
            case AngleType.ARCMIN -> UserAngle.USERUNIT_ARCMIN;
            case AngleType.ARCSEC -> UserAngle.USERUNIT_ARCSEC;
            case AngleType.DEG -> UserAngle.USERUNIT_DEG;
            case AngleType.MAS -> UserAngle.USERUNIT_MAS;
            case AngleType.RAD -> UserAngle.USERUNIT_RAD;
            case AngleType.H -> UserAngle.USERUNIT_H;
            default -> throw new UnitMappingErrorException("unknown user unit found " + String.valueOf((Object)angle.getUnit()));
        };
        return UserAngle.createUserAngle(angle.getAngle(), string);
    }

    public static alma.valuetypes.Angle mapAngle(@NonNull Angle angle) throws UnitMappingErrorException {
        if (angle == null) {
            throw new NullPointerException("angle is marked non-null but is null");
        }
        String string = switch (angle.getUnit()) {
            case AngleType.ARCMIN -> alma.valuetypes.Angle.UNIT_ARCMIN;
            case AngleType.ARCSEC -> alma.valuetypes.Angle.UNIT_ARCSEC;
            case AngleType.DEG -> alma.valuetypes.Angle.UNIT_DEG;
            case AngleType.MAS -> alma.valuetypes.Angle.UNIT_MAS;
            case AngleType.RAD -> alma.valuetypes.Angle.UNIT_RAD;
            default -> throw new UnitMappingErrorException("unknown user unit found " + String.valueOf((Object)angle.getUnit()));
        };
        return alma.valuetypes.Angle.createAngle((double)angle.getAngle(), (String)string);
    }

    public static alma.valuetypes.Length mapLength(@NonNull Length length) throws UnitMappingErrorException {
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        String string = switch (length.getUnit()) {
            case LengthType.CM -> alma.valuetypes.Length.UNIT_CM;
            case LengthType.KM -> alma.valuetypes.Length.UNIT_KM;
            case LengthType.M -> alma.valuetypes.Length.UNIT_M;
            case LengthType.MM -> alma.valuetypes.Length.UNIT_MM;
            case LengthType.PC -> alma.valuetypes.Length.UNIT_PC;
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf((Object)length.getUnit()));
        };
        return alma.valuetypes.Length.createLength((double)length.getLength(), (String)string);
    }

    public static String mapDopplerType(@NonNull DopplerType dopplerType) throws UnitMappingErrorException {
        if (dopplerType == null) {
            throw new NullPointerException("dopplerType is marked non-null but is null");
        }
        return switch (dopplerType) {
            case DopplerType.OPTICAL -> Velocity.DOPPLERCALCTYPE_OPTICAL;
            case DopplerType.RADIO -> Velocity.DOPPLERCALCTYPE_RADIO;
            case DopplerType.RELATIVISTIC -> Velocity.DOPPLERCALCTYPE_RELATIVISTIC;
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf((Object)dopplerType));
        };
    }

    public static String mapVelocityReferenceType(@NonNull VelocityReferenceType velocityReferenceType) throws UnitMappingErrorException {
        if (velocityReferenceType == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        return switch (velocityReferenceType) {
            case VelocityReferenceType.BAR -> Velocity.REFERENCESYSTEM_BAR;
            case VelocityReferenceType.HEL -> Velocity.REFERENCESYSTEM_HEL;
            case VelocityReferenceType.LSRK -> Velocity.REFERENCESYSTEM_LSRK;
            case VelocityReferenceType.TOPO -> Velocity.REFERENCESYSTEM_TOPO;
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf((Object)velocityReferenceType));
        };
    }

    public static String mapVelocityUnitType(@NonNull SpeedType speedType) throws UnitMappingErrorException {
        if (speedType == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return switch (speedType) {
            case SpeedType.KM_S -> alma.valuetypes.Speed.UNIT_KM_S;
            case SpeedType.M_S -> alma.valuetypes.Speed.UNIT_M_S;
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf((Object)speedType));
        };
    }

    public static String mapCoordinateSystemType(@NonNull CoordinateSystemType coordinateSystemType) throws UnitMappingErrorException {
        if (coordinateSystemType == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        return switch (coordinateSystemType) {
            case CoordinateSystemType.AZEL -> SkyCoordinates.SYSTEM_AZEL;
            case CoordinateSystemType.ECLIPTIC -> SkyCoordinates.SYSTEM_ECLIPTIC;
            case CoordinateSystemType.GALACTIC -> SkyCoordinates.SYSTEM_GALACTIC;
            case CoordinateSystemType.HORIZON -> SkyCoordinates.SYSTEM_HORIZON;
            case CoordinateSystemType.ICRS -> SkyCoordinates.SYSTEM_ICRS;
            case CoordinateSystemType.J_2000 -> SkyCoordinates.SYSTEM_J2000;
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf((Object)coordinateSystemType));
        };
    }

    public static String mapCoordinateType(@NonNull CoordinateType coordinateType) throws UnitMappingErrorException {
        if (coordinateType == null) {
            throw new NullPointerException("coordinateType is marked non-null but is null");
        }
        return switch (coordinateType) {
            case CoordinateType.ABSOLUTE -> SkyCoordinates.TYPE_ABSOLUTE;
            case CoordinateType.RELATIVE -> SkyCoordinates.TYPE_RELATIVE;
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf((Object)coordinateType));
        };
    }

    public static alma.valuetypes.Speed mapSpeed(@NonNull Speed speed) throws UnitMappingErrorException {
        if (speed == null) {
            throw new NullPointerException("speed is marked non-null but is null");
        }
        return switch (speed.getUnit()) {
            case SpeedType.KM_S -> alma.valuetypes.Speed.createSpeed((double)speed.getSpeed(), (String)alma.valuetypes.Speed.UNIT_KM_S);
            case SpeedType.KM_H -> alma.valuetypes.Speed.createSpeed((double)speed.getSpeed(), (String)alma.valuetypes.Speed.UNIT_KM_H);
            case SpeedType.M_S -> alma.valuetypes.Speed.createSpeed((double)speed.getSpeed(), (String)alma.valuetypes.Speed.UNIT_M_S);
            default -> throw new UnitMappingErrorException(CANNOT_FIND_MAPPING_FOR + String.valueOf(speed));
        };
    }

    public static List<Target> fetchSBTargets(@NonNull IntentType intentType, @NonNull List<SchedBlock> list) throws UnitMappingErrorException {
        if (intentType == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        Optional<Predicate<Target>> optional = BatchOTXMLUnitMapper.mapIntentToIntentFilter(intentType);
        return list.stream().map(schedBlock -> schedBlock.getAllTargets(optional)).flatMap(Collection::stream).toList();
    }

    public static Optional<Predicate<Target>> mapIntentToIntentFilter(@NonNull IntentType intentType) throws UnitMappingErrorException {
        if (intentType == null) {
            throw new NullPointerException("targetIntent is marked non-null but is null");
        }
        return switch (intentType) {
            case IntentType.AMPLITUDE -> AmplitudeCalParameters.ampCalParametersFilter;
            case IntentType.BANDPASS -> BandpassCalParameters.bandpassParametersFilter;
            case IntentType.CHECKSOURCE -> CheckSourceCalParameters.CheckSourceParametersFilter;
            case IntentType.DELAY -> DelayCalParameters.delayParametersFilter;
            case IntentType.DGCREFERENCE -> DGCReferenceCalParameters.DGCReferenceCalParametersFilter;
            case IntentType.DGCSCIENCE -> DGCScienceCalParameters.DGCScienceCalParametersFilter;
            case IntentType.FOCUS -> FocusCalParameters.focusCalParametersFilter;
            case IntentType.PHASE -> PhaseCalParameters.phaseCalParametersFilter;
            case IntentType.POINTING -> PointingCalParameters.pointingCalParametersFilter;
            case IntentType.POLARIZATION -> PolarizationCalParameters.polarizationParametersFilter;
            case IntentType.SIDEBANDRATIO -> SidebandRatioCalParameters.sidebandRatioParametersFilter;
            default -> throw new UnitMappingErrorException("Unknown intent " + String.valueOf((Object)intentType));
        };
    }

    public static ObsType mapIntentToAPDMCalType(@NonNull IntentType intentType) throws UnitMappingErrorException {
        if (intentType == null) {
            throw new NullPointerException("targetIntent is marked non-null but is null");
        }
        return switch (intentType) {
            case IntentType.AMPLITUDE -> ObsType.AMPLITUDE;
            case IntentType.BANDPASS -> ObsType.BANDPASS;
            case IntentType.CHECKSOURCE -> ObsType.CHECKSOURCE;
            case IntentType.DELAY -> ObsType.DELAY;
            case IntentType.DGCREFERENCE -> ObsType.DGCREFERENCE;
            case IntentType.DGCSCIENCE -> ObsType.DGCSCIENCE;
            case IntentType.FOCUS -> ObsType.FOCUS;
            case IntentType.PHASE -> ObsType.PHASE;
            case IntentType.POINTING -> ObsType.POINTING;
            case IntentType.POLARIZATION -> ObsType.POLARIZATION;
            case IntentType.SIDEBANDRATIO -> ObsType.SIDEBANDRATIO;
            default -> throw new UnitMappingErrorException("Unknown intent " + String.valueOf((Object)intentType));
        };
    }

    public static alma.valuetypes.Time mapTime(@NonNull Time time) throws UnitMappingErrorException {
        if (time == null) {
            throw new NullPointerException("time is marked non-null but is null");
        }
        return alma.valuetypes.Time.createTime((double)time.getTime(), (String)BatchOTXMLUnitMapper.mapTimeType(time.getUnit()));
    }

    private static String mapTimeType(@NonNull TimeType timeType) throws UnitMappingErrorException {
        if (timeType == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        return switch (timeType) {
            case TimeType.H -> alma.valuetypes.Time.UNIT_H;
            case TimeType.MIN -> alma.valuetypes.Time.UNIT_MIN;
            case TimeType.S -> alma.valuetypes.Time.UNIT_S;
            default -> throw new UnitMappingErrorException("Unknown unit specified " + String.valueOf((Object)timeType));
        };
    }

    public static alma.valuetypes.Frequency mapFrequency(Frequency frequency) throws UnitMappingErrorException {
        return alma.valuetypes.Frequency.createFrequency((double)frequency.getFrequency(), (String)BatchOTXMLUnitMapper.mapFrequencyType(frequency.getUnit()));
    }

    private static String mapFrequencyType(@NonNull FrequencyUnit frequencyUnit) throws UnitMappingErrorException {
        if (frequencyUnit == null) {
            throw new NullPointerException("frequencyUnit is marked non-null but is null");
        }
        return switch (frequencyUnit) {
            case FrequencyUnit.G_HZ -> alma.valuetypes.Frequency.UNIT_GHZ;
            case FrequencyUnit.HZ -> alma.valuetypes.Frequency.UNIT_HZ;
            case FrequencyUnit.K_HZ -> alma.valuetypes.Frequency.UNIT_KHZ;
            case FrequencyUnit.M_HZ -> alma.valuetypes.Frequency.UNIT_MHZ;
            default -> throw new UnitMappingErrorException("Unknown unit specified " + String.valueOf((Object)frequencyUnit));
        };
    }

    public static String mapRxb(@NonNull ReceiverbandType receiverbandType) {
        if (receiverbandType == null) {
            throw new NullPointerException("receiverband is marked non-null but is null");
        }
        return ReceiverBand.getReceiverBand(receiverbandType.getBand()).getName();
    }

    private BatchOTXMLUnitMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public record AngleUnits(String latitudeUnit, String longitudeUnit) {
        public AngleUnits {
            Objects.requireNonNull(string);
            Objects.requireNonNull(string2);
        }
    }

    public static class UnitMappingErrorException
    extends Exception {
        public UnitMappingErrorException(String string) {
            super(string);
        }
    }
}

