/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.common.horizonsparser.HorizonParser;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.VLBIFrequencyBands;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.AbstractTargetParametersData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersEditor;
import alma.obsprep.ot.editors.schedblock.NameResolver;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.ProperMotionModel;
import alma.obsprep.ot.models.sciencegoals.TPRegionalMappingTypes;
import alma.obsprep.ot.models.sciencegoals.TPRegionalPatterns;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectExportListener;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTargetModel
extends ProperMotionModel
implements ProjectExportListener {
    private static final Integer NAME_DUFF_REVERT_BACK = 0;
    private final ValueUnitPairModel expectedPeakFluxDensity;
    private final ValueUnitPairModel expectedPeakLineFluxDensity;
    private final ValueUnitPairModel solarMappingDiameter;
    private final UserUnitValueUnitPairModel expectedLineWidth;
    private final NameResolver nameResolver;
    private final Log.Logger logger = Log.logger((Object)this);
    private Object previousTP = null;

    protected AbstractTargetModel(AbstractTargetParameters abstractTargetParameters) {
        super(abstractTargetParameters);
        this.sourceCoordinatesModel = new SkyCoordsModel(null);
        this.sourceVelocityModel = new VelocityModel(null, AbstractTargetEditor.FID_SOURCEVELOCITY_VALUE, AbstractTargetEditor.FID_SOURCEVELOCITY_UNIT, AbstractTargetEditor.FID_SOURCEVELOCITY_SYSTEM, AbstractTargetEditor.FID_SOURCEVELOCITY_DOPPLER, AbstractTargetEditor.FID_SOURCEVELOCITY_REDSHIFT);
        this.expectedPeakFluxDensity = new ValueUnitPairModel(null, AbstractTargetEditor.FID_PEAKFLUXDENSITY_VALUE, AbstractTargetEditor.FID_PEAKFLUXDENSITY_UNIT);
        this.expectedPeakLineFluxDensity = new ValueUnitPairModel(null, AbstractTargetEditor.FID_PEAKLINEFLUXDENSITY_VALUE, AbstractTargetEditor.FID_PEAKLINEFLUXDENSITY_UNIT);
        this.expectedLineWidth = new UserUnitValueUnitPairModel(null, AbstractTargetEditor.FID_LINEWIDTH_VALUE, AbstractTargetEditor.FID_LINEWIDTH_UNIT);
        this.solarMappingDiameter = new ValueUnitPairModel(null, AbstractTargetEditor.FID_SOLARMAPPINGRADIUS_VALUE, AbstractTargetEditor.FID_SOLARMAPPINGRADIUS_UNIT);
        this.registerSubModel(this.solarMappingDiameter, this.sourceCoordinatesModel, this.sourceVelocityModel, this.expectedPeakFluxDensity, this.expectedPeakLineFluxDensity, this.expectedLineWidth);
        this.nameResolver = new NameResolver();
        ImpexFactory.getInstance().addProjectExportListener(this);
    }

    public AbstractTargetParameters getAbstractTarget() {
        TargetParameters targetParameters;
        if (this.document == null) {
            return null;
        }
        try {
            targetParameters = (TargetParameters)((SpatialDocument)this.document).getSpatialPartOfSpatialDocument();
        }
        catch (ClassCastException classCastException) {
            Log.logger((Object)this).warning("Unexpected document : " + this.document.getClass().getSimpleName());
            return null;
        }
        return targetParameters;
    }

    public SkyCoordinates getTargetCenter() {
        return this.getSourceCoordinates();
    }

    public SkyCoordinates getSourceCoordinates() {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        if (abstractTargetParameters == null) {
            return null;
        }
        return abstractTargetParameters.getSourceCoordinates();
    }

    @Override
    public void publish() {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        if (abstractTargetParameters == null) {
            return;
        }
        if (abstractTargetParameters.getSourceName().equals("")) {
            abstractTargetParameters.setPreviousResolvedTargetName(null);
        }
        this.publish(AbstractTargetEditor.FID_SOURCENAME, abstractTargetParameters.getSourceName());
        this.publish(AbstractTargetEditor.FID_NONSIDEREALMOTION, abstractTargetParameters.getNonSiderealMotion());
        this.publish(AbstractTargetEditor.FID_SOLARSYSTEMOBJECT, abstractTargetParameters.getSolarSystemObject());
        this.publish(AbstractTargetEditor.FID_SOURCEEPHEMERIS, abstractTargetParameters.getSourceEphemeris());
        ExpectedProperties expectedProperties = abstractTargetParameters.getExpectedProperties();
        this.publish(AbstractTargetEditor.FID_CONTINUUM_LINEAR_POLARIZATION, expectedProperties.getDesiredPolarizationPercentage());
        this.publish(AbstractTargetEditor.FID_LINE_POLARIZATION_PERCENTAGE, expectedProperties.getDesiredLinePolarizationPercentage());
        this.publish(AbstractTargetEditor.FID_SOLAR_ACTIVITY, expectedProperties.getSolarActivityLevel());
        this.publish(AbstractTargetEditor.FID_CONTINUUM_CIRCULAR_POLARIZATION, expectedProperties.getDesiredCircularPolarizationPercentage());
        this.publish(AbstractTargetEditor.FID_SPECTRALLINE_CIRCULAR_POLARIZATION, expectedProperties.getDesiredLineCircularPolarizationPercentage());
        this.publish(AbstractTargetEditor.FID_VLBI_PASSIVE_PHASING, expectedProperties.getIsPassivePhasing());
        if (abstractTargetParameters.getSolarMapping() != null) {
            this.publish(AbstractTargetEditor.FID_TP_SOLAR_MAPPING, abstractTargetParameters.getSolarMapping());
        }
        if (abstractTargetParameters.getSolarMappingPattern() != null) {
            this.publish(AbstractTargetEditor.FID_TP_SOLAR_PATTERN_TYPE, abstractTargetParameters.getSolarMappingPattern());
        }
        this.solarMappingDiameter.publish();
        this.sourceCoordinatesModel.publish();
        this.getPmRAModel().publish();
        this.getPmDecModel().publish();
        this.getParallaxModel().publish();
        this.sourceVelocityModel.publish();
        this.expectedPeakFluxDensity.publish();
        this.expectedPeakLineFluxDensity.publish();
        this.expectedLineWidth.publish();
        try {
            if (ObsProposal.isVLBIRelated()) {
                this.publish(AbstractTargetEditor.FID_VLBI_PASSIVE_PHASING_LABEL, this.getPassivePhasingLabel());
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    private String getPassivePhasingLabel() {
        Object object = "Passive phasing is required";
        Optional<ScienceGoal> optional = ScienceGoal.getBOsParentScienceGoal((BusinessObject)this.getAbstractTarget());
        if (optional.isPresent()) {
            ScienceGoal scienceGoal = optional.get();
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
            if (spectralSetupParameters.isSpectralLine()) {
                return "Passive phasing is required (check the Proposer's Guide for the line flux limits)";
            }
            if (spectralSetupParameters.isSingleContinuum() && receiverBand != null) {
                boolean bl = false;
                try {
                    bl = ObsProposal.isProposalVLBI();
                }
                catch (UnknownEntityException unknownEntityException) {
                    return "Passive phasing is required (check the Proposer's Guide for the line flux limits)";
                }
                AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
                List<VLBIFrequencyBands.VLBIBands> list = bl ? almaCapabilities.getVLBIBands().getVLBIBands() : almaCapabilities.getVLBIPhaserBands().getVLBIBands();
                Optional<VLBIFrequencyBands.VLBIBands> optional2 = list.stream().filter(vLBIBands -> vLBIBands.getBand() == receiverBand.getNumber()).findFirst();
                if (optional2.isPresent()) {
                    Sensitivity sensitivity = OTConfigurationHelper.getSensitivity(optional2.get().getPassivePhasingSensitivityThreshold());
                    object = (String)object + " (science target < " + sensitivity.toString() + ")";
                }
            }
        }
        return object;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        if (fieldID.equals(AbstractTargetEditor.FID_SOURCENAME)) {
            String string = (String)object;
            if (abstractTargetParameters.hasNoPreviousTargetName()) {
                abstractTargetParameters.setPreviousTargetName(abstractTargetParameters.getSourceName());
            }
            abstractTargetParameters.setSourceName(string);
            return string;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_VLBI_PASSIVE_PHASING)) {
            boolean bl = (Boolean)object;
            abstractTargetParameters.getExpectedProperties().setIsPassivePhasing(bl);
            if (bl) {
                ObservingToolController.getMyInstance();
                CalibrationSetupParametersModel calibrationSetupParametersModel = (CalibrationSetupParametersModel)ObservingToolController.getOTGui().getEditors().modelFor(CalibrationSetupParameters.class);
                calibrationSetupParametersModel.update(null, CalibrationSetupParametersEditor.MANUAL_CALIBRATORS, true);
            }
        } else {
            if (fieldID.equals(AbstractTargetEditor.FID_NONSIDEREALMOTION)) {
                Boolean bl = (Boolean)object;
                this.updateNonSidereal(abstractTargetParameters, bl);
                return bl;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_SOLARSYSTEMOBJECT) && object instanceof String) {
                return this.setSolarSystemObject((String)object, abstractTargetParameters);
            }
            if (fieldID.equals(AbstractTargetEditor.FID_SOURCEEPHEMERIS)) {
                String string = (String)object;
                abstractTargetParameters.setSourceEphemeris(string);
                this.setEphemerisAttributesInDocument(abstractTargetParameters, string);
                return string;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_RESOLVENAME)) {
                this.resolveName();
                return null;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_RESOLVECANCEL)) {
                return null;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_CONTINUUM_LINEAR_POLARIZATION)) {
                double d = 0.0;
                try {
                    d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
                }
                catch (OutOfRangeException | NumberFormatException exception) {
                    // empty catch block
                }
                abstractTargetParameters.getExpectedProperties().setDesiredPolarizationPercentage(d);
                return d;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_SOLAR_ACTIVITY)) {
                String string = (String)object;
                abstractTargetParameters.getExpectedProperties().setSolarActivityLevel(string);
                return string;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_LINE_POLARIZATION_PERCENTAGE)) {
                double d = 0.0;
                try {
                    d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
                }
                catch (OutOfRangeException | NumberFormatException exception) {
                    // empty catch block
                }
                abstractTargetParameters.getExpectedProperties().setDesiredLinePolarizationPercentage(d);
                return d;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_CONTINUUM_CIRCULAR_POLARIZATION)) {
                double d = 0.0;
                try {
                    d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
                }
                catch (OutOfRangeException | NumberFormatException exception) {
                    // empty catch block
                }
                abstractTargetParameters.getExpectedProperties().setDesiredCircularPolarizationPercentage(d);
                return d;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_SPECTRALLINE_CIRCULAR_POLARIZATION)) {
                double d = 0.0;
                try {
                    d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
                }
                catch (OutOfRangeException | NumberFormatException exception) {
                    // empty catch block
                }
                abstractTargetParameters.getExpectedProperties().setDesiredLineCircularPolarizationPercentage(d);
                return d;
            }
            if (fieldID.equals(AbstractTargetEditor.FID_TP_SOLAR_MAPPING) && object != null) {
                String string = (String)object;
                abstractTargetParameters.setSolarMapping(TPRegionalMappingTypes.valueOfBOMapping(string).getBOMapping());
            } else if (fieldID.equals(AbstractTargetEditor.FID_TP_SOLAR_PATTERN_TYPE) && object != null) {
                String string = (String)object;
                abstractTargetParameters.setSolarMappingPattern(TPRegionalPatterns.valueOfBOMapping(string).getBOMapping());
            }
        }
        return object;
    }

    private void updateNonSidereal(@NonNull AbstractTargetParameters abstractTargetParameters, @NonNull Boolean bl) {
        if (abstractTargetParameters == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (bl == null) {
            throw new NullPointerException("isNonSiderealSelected is marked non-null but is null");
        }
        if (this.previousTP != null && this.previousTP.equals(abstractTargetParameters) && abstractTargetParameters.getNonSiderealMotion() != bl.booleanValue()) {
            if (!bl.booleanValue()) {
                this.zeroNonSolarSystemFields(false);
                abstractTargetParameters.setSourceName("");
            } else {
                abstractTargetParameters.setSourceName(AbstractTargetParameters.SOLARSYSTEMOBJECT_UNSPECIFIED);
                abstractTargetParameters.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
            }
            this.publish(AbstractTargetEditor.FID_SOURCENAME, abstractTargetParameters.getSourceName());
            this.sourceVelocityModel.publish();
        }
        abstractTargetParameters.setNonSiderealMotion(bl);
        this.previousTP = abstractTargetParameters;
        if (!bl.booleanValue()) {
            abstractTargetParameters.setSolarSystemObject(AbstractTargetParameters.SOLARSYSTEMOBJECT_UNSPECIFIED);
            this.publish(AbstractTargetEditor.FID_SOLARSYSTEMOBJECT, abstractTargetParameters.getSolarSystemObject());
            abstractTargetParameters.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
            this.sourceVelocityModel.publish();
        }
        this.publish(AbstractTargetEditor.FID_NONSIDEREALMOTION, bl);
        boolean bl2 = abstractTargetParameters.isEphemerisSource();
        if (bl2) {
            this.setEphemerisAttributesInDocument(abstractTargetParameters, abstractTargetParameters.getSourceEphemeris());
        } else if (!bl2 && abstractTargetParameters.getNonSiderealMotion()) {
            this.resetNonSiderealCoordinates(abstractTargetParameters);
        }
    }

    private String setSolarSystemObject(String string, @NonNull AbstractTargetParameters abstractTargetParameters) {
        boolean bl;
        String string2;
        boolean bl2;
        if (abstractTargetParameters == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        abstractTargetParameters.setSolarSystemObject(string);
        if (!abstractTargetParameters.isSun()) {
            abstractTargetParameters.setSolarMapping(AbstractTargetParameters.SOLARMAPPING_FULLSOLARDISC);
            this.publish(AbstractTargetEditor.FID_TP_SOLAR_MAPPING, AbstractTargetParameters.SOLARMAPPING_FULLSOLARDISC);
        }
        boolean bl3 = bl2 = StringUtils.isNotEmpty((CharSequence)(string2 = abstractTargetParameters.getSourceEphemeris())) && (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_EPHEMERIS) || string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_SUN));
        if (bl2) {
            this.setEphemerisAttributesInDocument(abstractTargetParameters, string2);
        } else {
            abstractTargetParameters.setSourceName(string);
        }
        boolean bl4 = abstractTargetParameters.isEphemerisSource();
        boolean bl5 = bl = !bl4 && abstractTargetParameters.getNonSiderealMotion();
        if (bl) {
            this.resetNonSiderealCoordinates(abstractTargetParameters);
        }
        this.publish(AbstractTargetEditor.FID_SOURCENAME, abstractTargetParameters.getSourceName());
        return string;
    }

    private void resetNonSiderealCoordinates(@NonNull AbstractTargetParameters abstractTargetParameters) {
        if (abstractTargetParameters == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SkyCoordinates skyCoordinates = abstractTargetParameters.getSourceCoordinates();
        skyCoordinates.setLatitude(Latitude.createLatitude());
        skyCoordinates.setLongitude(Longitude.createLongitude());
        this.sourceCoordinatesModel.publish();
    }

    private void setEphemerisAttributesInDocument(@NonNull AbstractTargetParameters abstractTargetParameters, String string) {
        if (abstractTargetParameters == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (string == null || string.isEmpty()) {
            return;
        }
        try {
            OTHorizonParser oTHorizonParser = new OTHorizonParser(new OTLoggerAdapter(this.logger, this.getClass().getName(), null), string);
            assert (oTHorizonParser != null);
            abstractTargetParameters.setSourceName(MiscUtils.getSanitizedSourceName(oTHorizonParser.getSourceName(string)));
            List list = oTHorizonParser.parseEphemeris();
            if (!list.isEmpty()) {
                HorizonParser.ParsedEphemerisLine parsedEphemerisLine = (HorizonParser.ParsedEphemerisLine)list.get(0);
                SkyCoordinates skyCoordinates = abstractTargetParameters.getSourceCoordinates();
                skyCoordinates.setLatitude(Latitude.createLatitude((double)parsedEphemerisLine.declination, (String)Latitude.UNIT_RAD));
                skyCoordinates.setLongitude(Longitude.createLongitude((double)parsedEphemerisLine.rightAscension, (String)Longitude.UNIT_RAD));
                skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
                skyCoordinates.setType(SkyCoordinates.TYPE_ABSOLUTE);
                this.sourceCoordinatesModel.publish();
            } else {
                Log.logger(AbstractTargetModel.class).warning("No ephemeris data found in the file");
            }
            this.publish(AbstractTargetEditor.FID_SOURCENAME, this.getAbstractTarget().getSourceName());
        }
        catch (HorizonParser.UnableToParseEphemerisDataException | IOException | NullPointerException throwable) {
            this.logger.info("Logic error: the ephemeris data should be parseable at this point : " + throwable.getMessage());
        }
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        if (object != null) {
            this.setDocumentToSubModels(object);
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    protected void setDocumentToSubModels(Object object) {
        if (object == null) {
            return;
        }
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        this.sourceCoordinatesModel.setonlyDocument(abstractTargetParameters.getSourceCoordinates());
        this.getPmRAModel().setonlyDocument((Object)abstractTargetParameters.getPmRA());
        this.getPmDecModel().setonlyDocument((Object)abstractTargetParameters.getPmDec());
        this.getParallaxModel().setonlyDocument((Object)abstractTargetParameters.getParallax());
        this.sourceVelocityModel.setonlyDocument((Object)abstractTargetParameters.getSourceVelocity());
        this.expectedPeakFluxDensity.setonlyDocument((Object)abstractTargetParameters.getExpectedProperties().getExpectedPeakFluxDensity());
        this.expectedPeakLineFluxDensity.setonlyDocument((Object)abstractTargetParameters.getExpectedProperties().getExpectedPeakLineFluxDensity());
        this.expectedLineWidth.setonlyDocument(abstractTargetParameters.getExpectedProperties().getExpectedLineWidth());
        this.solarMappingDiameter.setonlyDocument((Object)abstractTargetParameters.getSolarMappingDiameter());
        AbstractTargetParameters abstractTargetParameters2 = abstractTargetParameters;
        if (abstractTargetParameters2.isEphemerisSource()) {
            this.setEphemerisAttributesInDocument(abstractTargetParameters2, abstractTargetParameters2.getSourceEphemeris());
        }
    }

    public void resolveName() {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        Object object = this.nameResolver.resolve(abstractTargetParameters);
        if (object instanceof Resolver) {
            ObservingToolGui observingToolGui;
            this.publish();
            this.sourceCoordinatesModel.publish(SkyCoordsModel.FID_RESOLVEDBY, ((Resolver)object).getNameServer() + " (" + ((Resolver)object).getResolverService().getResolutionServiceName() + ")");
            ObservingToolController observingToolController = ObservingToolController.getMyInstance();
            if (observingToolController != null && (observingToolGui = observingToolController.getGui()) != null) {
                observingToolGui.addInformationMessage(this.nameResolver.getFeedback());
            }
            abstractTargetParameters.setPreviousResolvedTargetName(abstractTargetParameters.getSourceName());
        } else {
            boolean bl;
            boolean bl2 = bl = object instanceof Integer && (Integer)object == NAME_DUFF_REVERT_BACK;
            if (bl) {
                boolean bl3;
                String string = abstractTargetParameters.getPreviousResolvedTargetName();
                boolean bl4 = null == string;
                boolean bl5 = bl3 = abstractTargetParameters.getSourceName() == abstractTargetParameters.getPreviousTargetName();
                if (abstractTargetParameters.hasNoPreviousResolvedTargetName()) {
                    string = bl4 || bl3 ? "" : abstractTargetParameters.getPreviousTargetName();
                }
                abstractTargetParameters.setSourceName(string);
                this.publish(AbstractTargetEditor.FID_SOURCENAME, abstractTargetParameters.getSourceName());
            }
        }
    }

    @Override
    public void projectExported(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsproject is marked non-null but is null");
        }
        try {
            this.publish();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ValueUnitPairModel getExpectedPeakFluxDensity() {
        return this.expectedPeakFluxDensity;
    }

    public ValueUnitPairModel getExpectedPeakLineFluxDensity() {
        return this.expectedPeakLineFluxDensity;
    }

    public ValueUnitPairModel getSolarMappingDiameter() {
        return this.solarMappingDiameter;
    }

    public UserUnitValueUnitPairModel getExpectedLineWidth() {
        return this.expectedLineWidth;
    }
}

