/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.Source;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.models.obsproject.GoalTargetParametersModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import java.util.Collection;

public class CalibrationTargetParametersModel
extends Model {
    public static final FieldID NON_SIDEREAL_MOTION = new FieldID("CalibrationTargetParametersModel non-sidereal source FID");
    public static final FieldID SIDEREAL_MOTION = new FieldID("CalibrationTargetParametersModel sidereal source FID");
    public static final FieldID SOLAR_SYSTEM_OBJECT = new FieldID("CalibrationTargetParametersModel solar system object FID");
    private final CalibratorExpertModel queryModel = new CalibratorExpertModel(null);
    private final GoalTargetParametersModel parametersModel = new GoalTargetParametersModel(null);

    public CalibrationTargetParametersModel(CalibrationTargetParameters calibrationTargetParameters) {
        super(calibrationTargetParameters);
        this.queryModel.subscribe(new CalibratorExpertController());
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> this.getController().modelChanged(fieldID, object);
        this.parametersModel.subscribe(modelChangeSubscriber);
        this.registerSubModel(this.parametersModel);
        this.setDocument(calibrationTargetParameters);
    }

    @Override
    public void setDocument(Object object) {
        if (object instanceof CalibrationTargetParameters) {
            CalibrationTargetParameters calibrationTargetParameters = (CalibrationTargetParameters)object;
            this.parametersModel.setDocument(calibrationTargetParameters);
            super.setDocument(object);
        }
    }

    @Override
    public void publish() {
        CalibrationTargetParameters calibrationTargetParameters = this.getCalibrationTargetParameters();
        if (calibrationTargetParameters == null) {
            return;
        }
        this.publish(SOLAR_SYSTEM_OBJECT, calibrationTargetParameters.getSolarSystemObject());
        if (calibrationTargetParameters.getNonSiderealMotion()) {
            this.publish(NON_SIDEREAL_MOTION, true);
        } else {
            this.publish(SIDEREAL_MOTION, true);
        }
        this.publishSubmodels();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (NON_SIDEREAL_MOTION.equals(fieldID)) {
            CalibrationTargetParameters calibrationTargetParameters = this.getCalibrationTargetParameters();
            if (calibrationTargetParameters != null) {
                calibrationTargetParameters.setNonSiderealMotion(true);
                this.clearCalibrationTargetProperties();
            }
            return object;
        }
        if (SIDEREAL_MOTION.equals(fieldID)) {
            CalibrationTargetParameters calibrationTargetParameters = this.getCalibrationTargetParameters();
            if (calibrationTargetParameters != null) {
                calibrationTargetParameters.setNonSiderealMotion(false);
                calibrationTargetParameters.clearCalibrationTargetProperties();
            }
            return object;
        }
        if (SOLAR_SYSTEM_OBJECT.equals(fieldID)) {
            CalibrationTargetParameters calibrationTargetParameters = this.getCalibrationTargetParameters();
            if (calibrationTargetParameters != null) {
                if (object instanceof String) {
                    calibrationTargetParameters.setSolarSystemObject((String)object);
                } else {
                    throw new IllegalArgumentException("Non-String published for solar system object");
                }
            }
            return object;
        }
        for (Model model : this.getSubModels()) {
            object = model.update(editor, fieldID, object);
        }
        return object;
    }

    private void clearCalibrationTargetProperties() {
        CalibrationTargetParameters calibrationTargetParameters = this.getCalibrationTargetParameters();
        if (calibrationTargetParameters != null) {
            calibrationTargetParameters.clearCalibrationTargetProperties();
        }
        this.parametersModel.publish();
    }

    public VelocityModel getVelocityModel() {
        return this.parametersModel.getVelocityModel();
    }

    public SkyCoordsModel getSkyCoordsModel() {
        return this.parametersModel.getSkyCoordsModel();
    }

    public CalibratorExpertModel getCalibratorExpertModel() {
        return this.queryModel;
    }

    public void setTargetFromMeasurement(Measurement measurement) {
        this.parametersModel.setTargetFromMeasurement(measurement);
    }

    public void addCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties) {
        this.parametersModel.addCalibrationTargetProperties(calibrationTargetProperties);
    }

    public void setCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties, int n) {
        this.parametersModel.setCalibrationTargetProperties(calibrationTargetProperties, n);
    }

    public Collection<CalibrationTargetProperties> getCalibrationTargetProperties() {
        return this.parametersModel.getCalibrationTargetProperties();
    }

    public boolean removeCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties) {
        return this.parametersModel.removeCalibrationTargetProperties(calibrationTargetProperties);
    }

    private CalibrationTargetParameters getCalibrationTargetParameters() {
        return (CalibrationTargetParameters)this.getDocument();
    }

    public void setTargetFromSource(Source source) {
        this.parametersModel.setTargetFromSource(source);
    }
}

