/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

class LoggingPanel
extends JPanel
implements ActionListener {
    private final JLabel label;
    private final JTextArea text;
    private JPopupMenu popupMenu;

    LoggingPanel() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(new JEditorPane().getBackground());
        this.label = new JLabel("This window shows application warnings and errors. The full log is in file 'ot.log'");
        this.text = new JTextArea();
        this.add((Component)this.label, "North");
        this.add((Component)this.text, "Center");
        this.popupMenu = this.addPanelPopupMenu();
        this.text.setComponentPopupMenu(this.popupMenu);
    }

    void addMessage(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("summary is marked non-null but is null");
        }
        this.text.append(string);
        this.validate();
    }

    private JPopupMenu addPanelPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Copy Text");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        this.setComponentPopupMenu(jPopupMenu);
        return jPopupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.text.getSelectedText();
        StringBuilder stringBuilder = new StringBuilder(!StringUtils.isEmpty((CharSequence)string) ? string : "");
        StringSelection stringSelection = new StringSelection(stringBuilder.length() > 0 ? stringBuilder.toString() : "");
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }
}

