/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.DecVerifier;
import alma.obsprep.ot.boEditors.DegreeVerifier;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.GenerousParallaxVerifier;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.VelocityEditor;
import alma.obsprep.ot.models.sciencegoals.ProperMotionModel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class SolarSystemTargetAwareEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -2532034457875115423L;
    protected final Set<JComponent> extraSolarComps = new HashSet<JComponent>();
    private Object lastDocument = null;
    private boolean resetNonSolarSystemFieldsLatch = true;
    private VelocityEditor velocityEditor;
    private JLabel sourceRadialVelocityLabel;
    private SkyCoordsEditor skyCoordsEditor;
    private JLabel sourceCoordinatesLabel;
    private JLabel pmRALabel;
    private JLabel pmDecLabel;
    private ValueUnitPairEditor properMotionRAEditor;
    private ValueUnitPairEditor properMotionDecEditor;
    private ValueUnitPairEditor parallaxEditor;
    private JLabel parallaxLabel;

    @Override
    public ProperMotionModel getModel() {
        return (ProperMotionModel)super.getModel();
    }

    protected void addExtraSolarComponentArray(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, ComponentCollection componentCollection) {
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.extraSolarComps.addAll(componentCollection.getComponents());
    }

    protected void showExtraSolarSystemComponents(boolean bl, boolean bl2) {
        if (!bl) {
            ProperMotionModel properMotionModel = this.getModel();
            Object object = properMotionModel.getDocument();
            if (this.lastDocument != object || this.resetNonSolarSystemFieldsLatch) {
                properMotionModel.zeroNonSolarSystemFields(bl2);
                this.lastDocument = object;
                this.resetNonSolarSystemFieldsLatch = false;
            }
        } else {
            this.resetNonSolarSystemFieldsLatch = true;
        }
        for (JComponent jComponent : this.extraSolarComps) {
            jComponent.setVisible(bl);
        }
    }

    protected JPanel CreateProperMotionGrid() {
        ProperMotionModel properMotionModel = this.getModel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 6, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets2;
        this.parallaxLabel = this.makeLabel("Parallax");
        this.parallaxLabel.setHorizontalAlignment(2);
        this.parallaxLabel.setVerticalAlignment(0);
        jPanel.add((Component)this.parallaxLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.pmRALabel = this.makeLabel("PM RA");
        this.pmRALabel.setHorizontalAlignment(2);
        this.pmRALabel.setVerticalAlignment(0);
        jPanel.add((Component)this.pmRALabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.pmDecLabel = this.makeLabel("PM Dec");
        this.pmDecLabel.setHorizontalAlignment(2);
        this.pmDecLabel.setVerticalAlignment(0);
        jPanel.add((Component)this.pmDecLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        this.parallaxEditor = this.makeSmallAngleEditor(properMotionModel.getParallaxModel(), "Annual parallax of the source");
        this.parallaxEditor.getInput().setName("SolarSystemAwareTargetEditor.ParallaxText");
        this.parallaxEditor.getUnits().setName("SolarSystemAwareTargetEditor.ParallaxUnitCombo");
        ((FlowLayout)this.parallaxEditor.getLayout()).setVgap(1);
        GenerousParallaxVerifier generousParallaxVerifier = new GenerousParallaxVerifier(this.parallaxEditor);
        this.parallaxEditor.setVerifier("FOCUSLOST_VERIFIER", generousParallaxVerifier);
        jPanel.add((Component)this.parallaxEditor, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.properMotionRAEditor = this.makeValueUnitPairEditor(properMotionModel.getPmRAModel(), "Proper motion along RA (cross-declination) direction.");
        this.properMotionRAEditor.getInput().setName("SolarSystemAwareTargetEditor.PM_RAText");
        this.properMotionRAEditor.getUnits().setName("SolarSystemAwareTargetEditor.PM_RAUnitCombo");
        DegreeVerifier degreeVerifier = new DegreeVerifier(this.properMotionRAEditor);
        this.properMotionRAEditor.setVerifier("FOCUSLOST_VERIFIER", degreeVerifier);
        ((FlowLayout)this.properMotionRAEditor.getLayout()).setVgap(1);
        jPanel.add((Component)this.properMotionRAEditor, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.properMotionDecEditor = this.makeValueUnitPairEditor(properMotionModel.getPmDecModel(), "Proper motion along the declination direction.");
        ((FlowLayout)this.properMotionDecEditor.getLayout()).setVgap(1);
        this.properMotionDecEditor.getInput().setName("SolarSystemAwareTargetEditor.PM_DecText");
        this.properMotionDecEditor.getUnits().setName("SolarSystemAwareTargetEditor.PM_DecUnitCombo");
        DecVerifier decVerifier = new DecVerifier(this.properMotionDecEditor);
        this.properMotionDecEditor.setVerifier("FOCUSLOST_VERIFIER", decVerifier);
        jPanel.add((Component)this.properMotionDecEditor, gridBagConstraints);
        return jPanel;
    }

    protected void addSolarSystemTargetAwareEditorComponents(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        ProperMotionModel properMotionModel = this.getModel();
        ComponentCollection componentCollection = new ComponentCollection();
        this.sourceCoordinatesLabel = this.makeLabel("Source Coordinates");
        componentCollection.remember(this.sourceCoordinatesLabel);
        this.skyCoordsEditor = this.makeSkyCoordsEditor(properMotionModel.getSourceCoordinatesModel(), "The latitude and longitude of the source");
        componentCollection.remember(this.skyCoordsEditor);
        componentCollection.remember(this.CreateProperMotionGrid());
        this.addExtraSolarComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        this.sourceRadialVelocityLabel = this.makeLabel("Source Radial Velocity");
        componentCollection.remember(this.sourceRadialVelocityLabel);
        this.velocityEditor = this.makeVelocityEditor(properMotionModel.getSourceVelocityModel(), "The radial velocity of the source");
        componentCollection.remember((JComponent)this.velocityEditor, 2);
        this.addExtraSolarComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(20);
        arrayList.addAll(this.velocityEditor.getUserRestrictedEditableComponents());
        arrayList.add(this.sourceRadialVelocityLabel);
        arrayList.add(this.sourceCoordinatesLabel);
        arrayList.addAll(this.skyCoordsEditor.getUserRestrictedEditableComponents());
        return arrayList;
    }
}

