/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.ControlBlock;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.editors.obsproject.DependencyEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.obsproject.ObsUnitModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ObsUnitEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -7791180263762539039L;
    private final DependencyEditor dependencyEditor = new DependencyEditor();
    private JPanel unitDependenciesGroupPanel = null;

    public ObsUnitEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected ObsUnitEditor() {
    }

    @Override
    public ObsUnitModel getModel() {
        return (ObsUnitModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        this.addBasicsGroup(string);
        this.addControlGroup();
        this.addUnitDependenciesGroup(string);
    }

    protected JComponent addBasicsGroup(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.nameFID, string + " Name", "The name of this " + string);
        OTTextField oTTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.statusFID, "Status", "The status of this " + string);
        this.setEnabled(oTTextField, false);
        this.addOTTextArea(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.noteFID, 200, 75, "<html>Description<br>(optional)</html>", "A brief note or comment about this " + string, true);
        return this.addNonCollapsingGroup(jPanel, "Basics");
    }

    protected JPanel addControlGroup() {
        ValueUnitPairEditor valueUnitPairEditor = null;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getMaximumTimeModel(), "MOUS Max. Total Execution Time", "The maximum total time allowed for multiple SB executions. It is equal to the SB Maximum Execution Time (given in the SchedBlock panel) multiplied by the number of expected executions.");
        valueUnitPairEditor.setEditable(false);
        valueUnitPairEditor.setEnabled(false);
        ValueUnitPairEditor valueUnitPairEditor2 = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getEstimatedTimeModel(), "MOUS Estimated Total Execution Time", "This is the estimated total execution time for all executions of this SB. During automatic SB generation, it is currently set to the same as the MOUS Estimated Total Execution Time.");
        valueUnitPairEditor2.setEditable(true);
        valueUnitPairEditor2.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor2));
        this.addComboBox((JComponent)jPanel, gridBagLayout, gridBagConstraints, FieldIDs.arrayRequestedFID, "Array type", "Request array type", ControlBlock.getKnownArrayRequestedList());
        JPanel jPanel2 = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 0, 0);
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints2, "User Priority", (JComponent)this.makeTextFieldWithIntegerVerifier(FieldIDs.userPriorityFID, "The user priority", 0, Integer.MAX_VALUE));
        OTTextField oTTextField = this.makeTextFieldWithIntegerVerifier(FieldIDs.tacPriorityFID, "The Time Allocation Committee priority", 0, Integer.MAX_VALUE);
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints2, "TAC Priority", (JComponent)oTTextField);
        this.setEnabled(oTTextField, false);
        this.addValueUnitPair((JComponent)jPanel2, gridBagLayout2, gridBagConstraints2, this.getModel().getPointingAccuracyModel(), "Pointing Accuracy", "The pointing accuracy required");
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints2, "Bandpass Accuracy", (JComponent)this.makeTextFieldWithDoubleVerifier(FieldIDs.bandpassAccuracyFID, "The bandpass accuracy required (as a percentage deviation from a perfectly flat bandpass)", Double.MIN_VALUE, Double.MAX_VALUE));
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints2, "Polarization Accuracy", (JComponent)this.makeTextFieldWithDoubleVerifier(FieldIDs.polarizationAccuracyFID, "The polarization accuracy required", Double.MIN_VALUE, Double.MAX_VALUE));
        this.addGroup(0, jPanel, gridBagLayout, gridBagConstraints, jPanel2, "( Not currently used )", true);
        return this.addGroup(jPanel, "Control");
    }

    protected JPanel addUnitDependenciesGroup(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.dependencyEditor);
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getUnitDepDelayModel(), "Delay", "The amount by which this unit should be delayed.");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getUnitDepMarginModel(), "Margin", "The time margin between dependencies.");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Execution count", (JComponent)this.makeTextFieldWithIntegerVerifier(FieldIDs.unitDepExecCountFID, "The execution count of this " + string, 0, Integer.MAX_VALUE));
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.unitDepExprFID, "Expression", "The logical expression controlling the execution of this " + string);
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.controlScriptFID, "Control Script", "The control script");
        this.unitDependenciesGroupPanel = this.addGroup(jPanel, "Unit Dependencies", true);
        return this.unitDependenciesGroupPanel;
    }

    @Override
    protected void build() {
        super.build("ObsUnit");
    }

    @Override
    public void setModel(Model model, boolean bl) {
        super.setModel(model, bl);
        this.dependencyEditor.setObsUnitModel((ObsUnitModel)model);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        ObsUnitModel obsUnitModel = this.getModel();
        Object object2 = obsUnitModel.getDocument();
        if (this.unitDependenciesGroupPanel != null) {
            TitledBorder titledBorder = (TitledBorder)this.unitDependenciesGroupPanel.getBorder();
            if (object2 instanceof SchedBlock) {
                titledBorder.setTitle("Unit Dependencies");
            } else {
                titledBorder.setTitle("Unit Dependencies (not currently used)");
            }
        }
        super.update(fieldID, object);
    }
}

