/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.SourceCatalogQueryParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.services.experts.calibrators.DeclinationComparator;
import alma.obsprep.services.experts.calibrators.MeasurementTableModel;
import alma.obsprep.services.experts.spectralline.gui.OTTableRenderer;
import alma.obsprep.services.experts.spectralline.gui.TableCellRendererFactory;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class CalibrationSetupParametersQuerySourceEditor
extends EditorWithGridBagLayout
implements TableModelListener {
    private static final SourceCatalogQueryParameters junk = new CatalogQueryParameters();
    private final MeasurementTableModel measurementTableModel = new MeasurementTableModel();
    private final QuerySourceEditor queryEditor;
    private JComboBox catalogue;
    private JButton cancelButton;
    private JButton okButton;
    private JLabel infoLabel;
    private JPanel resultsPanel;
    private JButton submitButton;
    private JTable measurementTable;

    public CalibrationSetupParametersQuerySourceEditor(Model model, boolean bl) {
        this.setModel(model);
        this.queryEditor = new QuerySourceEditor(model, QuerySourceEditor.ShowSourceNameEnum.ShowSourceNameFilter);
        this.registerSubView(this.queryEditor);
        this.buildResultsPanel(bl);
        this.build();
        model.publish();
    }

    @Override
    protected void build() {
        super.build("CalibrationSetupParametersQuerySourceEditor");
        this.catalogue.setModel(new DefaultComboBoxModel<String>(CalibratorExpert.SourceCatalog.getNames()));
        this.initEvents(this.catalogue, QuerySourceEditor.catlocFID);
        this.makeTableSortable();
        this.measurementTableModel.addTableModelListener(this);
    }

    @Override
    protected void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.queryEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.resultsPanel.setBorder(new TitledBorder("Search Results"));
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (QuerySourceEditor.filterFID.equals(fieldID)) {
            this.submitButton.setEnabled(false);
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(CalibratorExpertEditor.tableFID)) {
            if (object instanceof List) {
                List list = (List)object;
                this.measurementTableModel.setCalibrators(list);
                if (this.infoLabel != null) {
                    this.infoLabel.setText("These results could be different at project execution time");
                    this.infoLabel.setIcon(Icons.warning);
                }
            }
            if (this.submitButton != null) {
                this.submitButton.setEnabled(true);
            }
        } else if (fieldID.equals(QuerySourceEditor.raFID)) {
            String string = (String)object;
            this.measurementTableModel.setQueryRA(string);
        } else if (fieldID.equals(QuerySourceEditor.decFID)) {
            String string = (String)object;
            this.measurementTableModel.setQueryDec(string);
        }
        super.update(fieldID, object);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    private void resizeColumn(JTable jTable, TableColumn tableColumn, TableCellRenderer tableCellRenderer, int n) {
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
        int n2 = component.getPreferredSize().width;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(i, n);
            component = tableCellRenderer2.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n2);
    }

    private void buildResultsPanel(boolean bl) {
        this.resultsPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.infoLabel = new JLabel();
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane();
        this.measurementTable = new JTable();
        this.measurementTable.getTableHeader().setReorderingAllowed(false);
        JPanel jPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        JLabel jLabel5 = new JLabel();
        this.catalogue = new JComboBox();
        this.submitButton = this.makeButton(QuerySourceEditor.filterFID, "Test Query", "Query the ALMA calibrator database for possible calibrators given the constraints entered");
        this.setLayout(new GridBagLayout());
        this.resultsPanel.setLayout(new GridBagLayout());
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() & 0xFFFFFFFE));
        jLabel.setText("<html><ul><li>This is designed to provide you with an idea of what calibrators are available in the ALMA database, but will not allow you to select a specific calibrator. Click <i>Test Query</i> to find source catalog measurements matching your constraints</li></ul></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.resultsPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.resultsPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.measurementTable.setModel(this.measurementTableModel);
        this.measurementTable.setSelectionMode(0);
        TableColumn tableColumn = this.measurementTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.SEPARATION));
        tableColumn = this.measurementTable.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.measurementTable.getColumnModel().getColumn(5);
        OTTableRenderer oTTableRenderer = TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FLUX_DENSITY);
        if (bl) {
            // empty if block
        }
        tableColumn.setCellRenderer(oTTableRenderer);
        tableColumn = this.measurementTable.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.DATE));
        scrollWhenFocusedPane.setViewportView(this.measurementTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.resultsPanel.add((Component)scrollWhenFocusedPane, gridBagConstraints);
        jLabel5.setText("using");
        this.cancelButton.setText("Cancel");
        this.okButton.setText("OK");
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogue, -2, -1, -2).addGap(18, 18, 18).addComponent(jLabel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton)));
        groupLayout.linkSize(0, this.okButton, jLabel2);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(jLabel3).addComponent(jLabel5).addComponent(this.catalogue, -2, -1, -2).addComponent(this.submitButton).addComponent(jLabel4).addComponent(this.cancelButton).addComponent(this.okButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 11, 11);
        this.resultsPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.setName("CalibrationSetupParametersQuerySourceEditor.buttonPanel");
        this.cancelButton.setName("CalibrationSetupParametersQuerySourceEditor.cancelButton");
        this.catalogue.setName("CalibrationSetupParametersQuerySourceEditor.catalogue");
        jLabel5.setName("CalibrationSetupParametersQuerySourceEditor.catalogueLabel");
        jLabel.setName("CalibrationSetupParametersQuerySourceEditor.helpLabel");
        this.infoLabel.setName("CalibrationSetupParametersQuerySourceEditor.infoLabel");
        this.okButton.setName("CalibrationSetupParametersQuerySourceEditor.okButton");
        this.queryEditor.setName("CalibrationSetupParametersQuerySourceEditor.queryEditor");
        this.resultsPanel.setName("CalibrationSetupParametersQuerySourceEditor.resultsPanel");
        scrollWhenFocusedPane.setName("CalibrationSetupParametersQuerySourceEditor.scrollPane");
        jLabel2.setName("CalibrationSetupParametersQuerySourceEditor.spacer1");
        jLabel3.setName("CalibrationSetupParametersQuerySourceEditor.spacer2");
        jLabel4.setName("CalibrationSetupParametersQuerySourceEditor.spacer3");
        this.submitButton.setName("CalibrationSetupParametersQuerySourceEditor.submitButton");
        this.measurementTable.setName("CalibrationSetupParametersQuerySourceEditor.table");
    }

    private void makeTableSortable() {
        TableRowSorter<MeasurementTableModel> tableRowSorter = new TableRowSorter<MeasurementTableModel>(this.measurementTableModel);
        tableRowSorter.setComparator(2, new DeclinationComparator());
        this.measurementTable.setRowSorter(tableRowSorter);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(null);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE);
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            CalibrationSetupParametersQuerySourceEditor calibrationSetupParametersQuerySourceEditor = new CalibrationSetupParametersQuerySourceEditor(calibratorExpertModel, false);
            calibratorExpertModel.setDocument(querySourceAdapter);
            JFrame jFrame = new JFrame("CalibrationSetupParametersQueryEditor");
            jFrame.setDefaultCloseOperation(3);
            jFrame.getContentPane().add(calibrationSetupParametersQuerySourceEditor);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getSubmitButton() {
        return this.submitButton;
    }

    private static /* synthetic */ boolean lambda$buildResultsPanel$0(double d) {
        return d * 1000.0 > 500.0;
    }
}

