/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.QuitInteractor;
import alma.obsprep.ot.actions.QuitPerformer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.util.GUIUtilities;

public class Quit
extends OTAction
implements QuitInteractor {
    private static DialogId DIALOG_SAVE_CURRENT_PROJECT = new DialogId("Quit.SaveCurrentProject", "Save current project before quitting");
    ObservingToolController ctrl;

    public Quit(ObservingToolController observingToolController) {
        this.ctrl = observingToolController;
        QuitPerformer quitPerformer = new QuitPerformer(this);
        this.setPerformer(quitPerformer);
    }

    @Override
    public boolean getConfirmation() {
        ObservingToolGui observingToolGui = this.ctrl.getGui();
        if (observingToolGui.isProjectModified(observingToolGui.getPrimaryProject())) {
            GUIUtilities.dialogSettings(DIALOG_SAVE_CURRENT_PROJECT).setAutoanswer(1L);
            switch (GUIUtilities.offer(DIALOG_SAVE_CURRENT_PROJECT, "The current project has unsaved changes.\nDo you want to save it now, or quit without saving?", "Save", "Quit", "Cancel")) {
                case 2: {
                    return false;
                }
                case 0: {
                    this.ctrl.getGui().primaryProjectCompartment().getProjectTiedActions().save.actionPerformed(null);
                }
            }
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.ctrl.shutdown();
    }
}

