/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.project.ProjectTreePanels;
import alma.obsprep.util.GUIUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class Close
extends AbstractAction {
    private static final DialogId DIALOG_DISCARD_CHANGES = new DialogId("Close.DiscardChanges");
    protected ObservingToolGui gui;
    protected ProjectTreePanels ptrees;

    public Close(ObservingToolGui observingToolGui, ProjectTreePanels projectTreePanels) {
        this.gui = observingToolGui;
        this.ptrees = projectTreePanels;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            ObsProject obsProject = this.ptrees.getObsProject();
            if (this.gui.isProjectModified(obsProject) && !GUIUtilities.confirm(DIALOG_DISCARD_CHANGES, "Project was modified. Close without saving?")) {
                return;
            }
            this.gui.closeCompartment(obsProject);
            Close.removeProjectFromMemory(obsProject);
            ActionLog.performed("Close", obsProject);
        }
        catch (Exception exception) {
            GUIUtilities.warning(null, "Encountered a problem while attempting to close project", exception);
        }
    }

    public static void removeProjectFromMemory(ObsProject obsProject) {
    }
}

