/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.valuetypes.Frequency;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ConfigModeComparator
implements Comparator<CorrConfigMode> {
    private final List<Column> priority;

    public ConfigModeComparator() {
        this(Column.MODE);
    }

    private ConfigModeComparator(Column column) {
        this.priority = Arrays.asList(column);
    }

    public ConfigModeComparator(Column[] columnArray) {
        this.priority = Arrays.asList(columnArray);
    }

    @Override
    public int compare(CorrConfigMode corrConfigMode, CorrConfigMode corrConfigMode2) {
        Iterator<Column> iterator = this.priority.iterator();
        while (iterator.hasNext()) {
            int n = this.compare(iterator.next(), corrConfigMode, corrConfigMode2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private int compare(Column column, CorrConfigMode corrConfigMode, CorrConfigMode corrConfigMode2) {
        switch (column.ordinal()) {
            case 0: {
                int n = corrConfigMode.getMode();
                int n2 = corrConfigMode2.getMode();
                return (n - n2) / Math.abs(n - n2);
            }
            case 3: {
                int n = corrConfigMode.getNominalChannels();
                int n3 = corrConfigMode2.getNominalChannels();
                return (n - n3) / Math.abs(n - n3);
            }
            case 1: {
                Frequency frequency = corrConfigMode.getNominalBandwidth();
                Frequency frequency2 = corrConfigMode2.getNominalBandwidth();
                return frequency.compareTo((AbstractDoubleWithUnit)frequency2);
            }
            case 2: {
                Frequency frequency = corrConfigMode.getResolution();
                Frequency frequency3 = corrConfigMode2.getResolution();
                return frequency.compareTo((AbstractDoubleWithUnit)frequency3);
            }
        }
        return 0;
    }

    public static enum Column {
        MODE,
        BANDWIDTH,
        RESOLUTION,
        CHANNELS;

    }
}

