/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.AtmosphericCalParametersT;
import alma.obsprep.bo.schedblock.data.AtmosphericCalParametersData;
import alma.obsprep.ot.actions.AddInteractor;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;

public class AtmosphericCalParameters
extends AtmosphericCalParametersData {
    public AtmosphericCalParameters(AtmosphericCalParametersT atmosphericCalParametersT) {
        super(atmosphericCalParametersT);
    }

    public AddInteractor.ObjectType whatType() {
        return AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS;
    }

    protected void initAsNew() {
        super.initAsNew();
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        skyCoordinates.setLongitude(Longitude.createLongitude((double)0.03333333333333, (String)Longitude.UNIT_DEG));
        skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Latitude.UNIT_DEG));
        this.setSkyPosition(skyCoordinates);
        this.setDataOrigin(DATAORIGIN_FULL_RESOLUTION_AUTO);
        this.setUseHotLoad(true);
        this.setSubScanDuration(Time.createTimeSec(2.0));
        this.setDefaultIntegrationTime(Time.createTimeSec(2.0));
        this.setCycleTime(Time.createTime((double)10.0, (String)Time.UNIT_MIN));
    }

    public int getSummaryPriority() {
        return 107;
    }
}

