/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.entity.xmlbinding.obsproject.CalibrationTargetPropertiesT;
import alma.obsprep.bo.obsproject.data.CalibrationTargetPropertiesData;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;

public class CalibrationTargetProperties
extends CalibrationTargetPropertiesData {
    public CalibrationTargetProperties(CalibrationTargetPropertiesT calibrationTargetPropertiesT) {
        super(calibrationTargetPropertiesT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setFlux(Flux.createFlux((double)0.0, (String)Flux.UNIT_JY));
        this.setFrequency(Frequency.createFrequencyGHZ(0.0));
    }

    public static CalibrationTargetProperties createCalibrationTargetProperties(double d, double d2) {
        CalibrationTargetProperties calibrationTargetProperties = CalibrationTargetProperties.createCalibrationTargetProperties();
        calibrationTargetProperties.getFrequency().setContentAndUnit(d, Frequency.UNIT_HZ);
        calibrationTargetProperties.getFlux().setContentAndUnit(d2, Flux.UNIT_JY);
        calibrationTargetProperties.getFrequency().convertToFriendlyUnit();
        return calibrationTargetProperties;
    }

    public static CalibrationTargetProperties createCalibrationTargetProperties(Measurement measurement) {
        Double d = measurement.getFrequency();
        Double d2 = measurement.getFlux();
        return CalibrationTargetProperties.createCalibrationTargetProperties(d, d2);
    }
}

