/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.configuration;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.configuration.ArrayConfigurationType;
import alma.observatorycharacteristics.configuration.ArrayMultiplierType;
import alma.observatorycharacteristics.configuration.MultiplierType;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.ObjectFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.MiscUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import org.apache.commons.lang3.StringUtils;

public class OTXMLConfigurationReader {
    public static final File ALMA_CONFIGURATION_PROPERTIES_FOLDER = new File("alma/observatorycharacteristics/configuration");
    private OTConfiguration otConfiguration = null;
    private String telescopeUsedDuringLastUnmarshalling = null;
    private static OTXMLConfigurationReader instance;

    public OTConfiguration getOTConfiguration() throws JAXBException, InvalidOTCOnfigurationException {
        String string = System.getProperty("Telescope", "Cycle12");
        if (StringUtils.equals((CharSequence)string, (CharSequence)this.telescopeUsedDuringLastUnmarshalling) && this.otConfiguration != null) {
            return this.otConfiguration;
        }
        this.telescopeUsedDuringLastUnmarshalling = string;
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        assert (jAXBContext != null && unmarshaller != null);
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
        InputStream inputStream = null;
        String string2 = string + "OTConfiguration.xml";
        Log.logger(OTXMLConfigurationReader.class).info("Loading OT Configuration file : " + string2);
        try {
            ValidationEvent[] validationEventArray = MiscUtils.findResource(ALMA_CONFIGURATION_PROPERTIES_FOLDER, string2);
            inputStream = validationEventArray.openStream();
        }
        catch (Exception exception) {
            Log.logger(AlmaCapabilities.class).log(Level.WARNING, "Error accessing " + string2 + " file: " + exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        assert (inputStream != null);
        this.otConfiguration = (OTConfiguration)unmarshaller.unmarshal(inputStream);
        if (validationEventCollector.hasEvents()) {
            for (ValidationEvent validationEvent : validationEventCollector.getEvents()) {
                Log.logger(OTXMLConfigurationReader.class).warning(validationEvent.getMessage());
            }
            throw new JAXBException("Unable to unmarshall array configuration XML");
        }
        this.validOTConfiguration(this.otConfiguration);
        return this.otConfiguration;
    }

    private void validOTConfiguration(OTConfiguration oTConfiguration) throws InvalidOTCOnfigurationException {
        this.validateArrayConfigurations(oTConfiguration);
        this.validatePolicies(oTConfiguration);
        this.validateCapabilities(oTConfiguration);
    }

    private void validateCapabilities(OTConfiguration oTConfiguration) throws InvalidOTCOnfigurationException {
        oTConfiguration.getTelescopeCapabilities();
    }

    private void validatePolicies(OTConfiguration oTConfiguration) throws InvalidOTCOnfigurationException {
        oTConfiguration.getTelescopePolicies();
    }

    private void validateArrayConfigurations(OTConfiguration oTConfiguration) throws InvalidOTCOnfigurationException {
        OTConfiguration.ArrayConfigurations arrayConfigurations = oTConfiguration.getArrayConfigurations();
        if (arrayConfigurations == null || arrayConfigurations.getArrayConfiguration().isEmpty()) {
            throw new InvalidOTCOnfigurationException("No array configurations have been specified");
        }
        HashSet<ArrayConfigurationType> hashSet = new HashSet<ArrayConfigurationType>();
        HashMap hashMap = new HashMap();
        for (Object object : ArrayConfigurationType.values()) {
            hashMap.put((ArrayConfigurationType)((Object)object), new ArrayList());
        }
        for (OTConfiguration.ArrayConfigurations.ArrayConfiguration arrayConfiguration : arrayConfigurations.getArrayConfiguration()) {
            Object object;
            if (arrayConfiguration.isIsLongBaselineConfiguration()) {
                Log.logger(OTXMLConfigurationReader.class).info("Configuration " + arrayConfiguration.getConfigurationName() + " is configured as long baseline");
            }
            if (!arrayConfiguration.isIsEnabled()) continue;
            ArrayConfigurationType arrayConfigurationType = arrayConfiguration.getConfigurationType();
            object = arrayConfiguration.getConfigurationName();
            if (hashSet.contains(object)) {
                throw new InvalidOTCOnfigurationException("Configuration name already used : " + (String)object);
            }
            hashSet.add((ArrayConfigurationType)((Object)object));
            int n = arrayConfiguration.getConfigurationNumber();
            Iterator iterator = ((ArrayList)hashMap.get((Object)arrayConfigurationType)).iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n != n2) continue;
                throw new InvalidOTCOnfigurationException("Cannot use the same configuration number more than once : " + (String)object);
            }
            ((ArrayList)hashMap.get((Object)arrayConfigurationType)).add(n);
            boolean bl = arrayConfiguration.isIsACAAllowed();
            if (!ArrayConfigurationType.TWELVE_M.equals((Object)arrayConfigurationType) && !bl) {
                throw new InvalidOTCOnfigurationException("An ACA configuration cannot have the ACA disallowed : " + (String)object);
            }
            if (arrayConfiguration.getMinBaseline() > arrayConfiguration.getMaxBaseline()) {
                throw new InvalidOTCOnfigurationException("Min baseline is greater than the max baseline for " + (String)object);
            }
            EnumSet<MultiplierType> enumSet = EnumSet.noneOf(MultiplierType.class);
            for (ArrayMultiplierType arrayMultiplierType : arrayConfiguration.getArrayMultiplier()) {
                Object object2 = arrayMultiplierType.getMultiplierType();
                if (enumSet.contains(object2)) {
                    throw new InvalidOTCOnfigurationException("Array Multiplier type " + String.valueOf(arrayMultiplierType) + " specified multiple times for " + (String)object);
                }
                enumSet.add((MultiplierType)((Object)object2));
            }
            String string = arrayConfiguration.getCompactConfiguration();
            if (string == null) continue;
            if (!ArrayConfigurationType.TWELVE_M.equals((Object)arrayConfigurationType)) {
                throw new InvalidOTCOnfigurationException("An ACA configuration should not have a 12-m compact counterpart " + (String)object);
            }
            boolean bl2 = false;
            for (OTConfiguration.ArrayConfigurations.ArrayConfiguration arrayConfiguration2 : arrayConfigurations.getArrayConfiguration()) {
                if (!arrayConfiguration2.getConfigurationType().equals((Object)arrayConfiguration.getConfigurationType()) || !arrayConfiguration2.getConfigurationName().equals(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            throw new InvalidOTCOnfigurationException("The 12-m compact configuration array " + (String)string + " for configuration " + (String)object + " has not been defined in the XML");
        }
    }

    public static OTXMLConfigurationReader getInstance() {
        if (null == instance) {
            instance = new OTXMLConfigurationReader();
        }
        return instance;
    }

    public static RequestedArray mapArrayConfigurationType(ArrayConfigurationType arrayConfigurationType) {
        RequestedArray requestedArray = null;
        requestedArray = switch (arrayConfigurationType) {
            case ArrayConfigurationType.ACA_7_M -> RequestedArray.SEVEN_M;
            case ArrayConfigurationType.TWELVE_M -> RequestedArray.TWELVE_M;
            default -> throw new RuntimeException("Unknown array configuration type specified " + String.valueOf((Object)arrayConfigurationType));
        };
        assert (requestedArray != null);
        return requestedArray;
    }

    public static void main(String[] stringArray) throws InvalidOTCOnfigurationException {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        OTXMLConfigurationReader oTXMLConfigurationReader = OTXMLConfigurationReader.getInstance();
        try {
            oTXMLConfigurationReader.getOTConfiguration();
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            System.exit(-1);
        }
        assert (oTXMLConfigurationReader != null);
        System.out.println("OT configuration XML file read in");
    }

    public class InvalidOTCOnfigurationException
    extends Exception {
        private static final long serialVersionUID = 115074371536577720L;

        public InvalidOTCOnfigurationException(String string) {
            super(string);
        }
    }
}

