/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pal;

import uk.ac.starlink.pal.AMParams;
import uk.ac.starlink.pal.AOParams;
import uk.ac.starlink.pal.AngleDR;
import uk.ac.starlink.pal.Cartesian;
import uk.ac.starlink.pal.Galactic;
import uk.ac.starlink.pal.ObsPosition;
import uk.ac.starlink.pal.Observatory;
import uk.ac.starlink.pal.Spherical;
import uk.ac.starlink.pal.Stardata;
import uk.ac.starlink.pal.UTCdate;
import uk.ac.starlink.pal.mjDate;
import uk.ac.starlink.pal.palError;
import uk.ac.starlink.pal.palString;
import uk.ac.starlink.pal.palTime;

public class Pal {
    private static boolean Debug = false;
    private static boolean Trace = false;
    private static final double DPI = Math.PI;
    private static final double D2PI = Math.PI * 2;
    private static final double D1B2PI = 0.15915494309189535;
    private static final double D4PI = Math.PI * 4;
    private static final double D1B4PI = 0.07957747154594767;
    private static final double DPISQ = Math.PI * Math.PI;
    private static final double DSQRPI = Math.sqrt(Math.PI);
    private static final double DPIBY2 = 1.5707963267948966;
    private static final double DD2R = Math.PI / 180;
    private static final double DR2D = 57.29577951308232;
    private static final double DAS2R = 4.84813681109536E-6;
    private static final double DR2AS = 206264.80624709636;
    private static final double DH2R = 0.2617993877991494;
    private static final double DR2H = 3.819718634205488;
    private static final double DS2R = 7.27220521664304E-5;
    private static final double DR2S = 13750.987083139758;
    private static final double D15B2P = 2.3873241463784303;
    private static final double TURNAS = 1296000.0;
    private static final double DJM0 = 51544.5;
    private static final double DJC = 36525.0;
    public static final double GR2 = 1.974126E-8;
    private static final double T2AS = 1296000.0;
    private static final double U2R = 4.84813681109536E-10;
    public static final double VF = 0.21094502;
    public static final double C = 173.14463331;
    public static final double SOLSID = 1.00273790935;
    private static final int ISMAX = 16384;
    private static final double TINY = 1.0E-20;
    private static final double VERYTINY = 1.0E-30;
    public static final double ESPEED = 0.4655;
    public static final double D2S = 86400.0;
    public static final double AUKM = 1.4959787E8;
    public static final double AUSEC = 499.004782;
    public static final double R2D = 57.29577951308232;
    public int Status = 0;
    public int Flag = 0;
    private static String space = "";
    private static final int NUMBER = 0;
    private static final int SPACE = 1;
    private static final int EXPSYM = 2;
    private static final int PERIOD = 3;
    private static final int PLUS = 4;
    private static final int MINUS = 5;
    private static final int COMMA = 6;
    private static final int OTHER = 7;
    private static final int END = 8;

    private static double refi(double DN, double RDNDR) {
        return RDNDR / (DN + RDNDR);
    }

    private static double dmod(double a, double b) {
        double c = b != 0.0 ? (a * b > 0.0 ? a - b * Math.floor(a / b) : a + b * Math.floor(-a / b)) : a;
        return c;
    }

    private static double gmax(double a, double b) {
        return a > b ? a : b;
    }

    private static double gmin(double a, double b) {
        return a < b ? a : b;
    }

    private static int dint(double a) {
        return a < 0.0 ? (int)Math.ceil(a) : (int)Math.floor(a);
    }

    private static double dnint(double a) {
        return a < 0.0 ? Math.ceil(a - 0.5) : Math.floor(a + 0.5);
    }

    private static void DEBUG(String s) {
        if (Debug) {
            System.out.println("Debug Message: " + s);
        }
    }

    private static void TRACE(String s) {
        space = space.concat("-");
        if (Trace) {
            System.out.println(space + "Entering Routine: " + s);
        }
    }

    private static void ENDTRACE(String s) {
        if (Trace) {
            System.out.println(space + "Exiting Routine: " + s);
        }
        space = space.substring(0, space.length() - 1);
    }

    public AngleDR Addet(AngleDR m, double eq) {
        Pal.TRACE("Addet");
        double[] a = this.Etrms(eq);
        double[] v = this.Dcs2c(m);
        for (int i = 0; i < 3; ++i) {
            int n = i;
            v[n] = v[n] + a[i];
        }
        AngleDR c = this.Dcc2s(v);
        c.setAlpha(this.Dranrm(c.getAlpha()));
        Pal.ENDTRACE("Addet");
        return c;
    }

    public AngleDR Amp(AngleDR ap, double date, double eq) {
        Pal.TRACE("Amp");
        AMParams amprms = this.Mappa(eq, date);
        Pal.ENDTRACE("Amp");
        return this.Ampqk(ap, amprms);
    }

    public AngleDR Ampqk(AngleDR ap, AMParams amprms) {
        double w;
        int j;
        int i;
        double[] ehn = new double[3];
        double[] abv = new double[3];
        double[] p = new double[3];
        double[] p1 = new double[3];
        double[] p2 = new double[3];
        double[] p3 = new double[3];
        double p1dv = 0.0;
        double pde = 0.0;
        Pal.TRACE("Ampqk");
        double gr2e = amprms.getGrad();
        double ab1 = amprms.getRoot();
        ehn = amprms.getHelio();
        abv = amprms.getEarthv();
        p3 = this.Dcs2c(ap);
        p2 = this.Dimxv(amprms.getPrecess(), p3);
        double ab1p1 = ab1 + 1.0;
        for (i = 0; i < 3; ++i) {
            p1[i] = p2[i];
        }
        for (j = 0; j < 2; ++j) {
            p1dv = this.Dvdv(p1, abv);
            double p1dvp1 = 1.0 + p1dv;
            w = 1.0 + p1dv / ab1p1;
            for (i = 0; i < 3; ++i) {
                p1[i] = (p1dvp1 * p2[i] - w * abv[i]) / ab1;
            }
            w = this.Dvn(p1, p3);
            for (i = 0; i < 3; ++i) {
                p1[i] = p3[i];
            }
        }
        for (i = 0; i < 3; ++i) {
            p[i] = p1[i];
        }
        for (j = 0; j < 5; ++j) {
            pde = this.Dvdv(p, ehn);
            double pdep1 = 1.0 + pde;
            w = pdep1 - gr2e * pde;
            for (i = 0; i < 3; ++i) {
                p[i] = (pdep1 * p1[i] - gr2e * ehn[i]) / w;
            }
            w = this.Dvn(p, p2);
            for (i = 0; i < 3; ++i) {
                p[i] = p2[i];
            }
        }
        ap = this.Dcc2s(p);
        ap.setAlpha(this.Dranrm(ap.getAlpha()));
        Pal.ENDTRACE("Ampqk");
        return ap;
    }

    public AOParams Aoppa(UTCdate date, ObsPosition obs, Cartesian pm, double tdk, double pmb, double rh, double wl, double tlr) {
        Pal.TRACE("Aoppa");
        double dut = date.getDeriv();
        double elongm = obs.getLongitude();
        double phim = obs.getLatitude();
        double hm = obs.getHeight();
        double xp = pm.getX();
        double yp = pm.getY();
        AOParams aoprms = new AOParams();
        double cphim = Math.cos(phim);
        double xt = Math.cos(elongm) * cphim;
        double yt = Math.sin(elongm) * cphim;
        double zt = Math.sin(phim);
        double xc = xt - xp * zt;
        double yc = yt + yp * zt;
        double zc = xp * xt - yp * yt + zt;
        double elong = xc != 0.0 || yc != 0.0 ? Math.atan2(yc, xc) : 0.0;
        double phi = Math.atan2(zc, Math.sqrt(xc * xc + yc * yc));
        aoprms.setLat(phi);
        double[] g = this.Geoc(phi, hm);
        double uau = g[0];
        double vau = g[1];
        aoprms.setDabb(Math.PI * 2 * uau * 1.00273790935 / 173.14463331);
        aoprms.setHeight(hm);
        aoprms.setTemp(tdk);
        aoprms.setPressure(pmb);
        aoprms.setHumidity(rh);
        aoprms.setWavelength(wl);
        aoprms.setLapserate(tlr);
        double[] a = this.Refco(hm, tdk, pmb, rh, wl, phi, tlr, 1.0E-10);
        aoprms.setRefractA(a[0]);
        aoprms.setRefractB(a[1]);
        aoprms.setLongplus(elong + this.Eqeqx(date.getDate()) + dut * 1.00273790935 * 7.27220521664304E-5);
        this.Aoppat(date.getDate(), aoprms);
        Pal.ENDTRACE("Aoppa");
        return aoprms;
    }

    public void Aoppat(double date, AOParams aoprms) {
        Pal.TRACE("Aoppat");
        aoprms.setLocalTime(this.Gmst(date) + aoprms.getLongplus());
        Pal.ENDTRACE("Aoppat");
    }

    public double Caldj(int iy, int im, int id) throws palError {
        double d = 0.0;
        Pal.TRACE("Caldj");
        int ny = iy >= 0 && iy <= 49 ? iy + 2000 : (iy >= 50 && iy <= 99 ? iy + 1900 : iy);
        Pal.ENDTRACE("Caldj");
        return this.Cldj(ny, im, id);
    }

    public double Cldj(int iy, int im, int id) throws palError {
        int[] mtab = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Pal.TRACE("Cldj");
        if (iy < -4699) {
            this.Status = 1;
            throw new palError(this.Status, "Cldj: Bad Year");
        }
        if (im < 1 || im > 12) {
            this.Status = 2;
            throw new palError(this.Status, "Cldj: Bad Month");
        }
        int n = mtab[1] = iy % 4 == 0 && (iy % 100 != 0 || iy % 400 == 0) ? 29 : 28;
        if (id < 1 || id > mtab[im - 1]) {
            this.Status = 3;
            throw new palError(this.Status, "Cldj: Bad Day");
        }
        long iyL = iy;
        long imL = im;
        Pal.ENDTRACE("Cldj");
        return 1461L * (iyL - (12L - imL) / 10L + 4712L) / 4L + (306L * ((imL + 9L) % 12L) + 5L) / 10L - 3L * ((iyL - (12L - imL) / 10L + 4900L) / 100L) / 4L + (long)id - 2399904L;
    }

    public double Daf2r(int ideg, int iamin, double asec) throws palError {
        this.Status = 0;
        double rad = 0.0;
        Pal.TRACE("Daf2r");
        if (asec < 0.0 || asec >= 60.0) {
            this.Status = 3;
            throw new palError(this.Status, "Daf2r: asec outside range 0-59.999...");
        }
        if (iamin < 0 || iamin > 59) {
            this.Status = 2;
            throw new palError(this.Status, "Daf2r: iamin outside range 0-59");
        }
        if (ideg < 0 || ideg > 359) {
            this.Status = 1;
            throw new palError(this.Status, "Daf2r: ideg outside range 0-359");
        }
        rad = 4.84813681109536E-6 * (60.0 * (60.0 * (double)ideg + (double)iamin) + asec);
        Pal.ENDTRACE("Daf2r");
        return rad;
    }

    public double Dat(double utc) {
        Pal.TRACE("Dat");
        if (utc >= 54832.0) {
            return 34.0;
        }
        if (utc >= 53736.0) {
            return 33.0;
        }
        if (utc >= 51179.0) {
            return 32.0;
        }
        if (utc >= 50630.0) {
            return 31.0;
        }
        if (utc >= 50083.0) {
            return 30.0;
        }
        if (utc >= 49534.0) {
            return 29.0;
        }
        if (utc >= 49169.0) {
            return 28.0;
        }
        if (utc >= 48804.0) {
            return 27.0;
        }
        if (utc >= 48257.0) {
            return 26.0;
        }
        if (utc >= 47892.0) {
            return 25.0;
        }
        if (utc >= 47161.0) {
            return 24.0;
        }
        if (utc >= 46247.0) {
            return 23.0;
        }
        if (utc >= 45516.0) {
            return 22.0;
        }
        if (utc >= 45151.0) {
            return 21.0;
        }
        if (utc >= 44786.0) {
            return 20.0;
        }
        if (utc >= 44239.0) {
            return 19.0;
        }
        if (utc >= 43874.0) {
            return 18.0;
        }
        if (utc >= 43509.0) {
            return 17.0;
        }
        if (utc >= 43144.0) {
            return 16.0;
        }
        if (utc >= 42778.0) {
            return 15.0;
        }
        if (utc >= 42413.0) {
            return 14.0;
        }
        if (utc >= 42048.0) {
            return 13.0;
        }
        if (utc >= 41683.0) {
            return 12.0;
        }
        if (utc >= 41499.0) {
            return 11.0;
        }
        if (utc >= 41317.0) {
            return 10.0;
        }
        if (utc >= 39887.0) {
            return 4.21317 + (utc - 39126.0) * 0.002592;
        }
        if (utc >= 39126.0) {
            return 4.31317 + (utc - 39126.0) * 0.002592;
        }
        if (utc >= 39004.0) {
            return 3.84013 + (utc - 38761.0) * 0.001296;
        }
        if (utc >= 38942.0) {
            return 3.74013 + (utc - 38761.0) * 0.001296;
        }
        if (utc >= 38820.0) {
            return 3.64013 + (utc - 38761.0) * 0.001296;
        }
        if (utc >= 38761.0) {
            return 3.54013 + (utc - 38761.0) * 0.001296;
        }
        if (utc >= 38639.0) {
            return 3.44013 + (utc - 38761.0) * 0.001296;
        }
        if (utc >= 38486.0) {
            return 3.34013 + (utc - 38761.0) * 0.001296;
        }
        if (utc >= 38395.0) {
            return 3.24013 + (utc - 38761.0) * 0.001296;
        }
        if (utc >= 38334.0) {
            return 1.945858 + (utc - 37665.0) * 0.0011232;
        }
        if (utc >= 37665.0) {
            return 1.845858 + (utc - 37665.0) * 0.0011232;
        }
        if (utc >= 37512.0) {
            return 1.372818 + (utc - 37300.0) * 0.001296;
        }
        if (utc >= 37300.0) {
            return 1.422818 + (utc - 37300.0) * 0.001296;
        }
        Pal.ENDTRACE("Dat");
        return 1.417818 + (utc - 37300.0) * 0.001296;
    }

    public double[][] Dav2m(double[] axvec) {
        double[][] rmat = new double[3][3];
        Pal.TRACE("Dav2m");
        double x = axvec[0];
        double y = axvec[1];
        double z = axvec[2];
        double phi = Math.sqrt(x * x + y * y + z * z);
        double s = Math.sin(phi);
        double c = Math.cos(phi);
        double w = 1.0 - c;
        if (phi != 0.0) {
            x /= phi;
            y /= phi;
            z /= phi;
        }
        rmat[0][0] = x * x * w + c;
        rmat[0][1] = x * y * w + z * s;
        rmat[0][2] = x * z * w - y * s;
        rmat[1][0] = x * y * w - z * s;
        rmat[1][1] = y * y * w + c;
        rmat[1][2] = y * z * w + x * s;
        rmat[2][0] = x * z * w + y * s;
        rmat[2][1] = y * z * w - x * s;
        rmat[2][2] = z * z * w + c;
        Pal.ENDTRACE("Dav2m");
        return rmat;
    }

    public double Dbjin(palString string, double dreslt) {
        double reslt = dreslt;
        Pal.TRACE("Dbjin");
        this.Status = 0;
        this.Flag = 0;
        int lenstr = string.length();
        dreslt = this.Dfltin(string, dreslt);
        int na = string.getPos();
        int j1a = this.Status;
        if (na > 0 && na <= lenstr && j1a == 1) {
            char c = string.getChar(na);
            if (c == 'B' || c == 'b') {
                this.Flag = 1;
            } else if (c == 'J' || c == 'j') {
                this.Flag = 2;
            }
            if (this.Flag == 1 || this.Flag == 2) {
                int nb = na + 1;
                string.incrChar();
                dreslt = this.Dfltin(string, dreslt);
                int j1b = this.Status;
                if (j1b <= 0) {
                    na = nb;
                    j1a = j1b;
                } else {
                    this.Flag = 0;
                    string.setPos(na);
                }
            }
        }
        this.Status = j1a;
        Pal.ENDTRACE("Dbjin");
        return dreslt;
    }

    public Spherical Dc62s(Cartesian v) {
        double bd;
        double ad;
        double b;
        double a;
        Pal.TRACE("Dc62s");
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        double xd = v.getXvel();
        double yd = v.getYvel();
        double zd = v.getZvel();
        double rxy2 = x * x + y * y;
        double r2 = rxy2 + z * z;
        if (r2 == 0.0) {
            x = xd;
            y = yd;
            z = zd;
            rxy2 = x * x + y * y;
            r2 = rxy2 + z * z;
        }
        double rxy = Math.sqrt(rxy2);
        double xyp = x * xd + y * yd;
        if (rxy2 != 0.0) {
            a = Math.atan2(y, x);
            b = Math.atan2(z, rxy);
            ad = (x * yd - y * xd) / rxy2;
            bd = (zd * rxy2 - z * xyp) / (r2 * rxy);
        } else {
            a = 0.0;
            b = z != 0.0 ? Math.atan2(z, rxy) : 0.0;
            ad = 0.0;
            bd = 0.0;
        }
        double r = Math.sqrt(r2);
        double rd = r != 0.0 ? (xyp + z * zd) / r : 0.0;
        Pal.ENDTRACE("Dc62s");
        return new Spherical(a, b, r, ad, bd, rd);
    }

    public AngleDR Dcc2s(double[] v) {
        Pal.TRACE("Dcc2s");
        double x = v[0];
        double y = v[1];
        double z = v[2];
        double r = Math.sqrt(x * x + y * y);
        double a = r != 0.0 ? Math.atan2(y, x) : 0.0;
        double b = z != 0.0 ? Math.atan2(z, r) : 0.0;
        Pal.ENDTRACE("Dcc2s");
        return new AngleDR(a, b);
    }

    public double[] Dcs2c(AngleDR a) {
        Pal.TRACE("Dcs2c");
        double[] v = new double[3];
        double a0 = a.getAlpha();
        double a1 = a.getDelta();
        double cosb = Math.cos(a1);
        v[0] = Math.cos(a0) * cosb;
        v[1] = Math.sin(a0) * cosb;
        v[2] = Math.sin(a1);
        Pal.ENDTRACE("Dcs2c");
        return v;
    }

    public palTime Dd2tf(double days) {
        Pal.TRACE("Dd2tf");
        char sign = days < 0.0 ? (char)'-' : '+';
        Pal.DEBUG("Dd2tf: days = " + days);
        double a = 86400.0 * Math.abs(days);
        Pal.DEBUG("Dd2tf: a = " + a);
        int ih = Pal.dint(a / 3600.0);
        int im = Pal.dint((a -= (double)ih * 3600.0) / 60.0);
        int is = Pal.dint(a -= (double)im * 60.0);
        Pal.DEBUG("Dd2tf: secs = " + a);
        double af = a - (double)is;
        palTime ihmsf = new palTime(ih, im, is, af, sign);
        Pal.ENDTRACE("Dd2tf");
        return ihmsf;
    }

    public double[][] Deuler(String order, double phi, double theta, double psi) {
        int i;
        int j;
        double[][] result = new double[3][3];
        double[][] rotn = new double[3][3];
        double[][] wm = new double[3][3];
        Pal.TRACE("Deuler");
        for (j = 0; j < 3; ++j) {
            for (i = 0; i < 3; ++i) {
                result[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        int l = order.length();
        for (int n = 0; n < 3; ++n) {
            double angle;
            if (n >= l) continue;
            for (j = 0; j < 3; ++j) {
                for (i = 0; i < 3; ++i) {
                    rotn[i][j] = i == j ? 1.0 : 0.0;
                }
            }
            switch (n) {
                case 0: {
                    angle = phi;
                    break;
                }
                case 1: {
                    angle = theta;
                    break;
                }
                default: {
                    angle = psi;
                }
            }
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            char axis = order.charAt(n);
            if (axis == 'X' || axis == 'x' || axis == '1') {
                rotn[1][1] = c;
                rotn[1][2] = s;
                rotn[2][1] = -s;
                rotn[2][2] = c;
            } else if (axis == 'Y' || axis == 'y' || axis == '2') {
                rotn[0][0] = c;
                rotn[0][2] = -s;
                rotn[2][0] = s;
                rotn[2][2] = c;
            } else if (axis == 'Z' || axis == 'z' || axis == '3') {
                rotn[0][0] = c;
                rotn[0][1] = s;
                rotn[1][0] = -s;
                rotn[1][1] = c;
            } else {
                l = 0;
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    double w = 0.0;
                    for (int k = 0; k < 3; ++k) {
                        w += rotn[i][k] * result[k][j];
                    }
                    wm[i][j] = w;
                }
            }
            for (j = 0; j < 3; ++j) {
                for (i = 0; i < 3; ++i) {
                    result[i][j] = wm[i][j];
                }
            }
        }
        Pal.ENDTRACE("Deuler");
        return result;
    }

    public double Dfltin(palString string, double dreslt) {
        int digit = 0;
        double reslt = dreslt;
        int seek_sign = 100;
        int neg_mant = 200;
        int seek_1st_leading_digit = 300;
        int accept_leading_digit = 400;
        int seek_digit_when_none_before_pt = 500;
        int seek_trailing_digit = 600;
        int accept_trailing_digit = 700;
        int accept_uns_exp_no_mant = 800;
        int seek_sign_exp = 900;
        int neg_exp = 1000;
        int seek_1st_exp_digit = 1100;
        int accept_exp_digit = 1200;
        int end_of_field = 1300;
        int build_result = 1310;
        int seeking_end_of_field = 1620;
        int next_field_OK = 1720;
        int next_field_default = 9100;
        int null_field = 9110;
        int next_field_error = 9200;
        int error = 9210;
        int done = 9900;
        String Errmsg = null;
        Pal.TRACE("Dfltin");
        int l_string = string.length();
        int nptr = string.getPos();
        double dmant = 0.0;
        int msign = 1;
        int nexp = 0;
        int isignx = 1;
        int ndp = 0;
        int state = 100;
        block81: while (state != 9900) {
            switch (state) {
                case 100: {
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 400;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 1: {
                            state = 100;
                            continue block81;
                        }
                        case 2: {
                            state = 800;
                            continue block81;
                        }
                        case 3: {
                            state = 500;
                            continue block81;
                        }
                        case 4: {
                            state = 300;
                            continue block81;
                        }
                        case 5: {
                            state = 200;
                            continue block81;
                        }
                        case 7: {
                            state = 9100;
                            continue block81;
                        }
                        case 6: 
                        case 8: {
                            state = 9110;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 200: {
                    msign = -1;
                }
                case 300: {
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 400;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 1: {
                            state = 300;
                            continue block81;
                        }
                        case 2: {
                            state = 800;
                            continue block81;
                        }
                        case 3: {
                            state = 500;
                            continue block81;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            state = 9200;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 400: {
                    dmant = dmant * 10.0 + (double)digit;
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 400;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 1: {
                            state = 1310;
                            continue block81;
                        }
                        case 2: {
                            state = 900;
                            continue block81;
                        }
                        case 3: {
                            state = 600;
                            continue block81;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            state = 1300;
                            continue block81;
                        }
                        case 8: {
                            state = 1310;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 500: {
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 700;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 1: {
                            state = 500;
                            continue block81;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            state = 9200;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 600: {
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 700;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 2: {
                            state = 900;
                            continue block81;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            state = 1300;
                            continue block81;
                        }
                        case 1: 
                        case 8: {
                            state = 1310;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 700: {
                    ++ndp;
                    digit = string.getDigit();
                    dmant = dmant * 10.0 + (double)digit;
                    state = 600;
                    continue block81;
                }
                case 800: {
                    dmant = 1.0;
                }
                case 900: {
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 1200;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 1: {
                            state = 900;
                            continue block81;
                        }
                        case 4: {
                            state = 1100;
                            continue block81;
                        }
                        case 5: {
                            state = 1000;
                            continue block81;
                        }
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: {
                            state = 9200;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 1000: {
                    isignx = -1;
                }
                case 1100: {
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 1200;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 1: {
                            state = 1100;
                            continue block81;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            state = 9200;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 1200: {
                    digit = string.getDigit();
                    nexp = nexp * 10 + digit;
                    if (nexp > 100) {
                        state = 9200;
                        continue block81;
                    }
                    ++nptr;
                    switch (Pal.idchf(string)) {
                        case 0: {
                            state = 1200;
                            digit = string.getDigit();
                            continue block81;
                        }
                        case 1: {
                            state = 1310;
                            continue block81;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            state = 1300;
                            continue block81;
                        }
                        case 8: {
                            state = 1310;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 1300: {
                    --nptr;
                    string.backChar();
                }
                case 1310: {
                    if (nexp >= 0) {
                        for (nexp = nexp * isignx - ndp; nexp >= 10; nexp -= 10) {
                            dmant *= 1.0E10;
                        }
                        while (nexp >= 1) {
                            dmant *= 10.0;
                            --nexp;
                        }
                    } else {
                        while (nexp <= -10) {
                            dmant /= 1.0E10;
                            nexp += 10;
                        }
                        while (nexp <= -1) {
                            dmant /= 10.0;
                            ++nexp;
                        }
                    }
                    if (msign == 1) {
                        reslt = dmant;
                        this.Status = 0;
                    } else {
                        reslt = -dmant;
                        this.Status = -1;
                    }
                }
                case 1620: {
                    switch (Pal.idchf(string)) {
                        case 1: {
                            state = 1620;
                            continue block81;
                        }
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: {
                            state = 1720;
                            continue block81;
                        }
                        case 6: 
                        case 8: {
                            state = 9900;
                            continue block81;
                        }
                    }
                    state = 9210;
                    continue block81;
                }
                case 1720: {
                    --nptr;
                    string.backChar();
                    state = 9900;
                    continue block81;
                }
                case 9100: {
                    --nptr;
                    string.backChar();
                }
                case 9110: {
                    this.Status = 1;
                    Errmsg = "Dfltin: Null decode";
                    state = 9900;
                    continue block81;
                }
                case 9200: {
                    --nptr;
                    string.backChar();
                }
                case 9210: {
                    this.Status = 2;
                    Errmsg = "Dfltin: Decode has failed";
                    state = 9900;
                    string.incrChar();
                    continue block81;
                }
            }
            state = 9210;
        }
        Pal.ENDTRACE("Dfltin");
        return reslt;
    }

    private static int idchf(palString string) {
        char c = ' ';
        int nptr = string.getPos();
        int digit = 0;
        int l_string = string.length();
        Pal.TRACE("idchf");
        int NCREC = 20;
        char[] kctab = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' ', '\t', 'D', 'd', 'E', 'e', '.', '+', '-', ','};
        int[] kvtab = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 3, 4, 5, 6};
        int ivec = 7;
        if (nptr < 0 || nptr >= l_string) {
            ivec = 8;
        } else {
            c = string.getNextChar();
            for (int ictab = 0; ictab < 20; ++ictab) {
                if (kctab[ictab] != c) continue;
                ivec = kvtab[ictab];
                digit = ictab;
                break;
            }
            ++nptr;
        }
        string.setDigit(digit);
        Pal.ENDTRACE("idchf");
        return ivec;
    }

    public double[] Dimxv(double[][] dm, double[] va) {
        double[] vw = new double[3];
        Pal.TRACE("Dimxv");
        for (int j = 0; j < 3; ++j) {
            double w = 0.0;
            for (int i = 0; i < 3; ++i) {
                w += dm[i][j] * va[i];
            }
            vw[j] = w;
        }
        Pal.ENDTRACE("Dimxv");
        return vw;
    }

    public mjDate Djcal(double djm) throws palError {
        this.Status = 0;
        Pal.TRACE("Djcal");
        if (djm <= -2395520.0 || djm >= 1.0E9) {
            this.Status = -1;
            throw new palError(this.Status, "Djcal: Date out of Range");
        }
        double d = Math.floor(djm);
        double f = djm - d;
        if (f < 0.0) {
            f += 1.0;
        }
        long jd = (long)Pal.dnint(d) + 2400001L;
        long n4 = 4L * (jd + (2L * ((4L * jd - 17918L) / 146097L) * 3L / 4L + 1L) / 2L - 37L);
        long nd10 = 10L * ((n4 - 237L) % 1461L / 4L) + 5L;
        int yr = (int)(n4 / 1461L - 4712L);
        int mn = (int)((nd10 / 306L + 2L) % 12L + 1L);
        int dy = (int)(nd10 % 306L / 10L + 1L);
        Pal.ENDTRACE("Djcal");
        mjDate date = new mjDate(yr, mn, dy, f);
        return date;
    }

    public mjDate Djcl(double djm) throws palError {
        this.Status = 0;
        Pal.TRACE("Djcl");
        if (djm <= -2395520.0 || djm >= 1.0E9) {
            this.Status = -1;
            throw new palError(this.Status, "Djcl: unacceptable date (before 4701BC March 1)");
        }
        double f = Pal.dmod(djm, 1.0);
        if (f < 0.0) {
            f += 1.0;
        }
        double d = djm - f;
        d = Pal.dnint(d);
        long jd = (long)Pal.dnint(d) + 2400001L;
        long n4 = 4L * (jd + (6L * ((4L * jd - 17918L) / 146097L) / 4L + 1L) / 2L - 37L);
        long nd10 = 10L * ((n4 - 237L) % 1461L / 4L) + 5L;
        Pal.ENDTRACE("Djcl");
        mjDate date = new mjDate((int)(n4 / 1461L - 4712L), (int)((nd10 / 306L + 2L) % 12L + 1L), (int)(nd10 % 306L / 10L + 1L), f);
        return date;
    }

    public double[] Dm2av(double[][] rmat) {
        double[] axvec = new double[3];
        Pal.TRACE("Dm2av");
        double x = rmat[1][2] - rmat[2][1];
        double y = rmat[2][0] - rmat[0][2];
        double z = rmat[0][1] - rmat[1][0];
        double s2 = Math.sqrt(x * x + y * y + z * z);
        if (s2 != 0.0) {
            double c2 = rmat[0][0] + rmat[1][1] + rmat[2][2] - 1.0;
            double phi = Math.atan2(s2, c2);
            double f = phi / s2;
            axvec[0] = x * f;
            axvec[1] = y * f;
            axvec[2] = z * f;
        } else {
            axvec[0] = 0.0;
            axvec[1] = 0.0;
            axvec[2] = 0.0;
        }
        Pal.ENDTRACE("Dm2av");
        return axvec;
    }

    public double Dmat(double[][] a, double[] y) {
        double t;
        double[] ai;
        int i;
        int k;
        int n = y.length;
        int[] iw = new int[n];
        Pal.TRACE("Dmat");
        int jf = 0;
        double d = 1.0;
        for (k = 0; k < n; ++k) {
            double yk;
            int j;
            double[] ak = a[k];
            double amx = Math.abs(ak[k]);
            int imx = k;
            double[] aimx = ak;
            if (k != n) {
                for (i = k + 1; i < n; ++i) {
                    ai = a[i];
                    t = Math.abs(ai[k]);
                    if (!(t > amx)) continue;
                    amx = t;
                    imx = i;
                    aimx = ai;
                }
            }
            if (amx < 1.0E-20) {
                jf = -1;
                continue;
            }
            if (imx != k) {
                for (j = 0; j < n; ++j) {
                    t = ak[j];
                    ak[j] = aimx[j];
                    aimx[j] = t;
                }
                t = y[k];
                y[k] = y[imx];
                y[imx] = t;
                d = -d;
            }
            iw[k] = imx;
            if (Math.abs(d *= ak[k]) < 1.0E-20) {
                jf = -1;
                continue;
            }
            ak[k] = 1.0 / ak[k];
            for (j = 0; j < n; ++j) {
                if (j == k) continue;
                int n2 = j;
                ak[n2] = ak[n2] * ak[k];
            }
            y[k] = yk = y[k] * ak[k];
            for (i = 0; i < n; ++i) {
                ai = a[i];
                if (i == k) continue;
                for (j = 0; j < n; ++j) {
                    if (j == k) continue;
                    int n3 = j;
                    ai[n3] = ai[n3] - ai[k] * ak[j];
                }
                int n4 = i;
                y[n4] = y[n4] - ai[k] * yk;
            }
            for (i = 0; i < n; ++i) {
                ai = a[i];
                if (i == k) continue;
                int n5 = k;
                ai[n5] = ai[n5] * -ak[k];
            }
        }
        if (jf != 0) {
            d = 0.0;
        } else {
            k = n;
            while (k-- > 0) {
                int ki = iw[k];
                if (k == ki) continue;
                for (i = 0; i < n; ++i) {
                    ai = a[i];
                    t = ai[k];
                    ai[k] = ai[ki];
                    ai[ki] = t;
                }
            }
        }
        Pal.ENDTRACE("Dmat");
        return d;
    }

    public double[][] Dmxm(double[][] a, double[][] b) {
        double[][] c = new double[3][3];
        Pal.TRACE("Dmxm");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double w = 0.0;
                for (int k = 0; k < 3; ++k) {
                    w += a[i][k] * b[k][j];
                }
                c[i][j] = w;
            }
        }
        Pal.ENDTRACE("Dmxm");
        return c;
    }

    public double[] Dmxv(double[][] dm, double[] va) {
        double[] vb = new double[3];
        Pal.TRACE("Dmxv");
        for (int j = 0; j < 3; ++j) {
            double w = 0.0;
            for (int i = 0; i < 3; ++i) {
                w += dm[j][i] * va[i];
            }
            vb[j] = w;
        }
        Pal.ENDTRACE("Dmxv");
        return vb;
    }

    public palTime Dr2af(double angle) {
        Pal.TRACE("Dr2af");
        Pal.ENDTRACE("Dr2af");
        return this.Dd2tf(angle * 2.3873241463784303);
    }

    public palTime Dr2tf(double angle) {
        Pal.TRACE("Dr2tf");
        Pal.ENDTRACE("Dr2tf");
        return this.Dd2tf(angle / (Math.PI * 2));
    }

    public double Drange(double angle) {
        Pal.TRACE("Drange");
        double w = Pal.dmod(angle, Math.PI * 2);
        double w1 = angle < 0.0 ? Math.PI * -2 : Math.PI * 2;
        Pal.ENDTRACE("Drange");
        return Math.abs(w) < Math.PI ? w : w - w1;
    }

    public double Dranrm(double angle) {
        Pal.TRACE("Dranrm");
        double w = Pal.dmod(angle, Math.PI * 2);
        Pal.ENDTRACE("Dranrm");
        return w >= 0.0 ? w : w + Math.PI * 2;
    }

    public double Drverot(double phi, AngleDR r, double st) {
        Pal.TRACE("Drverot");
        Pal.ENDTRACE("Drverot");
        return 0.4655 * Math.cos(phi) * Math.sin(st - r.getAlpha()) * Math.cos(r.getDelta());
    }

    public double Drvgalc(AngleDR r2000) {
        double[] va = new double[]{-108.70408, 97.86251, -164.3361};
        Pal.TRACE("Drvgalc");
        double[] vb = this.Dcs2c(r2000);
        Pal.ENDTRACE("Drvgalc");
        return this.Dvdv(va, vb);
    }

    public double Drvlg(AngleDR r2000) {
        double[] va = new double[]{-148.23284, 133.44888, -224.09467};
        Pal.TRACE("Drvlg");
        double[] vb = this.Dcs2c(r2000);
        Pal.ENDTRACE("Drvlg");
        return this.Dvdv(va, vb);
    }

    public double Drvlsrd(AngleDR r2000) {
        double[] va = new double[]{0.63823, 14.58542, -7.80116};
        Pal.TRACE("Drvlsrd");
        double[] vb = this.Dcs2c(r2000);
        Pal.ENDTRACE("Drvlsrd");
        return this.Dvdv(va, vb);
    }

    public double Drvlsrk(AngleDR r2000) {
        double[] va = new double[]{-0.29, 17.31726, -10.00141};
        Pal.TRACE("Drvlsrk");
        double[] vb = this.Dcs2c(r2000);
        Pal.ENDTRACE("Drvlsrk");
        return this.Dvdv(va, vb);
    }

    public Cartesian Ds2c6(Spherical s) {
        double a = s.getLong();
        double b = s.getLat();
        double r = s.getRadial();
        double ad = s.getLongDeriv();
        double bd = s.getLatDeriv();
        double rd = s.getRadialDeriv();
        Pal.TRACE("Ds2c6");
        double sa = Math.sin(a);
        double ca = Math.cos(a);
        double sb = Math.sin(b);
        double cb = Math.cos(b);
        double rcb = r * cb;
        double x = rcb * ca;
        double y = rcb * sa;
        double rbd = r * bd;
        double w = rbd * sb - cb * rd;
        Pal.ENDTRACE("Ds2c6");
        return new Cartesian(x, y, r * sb, -y * ad - w * ca, x * ad - w * sa, rbd * cb + sb * rd);
    }

    public AngleDR Ds2tp(AngleDR r, AngleDR rz) throws palError {
        double ra = r.getAlpha();
        double dec = r.getDelta();
        double raz = rz.getAlpha();
        double decz = rz.getDelta();
        String Errmsg = null;
        Pal.TRACE("Ds2tp");
        double sdecz = Math.sin(decz);
        double sdec = Math.sin(dec);
        double cdecz = Math.cos(decz);
        double cdec = Math.cos(dec);
        double radif = ra - raz;
        double sradif = Math.sin(radif);
        double cradif = Math.cos(radif);
        double denom = sdec * sdecz + cdec * cdecz * cradif;
        if (denom > 1.0E-20) {
            this.Status = 0;
        } else if (denom >= 0.0) {
            this.Status = 1;
            Errmsg = "star too far from axis";
            denom = 1.0E-20;
        } else if (denom > -1.0E-20) {
            this.Status = 2;
            Errmsg = "antistar on tangent plane";
            denom = -1.0E-20;
        } else {
            this.Status = 3;
            Errmsg = "antistar too far from axis";
        }
        double xi = cdec * sradif / denom;
        double eta = (sdec * cdecz - cdec * sdecz * cradif) / denom;
        Pal.ENDTRACE("Ds2tp");
        return new AngleDR(xi, eta);
    }

    public double Dt(double epoch) {
        double s;
        Pal.TRACE("Dt");
        double t = (epoch - 1800.0) / 100.0;
        if (epoch >= 1708.185161980887) {
            double w = t - 0.19;
            s = 5.156 + 13.3066 * w * w;
        } else {
            s = epoch >= 979.0258204760233 ? 25.5 * t * t : 1360.0 + (320.0 + 44.3 * t) * t;
        }
        Pal.ENDTRACE("Dt");
        return s;
    }

    public double Dtf2d(int ihour, int imin, double sec) throws palError {
        this.Status = 0;
        Pal.TRACE("Dtf2d");
        Pal.ENDTRACE("Dtf2d");
        if (sec < 0.0 || sec >= 60.0) {
            this.Status = 1;
            throw new palError(1, "Dtf2d: sec outside range 0-59.999...");
        }
        if (imin < 0 || imin > 59) {
            this.Status = 2;
            throw new palError(1, "Dtf2d: min outside range 0-59");
        }
        if (ihour < 0 || ihour > 23) {
            this.Status = 1;
            throw new palError(1, "Dtf2d: hour outside range 0-23");
        }
        return (60.0 * (60.0 * (double)ihour + (double)imin) + sec) / 86400.0;
    }

    public double Dtf2r(int ihour, int imin, double sec) throws palError {
        Pal.TRACE("Dtf2r");
        double turns = this.Dtf2d(ihour, imin, sec);
        Pal.ENDTRACE("Dtf2r");
        return Math.PI * 2 * turns;
    }

    public AngleDR Dtp2s(AngleDR x, AngleDR rz) {
        double xi = x.getAlpha();
        double eta = x.getDelta();
        double raz = rz.getAlpha();
        double decz = rz.getDelta();
        Pal.TRACE("Dtp2s");
        double sdecz = Math.sin(decz);
        double cdecz = Math.cos(decz);
        double denom = cdecz - eta * sdecz;
        double a1 = this.Dranrm(Math.atan2(xi, denom) + raz);
        double d1 = Math.atan2(sdecz + eta * cdecz, Math.sqrt(xi * xi + denom * denom));
        Pal.ENDTRACE("Dtp2s");
        return new AngleDR(a1, d1);
    }

    public double Dtt(double utc) {
        Pal.TRACE("Dtt");
        Pal.ENDTRACE("Dtt");
        return 32.184 + this.Dat(utc);
    }

    public double Dvdv(double[] va, double[] vb) {
        Pal.TRACE("Dvdv");
        Pal.ENDTRACE("Dvdv");
        return va[0] * vb[0] + va[1] * vb[1] + va[2] * vb[2];
    }

    public double Dvn(double[] v, double[] uv) {
        int i;
        Pal.TRACE("Dvn");
        double w1 = 0.0;
        for (i = 0; i < 3; ++i) {
            double w2 = v[i];
            w1 += w2 * w2;
        }
        double vm = w1 = Math.sqrt(w1);
        w1 = w1 > 0.0 ? w1 : 1.0;
        for (i = 0; i < 3; ++i) {
            uv[i] = v[i] / w1;
        }
        Pal.ENDTRACE("Dvn");
        return vm;
    }

    public double[] Dvxv(double[] va, double[] vb) {
        double[] vw = new double[3];
        Pal.TRACE("Dvxv");
        vw[0] = va[1] * vb[2] - va[2] * vb[1];
        vw[1] = va[2] * vb[0] - va[0] * vb[2];
        vw[2] = va[0] * vb[1] - va[1] * vb[0];
        Pal.ENDTRACE("Dvxv");
        return vw;
    }

    public AngleDR Ecleq(AngleDR dl, double date) {
        Pal.TRACE("Ecleq");
        double[] v1 = this.Dcs2c(dl);
        double[][] rmat = this.Ecmat(date);
        double[] v2 = this.Dimxv(rmat, v1);
        rmat = this.Prec(2000.0, this.Epj(date));
        v1 = this.Dimxv(rmat, v2);
        AngleDR dd = this.Dcc2s(v1);
        dd.setAlpha(this.Dranrm(dd.getAlpha()));
        dd.setDelta(this.Drange(dd.getDelta()));
        Pal.ENDTRACE("Ecleq");
        return dd;
    }

    public double[][] Ecmat(double date) {
        Pal.TRACE("Ecmat");
        double t = (date - 51544.5) / 36525.0;
        double eps0 = 4.84813681109536E-6 * (84381.448 + (-46.815 + (-5.9E-4 + 0.001813 * t) * t) * t);
        Pal.ENDTRACE("Ecmat");
        return this.Deuler("X", eps0, 0.0, 0.0);
    }

    public double Epb(double date) {
        Pal.TRACE("Epb");
        Pal.ENDTRACE("Epb");
        return 1900.0 + (date - 15019.81352) / 365.242198781;
    }

    public double Epb2d(double epb) {
        return 15019.81352 + (epb - 1900.0) * 365.242198781;
    }

    public double Epco(char k0, char k, double e) {
        new Character(k0);
        char c = Character.toUpperCase(k0);
        new Character(k);
        double result = c == Character.toUpperCase(k) ? e : (c == 'B' ? this.Epb(this.Epj2d(e)) : this.Epj(this.Epb2d(e)));
        return result;
    }

    public double Epj(double date) {
        Pal.TRACE("Epj");
        Pal.ENDTRACE("Epj");
        return 2000.0 + (date - 51544.5) / 365.25;
    }

    public double Epj2d(double epj) {
        Pal.TRACE("Epj2d");
        Pal.ENDTRACE("Epj2d");
        return 51544.5 + (epj - 2000.0) * 365.25;
    }

    public AngleDR Eqecl(AngleDR d, double date) {
        Pal.TRACE("Eqecl");
        double[] v1 = this.Dcs2c(d);
        double[][] rmat = this.Prec(2000.0, this.Epj(date));
        double[] v2 = this.Dmxv(rmat, v1);
        rmat = this.Ecmat(date);
        v1 = this.Dmxv(rmat, v2);
        AngleDR db = this.Dcc2s(v1);
        db.setAlpha(this.Dranrm(db.getAlpha()));
        db.setDelta(this.Drange(db.getDelta()));
        Pal.ENDTRACE("Eqecl");
        return db;
    }

    public double Eqeqx(double date) {
        Pal.TRACE("Eqeqx");
        double t = (date - 51544.5) / 36525.0;
        double om = 4.84813681109536E-6 * (450160.28 + (-6962890.539 + (7.455 + 0.008 * t) * t) * t);
        double[] ps = this.Nutc(date);
        Pal.ENDTRACE("Eqeqx");
        return ps[0] * Math.cos(ps[2]) + 4.84813681109536E-6 * (0.00264 * Math.sin(om) + 6.3E-5 * Math.sin(om + om));
    }

    public Galactic Eqgal(AngleDR dr) {
        double[][] rmat = new double[3][3];
        rmat[0][0] = -0.054875539726;
        rmat[0][1] = -0.87343710801;
        rmat[0][2] = -0.483834985808;
        rmat[1][0] = 0.494109453312;
        rmat[1][1] = -0.444829589425;
        rmat[1][2] = 0.74698225181;
        rmat[2][0] = -0.867666135858;
        rmat[2][1] = -0.198076386122;
        rmat[2][2] = 0.455983795705;
        double[] v1 = this.Dcs2c(dr);
        double[] v2 = this.Dmxv(rmat, v1);
        AngleDR db = this.Dcc2s(v2);
        return new Galactic(this.Dranrm(db.getAlpha()), this.Drange(db.getDelta()));
    }

    public double[] Etrms(double ep) {
        Pal.TRACE("Etrms");
        double[] ev = new double[3];
        double t = (ep - 1950.0) * 0.0100002135903;
        double e = 0.01673011 - (4.193E-5 + 1.26E-7 * t) * t;
        double e0 = (84404.836 - (46.8495 + (0.00319 + 0.00181 * t) * t) * t) * 4.84813681109536E-6;
        double p = (1015489.951 + (6190.67 + (1.65 + 0.012 * t) * t) * t) * 4.84813681109536E-6;
        double ek = e * 20.49552 * 4.84813681109536E-6;
        double cp = Math.cos(p);
        ev[0] = ek * Math.sin(p);
        ev[1] = -ek * cp * Math.cos(e0);
        ev[2] = -ek * cp * Math.sin(e0);
        Pal.ENDTRACE("Etrms");
        return ev;
    }

    public void Evp(double date, double deqx, double[] dvb, double[] dpb, double[] dvh, double[] dph) {
        double sina;
        double cosa;
        double a;
        int k;
        Pal.TRACE("Evp");
        double dml = 0.0;
        double[] sn = new double[4];
        double[] forbel = new double[7];
        double[] sorbel = new double[17];
        double[] sinlp = new double[4];
        double[] coslp = new double[4];
        double[][] dprema = new double[3][3];
        double[] vw = new double[3];
        double dcsld = 1.990987E-7;
        double ccsgd = 1.990969E-7;
        double cckm = 3.12214E-5;
        double ccmld = 2.661699E-6;
        double ccfdi = 2.399485E-7;
        double b1950 = 1949.9997904423;
        double[] ccpamv = new double[]{8.326827E-11, 1.843484E-11, 1.988712E-12, 1.881276E-12};
        double dc1mme = 0.99999696;
        double[] ccpam = new double[]{0.004960906, 0.002727436, 8.392311E-4, 0.001556861};
        double ccim = 0.08978749;
        double[][] dcfel = new double[][]{{1.7400353, 6.2565836, 4.7199666, 0.19636505, 4.1547339, 4.6524223, 4.2620486, 1.4740694}, {628.33195099091, 628.30194572674, 8399.7091449254, 8433.466291172, 52.993466764997, 21.354275911213, 7.5025342197656, 3.8377331909193}, {5.2796E-6, -2.618E-6, -1.978E-5, -5.6044E-5, 5.8845E-6, 5.6797E-6, 5.5317E-6, 5.6093E-6}};
        double[] dceps = new double[]{0.4093198, -2.27111E-4, -2.860401E-8};
        double[][] ccsel = new double[][]{{0.01675104, 0.2220221, 1.589963, 2.994089, 0.8155457, 1.735614, 1.968564, 1.282417, 2.28082, 0.04833473, 0.05589232, 0.04634443, 0.008997041, 0.02284178, 0.04350267, 0.01348204, 0.0310657}, {-4.179579E-5, 0.02809917, 0.03418075, 0.02590824, 0.02486352, 0.01763719, 0.0152402, 0.008703393, 0.0191801, 1.641773E-4, -3.455092E-4, -2.658234E-5, 6.329728E-6, -9.94159E-5, -6.839749E-5, 1.091504E-5, -1.665665E-4}, {-1.260516E-7, 1.852532E-5, 1.4302E-5, 4.15584E-6, 6.83684E-6, 6.37044E-6, -2.517152E-6, 2.289292E-5, 4.48452E-6, -4.6542E-7, -7.38856E-7, 7.757E-8, -1.939256E-9, 6.7874E-8, -2.714956E-7, 6.90376E-7, -1.590188E-7}};
        double[][] dcargs = new double[][]{{5.0974222, 3.9584962, 1.633807, 2.5487111, 4.9255514, 1.3363463, 1.6072053, 1.362948, 5.5657014, 5.0708205, 3.9318944, 4.8989497, 1.3097446, 3.5147141, 3.5413158}, {-786.04195454652, -575.33848094674, -1150.6769618935, -393.02097727326, -588.49265665348, -550.76098609303, -522.37501616674, -1179.0629318198, -1097.7134971135, -157.74000881978, 52.96346478, 39.809289073258, 77.540959633708, 79.618578146517, -548.68336758022}};
        double[][] ccamps = new double[][]{{-2.279594E-5, -3.494537E-5, 6.593466E-7, 1.140767E-5, 9.516893E-6, 7.31099E-6, -2.603449E-6, -3.228859E-6, 3.442177E-7, 8.702406E-6, -1.488378E-6, -8.043059E-6, 3.699128E-6, 2.55012E-6, -6.351059E-7}, {1.407414E-5, 2.860401E-7, 1.322572E-5, -2.049792E-5, -2.748894E-6, -1.92471E-6, 7.359472E-6, 1.308997E-7, 2.671323E-6, -8.421214E-6, -1.251789E-5, -2.9913E-6, -3.316126E-6, -1.241123E-6, 2.34165E-6}, {8.273188E-6, 1.289448E-7, 9.258695E-6, -4.74793E-6, -1.319381E-6, -8.772849E-7, 3.168357E-6, 1.013137E-7, 1.832858E-6, -1.372341E-6, 5.226868E-7, 1.473654E-7, 2.901257E-7, 9.901116E-8, 1.061492E-6}, {1.340565E-5, 1.627237E-5, -4.674248E-7, -2.638763E-6, -4.549908E-6, -3.334143E-6, 1.119056E-6, 2.403899E-6, -2.394688E-7, -1.455234E-6, -2.049301E-7, -3.154542E-7, 3.407826E-7, 2.210482E-7, 2.878231E-7}, {-2.490817E-7, -1.823138E-7, -3.646275E-7, -1.245408E-7, -1.864821E-7, -1.745256E-7, -1.655307E-7, -3.736225E-7, -3.478444E-7, -4.998479E-8, 0.0, 0.0, 0.0, 0.0, 0.0}};
        double ccsec3 = -7.75702E-8;
        double[][] ccsec = new double[][]{{1.2896E-6, 3.10281E-5, 9.12419E-6, 9.79324E-7}, {0.5550147, 4.035027, 0.9990265, 5.508259}, {2.076942, 0.3525565, 2.622706, 15.59103}};
        double[][] dcargm = new double[][]{{5.167983, 5.491315, 5.959853}, {8328.6911095275, -7214.06328381, 15542.754389685}};
        double[][] ccampm = new double[][]{{0.1097594, -0.02223581, 0.01148966}, {2.896773E-7, 5.083103E-8, 5.658888E-8}, {0.05450474, 0.01002548, 0.008249439}, {1.438491E-7, -2.291823E-8, 4.063015E-8}};
        boolean ideq = !(deqx <= 0.0);
        double dt = (date - 15019.5) / 36525.0;
        for (k = 0; k < 8; ++k) {
            double dlocal = Pal.dmod(dcfel[0][k] + dt * (dcfel[1][k] + dt * dcfel[2][k]), Math.PI * 2);
            if (k == 0) {
                dml = dlocal;
                continue;
            }
            forbel[k - 1] = dlocal;
        }
        double deps = Pal.dmod(dceps[0] + dt * (dceps[1] + dt * dceps[2]), Math.PI * 2);
        for (k = 0; k < 17; ++k) {
            sorbel[k] = Pal.dmod(ccsel[0][k] + dt * (ccsel[1][k] + dt * ccsel[2][k]), Math.PI * 2);
        }
        for (k = 0; k < 4; ++k) {
            a = Pal.dmod(ccsec[1][k] + dt * ccsec[2][k], Math.PI * 2);
            sn[k] = Math.sin(a);
        }
        double pertl = ccsec[0][0] * sn[0] + ccsec[0][1] * sn[1] + (ccsec[0][2] + dt * -7.75702E-8) * sn[2] + ccsec[0][3] * sn[3];
        double pertld = 0.0;
        double pertr = 0.0;
        double pertrd = 0.0;
        for (k = 0; k < 15; ++k) {
            a = Pal.dmod(dcargs[0][k] + dt * dcargs[1][k], Math.PI * 2);
            cosa = Math.cos(a);
            sina = Math.sin(a);
            pertl += ccamps[0][k] * cosa + ccamps[1][k] * sina;
            pertr += ccamps[2][k] * cosa + ccamps[3][k] * sina;
            if (k >= 10) continue;
            pertld += (ccamps[1][k] * cosa - ccamps[0][k] * sina) * ccamps[4][k];
            pertrd += (ccamps[3][k] * cosa - ccamps[2][k] * sina) * ccamps[4][k];
        }
        double e = sorbel[0];
        double twoe = e + e;
        double esq = e * e;
        double dparam = 1.0 - esq;
        double g = forbel[0];
        double twog = g + g;
        double phi = twoe * ((1.0 - esq / 8.0) * Math.sin(g) + 5.0 * e * Math.sin(twog) / 8.0 + 13.0 * esq * Math.sin(g + twog) / 24.0);
        double f = forbel[0] + phi;
        double sf = Math.sin(f);
        double cf = Math.cos(f);
        double dpsi = dparam / (1.0 + e * cf);
        double phid = twoe * 1.990969E-7 * ((1.0 + esq * 1.5) * cf + e * (1.25 - sf * sf / 2.0));
        double psid = 1.990969E-7 * e * sf / Math.sqrt(dparam);
        double d1pdro = 1.0 + pertr;
        double drd = d1pdro * (psid + dpsi * pertrd);
        double drld = d1pdro * dpsi * (1.990987E-7 + phid + pertld);
        double dtl = Pal.dmod(dml + phi + pertl, Math.PI * 2);
        double dsinls = Math.sin(dtl);
        double dcosls = Math.cos(dtl);
        double dxhd = drd * dcosls - drld * dsinls;
        double dyhd = drd * dsinls + drld * dcosls;
        pertl = 0.0;
        pertld = 0.0;
        double pertp = 0.0;
        double pertpd = 0.0;
        for (k = 0; k < 3; ++k) {
            a = Pal.dmod(dcargm[0][k] + dt * dcargm[1][k], Math.PI * 2);
            sina = Math.sin(a);
            cosa = Math.cos(a);
            pertl += ccampm[0][k] * sina;
            pertld += ccampm[1][k] * cosa;
            pertp += ccampm[2][k] * cosa;
            pertpd += -ccampm[3][k] * sina;
        }
        double tl = forbel[1] + pertl;
        double sinlm = Math.sin(tl);
        double coslm = Math.cos(tl);
        double sigma = 3.12214E-5 / (1.0 + pertp);
        a = sigma * (2.661699E-6 + pertld);
        double b = sigma * pertpd;
        double dzhd = -sigma * 2.399485E-7 * Math.cos(forbel[2]);
        double dxbd = (dxhd += a * sinlm + b * coslm) * 0.99999696;
        double dybd = (dyhd += -a * coslm + b * sinlm) * 0.99999696;
        double dzbd = dzhd * 0.99999696;
        for (k = 0; k < 4; ++k) {
            double plon = forbel[k + 3];
            double pomg = sorbel[k + 1];
            double pecc = sorbel[k + 9];
            tl = Pal.dmod(plon + 2.0 * pecc * Math.sin(plon - pomg), Math.PI * 2);
            sinlp[k] = Math.sin(tl);
            coslp[k] = Math.cos(tl);
            dxbd += ccpamv[k] * (sinlp[k] + pecc * Math.sin(pomg));
            dybd += -ccpamv[k] * (coslp[k] + pecc * Math.cos(pomg));
            dzbd += -ccpamv[k] * sorbel[k + 13] * Math.cos(plon - sorbel[k + 5]);
        }
        double dcosep = Math.cos(deps);
        double dsinep = Math.sin(deps);
        double dyahd = dcosep * dyhd - dsinep * dzhd;
        double dzahd = dsinep * dyhd + dcosep * dzhd;
        double dyabd = dcosep * dybd - dsinep * dzbd;
        double dzabd = dsinep * dybd + dcosep * dzbd;
        double dr = dpsi * d1pdro;
        double flatm = 0.08978749 * Math.sin(forbel[2]);
        a = sigma * Math.cos(flatm);
        double dxh = dr * dcosls - a * coslm;
        double dyh = dr * dsinls - a * sinlm;
        double dzh = -sigma * Math.sin(flatm);
        double dxb = dxh * 0.99999696;
        double dyb = dyh * 0.99999696;
        double dzb = dzh * 0.99999696;
        for (k = 0; k < 4; ++k) {
            double flat = sorbel[k + 13] * Math.sin(forbel[k + 3] - sorbel[k + 5]);
            a = ccpam[k] * (1.0 - sorbel[k + 9] * Math.cos(forbel[k + 3] - sorbel[k + 1]));
            b = a * Math.cos(flat);
            dxb -= b * coslp[k];
            dyb -= b * sinlp[k];
            dzb -= a * Math.sin(flat);
        }
        double dyah = dcosep * dyh - dsinep * dzh;
        double dzah = dsinep * dyh + dcosep * dzh;
        double dyab = dcosep * dyb - dsinep * dzb;
        double dzab = dsinep * dyb + dcosep * dzb;
        double depj = this.Epj(date);
        double deqcor = 7.27220521664304E-5 * (0.035 + 8.5E-4 * (depj - 1949.9997904423));
        dvh[0] = dxhd - deqcor * dyahd;
        dvh[1] = dyahd + deqcor * dxhd;
        dvh[2] = dzahd;
        dvb[0] = dxbd - deqcor * dyabd;
        dvb[1] = dyabd + deqcor * dxbd;
        dvb[2] = dzabd;
        dph[0] = dxh - deqcor * dyah;
        dph[1] = dyah + deqcor * dxh;
        dph[2] = dzah;
        dpb[0] = dxb - deqcor * dyab;
        dpb[1] = dyab + deqcor * dxb;
        dpb[2] = dzab;
        if (ideq) {
            int i;
            double w;
            int j;
            dprema = this.Prec(depj, deqx);
            for (j = 0; j < 3; ++j) {
                w = 0.0;
                for (i = 0; i < 3; ++i) {
                    w += dprema[j][i] * dvh[i];
                }
                vw[j] = w;
            }
            for (j = 0; j < 3; ++j) {
                dvh[j] = vw[j];
            }
            for (j = 0; j < 3; ++j) {
                w = 0.0;
                for (i = 0; i < 3; ++i) {
                    w += dprema[j][i] * dvb[i];
                }
                vw[j] = w;
            }
            for (j = 0; j < 3; ++j) {
                dvb[j] = vw[j];
            }
            for (j = 0; j < 3; ++j) {
                w = 0.0;
                for (i = 0; i < 3; ++i) {
                    w += dprema[j][i] * dph[i];
                }
                vw[j] = w;
            }
            for (j = 0; j < 3; ++j) {
                dph[j] = vw[j];
            }
            for (j = 0; j < 3; ++j) {
                w = 0.0;
                for (i = 0; i < 3; ++i) {
                    w += dprema[j][i] * dpb[i];
                }
                vw[j] = w;
            }
            for (j = 0; j < 3; ++j) {
                dpb[j] = vw[j];
            }
        }
        Pal.ENDTRACE("Evp");
    }

    public Stardata Fk425(Stardata s1950) {
        int i;
        double[] r0 = new double[3];
        double[] rd0 = new double[3];
        double[] v1 = new double[6];
        double[] v2 = new double[6];
        double pmf = 2.0626480624709636E7;
        double vf = 21.095;
        double[] a = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7};
        double[] ad = new double[]{0.001245, -0.00158, -6.59E-4};
        double[][] em = new double[][]{{0.9999256782, -0.0111820611, -0.0048579477, 2.42395018E-6, -2.710663E-8, -1.177656E-8}, {0.011182061, 0.9999374784, -2.71765E-5, 2.710663E-8, 2.42397878E-6, -6.587E-11}, {0.0048579479, -2.71474E-5, 0.9999881997, 1.177656E-8, -6.582E-11, 2.42410173E-6}, {-5.51E-4, -0.238565, 0.435739, 0.99994704, -0.01118251, -0.00485767}, {0.238514, -0.002667, -0.008541, 0.01118251, 0.99995883, -2.718E-5}, {-0.435623, 0.012254, 0.002117, 0.00485767, -2.714E-5, 1.00000956}};
        Pal.TRACE("Fk425");
        AngleDR rd = s1950.getAngle();
        double r = rd.getAlpha();
        double d = rd.getDelta();
        double[] pm = s1950.getMotion();
        double ur = pm[0] * 2.0626480624709636E7;
        double ud = pm[1] * 2.0626480624709636E7;
        double px = s1950.getParallax();
        double rv = s1950.getRV();
        double sr = Math.sin(r);
        double cr = Math.cos(r);
        double sd = Math.sin(d);
        double cd = Math.cos(d);
        r0[0] = cr * cd;
        r0[1] = sr * cd;
        r0[2] = sd;
        double w = vf * rv * px;
        rd0[0] = -sr * cd * ur - cr * sd * ud + w * r0[0];
        rd0[1] = cr * cd * ur - sr * sd * ud + w * r0[1];
        rd0[2] = cd * ud + w * r0[2];
        w = r0[0] * a[0] + r0[1] * a[1] + r0[2] * a[2];
        double wd = r0[0] * ad[0] + r0[1] * ad[1] + r0[2] * ad[2];
        for (i = 0; i < 3; ++i) {
            v1[i] = r0[i] - a[i] + w * r0[i];
            v1[i + 3] = rd0[i] - ad[i] + wd * r0[i];
        }
        for (i = 0; i < 6; ++i) {
            w = 0.0;
            for (int j = 0; j < 6; ++j) {
                w += em[i][j] * v1[j];
            }
            v2[i] = w;
        }
        double x = v2[0];
        double y = v2[1];
        double z = v2[2];
        double xd = v2[3];
        double yd = v2[4];
        double zd = v2[5];
        double rxysq = x * x + y * y;
        double rxyzsq = rxysq + z * z;
        double rxy = Math.sqrt(rxysq);
        double rxyz = Math.sqrt(rxyzsq);
        double spxy = x * xd + y * yd;
        double spxyz = spxy + z * zd;
        double d2 = r = x != 0.0 || y != 0.0 ? Math.atan2(y, x) : 0.0;
        if (r < 0.0) {
            r += Math.PI * 2;
        }
        d = Math.atan2(z, rxy);
        if (rxy > 1.0E-30) {
            ur = (x * yd - y * xd) / rxysq;
            ud = (zd * rxysq - z * spxy) / (rxyzsq * rxy);
        }
        if (px > 1.0E-30) {
            rv = spxyz / (px * rxyz * vf);
            px /= rxyz;
        }
        AngleDR ang = new AngleDR(r, d);
        double[] pm1 = new double[]{ur / 2.0626480624709636E7, ud / 2.0626480624709636E7};
        Pal.ENDTRACE("Fk425");
        return new Stardata(ang, pm1, px, rv);
    }

    public AngleDR Fk45z(AngleDR r1950, double bepoch) {
        int i;
        double[] a1 = new double[3];
        double[] v1 = new double[3];
        double[] v2 = new double[6];
        double pmf = 2.0626480624709636E7;
        double[] a = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7};
        double[] ad = new double[]{0.001245, -0.00158, -6.59E-4};
        double[][] em = new double[][]{{0.9999256782, -0.0111820611, -0.0048579477}, {0.011182061, 0.9999374784, -2.71765E-5}, {0.0048579479, -2.71474E-5, 0.9999881997}, {-5.51E-4, -0.238565, 0.435739}, {0.238514, -0.002667, -0.008541}, {-0.435623, 0.012254, 0.002117}};
        double[] r0 = this.Dcs2c(r1950);
        double w = (bepoch - 1950.0) / 2.0626480624709636E7;
        for (i = 0; i < 3; ++i) {
            a1[i] = a[i] + w * ad[i];
        }
        w = r0[0] * a1[0] + r0[1] * a1[1] + r0[2] * a1[2];
        for (i = 0; i < 3; ++i) {
            v1[i] = r0[i] - a1[i] + w * r0[i];
        }
        for (i = 0; i < 6; ++i) {
            w = 0.0;
            for (int j = 0; j < 3; ++j) {
                w += em[i][j] * v1[j];
            }
            v2[i] = w;
        }
        w = (this.Epj(this.Epb2d(bepoch)) - 2000.0) / 2.0626480624709636E7;
        for (i = 0; i < 3; ++i) {
            int n = i;
            v2[n] = v2[n] + w * v2[i + 3];
        }
        AngleDR r2000 = this.Dcc2s(v2);
        r2000.setAlpha(this.Dranrm(r2000.getAlpha()));
        return r2000;
    }

    public Stardata Fk524(Stardata j2000) {
        double[] v1 = new double[6];
        double[] v2 = new double[6];
        double pmf = 2.0626480624709636E7;
        double vf = 21.095;
        double[] a = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7, 0.001245, -0.00158, -6.59E-4};
        double[][] emi = new double[][]{{0.9999256795, 0.0111814828, 0.0048590039, -2.4238984E-6, -2.710544E-8, -1.177742E-8}, {-0.0111814828, 0.9999374849, -2.71771E-5, 2.710544E-8, -2.42392702E-6, 6.585E-11}, {-0.004859004, -2.71557E-5, 0.9999881946, 1.177742E-8, 6.585E-11, -2.42404995E-6}, {-5.51E-4, 0.238509, -0.435614, 0.99990432, 0.01118145, 0.00485852}, {-0.23856, -0.002667, 0.012254, -0.01118145, 0.99991613, -2.717E-5}, {0.43573, -0.008541, 0.002117, -0.00485852, -2.716E-5, 0.99996684}};
        double r = j2000.getAngle().getAlpha();
        double d = j2000.getAngle().getDelta();
        double ur = j2000.getMotion()[0] * 2.0626480624709636E7;
        double ud = j2000.getMotion()[1] * 2.0626480624709636E7;
        double px = j2000.getParallax();
        double rv = j2000.getRV();
        double sr = Math.sin(r);
        double cr = Math.cos(r);
        double sd = Math.sin(d);
        double cd = Math.cos(d);
        double x = cr * cd;
        double y = sr * cd;
        double z = sd;
        double w = 21.095 * rv * px;
        v1[0] = x;
        v1[1] = y;
        v1[2] = z;
        v1[3] = -ur * y - cr * sd * ud + w * x;
        v1[4] = ur * x - sr * sd * ud + w * y;
        v1[5] = cd * ud + w * z;
        for (int i = 0; i < 6; ++i) {
            w = 0.0;
            for (int j = 0; j < 6; ++j) {
                w += emi[i][j] * v1[j];
            }
            v2[i] = w;
        }
        x = v2[0];
        y = v2[1];
        z = v2[2];
        double rxyz = Math.sqrt(x * x + y * y + z * z);
        w = x * a[0] + y * a[1] + z * a[2];
        x += a[0] * rxyz - w * x;
        y += a[1] * rxyz - w * y;
        z += a[2] * rxyz - w * z;
        rxyz = Math.sqrt(x * x + y * y + z * z);
        x = v2[0];
        y = v2[1];
        z = v2[2];
        w = x * a[0] + y * a[1] + z * a[2];
        double wd = x * a[3] + y * a[4] + z * a[5];
        x += a[0] * rxyz - w * x;
        y += a[1] * rxyz - w * y;
        z += a[2] * rxyz - w * z;
        double xd = v2[3] + a[3] * rxyz - wd * x;
        double yd = v2[4] + a[4] * rxyz - wd * y;
        double zd = v2[5] + a[5] * rxyz - wd * z;
        double rxysq = x * x + y * y;
        double rxy = Math.sqrt(rxysq);
        double d2 = r = x != 0.0 || y != 0.0 ? Math.atan2(y, x) : 0.0;
        if (r < 0.0) {
            r += Math.PI * 2;
        }
        d = Math.atan2(z, rxy);
        if (rxy > 1.0E-30) {
            ur = (x * yd - y * xd) / rxysq;
            ud = (zd * rxysq - z * (x * xd + y * yd)) / ((rxysq + z * z) * rxy);
        }
        if (px > 1.0E-30) {
            rv = (x * xd + y * yd + z * zd) / (px * 21.095 * rxyz);
            px /= rxyz;
        }
        AngleDR r1950 = new AngleDR(r, d);
        double[] d1950 = new double[]{ur / 2.0626480624709636E7, ud / 2.0626480624709636E7};
        return new Stardata(r1950, d1950, px, rv);
    }

    public Stardata Fk54z(AngleDR r2000, double bepoch) {
        double zero = 0.0;
        double[] v = new double[]{0.0, 0.0};
        Stardata s = new Stardata(r2000, v, 0.0, 0.0);
        Stardata t = this.Fk524(s);
        AngleDR r1950 = t.getAngle();
        double[] m1950 = t.getMotion();
        AngleDR ang = this.Pm(r1950, m1950, 0.0, 0.0, 1950.0, bepoch);
        return new Stardata(ang, m1950, 0.0, 0.0);
    }

    public AngleDR Galeq(Galactic gl) {
        double[] v2 = new double[3];
        AngleDR d = new AngleDR(gl.getLongitude(), gl.getLatitude());
        double[][] rmat = new double[][]{{-0.054875539726, -0.87343710801, -0.483834985808}, {0.494109453312, -0.444829589425, 0.74698225181}, {-0.867666135858, -0.198076386122, 0.455983795705}};
        Pal.TRACE("Galeq");
        double[] v1 = this.Dcs2c(d);
        v2 = this.Dimxv(rmat, v1);
        d = this.Dcc2s(v2);
        d.setAlpha(this.Dranrm(d.getAlpha()));
        d.setDelta(this.Drange(d.getDelta()));
        Pal.ENDTRACE("Galeq");
        return d;
    }

    public Galactic Galsup(Galactic gl) {
        AngleDR d = new AngleDR(gl.getLongitude(), gl.getLatitude());
        double[][] rmat = new double[][]{{-0.735742574804, 0.677261296414, 0.0}, {-0.074553778365, -0.080991471307, 0.9939225904}, {0.673145302109, 0.731271165817, 0.110081262225}};
        Pal.TRACE("Galsup");
        double[] v1 = this.Dcs2c(d);
        double[] v2 = this.Dmxv(rmat, v1);
        d = this.Dcc2s(v2);
        Pal.ENDTRACE("Galsup");
        return new Galactic(this.Dranrm(d.getAlpha()), this.Drange(d.getDelta()));
    }

    public double[] Geoc(double p, double h) {
        Pal.TRACE("Geoc");
        double[] r = new double[2];
        double a0 = 6378140.0;
        double f = 0.0033528131778969143;
        double b = 0.993305615000412;
        double au = 1.4959787E11;
        double sp = Math.sin(p);
        double cp = Math.cos(p);
        double c = 1.0 / Math.sqrt(cp * cp + b * sp * sp);
        double s = b * c;
        r[0] = (6378140.0 * c + h) * cp / 1.4959787E11;
        r[1] = (6378140.0 * s + h) * sp / 1.4959787E11;
        Pal.ENDTRACE("Geoc");
        return r;
    }

    public double Gmst(double ut1) {
        double tu = (ut1 - 51544.5) / 36525.0;
        return this.Dranrm(Pal.dmod(ut1, 1.0) * (Math.PI * 2) + (24110.54841 + (8640184.812866 + (0.093104 - 6.2E-6 * tu) * tu) * tu) * 7.27220521664304E-5);
    }

    public char Kbj(int jb, double e) throws palError {
        int k;
        this.Status = 0;
        if (jb == 1) {
            k = 66;
        } else if (jb == 2) {
            k = 74;
        } else if (jb == 0) {
            k = e < 1984.0 ? 66 : 74;
        } else {
            int k2 = 32;
            this.Status = 1;
            throw new palError(this.Status, "Kbj: Illegal prefix");
        }
        return (char)k;
    }

    public AngleDR Map(Stardata sd, double epq, double date) {
        Pal.TRACE("Map");
        AMParams amprms = this.Mappa(epq, date);
        AngleDR ra = this.Mapqk(sd, amprms);
        Pal.ENDTRACE("Map");
        return ra;
    }

    public AMParams Mappa(double eq, double date) {
        AMParams amprms = new AMParams();
        double[] ebd = new double[3];
        double[] ehd = new double[3];
        double[] eh = new double[3];
        double e = 1.0;
        double[] vn = new double[3];
        double vm = 0.0;
        Pal.TRACE("Mappa");
        amprms.setTimeint(this.Epj(date) - eq);
        this.Evp(date, eq, ebd, amprms.getBary(), ehd, eh);
        e = this.Dvn(eh, amprms.getHelio());
        amprms.setGrad(1.974126E-8 / e);
        for (int i = 0; i < 3; ++i) {
            ebd[i] = ebd[i] * 499.004782;
        }
        amprms.setEarthv(ebd);
        vm = this.Dvn(ebd, vn);
        amprms.setRoot(Math.sqrt(1.0 - vm * vm));
        amprms.setPrecess(this.Prenut(eq, date));
        Pal.ENDTRACE("Mappa");
        return amprms;
    }

    public AngleDR Mapqk(Stardata s, AMParams amprms) {
        int i;
        double[] em = new double[3];
        double[] p = new double[3];
        double[] pn = new double[3];
        double[] p1 = new double[3];
        double[] p2 = new double[3];
        double[] p3 = new double[3];
        Pal.TRACE("Mapqk");
        double pmt = amprms.getTimeint();
        double gr2e = amprms.getGrad();
        double ab1 = amprms.getRoot();
        double[] eb = amprms.getBary();
        double[] ehn = amprms.getHelio();
        double[] abv = amprms.getEarthv();
        AngleDR r = s.getAngle();
        double rm = r.getAlpha();
        double dm = r.getDelta();
        double[] pm = s.getMotion();
        double px = s.getParallax();
        double rv = s.getRV();
        double[] q = this.Dcs2c(r);
        double pxr = px * 4.84813681109536E-6;
        double w = 0.21094502 * rv * pxr;
        em[0] = -pm[0] * q[1] - pm[1] * Math.cos(rm) * Math.sin(dm) + w * q[0];
        em[1] = pm[0] * q[0] - pm[1] * Math.sin(rm) * Math.sin(dm) + w * q[1];
        em[2] = pm[1] * Math.cos(dm) + w * q[2];
        for (i = 0; i < 3; ++i) {
            p[i] = q[i] + pmt * em[i] - pxr * eb[i];
        }
        w = this.Dvn(p, pn);
        double pde = this.Dvdv(pn, ehn);
        double pdep1 = 1.0 + pde;
        w = gr2e / Pal.gmax(pdep1, 1.0E-5);
        for (i = 0; i < 3; ++i) {
            p1[i] = pn[i] + w * (ehn[i] - pde * pn[i]);
        }
        double p1dv = this.Dvdv(p1, abv);
        w = 1.0 + p1dv / (ab1 + 1.0);
        for (i = 0; i < 3; ++i) {
            p2[i] = ab1 * p1[i] + w * abv[i];
        }
        p3 = this.Dmxv(amprms.getPrecess(), p2);
        AngleDR ra = this.Dcc2s(p3);
        ra.setAlpha(this.Dranrm(ra.getAlpha()));
        Pal.ENDTRACE("Mapqk");
        return ra;
    }

    public AngleDR Mapqkz(AngleDR rm, AMParams amprms) {
        int i;
        double[] p1 = new double[3];
        double[] p2 = new double[3];
        Pal.TRACE("Mapqkz");
        double gr2e = amprms.getGrad();
        double ab1 = amprms.getRoot();
        double[] ehn = amprms.getHelio();
        double[] abv = amprms.getEarthv();
        double[] p = this.Dcs2c(rm);
        double pde = this.Dvdv(p, ehn);
        double pdep1 = pde + 1.0;
        double w = gr2e / Pal.gmax(pdep1, 1.0E-5);
        for (i = 0; i < 3; ++i) {
            p1[i] = p[i] + w * (ehn[i] - pde * p[i]);
        }
        double p1dv = this.Dvdv(p1, abv);
        double p1dvp1 = p1dv + 1.0;
        w = 1.0 + p1dv / (ab1 + 1.0);
        for (i = 0; i < 3; ++i) {
            p2[i] = (ab1 * p1[i] + w * abv[i]) / p1dvp1;
        }
        double[] p3 = this.Dmxv(amprms.getPrecess(), p2);
        AngleDR a = this.Dcc2s(p3);
        a.setAlpha(this.Dranrm(a.getAlpha()));
        Pal.ENDTRACE("Mapqkz");
        return a;
    }

    public double[][] Nut(double date) {
        Pal.TRACE("Nut");
        double[] nc = this.Nutc(date);
        double dpsi = nc[0];
        double deps = nc[1];
        double eps0 = nc[2];
        double[][] rmatn = this.Deuler("xzx", eps0, -dpsi, -(eps0 + deps));
        Pal.ENDTRACE("Nut");
        return rmatn;
    }

    /*
     * Opcode count of 16507 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public double[] Nutc(double date) {
        int[][] na = new int[][]{{0, 0, 0, 0, -1, 0, 0, 0, 0}, {0, 0, 2, -2, 2, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, -2, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 2, -2, 2, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 1, 0, 0, 0, 0}, {1, 0, 2, 0, 2, 0, 0, 0, 0}, {0, -1, 2, -2, 2, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, 0, 0}, {-1, 0, 2, 0, 2, 0, 0, 0, 0}, {-1, 0, 0, 2, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 0, 0, 0}, {1, 0, 0, 0, -1, 0, 0, 0, 0}, {-1, 0, 2, 2, 2, 0, 0, 0, 0}, {1, 0, 2, 0, 1, 0, 0, 0, 0}, {-2, 0, 2, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, 0, 0}, {2, 0, 2, 0, 2, 0, 0, 0, 0}, {1, 0, 2, -2, 2, 0, 0, 0, 0}, {-1, 0, 2, 0, 1, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0, 0}, {-1, 0, 0, 2, 1, 0, 0, 0, 0}, {0, 2, 2, -2, 2, 0, 0, 0, 0}, {0, 0, 2, -2, 0, 0, 0, 0, 0}, {-1, 0, 0, 2, -1, 0, 0, 0, 0}, {0, 1, 0, 0, -1, 0, 0, 0, 0}, {0, 2, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, 2, 2, 1, 0, 0, 0, 0}, {1, 0, 2, 2, 2, 0, 0, 0, 0}, {0, 1, 2, 0, 2, 0, 0, 0, 0}, {-2, 0, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 1, 0, 0, 0, 0}, {0, -1, 2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 2, 1, 0, 0, 0, 0}, {1, 0, 2, -2, 1, 0, 0, 0, 0}, {2, 0, 0, -2, -1, 0, 0, 0, 0}, {2, 0, 2, -2, 2, 0, 0, 0, 0}, {2, 0, 2, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 2, -1, 0, 0, 0, 0}, {0, -1, 2, -2, 1, 0, 0, 0, 0}, {-1, -1, 0, 2, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 1, 0, 0, 0, 0}, {1, 0, 0, 2, 0, 0, 0, 0, 0}, {0, 1, 2, -2, 1, 0, 0, 0, 0}, {1, -1, 0, 0, 0, 0, 0, 0, 0}, {-2, 0, 2, 0, 2, 0, 0, 0, 0}, {0, -1, 0, 2, 0, 0, 0, 0, 0}, {3, 0, 2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0}, {1, -1, 2, 0, 2, 0, 0, 0, 0}, {1, 0, 0, -1, 0, 0, 0, 0, 0}, {-1, -1, 2, 2, 2, 0, 0, 0, 0}, {-1, 0, 2, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, -1, 0, 0, 0, 0}, {0, -1, 2, 2, 2, 0, 0, 0, 0}, {1, 1, 2, 0, 2, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 0, -2, 2, -1, 0, 0, 0, 0}, {1, 0, 2, 0, 0, 0, 0, 0, 0}, {-1, 1, 0, 1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 2, 0, 0, 0, 0}, {-1, 0, 1, 0, 1, 0, 0, 0, 0}, {0, 0, 2, 1, 2, 0, 0, 0, 0}, {-1, 1, 0, 1, 1, 0, 0, 0, 0}, {-1, 0, 2, 4, 2, 0, 0, 0, 0}, {0, -2, 2, -2, 1, 0, 0, 0, 0}, {1, 0, 2, 2, 1, 0, 0, 0, 0}, {1, 0, 0, 0, -2, 0, 0, 0, 0}, {-2, 0, 2, 2, 2, 0, 0, 0, 0}, {1, 1, 2, -2, 2, 0, 0, 0, 0}, {-2, 0, 2, 4, 2, 0, 0, 0, 0}, {-1, 0, 4, 0, 2, 0, 0, 0, 0}, {2, 0, 2, -2, 1, 0, 0, 0, 0}, {1, 0, 0, -1, -1, 0, 0, 0, 0}, {2, 0, 2, 2, 2, 0, 0, 0, 0}, {1, 0, 0, 2, 1, 0, 0, 0, 0}, {3, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, -1, 0, 0, 0, 0}, {3, 0, 2, -2, 2, 0, 0, 0, 0}, {0, 0, 4, -2, 2, 0, 0, 0, 0}, {-1, 0, 0, 4, 0, 0, 0, 0, 0}, {0, 1, 2, 0, 1, 0, 0, 0, 0}, {0, 0, 2, -2, 3, 0, 0, 0, 0}, {-2, 0, 0, 4, 0, 0, 0, 0, 0}, {-1, -1, 0, 2, 1, 0, 0, 0, 0}, {-2, 0, 2, 0, -1, 0, 0, 0, 0}, {0, 0, 2, 0, -1, 0, 0, 0, 0}, {0, -1, 2, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 2, 0, 0, 0, 0}, {0, 0, 2, -1, 2, 0, 0, 0, 0}, {2, 1, 0, -2, 0, 0, 0, 0, 0}, {0, 0, 2, 4, 2, 0, 0, 0, 0}, {-1, -1, 0, 2, -1, 0, 0, 0, 0}, {-1, 1, 0, 2, 0, 0, 0, 0, 0}, {1, -1, 0, 0, 1, 0, 0, 0, 0}, {0, -1, 2, -2, 0, 0, 0, 0, 0}, {0, 1, 0, 0, -2, 0, 0, 0, 0}, {1, -1, 2, 2, 2, 0, 0, 0, 0}, {1, 0, 0, 2, -1, 0, 0, 0, 0}, {-1, 1, 2, 2, 2, 0, 0, 0, 0}, {3, 0, 2, 0, 1, 0, 0, 0, 0}, {0, 1, 2, 2, 2, 0, 0, 0, 0}, {1, 0, 2, -2, 0, 0, 0, 0, 0}, {-1, 0, -2, 4, -1, 0, 0, 0, 0}, {-1, -1, 2, 2, 1, 0, 0, 0, 0}, {0, -1, 2, 2, 1, 0, 0, 0, 0}, {2, -1, 2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 2, 2, 0, 0, 0, 0}, {1, -1, 2, 0, 1, 0, 0, 0, 0}, {-1, 1, 2, 0, 2, 0, 0, 0, 0}, {0, 1, 0, 2, 0, 0, 0, 0, 0}, {0, 1, 2, -2, 0, 0, 0, 0, 0}, {0, 3, 2, -2, 2, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0}, {-1, 0, 2, 2, 0, 0, 0, 0, 0}, {2, 1, 2, 0, 2, 0, 0, 0, 0}, {1, 1, 0, 0, 1, 0, 0, 0, 0}, {2, 0, 0, 2, 0, 0, 0, 0, 0}, {1, 1, 2, 0, 1, 0, 0, 0, 0}, {-1, 0, 0, 2, 2, 0, 0, 0, 0}, {1, 0, -2, 2, 0, 0, 0, 0, 0}, {0, -1, 0, 2, -1, 0, 0, 0, 0}, {-1, 0, 1, 0, 2, 0, 0, 0, 0}, {0, 1, 0, 1, 0, 0, 0, 0, 0}, {1, 0, -2, 2, -2, 0, 0, 0, 0}, {0, 0, 0, 1, -1, 0, 0, 0, 0}, {1, -1, 0, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 4, 0, 0, 0, 0, 0}, {1, -1, 0, 2, 0, 0, 0, 0, 0}, {1, 0, 2, 1, 2, 0, 0, 0, 0}, {1, 0, 2, -1, 2, 0, 0, 0, 0}, {-1, 0, 0, 2, -2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 0, 0, 0, 0}, {-1, 0, 2, 0, -1, 0, 0, 0, 0}, {-1, 0, 2, 4, 1, 0, 0, 0, 0}, {0, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 2, -2, 1, 0, 0, 0, 0}, {0, 0, 1, 0, 1, 0, 0, 0, 0}, {-1, 0, 2, -1, 1, 0, 0, 0, 0}, {-2, 0, 2, 2, 1, 0, 0, 0, 0}, {2, -1, 0, 0, 0, 0, 0, 0, 0}, {4, 0, 2, 0, 2, 0, 0, 0, 0}, {2, 1, 2, -2, 2, 0, 0, 0, 0}, {0, 1, 2, 1, 2, 0, 0, 0, 0}, {1, 0, 4, -2, 2, 0, 0, 0, 0}, {1, 1, 0, 0, -1, 0, 0, 0, 0}, {-2, 0, 2, 4, 1, 0, 0, 0, 0}, {2, 0, 2, 0, 0, 0, 0, 0, 0}, {-1, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 1, 0, 2, 1, 0, 0, 0, 0}, {-1, 0, 4, 0, 1, 0, 0, 0, 0}, {-1, 0, 0, 4, 1, 0, 0, 0, 0}, {2, 0, 2, 2, 1, 0, 0, 0, 0}, {2, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 5, -5, 5, -3, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0}, {0, 0, -1, 1, -1, 1, 0, 0, 0}, {0, 0, -1, 1, 0, 0, 2, 0, 0}, {0, 0, 3, -3, 3, 0, 0, -1, 0}, {0, 0, -8, 8, -7, 5, 0, 0, 0}, {0, 0, -1, 1, -1, 0, 2, 0, 0}, {0, 0, -2, 2, -2, 2, 0, 0, 0}, {0, 0, -6, 6, -6, 4, 0, 0, 0}, {0, 0, -2, 2, -2, 0, 8, -3, 0}, {0, 0, 6, -6, 6, 0, -8, 3, 0}, {0, 0, 4, -4, 4, -2, 0, 0, 0}, {0, 0, -3, 3, -3, 2, 0, 0, 0}, {0, 0, 4, -4, 3, 0, -8, 3, 0}, {0, 0, -4, 4, -5, 0, 8, -3, 0}, {0, 0, 0, 0, 0, 2, 0, 0, 0}, {0, 0, -4, 4, -4, 3, 0, 0, 0}, {0, 1, -1, 1, -1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0}, {0, 0, 1, -1, 1, 1, 0, 0, 0}, {0, 0, 2, -2, 2, 0, -2, 0, 0}, {0, -1, -7, 7, -7, 5, 0, 0, 0}, {-2, 0, 2, 0, 2, 0, 0, -2, 0}, {-2, 0, 2, 0, 1, 0, 0, -3, 0}, {0, 0, 2, -2, 2, 0, 0, -2, 0}, {0, 0, 1, -1, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 1}, {2, 0, -2, 0, -2, 0, 0, 3, 0}, {0, 0, 1, -1, 1, 0, 0, -2, 0}, {0, 0, -7, 7, -7, 5, 0, 0, 0}};
        double[][] psi = new double[][]{{3341.5, 1.72062418E7, 3.1, 17409.5}, {-1716.8, -1317185.3, 1.4, -156.8}, {285.7, -227667.0, 0.3, -23.5}, {-68.6, -207448.0, 0.0, -21.4}, {950.3, 147607.9, -2.3, -355.0}, {-66.7, -51689.1, 0.2, 122.6}, {-108.6, 71117.6, 0.0, 7.0}, {35.6, -38740.2, 0.1, -36.2}, {85.4, -30127.6, 0.0, -3.1}, {9.0, 21583.0, 0.1, -50.3}, {22.1, 12822.8, 0.0, 13.3}, {3.4, 12350.8, 0.0, 1.3}, {-21.1, 15699.4, 0.0, 1.6}, {4.2, 6313.8, 0.0, 6.2}, {-22.8, 5796.9, 0.0, 6.1}, {15.7, -5961.1, 0.0, -0.6}, {13.1, -5159.1, 0.0, -4.6}, {1.8, 4592.7, 0.0, 4.5}, {-17.5, 6336.0, 0.0, 0.7}, {16.3, -3851.1, 0.0, -0.4}, {-2.8, 4771.7, 0.0, 0.5}, {13.8, -3099.3, 0.0, -0.3}, {0.2, 2860.3, 0.0, 0.3}, {1.4, 2045.3, 0.0, 2.0}, {-8.6, 2922.6, 0.0, 0.3}, {-7.7, 2587.9, 0.0, 0.2}, {8.8, -1408.1, 0.0, 3.7}, {1.4, 1517.5, 0.0, 1.5}, {-1.9, -1579.7, 0.0, 7.7}, {1.3, -2178.6, 0.0, -0.2}, {-4.8, 1286.8, 0.0, 1.3}, {6.3, 1267.2, 0.0, -4.0}, {-1.0, 1669.3, 0.0, -8.3}, {2.4, -1020.0, 0.0, -0.9}, {4.5, -766.9, 0.0, 0.0}, {-1.1, 756.5, 0.0, -1.7}, {-1.4, -1097.3, 0.0, -0.5}, {2.6, -663.0, 0.0, -0.6}, {0.8, -714.1, 0.0, 1.6}, {0.4, -629.9, 0.0, -0.6}, {0.3, 580.4, 0.0, 0.6}, {-1.6, 577.3, 0.0, 0.5}, {-0.9, 644.4, 0.0, 0.0}, {2.2, -534.0, 0.0, -0.5}, {-2.5, 493.3, 0.0, 0.5}, {-0.1, -477.3, 0.0, -2.4}, {-0.9, 735.0, 0.0, -1.7}, {0.7, 406.2, 0.0, 0.4}, {-2.8, 656.9, 0.0, 0.0}, {0.6, 358.0, 0.0, 2.0}, {-0.7, 472.5, 0.0, -1.1}, {-0.1, -300.5, 0.0, 0.0}, {-1.2, 435.1, 0.0, -1.0}, {1.8, -289.4, 0.0, 0.0}, {0.6, -422.6, 0.0, 0.0}, {0.8, -287.6, 0.0, 0.6}, {-38.6, -392.3, 0.0, 0.0}, {0.7, -281.8, 0.0, 0.6}, {0.6, -405.7, 0.0, 0.0}, {-1.2, 229.0, 0.0, 0.2}, {1.1, -264.3, 0.0, 0.5}, {-0.7, 247.9, 0.0, -0.5}, {-0.2, 218.0, 0.0, 0.2}, {0.6, -339.0, 0.0, 0.8}, {-0.7, 198.7, 0.0, 0.2}, {-1.5, 334.0, 0.0, 0.0}, {0.1, 334.0, 0.0, 0.0}, {-0.1, -198.1, 0.0, 0.0}, {-106.6, 0.0, 0.0, 0.0}, {-0.5, 165.8, 0.0, 0.0}, {0.0, 134.8, 0.0, 0.0}, {0.9, -151.6, 0.0, 0.0}, {0.0, -129.7, 0.0, 0.0}, {0.8, -132.8, 0.0, -0.1}, {0.5, -140.7, 0.0, 0.0}, {-0.1, 138.4, 0.0, 0.0}, {0.0, 129.0, 0.0, -0.3}, {0.5, -121.2, 0.0, 0.0}, {-0.3, 114.5, 0.0, 0.0}, {-0.1, 101.8, 0.0, 0.0}, {-3.6, -101.9, 0.0, 0.0}, {0.8, -109.4, 0.0, 0.0}, {0.2, -97.0, 0.0, 0.0}, {-0.7, 157.3, 0.0, 0.0}, {0.2, -83.3, 0.0, 0.0}, {-0.3, 93.3, 0.0, 0.0}, {-0.1, 92.1, 0.0, 0.0}, {-0.5, 133.6, 0.0, 0.0}, {-0.1, 81.5, 0.0, 0.0}, {0.0, 123.9, 0.0, 0.0}, {-0.3, 128.1, 0.0, 0.0}, {0.1, 74.1, 0.0, -0.3}, {-0.2, -70.3, 0.0, 0.0}, {-0.4, 66.6, 0.0, 0.0}, {0.1, -66.7, 0.0, 0.0}, {-0.7, 69.3, 0.0, -0.3}, {0.0, -70.4, 0.0, 0.0}, {-0.1, 101.5, 0.0, 0.0}, {0.5, -69.1, 0.0, 0.0}, {-0.2, 58.5, 0.0, 0.2}, {0.1, -94.9, 0.0, 0.2}, {0.0, 52.9, 0.0, -0.2}, {0.1, 86.7, 0.0, -0.2}, {-0.1, -59.2, 0.0, 0.2}, {0.3, -58.8, 0.0, 0.1}, {-0.3, 49.0, 0.0, 0.0}, {-0.2, 56.9, 0.0, -0.1}, {0.3, -50.2, 0.0, 0.0}, {-0.2, 53.4, 0.0, -0.1}, {0.1, -76.5, 0.0, 0.0}, {-0.2, 45.3, 0.0, 0.0}, {0.1, -46.8, 0.0, 0.0}, {0.2, -44.6, 0.0, 0.0}, {0.2, -48.7, 0.0, 0.0}, {0.1, -46.8, 0.0, 0.0}, {0.1, -42.0, 0.0, 0.0}, {0.0, 46.4, 0.0, -0.1}, {0.2, -67.3, 0.0, 0.1}, {0.0, -65.8, 0.0, 0.2}, {-0.1, -43.9, 0.0, 0.3}, {0.0, -38.9, 0.0, 0.0}, {-0.3, 63.9, 0.0, 0.0}, {-0.2, 41.2, 0.0, 0.0}, {0.0, -36.1, 0.0, 0.2}, {-0.3, 58.5, 0.0, 0.0}, {-0.1, 36.1, 0.0, 0.0}, {0.0, -39.7, 0.0, 0.0}, {0.1, -57.7, 0.0, 0.0}, {-0.2, 33.4, 0.0, 0.0}, {36.4, 0.0, 0.0, 0.0}, {-0.1, 55.7, 0.0, -0.1}, {0.1, -35.4, 0.0, 0.0}, {0.1, -31.0, 0.0, 0.0}, {-0.1, 30.1, 0.0, 0.0}, {-0.3, 49.2, 0.0, 0.0}, {-0.2, 49.1, 0.0, 0.0}, {-0.1, 33.6, 0.0, 0.0}, {0.1, -33.5, 0.0, 0.0}, {0.1, -31.0, 0.0, 0.0}, {-0.1, 28.0, 0.0, 0.0}, {0.1, -25.2, 0.0, 0.0}, {0.1, -26.2, 0.0, 0.0}, {-0.2, 41.5, 0.0, 0.0}, {0.0, 24.5, 0.0, 0.1}, {-16.2, 0.0, 0.0, 0.0}, {0.0, -22.3, 0.0, 0.0}, {0.0, 23.1, 0.0, 0.0}, {-0.1, 37.5, 0.0, 0.0}, {0.2, -25.7, 0.0, 0.0}, {0.0, 25.2, 0.0, 0.0}, {0.1, -24.5, 0.0, 0.0}, {-0.1, 24.3, 0.0, 0.0}, {0.1, -20.7, 0.0, 0.0}, {0.1, -20.8, 0.0, 0.0}, {-0.2, 33.4, 0.0, 0.0}, {32.9, 0.0, 0.0, 0.0}, {0.1, -32.6, 0.0, 0.0}, {0.0, 19.9, 0.0, 0.0}, {-0.1, 19.6, 0.0, 0.0}, {0.0, -18.7, 0.0, 0.0}, {0.1, -19.0, 0.0, 0.0}, {0.1, -28.6, 0.0, 0.0}, {4.0, 178.8, -11.8, 0.3}, {39.8, -107.3, -5.6, -1.0}, {9.9, 164.0, -4.1, 0.1}, {-4.8, -135.3, -3.4, -0.1}, {50.5, 75.0, 1.4, -1.2}, {-1.1, -53.5, 1.3, 0.0}, {-45.0, -2.4, -0.4, 6.6}, {-11.5, -61.0, -0.9, 0.4}, {4.4, -68.4, -3.4, 0.0}, {7.7, -47.1, -4.7, -1.0}, {-42.9, -12.6, -1.2, 4.2}, {-42.8, 12.7, -1.2, -4.2}, {-7.6, -44.1, 2.1, -0.5}, {-64.1, 1.7, 0.2, 4.5}, {36.4, -10.4, 1.0, 3.5}, {35.6, 10.2, 1.0, -3.5}, {-1.7, 39.5, 2.0, 0.0}, {50.9, -8.2, -0.8, -5.0}, {0.0, 52.3, 1.2, 0.0}, {-42.9, -17.8, 0.4, 0.0}, {2.6, 34.3, 0.8, 0.0}, {-0.8, -48.6, 2.4, -0.1}, {-4.9, 30.5, 3.7, 0.7}, {0.0, -43.6, 2.1, 0.0}, {0.0, -25.4, 1.2, 0.0}, {2.0, 40.9, -2.0, 0.0}, {-2.1, 26.1, 0.6, 0.0}, {22.6, -3.2, -0.5, -0.5}, {-7.6, 24.9, -0.4, -0.2}, {-6.2, 34.9, 1.7, 0.3}, {2.0, 17.4, -0.4, 0.1}, {-3.9, 20.5, 2.4, 0.6}};
        double[][] eps = new double[][]{{9205365.8, -1506.2, 885.7, -0.2}, {573095.9, -570.2, -305.0, -0.3}, {97845.5, 147.8, -48.8, -0.2}, {-89753.6, 28.0, 46.9, 0.0}, {7406.7, -327.1, -18.2, 0.8}, {22442.3, -22.3, -67.6, 0.0}, {-683.6, 46.8, 0.0, 0.0}, {20070.7, 36.0, 1.6, 0.0}, {12893.8, 39.5, -6.2, 0.0}, {-9593.2, 14.4, 30.2, -0.1}, {-6899.5, 4.8, -0.6, 0.0}, {-5332.5, -0.1, 2.7, 0.0}, {-125.2, 10.5, 0.0, 0.0}, {-3323.4, -0.9, -0.3, 0.0}, {3142.3, 8.9, 0.3, 0.0}, {2552.5, 7.3, -1.2, 0.0}, {2634.4, 8.8, 0.2, 0.0}, {-2424.4, 1.6, -0.4, 0.0}, {-123.3, 3.9, 0.0, 0.0}, {1642.4, 7.3, -0.8, 0.0}, {47.9, 3.2, 0.0, 0.0}, {1321.2, 6.2, -0.6, 0.0}, {-1234.1, -0.3, 0.6, 0.0}, {-1076.5, -0.3, 0.0, 0.0}, {-61.6, 1.8, 0.0, 0.0}, {-55.4, 1.6, 0.0, 0.0}, {856.9, -4.9, -2.1, 0.0}, {-800.7, -0.1, 0.0, 0.0}, {685.1, -0.6, -3.8, 0.0}, {-16.9, -1.5, 0.0, 0.0}, {695.7, 1.8, 0.0, 0.0}, {642.2, -2.6, -1.6, 0.0}, {13.3, 1.1, -0.1, 0.0}, {521.9, 1.6, 0.0, 0.0}, {325.8, 2.0, -0.1, 0.0}, {-325.1, -0.5, 0.9, 0.0}, {10.1, 0.3, 0.0, 0.0}, {334.5, 1.6, 0.0, 0.0}, {307.1, 0.4, -0.9, 0.0}, {327.2, 0.5, 0.0, 0.0}, {-304.6, -0.1, 0.0, 0.0}, {304.0, 0.6, 0.0, 0.0}, {-276.8, -0.5, 0.1, 0.0}, {268.9, 1.3, 0.0, 0.0}, {271.8, 1.1, 0.0, 0.0}, {271.5, -0.4, -0.8, 0.0}, {-5.2, 0.5, 0.0, 0.0}, {-220.5, 0.1, 0.0, 0.0}, {-20.1, 0.3, 0.0, 0.0}, {-191.0, 0.1, 0.5, 0.0}, {-4.1, 0.3, 0.0, 0.0}, {130.6, -0.1, 0.0, 0.0}, {3.0, 0.3, 0.0, 0.0}, {122.9, 0.8, 0.0, 0.0}, {3.7, -0.3, 0.0, 0.0}, {123.1, 0.4, -0.3, 0.0}, {-52.7, 15.3, 0.0, 0.0}, {120.7, 0.3, -0.3, 0.0}, {4.0, -0.3, 0.0, 0.0}, {126.5, 0.5, 0.0, 0.0}, {112.7, 0.5, -0.3, 0.0}, {-106.1, -0.3, 0.3, 0.0}, {-112.9, -0.2, 0.0, 0.0}, {3.6, -0.2, 0.0, 0.0}, {107.4, 0.3, 0.0, 0.0}, {-10.9, 0.2, 0.0, 0.0}, {-0.9, 0.0, 0.0, 0.0}, {85.4, 0.0, 0.0, 0.0}, {0.0, -88.8, 0.0, 0.0}, {-71.0, -0.2, 0.0, 0.0}, {-70.3, 0.0, 0.0, 0.0}, {64.5, 0.4, 0.0, 0.0}, {69.8, 0.0, 0.0, 0.0}, {66.1, 0.4, 0.0, 0.0}, {-61.0, -0.2, 0.0, 0.0}, {-59.5, -0.1, 0.0, 0.0}, {-55.6, 0.0, 0.2, 0.0}, {51.7, 0.2, 0.0, 0.0}, {-49.0, -0.1, 0.0, 0.0}, {-52.7, -0.1, 0.0, 0.0}, {-49.6, 1.4, 0.0, 0.0}, {46.3, 0.4, 0.0, 0.0}, {49.6, 0.1, 0.0, 0.0}, {-5.1, 0.1, 0.0, 0.0}, {-44.0, -0.1, 0.0, 0.0}, {-39.9, -0.1, 0.0, 0.0}, {-39.5, -0.1, 0.0, 0.0}, {-3.9, 0.1, 0.0, 0.0}, {-42.1, -0.1, 0.0, 0.0}, {-17.2, 0.1, 0.0, 0.0}, {-2.3, 0.1, 0.0, 0.0}, {-39.2, 0.0, 0.0, 0.0}, {-38.4, 0.1, 0.0, 0.0}, {36.8, 0.2, 0.0, 0.0}, {34.6, 0.1, 0.0, 0.0}, {-32.7, 0.3, 0.0, 0.0}, {30.4, 0.0, 0.0, 0.0}, {0.4, 0.1, 0.0, 0.0}, {29.3, 0.2, 0.0, 0.0}, {31.6, 0.1, 0.0, 0.0}, {0.8, -0.1, 0.0, 0.0}, {-27.9, 0.0, 0.0, 0.0}, {2.9, 0.0, 0.0, 0.0}, {-25.3, 0.0, 0.0, 0.0}, {25.0, 0.1, 0.0, 0.0}, {27.5, 0.1, 0.0, 0.0}, {-24.4, -0.1, 0.0, 0.0}, {24.9, 0.2, 0.0, 0.0}, {-22.8, -0.1, 0.0, 0.0}, {0.9, -0.1, 0.0, 0.0}, {24.4, 0.1, 0.0, 0.0}, {23.9, 0.1, 0.0, 0.0}, {22.5, 0.1, 0.0, 0.0}, {20.8, 0.1, 0.0, 0.0}, {20.1, 0.0, 0.0, 0.0}, {21.5, 0.1, 0.0, 0.0}, {-20.0, 0.0, 0.0, 0.0}, {1.4, 0.0, 0.0, 0.0}, {-0.2, -0.1, 0.0, 0.0}, {19.0, 0.0, -0.1, 0.0}, {20.5, 0.0, 0.0, 0.0}, {-2.0, 0.0, 0.0, 0.0}, {-17.6, -0.1, 0.0, 0.0}, {19.0, 0.0, 0.0, 0.0}, {-2.4, 0.0, 0.0, 0.0}, {-18.4, -0.1, 0.0, 0.0}, {17.1, 0.0, 0.0, 0.0}, {0.4, 0.0, 0.0, 0.0}, {18.4, 0.1, 0.0, 0.0}, {0.0, 17.4, 0.0, 0.0}, {-0.6, 0.0, 0.0, 0.0}, {-15.4, 0.0, 0.0, 0.0}, {-16.8, -0.1, 0.0, 0.0}, {16.3, 0.0, 0.0, 0.0}, {-2.0, 0.0, 0.0, 0.0}, {-1.5, 0.0, 0.0, 0.0}, {-14.3, -0.1, 0.0, 0.0}, {14.4, 0.0, 0.0, 0.0}, {-13.4, 0.0, 0.0, 0.0}, {-14.3, -0.1, 0.0, 0.0}, {-13.7, 0.0, 0.0, 0.0}, {13.1, 0.1, 0.0, 0.0}, {-1.7, 0.0, 0.0, 0.0}, {-12.8, 0.0, 0.0, 0.0}, {0.0, -14.4, 0.0, 0.0}, {12.4, 0.0, 0.0, 0.0}, {-12.0, 0.0, 0.0, 0.0}, {-0.8, 0.0, 0.0, 0.0}, {10.9, 0.1, 0.0, 0.0}, {-10.8, 0.0, 0.0, 0.0}, {10.5, 0.0, 0.0, 0.0}, {-10.4, 0.0, 0.0, 0.0}, {-11.2, 0.0, 0.0, 0.0}, {10.5, 0.1, 0.0, 0.0}, {-1.4, 0.0, 0.0, 0.0}, {0.0, 0.1, 0.0, 0.0}, {0.7, 0.0, 0.0, 0.0}, {-10.3, 0.0, 0.0, 0.0}, {-10.0, 0.0, 0.0, 0.0}, {9.6, 0.0, 0.0, 0.0}, {9.4, 0.1, 0.0, 0.0}, {0.6, 0.0, 0.0, 0.0}, {-87.7, 4.4, -0.4, -6.3}, {46.3, 22.4, 0.5, -2.4}, {15.6, -3.4, 0.1, 0.4}, {5.2, 5.8, 0.2, -0.1}, {-30.1, 26.9, 0.7, 0.0}, {23.2, -0.5, 0.0, 0.6}, {1.0, 23.2, 3.4, 0.0}, {-12.2, -4.3, 0.0, 0.0}, {-2.1, -3.7, -0.2, 0.1}, {-18.6, -3.8, -0.4, 1.8}, {5.5, -18.7, -1.8, -0.5}, {-5.5, -18.7, 1.8, -0.5}, {18.4, -3.6, 0.3, 0.9}, {-0.6, 1.3, 0.0, 0.0}, {-5.6, -19.5, 1.9, 0.0}, {5.5, -19.1, -1.9, 0.0}, {-17.3, -0.8, 0.0, 0.9}, {-3.2, -8.3, -0.8, 0.3}, {-0.1, 0.0, 0.0, 0.0}, {-5.4, 7.8, -0.3, 0.0}, {-14.8, 1.4, 0.0, 0.3}, {-3.8, 0.4, 0.0, -0.2}, {12.6, 3.2, 0.5, -1.5}, {0.1, 0.0, 0.0, 0.0}, {-13.6, 2.4, -0.1, 0.0}, {0.9, 1.2, 0.0, 0.0}, {-11.9, -0.5, 0.0, 0.3}, {0.4, 12.0, 0.3, -0.2}, {8.3, 6.1, -0.1, 0.1}, {0.0, 0.0, 0.0, 0.0}, {0.4, -10.8, 0.3, 0.0}, {9.6, 2.2, 0.3, -1.2}};
        int nterms = na.length;
        double t = (date - 51544.5) / 36525.0;
        double el = 2.355555743493879 + Math.IEEEremainder(t * (1.7179159232178E9 + t * (31.8792 + t * (0.051635 + t * -2.447E-4))), 1296000.0) * 4.84813681109536E-6;
        double elp = 6.240060126913283 + Math.IEEEremainder(t * (1.295965810481E8 + t * (-0.5532 + t * (1.36E-4 + t * -1.149E-5))), 1296000.0) * 4.84813681109536E-6;
        double f = 1.6279050815375191 + Math.IEEEremainder(t * (1.7395272628478E9 + t * (-12.7512 + t * (-0.001037 + t * 4.17E-6))), 1296000.0) * 4.84813681109536E-6;
        double d = 5.1984665886601995 + Math.IEEEremainder(t * (1.602961601209E9 + t * (-6.3706 + t * (0.006539 + t * -3.169E-5))), 1296000.0) * 4.84813681109536E-6;
        double om = 2.182439196615671 + Math.IEEEremainder(t * (-6962890.5431 + t * (7.4722 + t * (0.007702 + t * -5.939E-5))), 1296000.0) * 4.84813681109536E-6;
        double ve = 3.1761466969560757 + Math.IEEEremainder(2.10664136433548E8 * t, 1296000.0) * 4.84813681109536E-6;
        double ma = 6.203476112910622 + Math.IEEEremainder(6.8905077493988E7 * t, 1296000.0) * 4.84813681109536E-6;
        double ju = 0.599547105073534 + Math.IEEEremainder(1.0925660377991E7 * t, 1296000.0) * 4.84813681109536E-6;
        double sa = 0.8740162840190671 + Math.IEEEremainder(4399609.855732 * t, 1296000.0) * 4.84813681109536E-6;
        double dp = -153.1 * Math.sin(elp) - 1.9 * Math.sin(2.0 * elp);
        double de = 0.0;
        for (int j = nterms - 1; j >= 0; --j) {
            double theta = (double)na[j][0] * el + (double)na[j][1] * elp + (double)na[j][2] * f + (double)na[j][3] * d + (double)na[j][4] * om + (double)na[j][5] * ve + (double)na[j][6] * ma + (double)na[j][7] * ju + (double)na[j][8] * sa;
            double c = Math.cos(theta);
            double s = Math.sin(theta);
            dp += (psi[j][0] + psi[j][2] * t) * c + (psi[j][1] + psi[j][3] * t) * s;
            de += (eps[j][0] + eps[j][2] * t) * c + (eps[j][1] + eps[j][3] * t) * s;
        }
        double[] r = new double[]{(dp * 1.0E-6 - 0.042888 - 0.29856 * t) * 4.84813681109536E-6, (de * 1.0E-6 - 0.005171 - 0.02408 * t) * 4.84813681109536E-6, (84381.412 + (-46.80927 + (-1.52E-4 + (0.0019989 + (-5.1E-7 + -2.5E-8 * t) * t) * t) * t) * t) * 4.84813681109536E-6};
        return r;
    }

    private double[] Nutc_old(double date) {
        double[] result = new double[3];
        Pal.TRACE("Nutc");
        double t = (date - 51544.5) / 36525.0;
        double el = this.Drange(4.84813681109536E-6 * Pal.dmod(485866.733 + (1.717915922633E9 + (31.31 + 0.064 * t) * t) * t, 1296000.0));
        double elp = this.Drange(4.84813681109536E-6 * Pal.dmod(1287099.804 + (1.29596581224E8 + (-0.577 - 0.012 * t) * t) * t, 1296000.0));
        double f = this.Drange(4.84813681109536E-6 * Pal.dmod(335778.877 + (1.739527263137E9 + (-13.257 + 0.011 * t) * t) * t, 1296000.0));
        double d = this.Drange(4.84813681109536E-6 * Pal.dmod(1072261.307 + (1.602961601328E9 + (-6.891 + 0.019 * t) * t) * t, 1296000.0));
        double om = this.Drange(4.84813681109536E-6 * Pal.dmod(450160.28 + (-6962890.539 + (7.455 + 0.008 * t) * t) * t, 1296000.0));
        double el2 = el + el;
        double el3 = el2 + el;
        double elp2 = elp + elp;
        double f2 = f + f;
        double f4 = f2 + f2;
        double d2 = d + d;
        double d4 = d2 + d2;
        double om2 = om + om;
        double dp = 0.0;
        double de = 0.0;
        dp += Math.sin(elp + d);
        dp -= Math.sin(f2 + d4 + om2);
        dp += Math.sin(el2 + d2);
        dp -= Math.sin(el - f2 + d2);
        dp -= Math.sin(el + elp - d2 + om);
        dp -= Math.sin(-elp + f2 + om);
        dp -= Math.sin(el - f2 - d2);
        dp -= Math.sin(elp + d2);
        dp -= Math.sin(f2 - d + om2);
        dp -= Math.sin(-f2 + om);
        dp += Math.sin(-el - elp + d2 + om);
        dp += Math.sin(elp + f2 + om);
        dp -= Math.sin(el + f2 - d2);
        dp += Math.sin(el3 + f2 - d2 + om2);
        dp += Math.sin(f4 - d2 + om2);
        dp -= Math.sin(el + d2 + om);
        dp -= Math.sin(el2 + f2 + d2 + om2);
        double a = el2 + f2 - d2 + om;
        dp += Math.sin(a);
        de -= Math.cos(a);
        dp += Math.sin(el - elp - d2);
        dp += Math.sin(-el + f4 + om2);
        a = -el2 + f2 + d4 + om2;
        dp -= Math.sin(a);
        de += Math.cos(a);
        a = el + f2 + d2 + om;
        dp -= Math.sin(a);
        de += Math.cos(a);
        a = el + elp + f2 - d2 + om2;
        dp += Math.sin(a);
        de -= Math.cos(a);
        dp -= Math.sin(el2 - d4);
        a = -el + f2 + d4 + om2;
        dp -= 2.0 * Math.sin(a);
        de += Math.cos(a);
        a = -el2 + f2 + d2 + om2;
        dp += Math.sin(a);
        de -= Math.cos(a);
        dp -= Math.sin(el - d4);
        a = -el + om2;
        dp += Math.sin(a);
        de -= Math.cos(a);
        a = f2 + d + om2;
        dp += 2.0 * Math.sin(a);
        de -= Math.cos(a);
        dp += 2.0 * Math.sin(el3);
        a = el + om2;
        dp -= 2.0 * Math.sin(a);
        de += Math.cos(a);
        a = el2 + om;
        dp += 2.0 * Math.sin(a);
        de -= Math.cos(a);
        a = -el + f2 - d2 + om;
        dp -= 2.0 * Math.sin(a);
        de += Math.cos(a);
        a = el + elp + f2 + om2;
        dp += 2.0 * Math.sin(a);
        de -= Math.cos(a);
        a = -elp + f2 + d2 + om2;
        dp -= 3.0 * Math.sin(a);
        de += Math.cos(a);
        a = el3 + f2 + om2;
        dp -= 3.0 * Math.sin(a);
        de += Math.cos(a);
        a = -el2 + om;
        dp -= 2.0 * Math.sin(a);
        de += Math.cos(a);
        a = -el - elp + f2 + d2 + om2;
        dp -= 3.0 * Math.sin(a);
        de += Math.cos(a);
        a = el - elp + f2 + om2;
        dp -= 3.0 * Math.sin(a);
        de += Math.cos(a);
        dp += 3.0 * Math.sin(el + f2);
        dp -= 3.0 * Math.sin(el + elp);
        dp -= 4.0 * Math.sin(d);
        dp += 4.0 * Math.sin(el - f2);
        dp -= 4.0 * Math.sin(elp - d2);
        a = el2 + f2 + om;
        dp -= 5.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        dp += 5.0 * Math.sin(el - elp);
        a = -d2 + om;
        dp -= 5.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        a = el + f2 - d2 + om;
        dp += 6.0 * Math.sin(a);
        de -= 3.0 * Math.cos(a);
        a = f2 + d2 + om;
        dp -= 7.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        a = d2 + om;
        dp -= 6.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        a = el2 + f2 - d2 + om2;
        dp += 6.0 * Math.sin(a);
        de -= 3.0 * Math.cos(a);
        dp += 6.0 * Math.sin(el + d2);
        a = el + f2 + d2 + om2;
        dp -= 8.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        a = -elp + f2 + om2;
        dp -= 7.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        a = elp + f2 + om2;
        dp += 7.0 * Math.sin(a);
        de -= 3.0 * Math.cos(a);
        dp -= 7.0 * Math.sin(el + elp - d2);
        a = -el + f2 + d2 + om;
        dp -= 10.0 * Math.sin(a);
        de += 5.0 * Math.cos(a);
        a = el - d2 + om;
        dp -= 13.0 * Math.sin(a);
        de += 7.0 * Math.cos(a);
        a = -el + d2 + om;
        dp += 16.0 * Math.sin(a);
        de -= 8.0 * Math.cos(a);
        a = -el + f2 + om;
        dp += 21.0 * Math.sin(a);
        de -= 10.0 * Math.cos(a);
        dp += 26.0 * Math.sin(f2);
        de -= Math.cos(f2);
        a = el2 + f2 + om2;
        dp -= 31.0 * Math.sin(a);
        de += 13.0 * Math.cos(a);
        a = el + f2 - d2 + om2;
        dp += 29.0 * Math.sin(a);
        de -= 12.0 * Math.cos(a);
        dp += 29.0 * Math.sin(el2);
        de -= Math.cos(el2);
        a = f2 + d2 + om2;
        dp -= 38.0 * Math.sin(a);
        de += 16.0 * Math.cos(a);
        a = el + f2 + om;
        dp -= 51.0 * Math.sin(a);
        de += 27.0 * Math.cos(a);
        a = -el + f2 + d2 + om2;
        dp -= 59.0 * Math.sin(a);
        de += 26.0 * Math.cos(a);
        a = -el + om;
        dp += (-58.0 - 0.1 * t) * Math.sin(a);
        de += 32.0 * Math.cos(a);
        a = el + om;
        dp += (63.0 + 0.1 * t) * Math.sin(a);
        de -= 33.0 * Math.cos(a);
        dp += 63.0 * Math.sin(d2);
        de -= 2.0 * Math.cos(d2);
        a = -el + f2 + om2;
        dp += 123.0 * Math.sin(a);
        de -= 53.0 * Math.cos(a);
        a = el - d2;
        dp -= 158.0 * Math.sin(a);
        de -= Math.cos(a);
        a = el + f2 + om2;
        dp -= 301.0 * Math.sin(a);
        de += (129.0 - 0.1 * t) * Math.cos(a);
        a = f2 + om;
        dp += (-386.0 - 0.4 * t) * Math.sin(a);
        de += 200.0 * Math.cos(a);
        dp += (712.0 + 0.1 * t) * Math.sin(el);
        de -= 7.0 * Math.cos(el);
        a = f2 + om2;
        dp += (-2274.0 - 0.2 * t) * Math.sin(a);
        de += (977.0 - 0.5 * t) * Math.cos(a);
        dp -= Math.sin(elp + f2 - d2);
        dp += Math.sin(-el + d + om);
        dp += Math.sin(elp + om2);
        dp -= Math.sin(elp - f2 + d2);
        dp += Math.sin(-f2 + d2 + om);
        dp += Math.sin(el2 + elp - d2);
        dp -= 4.0 * Math.sin(el - d);
        a = elp + f2 - d2 + om;
        dp += 4.0 * Math.sin(a);
        de -= 2.0 * Math.cos(a);
        a = el2 - d2 + om;
        dp += 4.0 * Math.sin(a);
        de -= 2.0 * Math.cos(a);
        a = -elp + f2 - d2 + om;
        dp -= 5.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        a = -el2 + d2 + om;
        dp -= 6.0 * Math.sin(a);
        de += 3.0 * Math.cos(a);
        a = -elp + om;
        dp -= 12.0 * Math.sin(a);
        de += 6.0 * Math.cos(a);
        a = elp2 + f2 - d2 + om2;
        dp += (-16.0 + 0.1 * t) * Math.sin(a);
        de += 7.0 * Math.cos(a);
        a = elp + om;
        dp -= 15.0 * Math.sin(a);
        de += 9.0 * Math.cos(a);
        dp += (17.0 - 0.1 * t) * Math.sin(elp2);
        dp -= 22.0 * Math.sin(f2 - d2);
        a = el2 - d2;
        dp += 48.0 * Math.sin(a);
        de += Math.cos(a);
        a = f2 - d2 + om;
        dp += (129.0 + 0.1 * t) * Math.sin(a);
        de -= 70.0 * Math.cos(a);
        a = -elp + f2 - d2 + om2;
        dp += (217.0 - 0.5 * t) * Math.sin(a);
        de += (-95.0 + 0.3 * t) * Math.cos(a);
        a = elp + f2 - d2 + om2;
        dp += (-517.0 + 1.2 * t) * Math.sin(a);
        de += (224.0 - 0.6 * t) * Math.cos(a);
        dp += (1426.0 - 3.4 * t) * Math.sin(elp);
        de += (54.0 - 0.1 * t) * Math.cos(elp);
        a = f2 - d2 + om2;
        dp += (-13187.0 - 1.6 * t) * Math.sin(a);
        de += (5736.0 - 3.1 * t) * Math.cos(a);
        dp += Math.sin(el2 - f2 + om);
        a = -elp2 + f2 - d2 + om;
        dp -= 2.0 * Math.sin(a);
        de += Math.cos(a);
        dp -= 3.0 * Math.sin(el - elp - d);
        a = -el2 + f2 + om2;
        dp -= 3.0 * Math.sin(a);
        de += Math.cos(a);
        dp += 11.0 * Math.sin(el2 - f2);
        a = -el2 + f2 + om;
        dp += 46.0 * Math.sin(a);
        de -= 24.0 * Math.cos(a);
        dp += (2062.0 + 0.2 * t) * Math.sin(om2);
        de += (-895.0 + 0.5 * t) * Math.cos(om2);
        result[0] = (dp += (-171996.0 - 174.2 * t) * Math.sin(om)) * 4.84813681109536E-10;
        result[1] = (de += (92025.0 + 8.9 * t) * Math.cos(om)) * 4.84813681109536E-10;
        result[2] = 4.84813681109536E-6 * (84381.448 + (-46.815 + (-5.9E-4 + 0.001813 * t) * t) * t);
        Pal.ENDTRACE("Nutc");
        return result;
    }

    public Observatory Obs(int n) {
        return new Observatory(n);
    }

    public Observatory Obs(String id) {
        return new Observatory(id);
    }

    public AngleDR Pm(AngleDR r0, double[] pm, double px, double rv, double ep0, double ep1) {
        double vfr = 1.022712169831181E-6;
        double[] em = new double[3];
        double[] p = new double[3];
        Pal.TRACE("Pm");
        p = this.Dcs2c(r0);
        double r = r0.getAlpha();
        double d = r0.getDelta();
        double w = 1.022712169831181E-6 * rv * px;
        em[0] = -pm[0] * p[1] - pm[1] * Math.cos(r) * Math.sin(d) + w * p[0];
        em[1] = pm[0] * p[0] - pm[1] * Math.sin(r) * Math.sin(d) + w * p[1];
        em[2] = pm[1] * Math.cos(d) + w * p[2];
        double t = ep1 - ep0;
        for (int i = 0; i < 3; ++i) {
            p[i] = p[i] + t * em[i];
        }
        AngleDR r1 = this.Dcc2s(p);
        r1.setAlpha(this.Dranrm(r1.getAlpha()));
        Pal.ENDTRACE("Pm");
        return r1;
    }

    public double[][] Prebn(double bep0, double bep1) {
        Pal.TRACE("Prebn");
        double bigt = (bep0 - 1850.0) / 100.0;
        double t = (bep1 - bep0) / 100.0;
        double tas2r = t * 4.84813681109536E-6;
        double w = 2303.5548 + (1.3972 + 5.9E-5 * bigt) * bigt;
        double zeta = (w + (0.30242 - 2.69E-4 * bigt + 0.017996 * t) * t) * tas2r;
        double z = (w + (1.09478 + 3.87E-4 * bigt + 0.018324 * t) * t) * tas2r;
        double theta = (2005.1125 + (-0.85294 - 3.65E-4 * bigt) * bigt + (-0.42647 - 3.65E-4 * bigt - 0.041802 * t) * t) * tas2r;
        Pal.ENDTRACE("Prebn");
        return this.Deuler("ZYZ", -zeta, theta, -z);
    }

    public double[][] Prec(double ep0, double ep1) {
        Pal.TRACE("Prec");
        double t0 = (ep0 - 2000.0) / 100.0;
        double t = (ep1 - ep0) / 100.0;
        double tas2r = t * 4.84813681109536E-6;
        double w = 2306.2181 + (1.39656 - 1.39E-4 * t0) * t0;
        double zeta = (w + (0.30188 - 3.44E-4 * t0 + 0.017998 * t) * t) * tas2r;
        double z = (w + (1.09468 + 6.6E-5 * t0 + 0.018203 * t) * t) * tas2r;
        double theta = (2004.3109 + (-0.8533 - 2.17E-4 * t0) * t0 + (-0.42665 - 2.17E-4 * t0 - 0.041833 * t) * t) * tas2r;
        Pal.ENDTRACE("Prec");
        return this.Deuler("ZYZ", -zeta, theta, -z);
    }

    public AngleDR Preces(String sys, double ep0, double ep1, AngleDR d) {
        Pal.TRACE("Preces");
        boolean fk4 = sys.toUpperCase().equals("FK4");
        boolean fk5 = sys.toUpperCase().equals("FK5");
        if (fk4 || fk5) {
            double[][] pm = fk4 ? this.Prebn(ep0, ep1) : this.Prec(ep0, ep1);
            double[] v1 = this.Dcs2c(d);
            double[] v2 = this.Dmxv(pm, v1);
            d = this.Dcc2s(v2);
            d.setAlpha(this.Dranrm(d.getAlpha()));
        } else {
            d = new AngleDR(-99.0, -99.0);
        }
        Pal.ENDTRACE("Preces");
        return d;
    }

    public double[][] Precl(double ep0, double ep1) {
        Pal.TRACE("Precl");
        double t0 = (ep0 - 2000.0) / 1000.0;
        double t = (ep1 - ep0) / 1000.0;
        double tas2r = t * 4.84813681109536E-6;
        double w = 23060.9097 + (139.7459 + (-0.0038 + (-0.5918 + (-0.0037 + 7.0E-4 * t0) * t0) * t0) * t0) * t0;
        double zeta = (w + (30.2226 + (-0.2523 + (-0.384 + (-0.0014 + 7.0E-4 * t0) * t0) * t0) * t0 + (18.0183 + (-0.1326 + (6.0E-4 + 5.0E-4 * t0) * t0) * t0 + (-0.0583 + (-1.0E-4 + 7.0E-4 * t0) * t0 + (-0.0285 + -2.0E-4 * t) * t) * t) * t) * t) * tas2r;
        double z = (w + (109.527 + (0.2446 + (-1.3913 + (-0.0134 + 0.0026 * t0) * t0) * t0) * t0 + (18.2667 + (-1.14 + (-0.0173 + 0.0044 * t0) * t0) * t0 + (-0.2821 + (-0.0093 + 0.0032 * t0) * t0 + (-0.0301 + 6.0E-4 * t0 - 1.0E-4 * t) * t) * t) * t) * t) * tas2r;
        double theta = (20042.0207 + (-85.3131 + (-0.2111 + (0.3642 + (8.0E-4 + -5.0E-4 * t0) * t0) * t0) * t0) * t0 + (-42.6566 + (-0.2111 + (0.5463 + (0.0017 + -0.0012 * t0) * t0) * t0) * t0 + (-41.8238 + (0.0359 + (0.0027 + -1.0E-4 * t0) * t0) * t0 + (-0.0731 + (0.0019 + 9.0E-4 * t0) * t0 + (-0.0127 + 0.0011 * t0 + 4.0E-4 * t) * t) * t) * t) * t) * tas2r;
        double[][] rmatp = this.Deuler("ZYZ", -zeta, theta, -z);
        Pal.ENDTRACE("Precl");
        return rmatp;
    }

    public double[][] Prenut(double epoch, double date) {
        Pal.TRACE("Prenut");
        double[][] rmatp = this.Prec(epoch, this.Epj(date));
        double[][] rmatn = this.Nut(date);
        rmatn = this.Dmxm(rmatn, rmatp);
        Pal.ENDTRACE("Prenut");
        return rmatn;
    }

    public double[] Refco(double hm, double tdk, double pmb, double rh, double wl, double phi, double tlr, double eps) {
        Pal.TRACE("Refco");
        double[] ref = new double[2];
        double atn1 = 0.7853981633974483;
        double atn4 = 1.325817663668033;
        double r1 = this.Refro(0.7853981633974483, hm, tdk, pmb, rh, wl, phi, tlr, eps);
        double r2 = this.Refro(1.325817663668033, hm, tdk, pmb, rh, wl, phi, tlr, eps);
        ref[0] = (64.0 * r1 - r2) / 60.0;
        ref[1] = (r2 - 4.0 * r1) / 60.0;
        Pal.ENDTRACE("Refco");
        return ref;
    }

    public double Refro(double zobs, double hm, double tdk, double pmb, double rh, double wl, double phi, double tlr, double eps) {
        Pal.TRACE("Refro");
        double d93 = 1.623156204;
        double gcr = 8314.32;
        double dmd = 28.9644;
        double dmw = 18.0152;
        double s = 6378120.0;
        double delta = 18.36;
        double ht = 11000.0;
        double hs = 80000.0;
        double refp = 0.0;
        double reft = 0.0;
        double zobs1 = this.Drange(zobs);
        double zobs2 = Math.abs(zobs1);
        zobs2 = Pal.gmin(zobs2, 1.623156204);
        double hmok = Pal.gmax(hm, -1000.0);
        hmok = Pal.gmin(hmok, 80000.0);
        double tdkok = Pal.gmax(tdk, 100.0);
        tdkok = Pal.gmin(tdkok, 500.0);
        double pmbok = Pal.gmax(pmb, 0.0);
        pmbok = Pal.gmin(pmbok, 10000.0);
        double rhok = Pal.gmax(rh, 0.0);
        rhok = Pal.gmin(rhok, 1.0);
        double wlok = Pal.gmax(wl, 0.1);
        double alpha = Math.abs(tlr);
        alpha = Pal.gmax(alpha, 0.001);
        alpha = Pal.gmin(alpha, 0.01);
        double w = Math.abs(eps);
        w = Pal.gmax(w, 1.0E-12);
        double tol = Pal.gmin(w, 0.1) / 2.0;
        boolean optic = wlok <= 100.0;
        double wlsq = wlok * wlok;
        double gb = 9.784 * (1.0 - 0.0026 * Math.cos(2.0 * phi) - 2.8E-7 * hmok);
        double a = optic ? (287.604 + 1.6288 / wlsq + 0.0136 / (wlsq * wlsq)) * 273.15 / 1013.25 * 1.0E-6 : 7.7689E-5;
        double gamal = gb * 28.9644 / 8314.32;
        double gamma = gamal / alpha;
        double gamm2 = gamma - 2.0;
        double delm2 = 16.36;
        double tdc = tdkok - 273.15;
        double psat = Math.pow(10.0, (0.7859 + 0.03477 * tdc) / (1.0 + 0.00412 * tdc)) * (1.0 + pmbok * (4.5E-6 + 6.0E-10 * tdc * tdc));
        double pwo = pmbok > 0.0 ? rhok * psat / (1.0 - (1.0 - rhok) * psat / pmbok) : 0.0;
        w = pwo * 0.3780226761127453 * gamma / (18.36 - gamma);
        double c1 = a * (pmbok + w) / tdkok;
        double c2 = (a * w + (optic ? 1.12684E-5 : 6.3938E-6) * pwo) / tdkok;
        double c3 = (gamma - 1.0) * alpha * c1 / tdkok;
        double c4 = 17.36 * alpha * c2 / tdkok;
        double c5 = optic ? 0.0 : 0.375463 * pwo / tdkok;
        double c6 = c5 * delm2 * alpha / (tdkok * tdkok);
        double robs = 6378120.0 + hmok;
        double[] a3 = Pal.atmt(robs, tdkok, alpha, gamm2, delm2, c1, c2, c3, c4, c5, c6, robs);
        double tempo = a3[0];
        double dn0 = a3[1];
        double rdndr0 = a3[2];
        double sk0 = dn0 * robs * Math.sin(zobs2);
        double f0 = Pal.refi(dn0, rdndr0);
        double rt = 6378120.0 + Pal.gmax(11000.0, hmok);
        a3 = Pal.atmt(robs, tdkok, alpha, gamm2, delm2, c1, c2, c3, c4, c5, c6, rt);
        double tt = a3[0];
        double dnt = a3[1];
        double rdndrt = a3[2];
        double zt = Math.asin(sk0 / (rt * dnt));
        double ft = Pal.refi(dnt, rdndrt);
        double[] a2 = Pal.atms(rt, tt, dnt, gamal, rt);
        double dnts = a2[0];
        double rdndrp = a2[1];
        double zts = Math.asin(sk0 / (rt * dnts));
        double fts = Pal.refi(dnts, rdndrp);
        double rs = 6458120.0;
        a2 = Pal.atms(rt, tt, dnt, gamal, rs);
        double dns = a2[0];
        double rdndrs = a2[1];
        double zs = Math.asin(sk0 / (rs * dns));
        double fs = Pal.refi(dns, rdndrs);
        block0: for (int k = 1; k <= 2; ++k) {
            double ff;
            double fb;
            double zrange;
            double z0;
            double refold = 1.0;
            int is = 8;
            if (k == 1) {
                z0 = zobs2;
                zrange = zt - z0;
                fb = f0;
                ff = ft;
            } else {
                z0 = zts;
                zrange = zs - z0;
                fb = fts;
                ff = fs;
            }
            double fo = 0.0;
            double fe = 0.0;
            int n = 1;
            while (true) {
                double h = zrange / (double)is;
                double r = k == 1 ? robs : rt;
                for (int i = 1; i < is; i += n) {
                    double rdndr;
                    double dn;
                    double sz = Math.sin(z0 + h * (double)i);
                    if (sz > 1.0E-20) {
                        double dr;
                        w = sk0 / sz;
                        double rg = r;
                        int j = 0;
                        do {
                            if (k == 1) {
                                a3 = Pal.atmt(robs, tdkok, alpha, gamm2, delm2, c1, c2, c3, c4, c5, c6, rg);
                                double tg = a3[0];
                                dn = a3[1];
                                rdndr = a3[2];
                            } else {
                                a2 = Pal.atms(rt, tt, dnt, gamal, rg);
                                dn = a2[0];
                                rdndr = a2[1];
                            }
                            dr = (rg * dn - w) / (dn + rdndr);
                            rg -= dr;
                        } while (Math.abs(dr) > 1.0 && j++ <= 4);
                        r = rg;
                    }
                    if (k == 1) {
                        a3 = Pal.atmt(robs, tdkok, alpha, gamm2, delm2, c1, c2, c3, c4, c5, c6, r);
                        double t = a3[0];
                        dn = a3[1];
                        rdndr = a3[2];
                    } else {
                        a2 = Pal.atms(rt, tt, dnt, gamal, r);
                        dn = a2[0];
                        rdndr = a2[1];
                    }
                    double f = Pal.refi(dn, rdndr);
                    if (n == 1 && i % 2 == 0) {
                        fe += f;
                        continue;
                    }
                    fo += f;
                }
                refp = h * (fb + 4.0 * fo + 2.0 * fe + ff) / 3.0;
                if (k == 1) {
                    reft = refp;
                }
                if (Math.abs(refp - refold) <= tol || is >= 16384) continue block0;
                refold = refp;
                is += is;
                fe += fo;
                fo = 0.0;
                n = 2;
            }
        }
        double ref = reft + refp;
        if (zobs1 < 0.0) {
            ref = -ref;
        }
        Pal.ENDTRACE("Refro");
        return ref;
    }

    private static double[] atmt(double robs, double tdkok, double alpha, double gamm2, double delm2, double c1, double c2, double c3, double c4, double c5, double c6, double r) {
        double[] t = new double[3];
        Pal.TRACE("atmt");
        double w = tdkok - alpha * (r - robs);
        w = Pal.gmin(w, 320.0);
        w = Pal.gmax(w, 100.0);
        double tt0 = w / tdkok;
        double tt0gm2 = Math.pow(tt0, gamm2);
        double tt0dm2 = Math.pow(tt0, delm2);
        t[0] = w;
        t[1] = 1.0 + (c1 * tt0gm2 - (c2 - c5 / w) * tt0dm2) * tt0;
        t[2] = r * (-c3 * tt0gm2 + (c4 - c6 / tt0) * tt0dm2);
        Pal.ENDTRACE("atmt");
        return t;
    }

    private static double[] atms(double rt, double tt, double dnt, double gamal, double r) {
        double[] dn = new double[2];
        Pal.TRACE("atms");
        double b = gamal / tt;
        double w = (dnt - 1.0) * Math.exp(-b * (r - rt));
        dn[0] = 1.0 + w;
        dn[1] = -r * b * w;
        Pal.ENDTRACE("atms");
        return dn;
    }

    public AngleDR Subet(AngleDR rc, double eq) {
        Pal.TRACE("Subet");
        double[] a = this.Etrms(eq);
        double[] v = this.Dcs2c(rc);
        double f = 1.0 + this.Dvdv(v, a);
        for (int i = 0; i < 3; ++i) {
            v[i] = f * v[i] - a[i];
        }
        AngleDR m = this.Dcc2s(v);
        m.setAlpha(this.Dranrm(m.getAlpha()));
        Pal.ENDTRACE("Subet");
        return m;
    }

    public Galactic Supgal(Galactic ds) {
        double[][] rmat = new double[][]{{-0.735742574804, 0.677261296414, 0.0}, {-0.074553778365, -0.080991471307, 0.9939225904}, {0.673145302109, 0.731271165817, 0.110081262225}};
        Pal.TRACE("Supgal");
        AngleDR d = new AngleDR(ds.getLongitude(), ds.getLatitude());
        double[] v1 = this.Dcs2c(d);
        double[] v2 = this.Dimxv(rmat, v1);
        d = this.Dcc2s(v2);
        Pal.ENDTRACE("Supgal");
        return new Galactic(this.Dranrm(d.getAlpha()), this.Drange(d.getDelta()));
    }

    public double Zd(double ha, double dec, double phi) {
        Pal.TRACE("Zd");
        double sh = Math.sin(ha);
        double ch = Math.cos(ha);
        double sd = Math.sin(dec);
        double cd = Math.cos(dec);
        double sp = Math.sin(phi);
        double cp = Math.cos(phi);
        double x = ch * cd * sp - sd * cp;
        double y = sh * cd;
        double z = ch * cd * cp + sd * sp;
        Pal.ENDTRACE("Zd");
        return Math.atan2(Math.sqrt(x * x + y * y), z);
    }
}

