/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import skyview.executive.Settings;
import skyview.survey.ImageGenerator;
import skyview.survey.Util;

public class TwoMASSGenerator
implements ImageGenerator {
    ArrayList<String> spells = new ArrayList();

    @Override
    public void getImages(double ra, double dec, double size, ArrayList<String> spells) {
        String urlString = Settings.get("SiapURL");
        urlString = urlString + "POS=" + ra + "," + dec + "&SIZE=" + size;
        System.err.println("  SIAP URL:" + urlString);
        int timeout = 15000;
        if (Settings.has("SIATimeout")) {
            try {
                timeout = Integer.parseInt("SIATimeout") * 1000;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            int len;
            URL siaURL = new URL(urlString);
            URLConnection conn = siaURL.openConnection();
            System.err.println("Setting timeout to:" + timeout);
            conn.setReadTimeout(timeout);
            BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream bo = new ByteArrayOutputStream(32768);
            byte[] buf = new byte[32768];
            while ((len = bi.read(buf)) > 0) {
                bo.write(buf, 0, len);
            }
            bi.close();
            bo.close();
            String response = bo.toString();
            response = response.replaceAll("<!DOCTYPE.*", "");
            ByteArrayInputStream byi = new ByteArrayInputStream(response.getBytes());
            try {
                SAXParserFactory sf = SAXParserFactory.newInstance();
                sf.setValidating(false);
                SAXParser sp = sf.newSAXParser();
                sp.parse((InputStream)byi, (DefaultHandler)new SIAPParserCallBack(spells));
            }
            catch (Exception e) {
                System.err.println("  SIAP error:" + e);
                e.printStackTrace(System.err);
                throw new Error("Error parsing SIAP:" + e);
            }
        }
        catch (SocketTimeoutException e) {
            System.err.println("Timeout querying SIA URL:" + urlString);
            return;
        }
        catch (Exception e) {
            throw new Error("Unable to do IO in SIAP processing:" + e);
        }
    }

    private class SIAPParserCallBack
    extends DefaultHandler {
        private StringBuffer buf;
        private boolean active = false;
        private int fieldCount = 0;
        private HashMap<String, Integer> fields = new HashMap();
        private ArrayList<String> values = new ArrayList();
        private String proj = Settings.get("SIAPProjection");
        private String csys = Settings.get("SIAPCoordinates");
        private String naxis = Settings.get("SIAPNaxis");
        private String scaling = Settings.get("SIAPScaling");
        private String filterValue = Settings.get("SIAPFilter");
        private String filterField = Settings.get("SIAPFilterField");
        ArrayList<String> spells;

        SIAPParserCallBack(ArrayList<String> spells) {
            this.spells = spells;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            if (qName.equals("FIELD")) {
                String id;
                String ucd = attrib.getValue("ucd");
                if (ucd != null && ucd.length() > 1) {
                    this.fields.put(ucd, this.fieldCount);
                }
                if ((id = attrib.getValue("ID")) != null) {
                    this.fields.put(id, this.fieldCount);
                }
                ++this.fieldCount;
            } else if (qName.equals("TR")) {
                this.values.clear();
            } else if (qName.equals("TD")) {
                this.active = true;
                this.buf = new StringBuffer();
            }
        }

        private String getUCD(String ucd) {
            if (this.fields.containsKey(ucd)) {
                int i = this.fields.get(ucd);
                return this.values.get(i);
            }
            return null;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.active) {
                this.active = false;
                String s = new String(this.buf).trim();
                if (qName.equals("TD")) {
                    this.values.add(s);
                }
            } else if (qName.equals("TR")) {
                if (!this.getUCD("VOX:Image_Format").equals("image/fits")) {
                    return;
                }
                if (!this.getUCD(this.filterField).equals(this.filterValue)) {
                    return;
                }
                String spell = "";
                String url = this.getUCD("VOX:Image_AccessReference");
                String file = url.substring(url.lastIndexOf(47) + 1);
                file = Util.replace(file, ".*name=", "", false);
                file = Util.replace(file, ".fits", "", false);
                String coadd = this.getUCD("coadd_key");
                file = file + "." + coadd + ".fits.gz";
                String ra = this.getUCD("POS_EQ_RA_MAIN");
                String dec = this.getUCD("POS_EQ_DEC_MAIN");
                String crval = this.getUCD("VOX:WCS_CoordRefValue");
                crval = Util.replace(crval, "(\\S)\\s+(\\S)", "$1,$2", true);
                String crota = this.getUCD("crota2");
                double rot = Math.toRadians(Double.parseDouble(crota));
                String scale = this.getUCD("VOX:Image_Scale");
                String[] scales = Pattern.compile(" +").split(scale);
                double xs = Double.parseDouble(scales[0]);
                double ys = Double.parseDouble(scales[1]);
                String scaling = Math.cos(rot) * xs + "," + Math.sin(rot) * xs + "," + Math.sin(rot) * ys + "," + Math.cos(rot) * ys;
                if (this.naxis == null) {
                    this.naxis = this.getUCD("VOX:Image_Naxis");
                    this.naxis = Util.replace(this.naxis, "(\\S)\\s+(\\S)", "$1,$2", true);
                }
                spell = url + "," + file + "," + crval + "," + this.proj + "," + this.csys + "," + this.naxis + "," + scaling;
                this.spells.add(spell);
            }
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }
}

