/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import skyview.executive.Settings;
import skyview.survey.ImageGenerator;

public class SIAPGenerator
implements ImageGenerator {
    ArrayList<String> spells = new ArrayList();
    String filterField;
    String filterValue;
    boolean filtering;

    protected String getBaseURL() {
        return Settings.get("SiapURL");
    }

    @Override
    public void getImages(double ra, double dec, double size, ArrayList<String> spells) {
        String urlString = this.getBaseURL();
        this.filterField = Settings.get("SIAPFilterField");
        this.filterValue = Settings.get("SIAPFilterValue");
        this.filtering = this.filterField != null && this.filterValue != null;
        int timeout = 15000;
        if (Settings.has("SIATimeout")) {
            try {
                timeout = Integer.parseInt("SIATimeout") * 1000;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        urlString = urlString + "&POS=" + ra + "," + dec + "&SIZE=" + 1.4 * size;
        System.err.println("  SIAP request URL:" + urlString);
        try {
            int len;
            URL siaURL = new URL(urlString);
            URLConnection conn = siaURL.openConnection();
            conn.setReadTimeout(timeout);
            BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream bo = new ByteArrayOutputStream(32768);
            byte[] buf = new byte[32768];
            while ((len = bi.read(buf)) > 0) {
                bo.write(buf, 0, len);
            }
            bi.close();
            bo.close();
            String response = bo.toString();
            response = response.replaceAll("<!DOCTYPE.*", "");
            ByteArrayInputStream byi = new ByteArrayInputStream(response.getBytes());
            try {
                SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
                sp.parse((InputStream)byi, (DefaultHandler)new SIAPParserCallBack(spells));
            }
            catch (Exception e) {
                throw new Error("Error parsing SIAP:" + e);
            }
        }
        catch (SocketTimeoutException e) {
            System.err.println("Timeout querying SIA URL:" + urlString);
            return;
        }
        catch (Exception e) {
            throw new Error("Unable to do IO in SIAP processing:" + e);
        }
    }

    private class SIAPParserCallBack
    extends DefaultHandler {
        private StringBuffer buf;
        private boolean active = false;
        private int fieldCount = 0;
        private HashMap<String, Integer> fields = new HashMap();
        private ArrayList<String> values = new ArrayList();
        private String proj = Settings.get("SIAPProjection");
        private String csys = Settings.get("SIAPCoordinates");
        private String naxis = Settings.get("SIAPNaxis");
        private String scaling = Settings.get("SIAPScaling");
        private String maxImageString = Settings.get("SIAPMaxImages");
        private int maxImages;
        private int imageCount = 0;
        ArrayList<String> spells;

        SIAPParserCallBack(ArrayList<String> spells) {
            this.spells = spells;
            if (this.maxImageString != null) {
                this.maxImages = Integer.parseInt(this.maxImageString);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            if (qName.equals("FIELD")) {
                String id;
                String name;
                String ucd = attrib.getValue("ucd");
                if (ucd != null && ucd.length() > 0) {
                    this.fields.put(ucd.toUpperCase(), this.fieldCount);
                }
                if ((name = attrib.getValue("name")) != null && name.length() > 0) {
                    this.fields.put(name, this.fieldCount);
                }
                if ((id = attrib.getValue("ID")) != null && id.length() > 0) {
                    this.fields.put(id, this.fieldCount);
                }
                ++this.fieldCount;
            } else if (qName.equals("TR")) {
                this.values.clear();
            } else if (qName.equals("TD")) {
                this.active = true;
                this.buf = new StringBuffer();
            }
        }

        private String getFieldValue(String id) {
            if (this.fields.containsKey(id = id.toUpperCase())) {
                int i = this.fields.get(id);
                return this.values.get(i);
            }
            return null;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.active) {
                this.active = false;
                String s = new String(this.buf).trim();
                if (qName.equals("TD")) {
                    this.values.add(s);
                }
            } else if (qName.equals("TR")) {
                String filter;
                String format = this.getFieldValue("VOX:Image_Format").toLowerCase();
                if (format.indexOf("fits") < 0) {
                    return;
                }
                if (SIAPGenerator.this.filtering && (filter = this.getFieldValue(SIAPGenerator.this.filterField)) != null && !filter.equals(SIAPGenerator.this.filterValue)) {
                    return;
                }
                if (this.maxImageString != null && this.imageCount >= this.maxImages) {
                    return;
                }
                String spell = "";
                String url = this.getFieldValue("VOX:Image_AccessReference");
                String file = this.getFieldValue("VOX:File_Name");
                if (file == null) {
                    file = url.substring(url.lastIndexOf(47) + 1);
                }
                String ra = this.getFieldValue("POS_EQ_RA_MAIN");
                String dec = this.getFieldValue("POS_EQ_DEC_MAIN");
                if (ra == null) {
                    ra = this.getFieldValue("pos.eq.ra;meta.main");
                }
                if (dec == null) {
                    dec = this.getFieldValue("pos.eq.dec;meta.main");
                }
                boolean invert = false;
                String projstr = this.getFieldValue("VOX:WCS_CoordProjection");
                if (projstr != null) {
                    invert = this.proj.matches(".*\\-(DEC|LAT).*\\-(RA|LON).*");
                }
                String crval = this.mashVal(this.getFieldValue("VOX:WCS_CoordRefValue"), invert, 2);
                if (this.scaling == null) {
                    this.scaling = this.mashVal(this.getFieldValue("VOX:WCS_CDMatrix"), invert, 4);
                }
                if (this.scaling == null) {
                    this.scaling = this.mashVal(this.getFieldValue("VOX:Image_Scale"), invert, 2);
                }
                if (this.naxis == null) {
                    this.naxis = this.mashVal(this.getFieldValue("VOX:Image_Naxis"), invert, 2);
                }
                if (crval == null) {
                    crval = ra + "," + dec;
                }
                spell = url + "," + file + "," + crval + "," + this.proj + "," + this.csys + "," + this.naxis + "," + this.scaling;
                this.spells.add(spell);
                ++this.imageCount;
            }
        }

        private String mashVal(String input, boolean invert, int count) {
            if (input == null) {
                return null;
            }
            String[] tokens = (input = input.trim()).split(" ");
            if (tokens.length == 1) {
                tokens = input.split(",");
            }
            String output = "";
            int curr = 0;
            int delta = 1;
            if (invert) {
                curr = tokens.length - 1;
                delta = -1;
            }
            String sep = "";
            for (int i = 0; i < tokens.length; ++i) {
                output = output + sep + tokens[curr];
                curr += delta;
                sep = ",";
            }
            if (tokens.length < count) {
                String last = tokens[tokens.length - 1];
                for (int i = tokens.length; i < count; ++i) {
                    output = output + sep + last;
                    sep = ",";
                }
            }
            return output;
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }
}

