/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class Hpx
extends Projecter {
    private int[] tileNum = new int[]{-1, -1, -1, 11, -1, -1, 10, 7, -1, 9, 6, 2, 8, 5, 1, -1, 4, 0, -1, -1, 3, -1, -1, -1};
    private static final double[][] tileOffsets = new double[][]{{Math.PI * 2, 0.0}};
    private double[] botLeftX = new double[]{-1.0, 0.0, 1.0, -2.0, -2.0, -1.0, 0.0, 1.0, -2.0, -1.0, 0.0, 1.0};
    private double[] botLeftY = new double[]{1.0, 0.0, -1.0, 2.0, 1.0, 0.0, -1.0, -2.0, 0.0, -1.0, -2.0, -3.0};
    private static final double[] error = new double[]{Double.NaN, Double.NaN, Double.NaN};
    private double[] zp = new double[]{2.356194490192345, 0.0};
    private double isqrt2 = 1.0 / Math.sqrt(2.0);
    private int nSide;
    private int nPixel;
    private int nSq;
    private int dim;
    private double sqDelta;
    private final double squareLength = Math.PI * this.isqrt2 / 2.0;

    public Hpx() {
        this(9);
    }

    public Hpx(int dim) {
        this.setDimension(dim);
    }

    public void setDimension(int dim) {
        this.dim = dim;
        this.nSide = (int)Math.pow(2.0, dim);
        this.nSq = this.nSide * this.nSide;
        this.nPixel = 12 * this.nSq;
        this.sqDelta = 1.0 / (double)this.nSide;
    }

    @Override
    public String getName() {
        return "Hpx";
    }

    @Override
    public String getDescription() {
        return "HEALPix projection";
    }

    @Override
    public Deprojecter inverse() {
        return new HpxDeproj();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return false;
    }

    @Override
    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && Math.abs(plane[1]) <= 1.5707963267948966 - Math.abs(0.7853981633974483 - Math.abs(plane[0]) % Math.PI / 2.0);
    }

    public double[] getOblCorner(int pix) {
        if (pix < 0 || pix >= this.nPixel) {
            return new double[]{Double.NaN, Double.NaN};
        }
        int square = pix / this.nSq;
        int rem = pix % this.nSq;
        double delta = 0.5;
        double x = this.botLeftX[square];
        double y = this.botLeftY[square];
        for (int div = this.nSide / 2; div > 0; div /= 2) {
            int test = rem / div;
            int nrem = rem % div;
            x += (double)(rem % 2) * delta;
            y += (double)(rem / 2) * delta;
            delta /= 2.0;
            rem = nrem;
        }
        return new double[]{x, y};
    }

    public double[][] getCorners(int pix) {
        double[][] z = new double[4][2];
        z[0] = this.getOblCorner(pix);
        z[1][0] = z[0][0] + this.sqDelta;
        z[1][1] = z[0][1];
        z[2][0] = z[1][0];
        z[2][1] = z[0][1] + this.sqDelta;
        z[3][0] = z[0][0];
        z[3][1] = z[2][1];
        for (int i = 0; i < z.length; ++i) {
            double[] t = z[i];
            double u = t[0];
            double v = t[1];
            t[0] = this.squareLength * (this.isqrt2 * u - this.isqrt2 * v) + this.zp[0];
            if (t[0] > Math.PI * 2) {
                t[0] = t[0] - Math.PI * 2;
            } else if (t[0] < 0.0) {
                t[0] = t[0] + Math.PI * 2;
            }
            t[1] = this.squareLength * (this.isqrt2 * u + this.isqrt2 * v) + this.zp[1];
        }
        return z;
    }

    public static void deproj(double[] in, double[] unit) {
        double sdec;
        double ra;
        double x = in[0];
        double y = in[1];
        if (x < 0.0) {
            x += Math.PI * 2;
        }
        if (x > Math.PI * 2) {
            x -= Math.PI * 2;
        }
        if (Math.abs(y) > 1.5707963267948966) {
            System.arraycopy(error, 0, unit, 0, error.length);
            return;
        }
        if (Math.abs(y) > 0.7853981633974483) {
            double posit = x / Math.PI % 0.5;
            double yt = Math.abs(y) / Math.PI;
            if (yt > 0.5 - Math.abs(posit - 0.25) + 1.0E-13) {
                System.arraycopy(error, 0, unit, 0, error.length);
                return;
            }
        }
        if (Math.abs(y) < 0.7853981633974483) {
            ra = x;
            sdec = 8.0 * y / (Math.PI * 3);
        } else {
            double xt;
            double yabs = Math.abs(y);
            ra = x - (yabs - 0.7853981633974483) / (yabs - 1.5707963267948966) * ((xt = x % 1.5707963267948966) - 0.7853981633974483);
            if (Double.isNaN(ra)) {
                ra = 0.0;
            }
            if ((sdec = (1.0 - (2.0 - 4.0 * yabs / Math.PI) * (2.0 - 4.0 * yabs / Math.PI) / 3.0) * y / yabs) > 1.0) {
                sdec = 1.0;
            } else if (sdec < -1.0) {
                sdec = -1.0;
            }
        }
        double cdec = Math.sqrt(1.0 - sdec * sdec);
        unit[0] = Math.cos(ra) * cdec;
        unit[1] = Math.sin(ra) * cdec;
        unit[2] = sdec;
    }

    public static void proj(double[] unit, double[] proj) {
        if (Math.abs(unit[2]) < 0.6666666666666666) {
            proj[0] = Math.atan2(unit[1], unit[0]);
            if (proj[0] < 0.0) {
                proj[0] = proj[0] + Math.PI * 2;
            }
            proj[1] = 1.1780972450961724 * unit[2];
        } else {
            double phi = Math.atan2(unit[1], unit[0]);
            if (phi < 0.0) {
                phi += Math.PI * 2;
            }
            double phit = phi % 1.5707963267948966;
            double z = unit[2];
            double sign = 1.0;
            if (z < 0.0) {
                z = -z;
                sign = -1.0;
            }
            double sigma = sign * (2.0 - Math.sqrt(3.0 * (1.0 - z)));
            proj[0] = phi - (Math.abs(sigma) - 1.0) * (phit - 0.7853981633974483);
            proj[1] = Math.PI * sigma / 4.0;
        }
        double x = proj[0] / Math.PI;
        double y = proj[1] / Math.PI;
        if (x > 1.5 && y > 1.75 - x) {
            proj[0] = proj[0] - Math.PI * 2;
        }
    }

    @Override
    public void transform(double[] sphere, double[] plane) {
        Hpx.proj(sphere, plane);
    }

    public int getPixel(double[] pos) {
        return this.getPixel(pos[0], pos[1]);
    }

    public int getPixel(double x, double y) {
        if (x < 0.0) {
            x += Math.PI * 2;
        } else if (x > Math.PI * 2) {
            x -= Math.PI * 2;
        }
        double u = ((x -= this.zp[0]) * this.isqrt2 + (y -= this.zp[1]) * this.isqrt2) / this.squareLength;
        double v = (-x * this.isqrt2 + y * this.isqrt2) / this.squareLength;
        return this.getObliquePixel(u, v);
    }

    public int getObliquePixel(double u, double v) {
        double xSq = Math.floor(u);
        double ySq = Math.floor(v);
        if (xSq < -2.0 || xSq >= 2.0) {
            int ix = (int)xSq + 2;
            ySq += (double)(4 * (ix / 4));
            xSq = ix % 4;
            if (xSq < 0.0) {
                xSq += 4.0;
            }
            xSq -= 2.0;
        }
        int td = (int)(xSq + 2.0 + 4.0 * (ySq + 3.0));
        if (ySq < -3.0 || ySq >= 3.0) {
            td = -1;
        }
        int tile = -1;
        if (td >= 0 && td < this.tileNum.length) {
            tile = this.tileNum[td];
        }
        if (tile == -1) {
            return -1;
        }
        int pix = this.nSq * tile;
        double delta = 0.5;
        double dx = u - xSq;
        double dy = v - ySq;
        int npix = this.nSide;
        while (npix > 1) {
            int ipix = 0;
            if (dy >= delta) {
                ipix = 2;
                dy -= delta;
            }
            if (dx >= delta) {
                ++ipix;
                dx -= delta;
            }
            delta /= 2.0;
            pix += ipix * (npix /= 2) * npix;
        }
        return pix;
    }

    public int cvtPixel(int pixel) {
        int ix = pixel % (4 * this.nSide);
        int iy = pixel / (4 * this.nSide);
        double px = (double)ix / (double)this.nSide;
        double py = (double)iy / (double)this.nSide;
        int result = this.getObliquePixel(px - 2.0, py - 3.0);
        return result;
    }

    public static void main(String[] args) {
        Hpx ob = new Hpx(Integer.parseInt(args[0]));
        int pix = Integer.parseInt(args[1]);
        double[] x1 = ob.getOblCorner(pix);
        double[][] corners = ob.getCorners(pix);
        System.out.println("Oblique corner:" + x1[0] + "," + x1[1]);
        for (int i = 0; i < corners.length; ++i) {
            System.out.println("Nominal Corners " + i + ": " + corners[i][0] / Math.PI + " " + corners[i][1] / Math.PI);
        }
        double x = Double.parseDouble(args[2]);
        double y = Double.parseDouble(args[3]);
        double[] unit = new double[3];
        double[] proj = new double[2];
        double xr = Math.toRadians(x);
        double yr = Math.toRadians(y);
        unit[0] = Math.cos(xr) * Math.cos(yr);
        unit[1] = Math.sin(xr) * Math.cos(yr);
        unit[2] = Math.sin(yr);
        Hpx.proj(unit, proj);
        Hpx.deproj(proj, unit);
        System.out.println("  deproj back to:" + Math.toDegrees(Math.atan2(unit[1], unit[0])) + " " + Math.toDegrees(Math.asin(unit[2])));
        System.out.println("Pixel is:" + ob.getPixel(proj));
    }

    public static class HpxDeproj
    extends Deprojecter {
        @Override
        public String getName() {
            return "HpxDeproj";
        }

        @Override
        public String getDescription() {
            return "HEALPix deprojector";
        }

        @Override
        public Transformer inverse() {
            return new Hpx();
        }

        @Override
        public boolean isInverse(Transformer t) {
            return false;
        }

        @Override
        public void transform(double[] plane, double[] sphere) {
            Hpx.deproj(plane, sphere);
        }
    }
}

