/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Animator
implements PlugIn {
    private static double animationRate = Prefs.getDouble("fps", 7.0);
    private static boolean oscillate;
    private ImagePlus imp;
    private StackWindow swin;
    private int slice;
    private int nSlices;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        if (this.nSlices < 2) {
            IJ.error("Stack required.");
            return;
        }
        ImageWindow win = this.imp.getWindow();
        if (win == null || !(win instanceof StackWindow)) {
            return;
        }
        this.swin = (StackWindow)win;
        ImageStack stack = this.imp.getStack();
        this.slice = this.imp.getCurrentSlice();
        IJ.register(Animator.class);
        if (arg.equals("options")) {
            this.doOptions();
            return;
        }
        if (arg.equals("start")) {
            this.startAnimation();
            return;
        }
        if (this.swin.running2) {
            this.stopAnimation();
        }
        if (arg.equals("stop")) {
            return;
        }
        if (arg.equals("next")) {
            this.nextSlice();
            return;
        }
        if (arg.equals("previous")) {
            this.previousSlice();
            return;
        }
        if (arg.equals("set")) {
            this.setSlice();
            return;
        }
    }

    void stopAnimation() {
        this.swin.running2 = false;
        IJ.wait(500 + (int)(1000.0 / animationRate));
        this.imp.unlock();
    }

    void startAnimation() {
        if (this.swin.running2) {
            this.stopAnimation();
            return;
        }
        this.imp.unlock();
        this.swin.running2 = true;
        long nextTime = System.currentTimeMillis();
        Thread.currentThread().setPriority(1);
        int sliceIncrement = 1;
        Calibration cal = this.imp.getCalibration();
        if (cal.fps != 0.0) {
            animationRate = cal.fps;
        }
        while (this.swin.running2) {
            long time = System.currentTimeMillis();
            if (time < nextTime) {
                IJ.wait((int)(nextTime - time));
            } else {
                Thread.yield();
            }
            nextTime += (long)(1000.0 / animationRate);
            this.slice += sliceIncrement;
            if (this.slice < 1) {
                this.slice = 2;
                sliceIncrement = 1;
            }
            if (this.slice > this.nSlices) {
                if (oscillate) {
                    this.slice = this.nSlices - 1;
                    sliceIncrement = -1;
                } else {
                    this.slice = 1;
                    sliceIncrement = 1;
                }
            }
            this.swin.showSlice(this.slice);
        }
    }

    void doOptions() {
        boolean start = !this.swin.running2;
        boolean saveOscillate = oscillate;
        Calibration cal = this.imp.getCalibration();
        if (cal.fps != 0.0) {
            animationRate = cal.fps;
        } else if (cal.frameInterval != 0.0 && cal.getTimeUnit().equals("sec")) {
            animationRate = 1.0 / cal.frameInterval;
        }
        int decimalPlaces = (double)((int)animationRate) == animationRate ? 0 : 1;
        GenericDialog gd = new GenericDialog("Animation Options");
        gd.addNumericField("Speed (0.1-100 fps):", animationRate, decimalPlaces);
        gd.addCheckbox("Loop Back and Forth", oscillate);
        gd.addCheckbox("Start Animation", start);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double speed = gd.getNextNumber();
        oscillate = gd.getNextBoolean();
        start = gd.getNextBoolean();
        if (speed > 100.0) {
            speed = 100.0;
        }
        if (speed < 0.1) {
            speed = 0.1;
        }
        if ((animationRate = speed) != 0.0) {
            cal.fps = animationRate;
        }
        if (start && !this.swin.running2) {
            this.startAnimation();
        }
    }

    void nextSlice() {
        if (!this.imp.lock()) {
            return;
        }
        this.slice = IJ.altKeyDown() ? (this.slice += 10) : ++this.slice;
        if (this.slice > this.nSlices) {
            this.slice = this.nSlices;
        }
        this.swin.showSlice(this.slice);
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void previousSlice() {
        if (!this.imp.lock()) {
            return;
        }
        this.slice = IJ.altKeyDown() ? (this.slice -= 10) : --this.slice;
        if (this.slice < 1) {
            this.slice = 1;
        }
        this.swin.showSlice(this.slice);
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void setSlice() {
        GenericDialog gd = new GenericDialog("Set Slice");
        gd.addNumericField("Slice Number (1-" + this.nSlices + "):", this.slice, 0);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            this.imp.setSlice((int)gd.getNextNumber());
        }
    }

    public static double getFrameRate() {
        return animationRate;
    }
}

