/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

public class MathUtilities {
    private static final double logOf10 = Math.log(10.0);
    private static final double vegaTemp = 9900.0;
    private static final double vegaMag = 0.5;
    private static final double vegaFlux = 5.5E10;

    public static double antilog10(double inVal) {
        return Math.pow(10.0, inVal);
    }

    public static double log10(double inVal) {
        return Math.log(inVal) / logOf10;
    }

    public static double convertFluxToMagnitude(double inFlux) {
        return MathUtilities.convertFluxToMagnitude(inFlux, 0.5, 5.5E10);
    }

    public static double convertFluxToMagnitude(double inFlux, double baseMag, double baseFlux) {
        return baseMag - 2.5 * MathUtilities.log10(inFlux / baseFlux);
    }

    public static double convertMagnitudeToFlux(double inMag) {
        return MathUtilities.convertMagnitudeToFlux(inMag, 0.5, 5.5E10);
    }

    public static double convertMagnitudeToFlux(double inMag, double baseMag, double baseFlux) {
        return baseFlux * MathUtilities.antilog10((baseMag - inMag) / 2.5);
    }
}

