/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.image.gui.MainImageDisplay;
import jsky.util.gui.DialogUtil;

public class ImageHistoryItem
implements Action,
ChangeListener,
Serializable {
    protected String title;
    protected double ra;
    protected double dec;
    protected URL url;
    protected String filename;
    protected String cmap;
    protected String itt;
    protected double hcut;
    protected double lcut;
    protected boolean userSetCutLevels;
    protected int scaleAlg;
    protected float scale;
    private transient AbstractAction _action;

    public ImageHistoryItem(MainImageDisplay imageDisplay, double ra, double dec, String title, URL url, String filename) {
        this.ra = ra;
        this.dec = dec;
        this.title = title;
        this.filename = new File(filename).getAbsolutePath();
        this.url = url;
        this.scale = imageDisplay.getScale();
        ImageProcessor imageProcessor = imageDisplay.getImageProcessor();
        this.cmap = imageProcessor.getColorLookupTableName();
        this.itt = imageProcessor.getIntensityLookupTableName();
        this.hcut = imageProcessor.getHighCut();
        this.lcut = imageProcessor.getLowCut();
        this.userSetCutLevels = imageProcessor.isUserSetCutLevels();
        this.scaleAlg = imageProcessor.getScaleAlgorithm();
        this._initAction();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._initAction();
    }

    private void _initAction() {
        this._action = new AbstractAction(this.title){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainImageDisplay imageDisplay = ImageDisplayMenuBar.getCurrentImageDisplay();
                if (ImageHistoryItem.this.filename != null && new File(ImageHistoryItem.this.filename).exists()) {
                    imageDisplay.addChangeListener(ImageHistoryItem.this);
                    imageDisplay.setFilename(ImageHistoryItem.this.filename, ImageHistoryItem.this.url);
                } else if (ImageHistoryItem.this.url != null) {
                    imageDisplay.addChangeListener(ImageHistoryItem.this);
                    imageDisplay.setURL(ImageHistoryItem.this.url);
                } else {
                    DialogUtil.error("No file or URL defined for image");
                }
            }
        };
    }

    public boolean match(double ra, double dec) {
        if (Double.isNaN(this.ra) || Double.isNaN(this.dec)) {
            return false;
        }
        double range = 0.11666666666666667;
        double diff = Math.abs(ra - this.ra);
        if (diff > range) {
            if (ra > 360.0 - range) {
                ra -= 360.0;
            } else if (ra < range) {
                ra += 360.0;
            }
            diff = Math.abs(ra - this.ra);
            if (diff > range) {
                return false;
            }
        }
        return (diff = Math.abs(dec - this.dec)) <= range;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        ImageChangeEvent e = (ImageChangeEvent)ce;
        if (e.isNewImage() && !e.isBefore()) {
            DivaMainImageDisplay imageDisplay = (DivaMainImageDisplay)e.getSource();
            ImageProcessor imageProcessor = imageDisplay.getImageProcessor();
            imageDisplay.removeChangeListener(this);
            imageProcessor.setColorLookupTable(this.cmap);
            imageProcessor.setIntensityLookupTable(this.itt);
            imageProcessor.setScaleAlgorithm(this.scaleAlg);
            imageProcessor.setCutLevels(this.lcut, this.hcut, this.userSetCutLevels);
            imageDisplay.setScale(this.scale);
            imageProcessor.update();
        }
    }

    @Override
    public Object getValue(String key) {
        return this._action.getValue(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this._action.putValue(key, value);
    }

    @Override
    public void setEnabled(boolean b) {
        this._action.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this._action.isEnabled();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._action.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._action.removePropertyChangeListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._action.actionPerformed(e);
    }
}

