/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.media.jai.Interpolation;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.graphics.gui.ImageGraphicsMenu;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.MainImageDisplay;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GenericToolBar;

public class ImageDisplayMenuBar
extends JMenuBar {
    private static final I18N _I18N = I18N.getInstance(ImageDisplayMenuBar.class);
    public static final float MAX_SCALE = 20.0f;
    public static final float MIN_SCALE = 0.05f;
    private static NumberFormat _scaleFormat = NumberFormat.getInstance(Locale.US);
    private DivaMainImageDisplay _imageDisplay;
    private static MainImageDisplay _currentImageDisplay;
    private GenericToolBar _toolBar;
    private JMenu _fileMenu;
    private JMenu _viewMenu;
    private JMenu _goMenu;
    private JMenu _graphicsMenu;
    private JMenu _zoomInMenu;
    private JMenu _zoomOutMenu;
    private ButtonGroup _zoomInOutGroup = new ButtonGroup();
    private JMenuItem _imagePropertiesMenuItem;
    private JMenuItem _fitsKeywordsMenuItem;
    private JMenuItem _pickObjectMenuItem;

    public ImageDisplayMenuBar(final DivaMainImageDisplay imageDisplay, GenericToolBar toolBar) {
        this._imageDisplay = imageDisplay;
        this._toolBar = toolBar;
        this._fileMenu = this.createFileMenu();
        this.add(this._fileMenu);
        this._viewMenu = this.createViewMenu();
        this.add(this._viewMenu);
        this._goMenu = this.createGoMenu(null);
        this.add(this._goMenu);
        this._graphicsMenu = new ImageGraphicsMenu(imageDisplay.getCanvasDraw());
        this.add(this._graphicsMenu);
        this._goMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                _currentImageDisplay = imageDisplay;
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        imageDisplay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewImage() && !e.isBefore()) {
                    ImageDisplayMenuBar.this._goMenu.removeAll();
                    ImageDisplayMenuBar.this.createGoMenu(ImageDisplayMenuBar.this._goMenu);
                    if (imageDisplay.getFitsImage() != null) {
                        ImageDisplayMenuBar.this._fitsKeywordsMenuItem.setEnabled(true);
                        ImageDisplayMenuBar.this._pickObjectMenuItem.setEnabled(true);
                        ImageDisplayMenuBar.this._imagePropertiesMenuItem.setEnabled(false);
                    } else {
                        ImageDisplayMenuBar.this._fitsKeywordsMenuItem.setEnabled(false);
                        ImageDisplayMenuBar.this._pickObjectMenuItem.setEnabled(false);
                        ImageDisplayMenuBar.this._imagePropertiesMenuItem.setEnabled(true);
                    }
                }
            }
        });
    }

    public static MainImageDisplay getCurrentImageDisplay() {
        return _currentImageDisplay;
    }

    public static void setCurrentImageDisplay(MainImageDisplay imageDisplay) {
        _currentImageDisplay = imageDisplay;
    }

    protected JMenu createFileMenu() {
        boolean useMacToolBar;
        JMenu menu = new JMenu(_I18N.getString("file"));
        menu.add(this._imageDisplay.getOpenAction());
        menu.add(this._imageDisplay.getOpenUrlAction());
        menu.addSeparator();
        menu.add(this._imageDisplay.getClearAction());
        menu.addSeparator();
        menu.add(this._imageDisplay.getSaveAction());
        menu.add(this._imageDisplay.getSaveAsAction());
        menu.addSeparator();
        menu.add(this._imageDisplay.getPrintPreviewAction());
        menu.add(this._imageDisplay.getPrintAction());
        menu.addSeparator();
        menu.add(this.createFileCloseMenuItem());
        boolean isMacOsX = "Mac OS X".equals(UIManager.getLookAndFeel().getName());
        boolean bl = useMacToolBar = isMacOsX && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
        if (!useMacToolBar && this._imageDisplay.isMainWindow()) {
            menu.add(this.createFileExitMenuItem());
        }
        return menu;
    }

    protected JMenuItem createFileNewWindowMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("newWindow"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.newWindow();
            }
        });
        return menuItem;
    }

    protected JMenuItem createFileExitMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.exit();
            }
        });
        return menuItem;
    }

    protected JMenuItem createFileCloseMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("close"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.close();
            }
        });
        return menuItem;
    }

    protected JMenu createEditMenu() {
        JMenu menu = new JMenu(_I18N.getString("edit"));
        menu.add(this.createEditPreferencesMenuItem());
        return menu;
    }

    protected JMenuItem createEditPreferencesMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("preferences"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogUtil.error("Sorry, not implemented...");
            }
        });
        return menuItem;
    }

    protected JMenu createViewMenu() {
        JMenu menu = new JMenu(_I18N.getString("view"));
        menu.add(this.createViewToolBarMenuItem());
        menu.add(this.createViewShowToolBarAsMenu());
        menu.addSeparator();
        menu.add(this._imageDisplay.getColorsAction());
        menu.add(this._imageDisplay.getCutLevelsAction());
        this._pickObjectMenuItem = this.createViewPickObjectMenuItem();
        menu.add(this._pickObjectMenuItem);
        menu.add(this._imageDisplay.getFitsExtensionsAction());
        this._fitsKeywordsMenuItem = this.createViewFitsKeywordsMenuItem();
        menu.add(this._fitsKeywordsMenuItem);
        this._imagePropertiesMenuItem = this.createViewImagePropertiesMenuItem();
        menu.add(this._imagePropertiesMenuItem);
        menu.addSeparator();
        menu.add(this.createViewScaleMenu());
        menu.add(this.createViewInterpolationMenu());
        menu.add(this.createViewSmoothScrollingMenuItem());
        return menu;
    }

    protected JCheckBoxMenuItem createViewToolBarMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(_I18N.getString("toolbar"));
        final String prefName = this.getClass().getName() + ".ShowToolBar";
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem rb = (JCheckBoxMenuItem)e.getSource();
                ImageDisplayMenuBar.this._toolBar.setVisible(rb.getState());
                if (rb.getState()) {
                    Preferences.set(prefName, "true");
                } else {
                    Preferences.set(prefName, "false");
                }
            }
        });
        String pref = Preferences.get(prefName);
        if (pref != null) {
            menuItem.setState(pref.equals("true"));
        } else {
            menuItem.setState(true);
        }
        return menuItem;
    }

    protected JMenu createViewShowToolBarAsMenu() {
        JMenu menu = new JMenu(_I18N.getString("showToolBarAs"));
        JRadioButtonMenuItem b1 = new JRadioButtonMenuItem(_I18N.getString("picAndText"));
        JRadioButtonMenuItem b2 = new JRadioButtonMenuItem(_I18N.getString("picOnly"));
        JRadioButtonMenuItem b3 = new JRadioButtonMenuItem(_I18N.getString("textOnly"));
        b2.setSelected(true);
        this._toolBar.setShowPictures(true);
        this._toolBar.setShowText(false);
        menu.add(b1);
        menu.add(b2);
        menu.add(b3);
        ButtonGroup group = new ButtonGroup();
        group.add(b1);
        group.add(b2);
        group.add(b3);
        final String prefName = this.getClass().getName() + ".ShowToolBarAs";
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                if (rb.isSelected()) {
                    if (rb.getText().equals(_I18N.getString("picAndText"))) {
                        ImageDisplayMenuBar.this._toolBar.setShowPictures(true);
                        ImageDisplayMenuBar.this._toolBar.setShowText(true);
                        Preferences.set(prefName, "1");
                    } else if (rb.getText().equals(_I18N.getString("picOnly"))) {
                        ImageDisplayMenuBar.this._toolBar.setShowPictures(true);
                        ImageDisplayMenuBar.this._toolBar.setShowText(false);
                        Preferences.set(prefName, "2");
                    } else if (rb.getText().equals(_I18N.getString("textOnly"))) {
                        ImageDisplayMenuBar.this._toolBar.setShowPictures(false);
                        ImageDisplayMenuBar.this._toolBar.setShowText(true);
                        Preferences.set(prefName, "3");
                    }
                }
            }
        };
        b1.addItemListener(itemListener);
        b2.addItemListener(itemListener);
        b3.addItemListener(itemListener);
        String pref = Preferences.get(prefName);
        if (pref != null) {
            JRadioButtonMenuItem[] ar = new JRadioButtonMenuItem[]{null, b1, b2, b3};
            try {
                ar[Integer.parseInt(pref)].setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return menu;
    }

    protected JMenuItem createViewCutLevelsMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("cutLevels") + "...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.editCutLevels();
            }
        });
        return menuItem;
    }

    protected JMenuItem createViewColorsMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("colors") + "...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.editColors();
            }
        });
        return menuItem;
    }

    protected JMenuItem createViewPickObjectMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("pickObjects"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.pickObject();
            }
        });
        return menuItem;
    }

    protected JMenuItem createViewFitsKeywordsMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("fitsKeywords"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.viewFitsKeywords();
            }
        });
        return menuItem;
    }

    protected JMenuItem createViewImagePropertiesMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("imageProps"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.viewImageProperties();
            }
        });
        return menuItem;
    }

    public static String getScaleLabel(float f) {
        if ((double)f < 1.0) {
            int i = Math.round(1.0f / f);
            return "1/" + i + "x";
        }
        return Integer.toString(Math.round(f)) + "x";
    }

    protected JMenu createViewScaleMenu() {
        JMenu scaleMenu = new JMenu(_I18N.getString("scale"));
        scaleMenu.add(this.createViewScaleZoomOutMenu());
        scaleMenu.add(this.createViewScaleZoomInMenu());
        scaleMenu.add(this.createViewScaleFitToWindowMenuItem());
        this._imageDisplay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewScale()) {
                    float scale = ImageDisplayMenuBar.this._imageDisplay.getScale();
                    String s = ImageDisplayMenuBar.getScaleLabel(scale);
                    JMenu menu = scale < 1.0f ? ImageDisplayMenuBar.this._zoomOutMenu : ImageDisplayMenuBar.this._zoomInMenu;
                    int n = menu.getItemCount();
                    for (int i = 0; i < n; ++i) {
                        JRadioButtonMenuItem b = (JRadioButtonMenuItem)menu.getItem(i);
                        if (!b.getText().equals(s)) continue;
                        b.setSelected(true);
                    }
                }
            }
        });
        return scaleMenu;
    }

    protected JMenu createViewScaleZoomOutMenu() {
        this._zoomOutMenu = new JMenu(_I18N.getString("zoomOut"));
        int i = 1;
        while ((float)i <= 20.0f) {
            this.addScaleMenuItem(this._zoomOutMenu, this._zoomInOutGroup, "1/" + i + "x", 1.0f / (float)i);
            ++i;
        }
        return this._zoomOutMenu;
    }

    protected JMenu createViewScaleZoomInMenu() {
        this._zoomInMenu = new JMenu(_I18N.getString("zoomIn"));
        int i = 1;
        while ((float)i <= 20.0f) {
            this.addScaleMenuItem(this._zoomInMenu, this._zoomInOutGroup, Integer.toString(i) + "x", i);
            ++i;
        }
        return this._zoomInMenu;
    }

    protected JMenuItem createViewScaleFitToWindowMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("fitImageInWindow"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.scaleToFit();
                ImageDisplayMenuBar.this._imageDisplay.updateImage();
            }
        });
        return menuItem;
    }

    protected void addScaleMenuItem(JMenu menu, ButtonGroup group, String label, float value) {
        JRadioButtonMenuItem b = new JRadioButtonMenuItem(label);
        b.setActionCommand(Float.toString(value));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDisplayMenuBar.this.setScale(Float.parseFloat(e.getActionCommand()));
            }
        });
        group.add(b);
        menu.add(b);
    }

    public void setScale(float value) {
        this._imageDisplay.setScale(value);
        this._imageDisplay.updateImage();
    }

    protected JMenu createViewInterpolationMenu() {
        JMenu menu = new JMenu(_I18N.getString("scaleInt"));
        JRadioButtonMenuItem b1 = new JRadioButtonMenuItem("Nearest");
        JRadioButtonMenuItem b2 = new JRadioButtonMenuItem("Bilinear");
        JRadioButtonMenuItem b3 = new JRadioButtonMenuItem("Bicubic");
        JRadioButtonMenuItem b4 = new JRadioButtonMenuItem("Bicubic2");
        b1.setSelected(true);
        menu.add(b1);
        menu.add(b2);
        menu.add(b3);
        menu.add(b4);
        ButtonGroup group = new ButtonGroup();
        group.add(b1);
        group.add(b2);
        group.add(b3);
        group.add(b4);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                if (rb.isSelected()) {
                    if (rb.getText().equals("Nearest")) {
                        ImageDisplayMenuBar.this._imageDisplay.setInterpolation(Interpolation.getInstance(0));
                    } else if (rb.getText().equals("Bilinear")) {
                        ImageDisplayMenuBar.this._imageDisplay.setInterpolation(Interpolation.getInstance(1));
                    } else if (rb.getText().equals("Bicubic")) {
                        ImageDisplayMenuBar.this._imageDisplay.setInterpolation(Interpolation.getInstance(2));
                    } else if (rb.getText().equals("Bicubic2")) {
                        ImageDisplayMenuBar.this._imageDisplay.setInterpolation(Interpolation.getInstance(3));
                    }
                    ImageDisplayMenuBar.this._imageDisplay.updateImage();
                }
            }
        };
        b1.addItemListener(itemListener);
        b2.addItemListener(itemListener);
        b3.addItemListener(itemListener);
        b4.addItemListener(itemListener);
        return menu;
    }

    protected JMenu createViewRotateMenu() {
        JMenu menu = new JMenu("Rotate");
        JRadioButtonMenuItem b1 = new JRadioButtonMenuItem("No Rotation");
        JRadioButtonMenuItem b2 = new JRadioButtonMenuItem("  90 deg");
        JRadioButtonMenuItem b3 = new JRadioButtonMenuItem(" 180 deg");
        JRadioButtonMenuItem b4 = new JRadioButtonMenuItem(" -90 deg");
        b1.setSelected(true);
        menu.add(b1);
        menu.add(b2);
        menu.add(b3);
        menu.add(b4);
        ButtonGroup group = new ButtonGroup();
        group.add(b1);
        group.add(b2);
        group.add(b3);
        group.add(b4);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                double rad = Math.PI / 180;
                ImageProcessor imageProcessor = ImageDisplayMenuBar.this._imageDisplay.getImageProcessor();
                if (rb.isSelected()) {
                    if (rb.getText().equals("No Rotation")) {
                        imageProcessor.setAngle(0.0);
                    } else if (rb.getText().equals("  90 deg")) {
                        imageProcessor.setAngle(90.0 * rad);
                    } else if (rb.getText().equals(" 180 deg")) {
                        imageProcessor.setAngle(180.0 * rad);
                    } else if (rb.getText().equals(" -90 deg")) {
                        imageProcessor.setAngle(-90.0 * rad);
                    }
                    imageProcessor.update();
                }
            }
        };
        b1.addItemListener(itemListener);
        b2.addItemListener(itemListener);
        b3.addItemListener(itemListener);
        b4.addItemListener(itemListener);
        return menu;
    }

    protected JCheckBoxMenuItem createViewFlipXMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Flip X");
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem rb = (JCheckBoxMenuItem)e.getSource();
                ImageProcessor imageProcessor = ImageDisplayMenuBar.this._imageDisplay.getImageProcessor();
                imageProcessor.setFlipX(rb.getState());
                imageProcessor.update();
            }
        });
        return menuItem;
    }

    protected JCheckBoxMenuItem createViewFlipYMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Flip Y");
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem rb = (JCheckBoxMenuItem)e.getSource();
                ImageProcessor imageProcessor = ImageDisplayMenuBar.this._imageDisplay.getImageProcessor();
                imageProcessor.setFlipY(rb.getState());
                imageProcessor.update();
            }
        });
        return menuItem;
    }

    protected JCheckBoxMenuItem createViewSmoothScrollingMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(_I18N.getString("smoothScrolling"), true);
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem rb = (JCheckBoxMenuItem)e.getSource();
                ImageDisplayMenuBar.this._imageDisplay.setImmediateMode(rb.getState());
                ImageDisplayMenuBar.this._imageDisplay.updateImage();
            }
        });
        return menuItem;
    }

    protected JMenu createGoMenu(JMenu menu) {
        if (menu == null) {
            menu = new JMenu(_I18N.getString("go"));
        }
        menu.add(this._imageDisplay.getBackAction());
        menu.add(this._imageDisplay.getForwAction());
        menu.addSeparator();
        this._imageDisplay.addHistoryMenuItems(menu);
        menu.addSeparator();
        menu.add(this.createGoClearHistoryMenuItem());
        return menu;
    }

    protected JMenuItem createGoClearHistoryMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("clearHistory"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageDisplayMenuBar.this._imageDisplay.clearHistory();
                ImageDisplayMenuBar.this._goMenu.removeAll();
                ImageDisplayMenuBar.this.createGoMenu(ImageDisplayMenuBar.this._goMenu);
            }
        });
        return menuItem;
    }

    public MainImageDisplay getImageDisplay() {
        return this._imageDisplay;
    }

    public JMenu getFileMenu() {
        return this._fileMenu;
    }

    public JMenu getViewMenu() {
        return this._viewMenu;
    }

    public JMenu getGoMenu() {
        return this._goMenu;
    }

    public JMenu getGraphicsMenu() {
        return this._graphicsMenu;
    }

    public JMenuItem getPickObjectMenuItem() {
        return this._pickObjectMenuItem;
    }

    static {
        _scaleFormat.setMaximumFractionDigits(1);
    }
}

