/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits;

import jsky.coords.WCSKeywordProvider;
import jsky.image.fits.codec.FITSImage;
import nom.tam.fits.Header;

public class FITSKeywordProvider
implements WCSKeywordProvider {
    private Header _primary;
    private Header _header;

    public FITSKeywordProvider(FITSImage fitsImage) {
        this._header = fitsImage.getHeader();
        if (this._header == null) {
            throw new IllegalArgumentException("No FITS header");
        }
        if (fitsImage.getNumHDUs() > 1) {
            this._primary = fitsImage.getHDU(0).getHeader();
            if (this._primary == null) {
                throw new IllegalArgumentException("No primary FITS extension header");
            }
            if (this._primary.getIntValue("NAXIS") != 0) {
                this._primary = new Header();
            }
        } else {
            this._primary = new Header();
        }
    }

    @Override
    public boolean findKey(String key) {
        return this._header.findKey(key) != null || this._primary.findKey(key) != null;
    }

    @Override
    public String getStringValue(String key) {
        if (this._header.findKey(key) != null) {
            return this._header.getStringValue(key);
        }
        return this._primary.getStringValue(key);
    }

    @Override
    public String getStringValue(String key, String defaultValue) {
        if (this._header.findKey(key) != null) {
            return this._header.getStringValue(key);
        }
        if (this._primary.findKey(key) != null) {
            return this._primary.getStringValue(key);
        }
        return defaultValue;
    }

    @Override
    public double getDoubleValue(String key) {
        if (this._header.findKey(key) != null) {
            return this._header.getDoubleValue(key);
        }
        return this._primary.getDoubleValue(key);
    }

    @Override
    public double getDoubleValue(String key, double defaultValue) {
        if (this._header.findKey(key) != null) {
            return this._header.getDoubleValue(key, defaultValue);
        }
        return this._primary.getDoubleValue(key, defaultValue);
    }

    @Override
    public float getFloatValue(String key) {
        if (this._header.findKey(key) != null) {
            return this._header.getFloatValue(key);
        }
        return this._primary.getFloatValue(key);
    }

    @Override
    public float getFloatValue(String key, float defaultValue) {
        if (this._header.findKey(key) != null) {
            return this._header.getFloatValue(key, defaultValue);
        }
        return this._primary.getFloatValue(key, defaultValue);
    }

    @Override
    public int getIntValue(String key) {
        if (this._header.findKey(key) != null) {
            return this._header.getIntValue(key);
        }
        return this._primary.getIntValue(key);
    }

    @Override
    public int getIntValue(String key, int defaultValue) {
        if (this._header.findKey(key) != null) {
            return this._header.getIntValue(key, defaultValue);
        }
        return this._primary.getIntValue(key, defaultValue);
    }
}

