/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.astrocat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.SearchCondition;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.astrocat.AstroCatTable;
import jsky.catalog.astrocat.AstroCatXML;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.DMS;
import jsky.coords.HMS;
import jsky.coords.WorldCoords;
import jsky.util.NameValue;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.StringUtil;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressPanel;

public class AstroCatalog
implements PlotableCatalog {
    private static Logger LOG = Logger.getLogger(AstroCatalog.class.getName());
    static final String OBJECT = "Object";
    static final String NAME_SERVER = "Name Server";
    static final String RA = "RA";
    static final String DEC = "Dec";
    static final String EQUINOX = "Equinox";
    static final String RADIUS = "Radius";
    static final String MIN_RADIUS = "Min Radius";
    static final String MAX_RADIUS = "Max Radius";
    static final String SIZE = "Size";
    static final String WIDTH = "Width";
    static final String HEIGHT = "Height";
    static final String SELECT = "Select";
    static final String MAX_OBJECTS = "Max Objects";
    private static final String J2000 = "2000";
    private static final String B1950 = "1950";
    private static NameValue[] _equinoxOptions = new NameValue[]{new NameValue("J2000", "2000"), new NameValue("B1950", "1950")};
    private URL _url;
    private CatalogDirectory _parent;
    private String _id;
    private String _name;
    private String _description;
    private String _docURL;
    private String _type = "catalog";
    private String _protocol;
    private String _host;
    private int _port = 80;
    private String _path;
    private String _handlerClass;
    private FieldDesc[] _paramDesc;
    private FieldDesc[] _dummyParamDesc;
    private TablePlotSymbol[] _symbols;
    private boolean _symbolsEdited = false;
    private ProgressPanel _progressPanel;
    private boolean _isCatalog = false;
    private boolean _isImageServer = false;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    @Override
    public CatalogDirectory getParent() {
        return this._parent;
    }

    @Override
    public void setParent(CatalogDirectory dir) {
        this._parent = dir;
    }

    @Override
    public Catalog[] getPath() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getPath(this);
    }

    public String toString() {
        return this.getName();
    }

    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDocURL(String docURL) {
        this._docURL = docURL;
    }

    @Override
    public URL getDocURL() {
        try {
            return new URL(this._docURL);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setType(String type) {
        this._type = type;
        this._isCatalog = this._type.equals("catalog") || this._type.equals("archive") || this._type.equals("local");
        this._isImageServer = this._type.equals("imagesvr");
    }

    @Override
    public String getType() {
        return this._type;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public URL getBaseURL() throws MalformedURLException {
        if (this._path == null) {
            return null;
        }
        int port = this._port;
        if (port == 80) {
            port = -1;
        }
        if (this._protocol != null && this._host != null) {
            return new URL(this._protocol, this._host, port, this._path);
        }
        File file = new File(this._path);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        if (this._path.endsWith(".xml")) {
            file = new File(Preferences.getPreferences().getDir(), this._path);
            if (file.exists()) {
                return file.toURI().toURL();
            }
            return Resources.getResource(this._path);
        }
        return null;
    }

    public void setURLPath(String path) {
        this._path = path;
    }

    public String getURLPath() {
        return this._path;
    }

    public void setParams(FieldDesc[] params) {
        this._paramDesc = params;
    }

    public void setHandlerClass(String handlerClass) {
        this._handlerClass = handlerClass;
    }

    public String getHandlerClass() {
        return this._handlerClass;
    }

    @Override
    public String getTitle() {
        return this._name;
    }

    @Override
    public int getNumParams() {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        return this._dummyParamDesc.length;
    }

    @Override
    public FieldDesc getParamDesc(int i) {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        return this._dummyParamDesc[i];
    }

    @Override
    public FieldDesc getParamDesc(String name) {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        for (FieldDesc a_dummyParamDesc : this._dummyParamDesc) {
            if (a_dummyParamDesc == null || !a_dummyParamDesc.getName().equals(name)) continue;
            return a_dummyParamDesc;
        }
        return null;
    }

    @Override
    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
        Coordinates coords = region.getCenterPosition();
        String equinoxStr = (String)queryArgs.getParamValue(EQUINOX);
        double equinox = this._getEquinox(queryArgs);
        WorldCoords pos = (WorldCoords)coords;
        String[] radec = pos.format(equinox);
        queryArgs.setParamValue(RA, (Object)radec[0]);
        queryArgs.setParamValue(DEC, (Object)radec[1]);
        queryArgs.setParamValue(EQUINOX, (Object)equinoxStr);
        queryArgs.setParamValue(RADIUS, region.getMaxRadius());
        queryArgs.setParamValue(MIN_RADIUS, region.getMinRadius());
        queryArgs.setParamValue(MAX_RADIUS, region.getMaxRadius());
        queryArgs.setParamValue(SIZE, region.getWidth());
        queryArgs.setParamValue(WIDTH, region.getWidth());
        queryArgs.setParamValue(HEIGHT, region.getHeight());
    }

    @Override
    public boolean isLocal() {
        return this._type != null && this._type.equalsIgnoreCase("local") || this._protocol != null && this._protocol.equals("file");
    }

    @Override
    public boolean isImageServer() {
        return this._type != null && this._type.equalsIgnoreCase("imagesvr");
    }

    @Override
    public QueryResult query(QueryArgs queryArgs) throws IOException {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        if (this._protocol == null || this._protocol.equalsIgnoreCase("http")) {
            return this._httpQuery(queryArgs);
        }
        throw new RuntimeException("Query not supported for this catalog type: " + this._protocol + ":" + this._type);
    }

    @Override
    public void setSymbols(TablePlotSymbol[] symbols) {
        this._symbols = symbols;
    }

    @Override
    public void setSymbolsEdited(boolean edited) {
        this._symbolsEdited = edited;
    }

    @Override
    public boolean isSymbolsEdited() {
        return this._symbolsEdited;
    }

    @Override
    public void saveSymbolConfig() {
        AstroCatConfig.getConfigFile().save();
    }

    @Override
    public int getNumSymbols() {
        if (this._symbols == null) {
            return 0;
        }
        return this._symbols.length;
    }

    @Override
    public TablePlotSymbol getSymbolDesc(int i) {
        return this._symbols[i];
    }

    @Override
    public TablePlotSymbol[] getSymbols() {
        return this._symbols;
    }

    private void _setQueryRegion(QueryArgs queryArgs, SearchCondition[] sc) throws IOException {
        WorldCoords wcs;
        if (queryArgs.getRegion() != null || sc == null || sc.length == 0) {
            return;
        }
        String objectName = (String)queryArgs.getParamValue(OBJECT);
        if (objectName == null || objectName.length() == 0) {
            String raStr = (String)queryArgs.getParamValue(RA);
            String decStr = (String)queryArgs.getParamValue(DEC);
            if (raStr == null || decStr == null) {
                return;
            }
            double equinox = this._getEquinox(queryArgs);
            wcs = new WorldCoords(raStr, decStr, equinox, true);
        } else {
            Object o = queryArgs.getParamValue(NAME_SERVER);
            if (!(o instanceof Catalog)) {
                throw new RuntimeException("No name server was specified");
            }
            wcs = this._resolveObjectName(objectName, (Catalog)o);
            queryArgs.setParamValue(RA, (Object)wcs.getRA().toString());
            queryArgs.setParamValue(DEC, (Object)wcs.getDec().toString());
            queryArgs.setParamValue(EQUINOX, (Object)J2000);
        }
        if (this._isCatalog) {
            if (this._findParamByType(this._paramDesc, "radius") != null) {
                Double radius = (Double)queryArgs.getParamValue(RADIUS);
                double r = radius == null ? 15.0 : radius;
                queryArgs.setRegion(new CoordinateRadius(wcs, r));
            } else {
                Double minRadius = (Double)queryArgs.getParamValue(MIN_RADIUS);
                double r1 = minRadius == null ? 0.0 : minRadius;
                Double maxRadius = (Double)queryArgs.getParamValue(MAX_RADIUS);
                double r2 = maxRadius == null ? 15.0 : maxRadius;
                queryArgs.setRegion(new CoordinateRadius(wcs, r1, r2));
            }
        } else if (this._isImageServer) {
            if (this._findParamByType(this._paramDesc, "size") != null) {
                Double size = (Double)queryArgs.getParamValue(SIZE);
                double sz = size == null ? 15.0 : size;
                double radius = Math.sqrt(2.0 * sz * sz) / 2.0;
                queryArgs.setRegion(new CoordinateRadius(wcs, radius, sz, sz));
            } else {
                Double width = (Double)queryArgs.getParamValue(WIDTH);
                double w = width == null ? 0.0 : width;
                Double height = (Double)queryArgs.getParamValue(HEIGHT);
                double h = height == null ? 15.0 : height;
                double radius = Math.sqrt(w * w + h * h) / 2.0;
                queryArgs.setRegion(new CoordinateRadius(wcs, radius, w, h));
            }
        }
    }

    private double _getEquinox(QueryArgs queryArgs) {
        String equinoxStr = (String)queryArgs.getParamValue(EQUINOX);
        if (equinoxStr.equals(B1950)) {
            return 1950.0;
        }
        return 2000.0;
    }

    private WorldCoords _resolveObjectName(String objectName, Catalog cat) throws IOException {
        Coordinates coords;
        BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
        queryArgs.setId(objectName);
        QueryResult r = cat.query(queryArgs);
        if (r instanceof TableQueryResult && (coords = ((TableQueryResult)r).getCoordinates(0)) instanceof WorldCoords) {
            return (WorldCoords)coords;
        }
        throw new RuntimeException("Unexpected result from " + cat.toString());
    }

    protected void _setMaxRows(QueryArgs queryArgs, SearchCondition[] sc) {
        if (queryArgs.getMaxRows() != 0 || sc == null || sc.length == 0) {
            return;
        }
        Integer maxObjects = (Integer)queryArgs.getParamValue(MAX_OBJECTS);
        if (maxObjects != null) {
            queryArgs.setMaxRows(maxObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult _httpQuery(QueryArgs queryArgs) throws IOException {
        QueryResult queryResult;
        block8: {
            URLConnection connection;
            ProgressBarFilterInputStream in;
            block6: {
                URLQueryResult uRLQueryResult;
                block7: {
                    URL queryUrl = this._getQueryUrl(queryArgs);
                    LOG.info("URL = " + queryUrl);
                    if (this._type.equals("imagesvr")) {
                        return new URLQueryResult(queryUrl);
                    }
                    if (this._progressPanel == null) {
                        this._progressPanel = ProgressPanel.makeProgressPanel("Downloading query results");
                    }
                    in = null;
                    try {
                        connection = this._progressPanel.openConnection(queryUrl);
                        String contentType = connection.getContentType();
                        if (contentType == null || !contentType.equals("text/html")) break block6;
                        uRLQueryResult = new URLQueryResult(queryUrl);
                        if (in == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            this._progressPanel.stopLoggingInputStream(in);
                        }
                        this._progressPanel.stop();
                        throw throwable;
                    }
                    this._progressPanel.stopLoggingInputStream(in);
                }
                this._progressPanel.stop();
                return uRLQueryResult;
            }
            InputStream ins = connection.getInputStream();
            in = this._progressPanel.getLoggedInputStream(ins, connection.getContentLength());
            queryResult = this._makeQueryResult(in, queryArgs);
            if (in == null) break block8;
            this._progressPanel.stopLoggingInputStream(in);
        }
        this._progressPanel.stop();
        return queryResult;
    }

    private String _getBaseUrl() {
        if (this._host == null || this._protocol == null) {
            return this._path;
        }
        String urlStr = this._protocol + "://" + this._host;
        if (this._port != 80) {
            urlStr = urlStr + ":" + this._port;
        }
        if (this._path != null) {
            urlStr = urlStr + this._path;
        }
        return urlStr;
    }

    private URL _getQueryUrl(QueryArgs queryArgs) throws IOException {
        String urlStr = this._getBaseUrl();
        SearchCondition[] sc = queryArgs.getConditions();
        if (!this._centerPosRadiusSearchSupported()) {
            if (sc != null && sc.length != 0) {
                for (int i = 0; i < sc.length; ++i) {
                    String sep = i == 0 ? "?" : "&";
                    urlStr = urlStr + sep + sc[i].toString();
                }
            }
        } else {
            this._setQueryRegion(queryArgs, sc);
            this._setMaxRows(queryArgs, sc);
            if (this._paramDesc != null && this._paramDesc.length != 0) {
                for (int i = 0; i < this._paramDesc.length; ++i) {
                    String value = this._getParamValue(this._paramDesc[i], queryArgs);
                    if (value == null || value.length() == 0) continue;
                    String sep = i == 0 ? "?" : "&";
                    urlStr = urlStr + sep + this._paramDesc[i].getId() + "=" + value;
                }
            }
        }
        urlStr = StringUtil.replace(urlStr, " ", "%20");
        return new URL(urlStr);
    }

    private String _getParamValue(FieldDesc param, QueryArgs queryArgs) {
        for (int i = 0; i < this._dummyParamDesc.length; ++i) {
            if (this._dummyParamDesc[i] != param) continue;
            Object o = queryArgs.getParamValue(i);
            if (o != null) {
                return o.toString();
            }
            return null;
        }
        CoordinateRadius region = queryArgs.getRegion();
        if (region == null) {
            return null;
        }
        WorldCoords pos = (WorldCoords)region.getCenterPosition();
        String type = param.getType();
        String units = param.getUnits();
        String format = param.getFormat();
        if (type.equalsIgnoreCase("radec")) {
            return this._getRADec(pos.getRA(), pos.getDec(), format);
        }
        if (type.equalsIgnoreCase("ra")) {
            return this._getRA(pos.getRA(), format);
        }
        if (type.equalsIgnoreCase("dec")) {
            return this._getDec(pos.getDec(), format);
        }
        if (type.equalsIgnoreCase("radius")) {
            return String.valueOf(this._getValueInUnits(region.getMaxRadius(), "arcmin", units));
        }
        if (type.equalsIgnoreCase("minradius")) {
            return String.valueOf(this._getValueInUnits(region.getMinRadius(), "arcmin", units));
        }
        if (type.equalsIgnoreCase("maxradius")) {
            return String.valueOf(this._getValueInUnits(region.getMaxRadius(), "arcmin", units));
        }
        if (type.equalsIgnoreCase("width") || type.equalsIgnoreCase("size")) {
            return String.valueOf(this._getValueInUnits(region.getWidth(), "arcmin", units));
        }
        if (type.equalsIgnoreCase("height")) {
            return String.valueOf(this._getValueInUnits(region.getHeight(), "arcmin", units));
        }
        return null;
    }

    private String _getRA(HMS ra, String format) {
        String raStr = ra.toString();
        if (format == null || format.length() == 0) {
            return raStr;
        }
        if (format.startsWith("h+m+s")) {
            return StringUtil.replace(raStr, ":", "+");
        }
        if (format.startsWith("h m s")) {
            return StringUtil.replace(raStr, ":", " ");
        }
        return raStr;
    }

    private String _getDec(DMS dec, String format) {
        String decStr = dec.toString();
        if (format == null || format.length() == 0) {
            return decStr;
        }
        if (format.endsWith("d+m+s")) {
            return StringUtil.replace(decStr, ":", "+");
        }
        if (format.endsWith("d m s")) {
            return StringUtil.replace(decStr, ":", " ");
        }
        return decStr;
    }

    private String _getRADec(HMS ra, DMS dec, String format) {
        String raDecStr = this._getRA(ra, format) + " " + this._getDec(dec, format);
        if (format == null || format.length() == 0) {
            return raDecStr;
        }
        if (format.equals("h+m+s d+m+s")) {
            return StringUtil.replace(raDecStr, " ", "%2b");
        }
        return raDecStr;
    }

    private double _getValueInUnits(double value, String inUnits, String outUnits) {
        if (inUnits == null || inUnits.length() == 0 || outUnits == null || outUnits.length() == 0) {
            return value;
        }
        if (inUnits.startsWith("arcmin")) {
            if (outUnits.startsWith("arcsec")) {
                return value * 60.0;
            }
            if (outUnits.startsWith("arcmin")) {
                return value;
            }
            if (outUnits.startsWith("deg")) {
                return value / 4.0;
            }
            if (outUnits.startsWith("hour")) {
                return value / 60.0;
            }
        } else if (inUnits.startsWith("arcsec")) {
            if (outUnits.startsWith("arcsec")) {
                return value;
            }
            if (outUnits.startsWith("arcmin")) {
                return value / 60.0;
            }
            if (outUnits.startsWith("deg")) {
                return value / 240.0;
            }
            if (outUnits.startsWith("hour")) {
                return value / 3600.0;
            }
        } else if (inUnits.startsWith("deg")) {
            if (outUnits.startsWith("arcsec")) {
                return value * 240.0;
            }
            if (outUnits.startsWith("arcmin")) {
                return value * 4.0;
            }
            if (outUnits.startsWith("deg")) {
                return value;
            }
            if (outUnits.startsWith("hour")) {
                return value / 15.0;
            }
        } else if (inUnits.startsWith("hours")) {
            if (outUnits.startsWith("arcsec")) {
                return value * 3600.0;
            }
            if (outUnits.startsWith("arcmin")) {
                return value * 60.0;
            }
            if (outUnits.startsWith("deg")) {
                return value * 15.0;
            }
            if (outUnits.startsWith("hour")) {
                return value;
            }
        } else {
            System.out.println("Warning: unrecognized units: '" + inUnits + "'");
        }
        System.out.println("Warning: unrecognized units: '" + outUnits + "'");
        return value;
    }

    private boolean _centerPosRadiusSearchSupported() {
        if (this._isCatalog || this._isImageServer) {
            boolean hasPos = false;
            boolean hasSizeOrRadius = false;
            for (FieldDesc a_paramDesc : this._paramDesc) {
                String type = a_paramDesc.getType();
                if (type == null || type.length() == 0) continue;
                if (type.equalsIgnoreCase("radec") || type.equalsIgnoreCase("ra")) {
                    hasPos = true;
                } else if (type.equalsIgnoreCase("radius") || type.equalsIgnoreCase("minradius") || type.equalsIgnoreCase("maxradius") || type.equalsIgnoreCase("size") || type.equalsIgnoreCase("width") || type.equalsIgnoreCase("height")) {
                    hasSizeOrRadius = true;
                }
                if (!hasPos || !hasSizeOrRadius) continue;
                return true;
            }
        }
        return false;
    }

    private QueryResult _makeQueryResult(InputStream ins, QueryArgs queryArgs) throws IOException {
        return new AstroCatTable(this, ins, queryArgs);
    }

    private void _initSearchParameters() {
        this._checkForDetailedCatalogDesc();
        if (!this._centerPosRadiusSearchSupported()) {
            this._dummyParamDesc = this._paramDesc;
            return;
        }
        ArrayList<FieldDesc> params = new ArrayList<FieldDesc>();
        if (this._isCatalog || this._isImageServer) {
            FieldDescAdapter p = new FieldDescAdapter(OBJECT);
            p.setDescription("Enter the name of the object");
            params.add(p);
            p = new FieldDescAdapter(NAME_SERVER);
            p.setDescription("Select the name server to use to resolve the object name");
            List<Catalog> l = AstroCatConfig.getConfigFile().getNameServers();
            NameValue[] ar = new NameValue[l.size()];
            for (int i = 0; i < ar.length; ++i) {
                Catalog cat = l.get(i);
                ar[i] = new NameValue(cat.getName(), cat);
            }
            p.setOptions(ar);
            params.add(p);
            p = new FieldDescAdapter(RA);
            p.setIsRA(true);
            p.setDescription("Right Ascension in the selected equinox, format: hh:mm:ss.sss");
            params.add(p);
            p = new FieldDescAdapter(DEC);
            p.setDescription("Declination in the selected equinox, format: dd:mm:ss.sss");
            p.setIsDec(true);
            params.add(p);
            p = new FieldDescAdapter(EQUINOX);
            p.setDescription("Equinox of RA and Dec");
            p.setOptions(_equinoxOptions);
            params.add(p);
            if (this._isCatalog) {
                if (this._findParamByType(this._paramDesc, "radius") != null) {
                    p = new FieldDescAdapter(MAX_RADIUS);
                    p.setDescription("The radius from the center coordinates in arcmin");
                    p.setFieldClass(Double.class);
                    p.setUnits("arcmin");
                    params.add(p);
                } else {
                    if (this._findParamByType(this._paramDesc, "minradius") != null) {
                        p = new FieldDescAdapter(MIN_RADIUS);
                        p.setDescription("The minimum radius from the center coordinates in arcmin");
                        p.setFieldClass(Double.class);
                        p.setUnits("arcmin");
                        params.add(p);
                    }
                    if (this._findParamByType(this._paramDesc, "maxradius") != null) {
                        p = new FieldDescAdapter(MAX_RADIUS);
                        p.setDescription("The maximum radius from the center coordinates in arcmin");
                        p.setFieldClass(Double.class);
                        p.setUnits("arcmin");
                        params.add(p);
                    }
                }
            } else if (this._isImageServer) {
                if (this._findParamByType(this._paramDesc, "size") != null) {
                    p = new FieldDescAdapter(SIZE);
                    p.setDescription("The requested size (width or height) about the center coordinates in arcmin");
                    p.setFieldClass(Double.class);
                    p.setUnits("arcmin");
                    params.add(p);
                } else {
                    if (this._findParamByType(this._paramDesc, "width") != null) {
                        p = new FieldDescAdapter(WIDTH);
                        p.setDescription("The width about the center coordinates in arcmin");
                        p.setFieldClass(Double.class);
                        p.setUnits("arcmin");
                        params.add(p);
                    }
                    if (this._findParamByType(this._paramDesc, "height") != null) {
                        p = new FieldDescAdapter(HEIGHT);
                        p.setDescription("The height about the center coordinates in arcmin");
                        p.setFieldClass(Double.class);
                        p.setUnits("arcmin");
                        params.add(p);
                    }
                }
            }
            if (this._isCatalog && this._findParamByType(this._paramDesc, "maxobjects") == null && this._findParamByType(this._paramDesc, "maxrows") == null) {
                p = new FieldDescAdapter(MAX_OBJECTS);
                p.setDescription("The maximum number of objects to return");
                p.setFieldClass(Integer.class);
                p.setDefaultValue(1000);
                params.add(p);
            }
        }
        for (FieldDesc a_paramDesc : this._paramDesc) {
            if (this._isPosRadiusParam(a_paramDesc)) continue;
            params.add(a_paramDesc);
        }
        this._dummyParamDesc = new FieldDescAdapter[params.size()];
        params.toArray(this._dummyParamDesc);
    }

    private boolean _isPosRadiusParam(FieldDesc param) {
        String type = param.getType();
        return type != null && type.length() != 0 && (type.equals("radec") || type.equalsIgnoreCase("ra") || type.equalsIgnoreCase("dec") || type.equalsIgnoreCase("equinox") || type.equalsIgnoreCase("epoch") || type.equalsIgnoreCase("nameserver") || type.equalsIgnoreCase("radius") || type.equalsIgnoreCase("minradius") || type.equalsIgnoreCase("maxradius") || type.equalsIgnoreCase("size") || type.equalsIgnoreCase("width") || type.equalsIgnoreCase("height"));
    }

    private FieldDesc _findParamByType(FieldDesc[] params, String type) {
        for (FieldDesc param : params) {
            if (!type.equalsIgnoreCase(param.getType())) continue;
            return param;
        }
        return null;
    }

    private void _checkForDetailedCatalogDesc() {
        if (this._paramDesc == null && this._path != null && this._path.endsWith(".xml") && !this._type.equals("directory")) {
            try {
                URL defaultURL;
                File file;
                String urlStr = this._getBaseUrl();
                URL url = new URL(this._url, urlStr);
                String filename = url.getFile();
                if (filename != null && !(file = new File(filename)).exists() && (defaultURL = Resources.getResource("conf/" + this._path)) != null) {
                    url = defaultURL;
                }
                AstroCatXML astroCatXML = new AstroCatXML();
                astroCatXML.parse(url);
                List<Catalog> catalogs = astroCatXML.getCatalogs();
                if (catalogs.size() != 1) {
                    throw new RuntimeException("Expected a single catalog description in: " + url);
                }
                AstroCatalog cat = (AstroCatalog)catalogs.get(0);
                this._url = url;
                this._id = cat._id;
                this._name = cat._name;
                this._description = cat._description;
                this._docURL = cat._docURL;
                this._type = cat._type;
                this._protocol = cat._protocol;
                this._host = cat._host;
                this._port = cat._port;
                this._path = cat._path;
                this._handlerClass = cat._handlerClass;
                this._paramDesc = cat._paramDesc;
                if (this._symbols == null) {
                    this._symbols = cat._symbols;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Catalog reload() {
        return this;
    }

    public static void main(String[] args) {
        String catalogName = "Guide Star Catalog at ESO";
        AstroCatConfig configFile = AstroCatConfig.getConfigFile();
        Catalog cat = configFile.getCatalog(catalogName);
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        }
        try {
            System.out.println("test query: at center position/radius: ");
            BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
            queryArgs.setParamValue("center", (Object)"03:19:44.44+41:30:58.21");
            queryArgs.setParamValue("radius", (Object)"2");
            QueryResult queryResult = cat.query(queryArgs);
            System.out.println("result: " + queryResult);
            if (queryResult instanceof AstroCatTable) {
                ((AstroCatTable)queryResult).saveAsSkycatTable(System.out);
            } else {
                System.out.println("Can't print table");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Test passed");
        System.exit(0);
    }
}

