<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:id="Alma/ObsPrep/SchedBlock">
<!--
     Notice that I've put 
                 xmlns:id="Alma/ObsPrep/SchedBlock"
     in as a namespace and used it to match against. This is the 
     same URI (Alma/ObsPrep/SchedBlock) as the default namespace in the
     Alma documents. For an idea of why this is necessary, see 
     http://www.topxml.com/people/bosley/defaultns.asp
 -->
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="id:SchedBlockEntity/@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.56</xsl:attribute>
  <xsl:comment>Converted from 1.54 to 1.56 by SchedBlock154-156.xslt</xsl:comment>
</xsl:template>

<xsl:template match="id:repeatCount">
<executionCount>
    <xsl:value-of select="."/>
</executionCount>
<!--
  Dont do this, it produces a weird duplicate namesapce called id;
    <xsl:element name="executionCount" namespace="Alma/ObsPrep/SchedBlock">
        <xsl:value-of select="."/>
    </xsl:element>
-->
</xsl:template>

<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>
</xsl:stylesheet>
