/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.entitybuilder.jaxb;

import alma.tools.entitybuilder.BindingException;
import alma.tools.entitybuilder.jaxb.generated.EntitybuilderSettings;
import alma.tools.entitybuilder.jaxb.generated.bind.Bindings;
import alma.tools.entitybuilder.jaxb.generated.bind.GlobalBindings;
import alma.tools.entitybuilder.jaxb.generated.bind.PackageType;
import alma.tools.entitybuilder.jaxb.generated.bind.Property;
import alma.tools.entitybuilder.jaxb.generated.bind.SchemaBindings;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class EntitybuilderConfig {
    private EntitybuilderSettings m_entitybuilderSettings;
    private Map<String, String> m_schema2pckMap = new HashMap<String, String>();
    private Map<String, String> m_ns2pckMap = new HashMap<String, String>();
    private Map<String, File> m_schemaName2File = new HashMap<String, File>();
    private Map<String, String> m_schemaName2Namespace = new HashMap<String, String>();

    public void load(File configFile, File[] includeConfigFiles) throws BindingException {
        this.m_entitybuilderSettings = this.parseConfigFile(configFile);
        this.storePckgMappings(this.m_entitybuilderSettings, configFile.getParentFile());
        for (File includeConfigFile : includeConfigFiles) {
            EntitybuilderSettings ebs = this.parseConfigFile(includeConfigFile);
            this.storePckgMappings(ebs, includeConfigFile.getParentFile());
        }
    }

    private void storePckgMappings(EntitybuilderSettings ebs, File schemaBaseDir) {
        for (EntitybuilderSettings.XmlNamespace2JPackage mapping : ebs.getXmlNamespace2JPackages()) {
            String namespace = mapping.getXmlNamespace();
            String jPackage = mapping.getJPackage();
            this.m_ns2pckMap.put(namespace, jPackage);
        }
        for (EntitybuilderSettings.EntitySchema schema : ebs.getEntitySchemas()) {
            String schemaName = schema.getSchemaName();
            String namespace = schema.getXmlNamespace();
            String jPackage = this.m_ns2pckMap.get(namespace);
            this.m_schema2pckMap.put(schemaName, jPackage);
            this.m_schemaName2Namespace.put(schemaName, namespace);
            Object relPath = schema.getRelativePathSchemafile();
            relPath = ((String)relPath).trim().length() == 0 || ((String)relPath).equals(".") ? File.separator : File.separator + (String)relPath + File.separator;
            String absPathName = schemaBaseDir.getAbsolutePath() + (String)relPath + schema.getSchemaName();
            File schemaFile = new File(absPathName);
            if (schemaFile.exists()) {
                this.m_schemaName2File.put(schemaName, schemaFile);
                continue;
            }
            System.err.println("specified schema file '" + absPathName + "' does not exist; will be ignored.");
        }
    }

    public String[] getAllNamespaces() {
        return this.m_ns2pckMap.keySet().toArray(new String[1]);
    }

    public String getJPackageForNamespace(String ns) {
        String jPackage = this.m_ns2pckMap.get(ns);
        return jPackage;
    }

    public String[] getAllSchemaNames() {
        return this.m_schema2pckMap.keySet().toArray(new String[1]);
    }

    public String getJPackageForSchema(String schemaName) {
        String jPackage = this.m_schema2pckMap.get(schemaName);
        return jPackage;
    }

    public List<File> getPrimarySchemaFiles() throws BindingException {
        ArrayList<File> schemaList = new ArrayList<File>();
        for (EntitybuilderSettings.EntitySchema schema : this.m_entitybuilderSettings.getEntitySchemas()) {
            File schemaFile = this.m_schemaName2File.get(schema.getSchemaName());
            if (schemaFile != null) {
                schemaList.add(schemaFile);
                continue;
            }
            String msg = "specified schema file " + schema.getSchemaName() + " does not exist.";
            System.err.println(msg + " Will be ignored.");
        }
        return schemaList;
    }

    public List<File> getAllSchemaFiles() {
        return new ArrayList<File>(this.m_schemaName2File.values());
    }

    public Map<String, File> getSchemaName2File() {
        return Collections.unmodifiableMap(this.m_schemaName2File);
    }

    public Map<String, String> getSchemaName2Namespace() {
        return Collections.unmodifiableMap(this.m_schemaName2Namespace);
    }

    private EntitybuilderSettings parseConfigFile(File configFile) throws BindingException {
        EntitybuilderSettings ebs = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null) {
            throw new BindingException("xml config file '" + configFile.getAbsolutePath() + "' not found.");
        }
        try {
            ebs = (EntitybuilderSettings)JAXBContext.newInstance((Class[])new Class[]{EntitybuilderSettings.class}).createUnmarshaller().unmarshal(new InputSource(is));
        }
        catch (Exception e) {
            String msg = "parsing of schema config file failed. ";
            throw new BindingException(msg, e);
        }
        return ebs;
    }

    public void writeXjb(File outputFile) throws BindingException {
        Bindings b = new Bindings();
        b.setVersion("3.0");
        b.addAttribute(new QName(null, "xmlns:xs"), "http://www.w3.org/2001/XMLSchema");
        GlobalBindings g = new GlobalBindings();
        QName qtag = new QName("http://java.sun.com/xml/ns/jaxb/xjc", "simple");
        JAXBElement jel = new JAXBElement(qtag, String.class, (Object)"");
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{String.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)jel, (Result)new DOMResult(doc));
            g.setAny(doc.getDocumentElement());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        b.getGlobalBindingsAndSchemaBindingsAndClazzs().add(g);
        for (File schema : this.getPrimarySchemaFiles()) {
            Bindings sBind = new Bindings();
            sBind.setSchemaLocation("file:/" + schema.getName());
            SchemaBindings s = new SchemaBindings();
            PackageType p = new PackageType();
            p.getNames().add(this.getJPackageForSchema(schema.getName()) + ".jaxb");
            s.setPackage(p);
            sBind.getGlobalBindingsAndSchemaBindingsAndClazzs().add(s);
            Bindings val = new Bindings();
            val.setNode("//xs:extension[contains(@base, ':string')]/xs:attribute[@name='value']");
            val.addAttribute(new QName(null, "required"), "false");
            Property prop = new Property();
            prop.getNames().add("content");
            val.getGlobalBindingsAndSchemaBindingsAndClazzs().add(prop);
            sBind.getGlobalBindingsAndSchemaBindingsAndClazzs().add(val);
            b.getGlobalBindingsAndSchemaBindingsAndClazzs().add(sBind);
        }
        try {
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{Bindings.class}).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)b, outputFile);
        }
        catch (Exception e) {
            String msg = "Problem writing the XML during marshalling.";
            throw new BindingException(msg, e);
        }
    }
}

