/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.oracle.DatabaseCache;
import alma.archive.database.oracle.DatabaseReader;
import alma.archive.database.oracle.DatabaseWriter;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.DocumentDoesNotExistException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.HistoryInconsistencyException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.wrappers.Permissions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SchemaManagerImpl
implements SchemaManager {
    private final DatabaseReader dbReader;
    private final DatabaseWriter dbWriter;
    private final DatabaseCache dbCache;

    public SchemaManagerImpl(DatabaseWriter writer, DatabaseReader reader, DatabaseCache cache) {
        this.dbReader = reader;
        this.dbWriter = writer;
        this.dbCache = cache;
    }

    @Override
    public void removeAll() throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        ArrayList<String> schemasToRemove = new ArrayList<String>();
        for (String schema : this.dbCache.getSchemas()) {
            schemasToRemove.add(schema);
        }
        for (String schema : schemasToRemove) {
            this.dbWriter.removeSchema(schema);
        }
        this.dbWriter.removeNamespaces();
        try {
            this.dbWriter.loadIdentifierRangeSchema();
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void close() throws DatabaseException {
    }

    @Override
    public URI getSchemaURI(String schema) throws DatabaseException, ArchiveException, UnknownSchemaException {
        URI ret = this.dbCache.getURI(schema);
        if (ret == null) {
            throw new UnknownSchemaException(schema);
        }
        return ret;
    }

    @Override
    public URI getSchemaURI(String schema, int version) throws ArchiveException, UnknownSchemaException, DatabaseException, ModuleCriticalException {
        return this.dbReader.getSchemaURI(schema, version);
    }

    @Override
    public String getSchemaName(URI schemaURI) throws ArchiveException, MalformedURIException, UnknownSchemaException, DatabaseException, ModuleCriticalException {
        return this.dbReader.getSchemaName(schemaURI);
    }

    @Override
    public int getSchemaVersion(URI schemaUri) throws ArchiveException, UnknownSchemaException, MalformedURIException, DatabaseException, ModuleCriticalException {
        return this.dbReader.getSchemaVersion(schemaUri);
    }

    public HashMap<String, String> getSchemaNamespaces(URI schemaUri) throws ArchiveException, UnknownSchemaException, DatabaseException, ModuleCriticalException {
        return this.dbReader.getSchemaNamespaces(schemaUri);
    }

    @Override
    public void registerNamespace(String prefix, URI namespace) throws NamespaceDefinedException, DatabaseException, ArchiveException, MalformedURIException {
        this.dbWriter.registerNamespace(prefix, namespace);
    }

    @Override
    public void removeNamespace(String prefix) throws DatabaseException, ArchiveException, MalformedURIException {
        this.dbWriter.removeNamespace(prefix);
    }

    @Override
    public boolean namespaceExists(URI namespace) throws ArchiveException, DatabaseException, ModuleCriticalException {
        return this.dbReader.namespaceExists(namespace);
    }

    @Override
    public void assignNamespace(String prefix, URI schemaUri) throws DatabaseException, ArchiveException, UnknownSchemaException {
        this.dbWriter.assignNamespace(prefix, schemaUri);
    }

    @Override
    public void withdrawNamespace(String prefix, URI schemaUri) throws DatabaseException, ArchiveException, UnknownSchemaException {
        this.dbWriter.withdrawNamespace(prefix, schemaUri);
    }

    public HashMap<String, String> namespaces() throws ArchiveException, DatabaseException, ModuleCriticalException {
        return this.dbReader.getSchemaNamespaces(null);
    }

    @Override
    public void addSchema(String schemaName, String xml, String indexConfig, URI schemaURInew, String owner, Permissions permissions) throws DatabaseException, ArchiveException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException {
        if (this.dbReader.existsSchema(schemaName)) {
            throw new EntityExistsException(schemaName);
        }
        this.dbWriter.addSchemaAndTables(schemaURInew, schemaName, xml, indexConfig);
    }

    @Override
    public void updateSchema(String schemaName, String xml, String indexConfig, URI schemaURIold, URI schemaURInew, String owner, Permissions permissions) throws ArchiveException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException, DatabaseException, DocumentDoesNotExistException, HistoryInconsistencyException, ModuleCriticalException {
        if (!this.dbReader.checkSchemaConsistency(schemaName, schemaURIold)) {
            throw new HistoryInconsistencyException("The schema document " + String.valueOf(schemaURInew) + " is not the latest schema document of schema " + schemaName);
        }
        int version = this.dbReader.getSchemaVersion(schemaURIold);
        this.dbWriter.addSchema(schemaURInew, schemaName, version + 1, xml, indexConfig);
    }

    @Override
    public void removeSchema(String schemaName) throws DatabaseException, ArchiveException, UnknownSchemaException, PermissionDeniedException {
        this.dbWriter.removeSchema(schemaName);
    }

    @Override
    public List<String> listSchema() throws DatabaseException, ArchiveException {
        return new ArrayList<String>(this.dbCache.getSchemas());
    }

    @Override
    public void refresh() throws DatabaseException, ModuleCriticalException {
        this.dbReader.initSchemaMaps();
    }
}

