/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.interfaces;

import alma.archive.database.helpers.ArchiveConfiguration;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.mock.MockIdentifierManager;
import alma.archive.database.mock.MockInternalIF;
import alma.archive.database.oracle.InternalIfImpl;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.general.DatabaseException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class InternalIFFactory {
    public static DBConfiguration dbConfig;

    public static InternalIF getInternalIF(Logger logger) throws ArchiveException {
        boolean notifyConfig = InternalIFFactory.ensureConfigIsLoaded(logger);
        InternalIF internal = null;
        if ("xmldb".equals(InternalIFFactory.dbConfig.dbBackend)) {
            internal = new MockInternalIF();
        } else if ("oracle".equals(InternalIFFactory.dbConfig.dbBackend)) {
            internal = InternalIfImpl.instance(logger);
        }
        if (internal == null) {
            logger.severe("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
            throw new DatabaseException("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
        }
        if (notifyConfig) {
            internal.notifyConfigChange();
        }
        return internal;
    }

    public static InternalIF getInternalIF(DataSource dataSource, Logger logger) throws ArchiveException {
        return InternalIfImpl.instance(dataSource, logger);
    }

    public static IdentifierManager getIdentifierManager(DataSource dataSource, Logger logger) throws ArchiveException {
        IdentifierManager imanager = InternalIfImpl.instance(dataSource, logger).getIdentifierManager();
        return imanager;
    }

    public static IdentifierManager getIdentifierManager(Logger logger) throws ArchiveException {
        InternalIFFactory.ensureConfigIsLoaded(logger);
        IdentifierManager imanager = null;
        if ("xmldb".equals(InternalIFFactory.dbConfig.dbBackend)) {
            imanager = new MockIdentifierManager();
        } else if ("oracle".equals(InternalIFFactory.dbConfig.dbBackend)) {
            imanager = InternalIfImpl.instance(logger).getIdentifierManager();
        }
        if (imanager != null) {
            return imanager;
        }
        logger.severe("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
        throw new DatabaseException("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
    }

    private static synchronized boolean ensureConfigIsLoaded(Logger logger) throws DatabaseException {
        boolean isLoaded = false;
        if (dbConfig == null) {
            dbConfig = ArchiveConfiguration.instance(logger);
            isLoaded = true;
        }
        return isLoaded;
    }

    public static synchronized SchemaManager getSchemaManager(Logger logger) throws ArchiveException {
        return InternalIFFactory.getInternalIF(logger).getSchemaManager("parameter not used anyway, so unimportant");
    }
}

