/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;
import uk.ac.starlink.util.gui.StoreConfiguration;
import uk.ac.starlink.util.gui.StoreSource;
import uk.ac.starlink.util.images.ImageHolder;

public class StoreControlFrame
extends JFrame {
    protected JPanel contentPane = null;
    protected JPanel actionBar = new JPanel();
    protected JPanel statusView = new JPanel();
    protected JTable statusTable = new JTable();
    protected StoreSource storeSource = null;
    protected StoreConfiguration store = null;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu("File");

    public StoreControlFrame(StoreSource storeSource) {
        this.storeSource = storeSource;
        this.contentPane = (JPanel)this.getContentPane();
        this.initMenus();
        this.initUI();
        this.initFrame();
    }

    protected void initMenus() {
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.fileMenu.setMnemonic(70);
        this.actionBar.setLayout(new BoxLayout(this.actionBar, 0));
        this.actionBar.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        ImageIcon addImage = new ImageIcon(ImageHolder.class.getResource("add.gif"));
        AddAction addAction = new AddAction("Store", addImage);
        JButton addButton = new JButton(addAction);
        this.actionBar.add(Box.createGlue());
        this.actionBar.add(addButton);
        addButton.setToolTipText("Store the current configuration");
        ImageIcon updateImage = new ImageIcon(ImageHolder.class.getResource("update.gif"));
        UpdateAction updateAction = new UpdateAction("Update", updateImage);
        JButton updateButton = new JButton(updateAction);
        this.actionBar.add(Box.createGlue());
        this.actionBar.add(updateButton);
        updateButton.setToolTipText("Update the selected configuration");
        ImageIcon restoreImage = new ImageIcon(ImageHolder.class.getResource("accept.gif"));
        RestoreAction restoreAction = new RestoreAction("Restore", restoreImage);
        JButton restoreButton = new JButton(restoreAction);
        this.actionBar.add(Box.createGlue());
        this.actionBar.add(restoreButton);
        restoreButton.setToolTipText("Restore the selected configuration");
        ImageIcon deleteImage = new ImageIcon(ImageHolder.class.getResource("delete.gif"));
        DeleteAction deleteAction = new DeleteAction("Delete", deleteImage);
        JButton deleteButton = new JButton(deleteAction);
        this.actionBar.add(Box.createGlue());
        this.actionBar.add(deleteButton);
        deleteButton.setToolTipText("Delete the selected configurations");
        ImageIcon closeImage = new ImageIcon(ImageHolder.class.getResource("exit.gif"));
        CloseAction closeAction = new CloseAction("Close", closeImage);
        this.fileMenu.add(closeAction).setMnemonic(67);
        JButton closeButton = new JButton(closeAction);
        this.actionBar.add(Box.createGlue());
        this.actionBar.add(closeButton);
        closeButton.setToolTipText("Close window and save configurations");
        this.actionBar.add(Box.createGlue());
    }

    protected void initFrame() {
        this.setTitle("Save or restore configurations");
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StoreControlFrame.this.closeWindowEvent();
            }
        });
        this.contentPane.add((Component)this.statusView, "Center");
        this.contentPane.add((Component)this.actionBar, "South");
        this.setSize(new Dimension(600, 300));
        this.setVisible(true);
    }

    protected void initUI() {
        this.contentPane.setLayout(new BorderLayout());
        this.store = new StoreConfiguration(this.storeSource.getApplicationName(), this.storeSource.getStoreName());
        this.statusTable.setModel(this.store);
        this.statusView.setBorder(BorderFactory.createTitledBorder("Previous configurations in store"));
        this.statusView.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.statusTable);
        this.statusView.add((Component)scrollPane, "Center");
    }

    protected void closeWindowEvent() {
        this.dispose();
        this.store.writeToBackingStore();
    }

    public void storeCurrentConfiguration() {
        Element newRoot = this.store.newState(this.storeSource.getTagName(), "New configuration");
        this.storeSource.saveState(newRoot);
        this.store.stateCompleted(newRoot);
    }

    public void updateCurrentConfiguration() {
        int[] rows = this.statusTable.getSelectedRows();
        if (rows.length > 0) {
            Element newRoot = this.store.reGetState(rows[0]);
            this.storeSource.saveState(newRoot);
            this.store.setDateStamp(rows[0]);
        }
    }

    public void deleteSelectedConfigurations() {
        int[] rows = this.statusTable.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this.store.removeState(i);
            }
        }
    }

    public void restoreSelectedConfiguration() {
        int selected = this.statusTable.getSelectedRow();
        if (selected < 0) {
            JOptionPane.showMessageDialog(this, "You have not selected a configuration to restore", "Not restored", 1);
            return;
        }
        Element state = this.store.getState(selected);
        this.storeSource.restoreState(state);
    }

    protected class RestoreAction
    extends AbstractAction {
        public RestoreAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            StoreControlFrame.this.restoreSelectedConfiguration();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction(String name, Icon icon) {
            super(name, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control W"));
        }

        public void actionPerformed(ActionEvent ae) {
            StoreControlFrame.this.closeWindowEvent();
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        public DeleteAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            StoreControlFrame.this.deleteSelectedConfigurations();
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        public UpdateAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            StoreControlFrame.this.updateCurrentConfiguration();
        }
    }

    protected class AddAction
    extends AbstractAction {
        public AddAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            StoreControlFrame.this.storeCurrentConfiguration();
        }
    }
}

